/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSCachingTypeOwner;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSStubIndexingUtils {
    public static void addImplicitNamespaces(@Nullable JSQualifiedName elementNs, @NotNull Collection<? super JSImplicitElement> outElements, @Nullable PsiElement element) {
        if (outElements == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(0);
        }
        for (JSQualifiedName parent = elementNs; parent != null; parent = parent.getParent()) {
            JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(parent.getName(), element).setNamespace(parent.getParent()).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Namespace);
            outElements.add(new JSImplicitElementImpl(builder2));
        }
    }

    public static void processExtendCall(@NotNull JSReferenceExpression typeExpression, @NotNull JSReferenceExpression baseTypeExpression, @NotNull JSContext extensionContext, @NotNull JSElementIndexingData outIndexingData) {
        if (typeExpression == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(1);
        }
        if (baseTypeExpression == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(2);
        }
        if (extensionContext == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(3);
        }
        if (outIndexingData == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(4);
        }
        JSStubIndexingUtils.processExtendCall(JSStubIndexingUtils.getNamespaceFromReferenceExpression(typeExpression, extensionContext), JSStubIndexingUtils.getNamespaceFromReferenceExpression(baseTypeExpression, extensionContext), outIndexingData);
    }

    @NotNull
    public static JSNamespace getNamespaceFromReferenceExpression(@NotNull JSReferenceExpression referenceExpression, @NotNull JSContext jsContext) {
        JSQualifiedName qualifiedName;
        JSNamespace ns;
        if (referenceExpression == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(5);
        }
        if (jsContext == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(6);
        }
        if ((ns = JSSymbolUtil.evaluateNamespaceLocally(referenceExpression)) == null) {
            ns = JSSymbolUtil.createNamespaceFromReferenceExpression(referenceExpression, jsContext, true);
        }
        if (ns != null) {
            qualifiedName = ns.getQualifiedName();
            if (ns.getJSContext() != JSContext.UNKNOWN) {
                jsContext = JSTypeUtils.combineJSContexts(jsContext, ns.getJSContext());
            }
        } else {
            qualifiedName = null;
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, (PsiElement)referenceExpression, false);
        if (jSNamespace == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(7);
        }
        return jSNamespace;
    }

    public static void processExtendCall(@NotNull JSNamespace ns, @NotNull JSNamespace baseNs, @NotNull JSElementIndexingData outIndexingData) {
        if (ns == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(8);
        }
        if (baseNs == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(9);
        }
        if (outIndexingData == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(10);
        }
        JSQualifiedName qName = ns.getQualifiedName();
        JSQualifiedName baseQName = baseNs.getQualifiedName();
        if (qName == null || baseQName == null) {
            return;
        }
        if (JSStubIndexingUtils.containsPrototypeComponent(qName.getParent()) || JSStubIndexingUtils.containsPrototypeComponent(baseQName.getParent())) {
            return;
        }
        outIndexingData.addBaseType(JSBaseTypesIndex.serializeHierarchyElement(ns), JSBaseTypesIndex.serializeHierarchyElement(baseNs));
    }

    private static boolean containsPrototypeComponent(@Nullable JSQualifiedName qualifiedName) {
        while (qualifiedName != null) {
            if ("prototype".equals(qualifiedName.getName())) {
                return true;
            }
            qualifiedName = qualifiedName.getParent();
        }
        return false;
    }

    public static boolean keepsInitializerStub(@NotNull JSInitializerOwner initializerOwner) {
        if (initializerOwner == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(11);
        }
        return JSStubIndexingUtils.isInStubTree(initializerOwner.getInitializer());
    }

    public static boolean isInStubTree(@Nullable JSExpression element) {
        if ((element = JSUtils.unparenthesize(element)) == null) {
            return false;
        }
        ASTNode elementNode = element.getNode();
        IElementType initializerElementType = elementNode.getElementType();
        return initializerElementType instanceof IStubElementType && ((IStubElementType)initializerElementType).shouldCreateStub(elementNode);
    }

    public static boolean needSerializeType(@NotNull JSCachingTypeOwner psi, @Nullable JSType type2) {
        if (psi == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(12);
        }
        return type2 != null && psi.calculateDeclarationTypeStubSafe() == null;
    }

    public static boolean isAstBasedTypeFromJSDoc(@Nullable JSType type2) {
        return type2 != null && type2.getSourceElement() instanceof JSDocComment;
    }

    @Nullable
    public static JSQualifiedName getResolvedQualifiedName(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(13);
        }
        return namespace.hasQualifiedName() ? JSQualifiedNameImpl.fromNamepath(namespace.getResolvedTypeText()) : null;
    }

    @Nullable
    public static String getNamespaceForIndexing(@NotNull JSNamespace namespace, boolean allowResolve) {
        JSQualifiedName namespaceIncludingLocal;
        if (namespace == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(14);
        }
        JSQualifiedName jSQualifiedName = namespaceIncludingLocal = allowResolve ? JSStubIndexingUtils.getResolvedQualifiedName(namespace) : namespace.getQualifiedName();
        return namespaceIncludingLocal != null ? namespaceIncludingLocal.getQualifiedName() : (namespace instanceof JSClassExpressionType ? JSTypeUtils.serializeType(namespace.copyWithTypeContext(JSTypeContext.UNKNOWN)) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseTypeExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionContext";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outIndexingData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFromReferenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitNamespaces";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processExtendCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromReferenceExpression";
                break;
            }
            case 7: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "keepsInitializerStub";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "needSerializeType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedQualifiedName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceForIndexing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

