/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.queue;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.queue.JSResolveLock;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSResolveQueue {
    @NotNull
    private static final ThreadLocal<IntRef> QUEUE_DEPTH = ThreadLocal.withInitial(() -> new IntRef(0));
    private static final int MAX_QUEUE_DEPTH = 5;
    @NotNull
    private final Set<JSReferenceExpression> myAllElements;
    @NotNull
    private final Map<JSReferenceExpression, JSResolveLock> myResolveStatus;

    public JSResolveQueue(@NotNull List<JSReferenceExpression> elements) {
        if (elements == null) {
            JSResolveQueue.$$$reportNull$$$0(0);
        }
        this.myResolveStatus = new ConcurrentHashMap<JSReferenceExpression, JSResolveLock>();
        this.myAllElements = new LinkedHashSet<JSReferenceExpression>(elements);
    }

    public boolean contains(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSResolveQueue.$$$reportNull$$$0(1);
        }
        return this.myAllElements.contains(ref);
    }

    @RequiresBackgroundThread
    @Nullable
    public JSResolveLock acquireLock(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSResolveQueue.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (!this.myAllElements.contains(ref)) {
            Logger.getInstance(JSResolveQueue.class).error("Element is not found in this queue, no lock acquired");
            return null;
        }
        JSResolveLock newLock = new JSResolveLock();
        JSResolveLock fromMap = this.myResolveStatus.putIfAbsent(ref, newLock);
        if (fromMap == null) {
            return newLock;
        }
        if (fromMap.isDone()) {
            return fromMap;
        }
        IntRef queueDepth = QUEUE_DEPTH.get();
        if (queueDepth.get() > 5) {
            return null;
        }
        for (JSReferenceExpression nextElement : this.myAllElements) {
            JSResolveLock newLockForRandom;
            JSResolveLock existingLock = this.myResolveStatus.putIfAbsent(nextElement, newLockForRandom = new JSResolveLock());
            if (existingLock == null) {
                JSEvaluatorComplexityTracker.runInNewContext(() -> {
                    try {
                        queueDepth.inc();
                        ((JSReferenceExpressionImpl)nextElement).doMultiResolve(false, newLockForRandom);
                    }
                    finally {
                        queueDepth.set(queueDepth.get() - 1);
                    }
                });
                ProgressManager.checkCanceled();
            }
            if (!fromMap.isDone()) continue;
            return fromMap;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/queue/JSResolveQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "acquireLock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

