/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.generic;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeSubstitutorImpl
implements JSTypeSubstitutor {
    @NotNull
    private final Map<JSTypeGenericId, JSType> myMap;

    public JSTypeSubstitutorImpl() {
        this.myMap = new LinkedHashMap<JSTypeGenericId, JSType>();
    }

    public JSTypeSubstitutorImpl(@NotNull JSTypeSubstitutor substitutor) {
        if (substitutor == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(0);
        }
        this.myMap = new LinkedHashMap<JSTypeGenericId, JSType>();
        this.myMap.putAll(substitutor.map());
    }

    public JSTypeSubstitutorImpl(@NotNull LinkedHashMap<JSTypeGenericId, JSType> map) {
        if (map == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(1);
        }
        this.myMap = map;
    }

    public JSTypeSubstitutorImpl(@NotNull Map<String, JSType> map) {
        if (map == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(2);
        }
        this.myMap = new LinkedHashMap<JSTypeGenericId, JSType>();
        map.forEach(this::putForJSGenerics);
    }

    @NotNull
    public static JSTypeSubstitutor of(@Nullable JSTypeSubstitutor substitutor) {
        return substitutor instanceof JSTypeSubstitutorImpl ? (JSTypeSubstitutorImpl)substitutor : (substitutor != null ? new JSTypeSubstitutorImpl(substitutor) : new JSTypeSubstitutorImpl());
    }

    @Override
    public boolean containsId(@NotNull JSTypeGenericId id) {
        if (id == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(3);
        }
        return this.myMap.containsKey(id);
    }

    public void put(@Nullable JSTypeGenericId key2, JSType value) {
        if (key2 == null) {
            return;
        }
        this.myMap.put(key2, value);
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public void putForJSGenerics(@Nullable String key2, JSType value) {
        if (key2 == null) {
            return;
        }
        this.put(new JSTypeSubstitutor.StringGenericId(key2), value);
    }

    public void putAll(@NotNull JSTypeSubstitutor first) {
        if (first == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(4);
        }
        this.putAll(first, (Condition<? super JSType>)Conditions.alwaysTrue());
    }

    public void putAll(@NotNull JSTypeSubstitutor first, Condition<? super JSType> include) {
        if (first == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(5);
        }
        for (Map.Entry<JSTypeGenericId, JSType> entry : first.map().entrySet()) {
            if (!include.value((Object)entry.getValue())) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public JSType get(@Nullable JSTypeGenericId key2) {
        return key2 == null ? null : this.myMap.get(key2);
    }

    @Override
    @NotNull
    public JSTypeSubstitutor transformValues(@NotNull Function<? super JSType, ? extends JSType> transformation) {
        if (transformation == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(6);
        }
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        boolean hasNewOuters = false;
        for (Map.Entry<JSTypeGenericId, JSType> entry : this.myMap.entrySet()) {
            JSType oldOuterArgType = entry.getValue();
            JSType newOuterArgType = (JSType)transformation.fun((Object)oldOuterArgType);
            if (newOuterArgType != oldOuterArgType) {
                hasNewOuters = true;
            }
            substitutor.put(entry.getKey(), newOuterArgType);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = hasNewOuters ? substitutor : this;
        if (jSTypeSubstitutorImpl == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(7);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public static JSTypeSubstitutor combine(@Nullable JSTypeSubstitutor first, @Nullable JSTypeSubstitutor second) {
        JSTypeSubstitutorImpl result2;
        first = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)first, (Object)EMPTY);
        second = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)second, (Object)EMPTY);
        if (first.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = second;
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutorImpl.$$$reportNull$$$0(8);
            }
            return jSTypeSubstitutor;
        }
        if (second.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = first;
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutorImpl.$$$reportNull$$$0(9);
            }
            return jSTypeSubstitutor;
        }
        if (first instanceof JSTypeSubstitutorImpl) {
            result2 = (JSTypeSubstitutorImpl)first;
        } else {
            result2 = new JSTypeSubstitutorImpl();
            result2.putAll(first);
        }
        SmartList genericsToPropagate = new SmartList();
        second.map().forEach((arg_0, arg_1) -> JSTypeSubstitutorImpl.lambda$combine$0((List)genericsToPropagate, result2, arg_0, arg_1));
        genericsToPropagate.forEach(pair -> {
            JSTypeGenericId id = (JSTypeGenericId)pair.first;
            JSGenericParameterImpl type2 = (JSGenericParameterImpl)pair.second;
            JSType current = result2.get(id);
            if (current != null && result2.get(type2.getGenericId()) == null) {
                result2.put(type2.getGenericId(), current);
            }
        });
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
        if (jSTypeSubstitutorImpl == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(10);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public static JSTypeSubstitutor combineWithApplying(@Nullable JSTypeSubstitutor toApply, @Nullable JSTypeSubstitutor substitutor, @NotNull BiFunction<? super JSType, ? super JSTypeSubstitutor, ? extends JSType> applier) {
        if (applier == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(11);
        }
        if (toApply == null || toApply.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)substitutor, (Object)EMPTY);
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutorImpl.$$$reportNull$$$0(12);
            }
            return jSTypeSubstitutor;
        }
        if (substitutor == null || substitutor.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)toApply, (Object)EMPTY);
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutorImpl.$$$reportNull$$$0(13);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl combinedSubstitutor = new JSTypeSubstitutorImpl();
        for (Map.Entry<JSTypeGenericId, JSType> entry : substitutor.map().entrySet()) {
            combinedSubstitutor.put(entry.getKey(), applier.apply(entry.getValue(), toApply));
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = combinedSubstitutor;
        if (jSTypeSubstitutorImpl == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(14);
        }
        return jSTypeSubstitutorImpl;
    }

    @Override
    @NotNull
    public Map<JSTypeGenericId, JSType> map() {
        Map<JSTypeGenericId, JSType> map = this.myMap;
        if (map == null) {
            JSTypeSubstitutorImpl.$$$reportNull$$$0(15);
        }
        return map;
    }

    private static /* synthetic */ void lambda$combine$0(List genericsToPropagate, JSTypeSubstitutorImpl result2, JSTypeGenericId id, JSType type2) {
        if (type2 instanceof JSGenericParameterImpl) {
            JSGenericParameterImpl genericParameter = (JSGenericParameterImpl)type2;
            genericsToPropagate.add(Pair.pair((Object)id, (Object)genericParameter));
        } else {
            result2.put(id, type2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/generic/JSTypeSubstitutorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/generic/JSTypeSubstitutorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "transformValues";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "combineWithApplying";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "transformValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "combineWithApplying";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

