/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHelper {
    protected JSTypeHelper() {
    }

    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, @NotNull ProcessingContext processingContext) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(0);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(2);
        }
        String lOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(lOpType, true);
        String rOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(rOpType, true);
        if (lOpQualifiedName == null || rOpQualifiedName == null) {
            return Objects.equals(lOpQualifiedName, rOpQualifiedName);
        }
        PsiFile context2 = rOpType.getSource().getScope();
        if ("Iterable".equals(lOpQualifiedName) && JSTypeHelper.isBuiltInIterable(rOpQualifiedName)) {
            return true;
        }
        if (context2 == null) {
            return lOpQualifiedName.equals(rOpQualifiedName);
        }
        Collection<String> possibleLNames = JSTypeHelper.getPossibleTypeNames(lOpType, lOpQualifiedName);
        if (possibleLNames.contains(rOpQualifiedName)) {
            return true;
        }
        boolean result2 = JSTypeEvaluateManager.iterateTypeHierarchy(rOpType, (Processor<JSClass>)((Processor)clazz -> {
            String qName = clazz.getQualifiedName();
            if (qName == null) {
                return true;
            }
            if (possibleLNames.contains(qName)) {
                return false;
            }
            String name = clazz.getName();
            if (name == null || qName.equals(name)) {
                return true;
            }
            PsiElement moduleCandidate = clazz.getContext();
            if (ES6PsiUtil.isExternalModule(moduleCandidate)) {
                return !possibleLNames.contains(name);
            }
            return true;
        }), (Processor<? super JSType>)((Processor)baseType -> {
            String qName = JSTypeUtils.getQualifiedNameMatchingType(baseType, false);
            if (qName == null) {
                return true;
            }
            return !possibleLNames.contains(qName);
        }), (PsiElement)context2, true);
        return !result2;
    }

    @NotNull
    private static Collection<String> getPossibleTypeNames(@NotNull JSNamedType type2, @NotNull String qName) {
        PsiElement module;
        String className;
        JSResolvedTypeInfo info2;
        JSClass jsClass;
        String text2;
        if (type2 == null) {
            JSTypeHelper.$$$reportNull$$$0(3);
        }
        if (qName == null) {
            JSTypeHelper.$$$reportNull$$$0(4);
        }
        if (Objects.equals(text2 = type2.getTypeText(), qName)) {
            List<String> list2 = Collections.singletonList(qName);
            if (list2 == null) {
                JSTypeHelper.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (type2.isTypeScript() && type2 instanceof JSResolvableType && (jsClass = (info2 = ((JSResolvableType)((Object)type2)).resolveType()).getDeclarationOfType(JSClass.class)) != null && (className = jsClass.getName()) != null && ES6PsiUtil.isExternalModule(module = jsClass.getContext()) && !Objects.equals(qName, className)) {
            Set<String> set = Set.of(qName, className);
            if (set == null) {
                JSTypeHelper.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<String> set = Collections.singleton(qName);
        if (set == null) {
            JSTypeHelper.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static boolean isBuiltInIterable(String rOpQualifiedName) {
        return "Set".equals(rOpQualifiedName) || "WeakSet".equals(rOpQualifiedName) || "Array".equals(rOpQualifiedName);
    }

    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @NotNull ProcessingContext processingContext) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(8);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(10);
        }
        if (rOpType instanceof JSNamedType) {
            JSResolvedTypeInfo info2;
            boolean checkWithNamedType = true;
            if (!(rOpType instanceof JSResolvableType) && ((info2 = lOpType.resolveType()).isEnum() || info2.isEnumLiteral())) {
                checkWithNamedType = false;
            }
            if (checkWithNamedType) {
                return this.areNamedTypesAssignable(lOpType, (JSNamedType)rOpType, processingContext);
            }
        }
        if (rOpType instanceof JSGenericTypeImpl) {
            return lOpType.isDirectlyAssignableType(((JSGenericTypeImpl)rOpType).getType(), processingContext);
        }
        if (rOpType instanceof JSNullType) {
            return true;
        }
        if (rOpType instanceof JSArrayType && !((JSArrayType)rOpType).isPrimitive()) {
            return this.isAssignableToNamedType(lOpType, ((JSArrayType)rOpType).asGenericType(), processingContext);
        }
        if (rOpType instanceof JSRecordType) {
            return this.substituteLeftTypeAndCheckAssignable(lOpType, rOpType, processingContext).isAssignable();
        }
        return false;
    }

    protected JSTypeCastUtil.AssignableResult substituteLeftTypeAndCheckAssignable(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @NotNull ProcessingContext processingContext) {
        JSRecordType lOpResolvedType;
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(11);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(13);
        }
        if ((lOpResolvedType = lOpType.asRecordType()) instanceof JSNotARecordType) {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        return JSTypeCastUtil.toStrictAssignable(lOpResolvedType.isDirectlyAssignableType(rOpType, processingContext));
    }

    @Nullable
    public JSType getTypeForIndexing(@Nullable JSExpression expression, @NotNull PsiElement context2) {
        JSType constant;
        if (context2 == null) {
            JSTypeHelper.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            return JSNamedTypeFactory.createUndefinedType(JSTypeSourceFactory.createTypeSource(context2, true));
        }
        if (expression instanceof JSLiteralExpression && (constant = JSTypeEvaluator.getTypeFromConstant(expression)) != null) {
            return constant;
        }
        return null;
    }

    @NotNull
    public Object getScopeId(@NotNull JSNamedType type2) {
        PsiFile scope2;
        if (type2 == null) {
            JSTypeHelper.$$$reportNull$$$0(15);
        }
        if ((scope2 = type2.getScope()) != null && scope2.isValid() && JSCorePredefinedLibrariesProvider.isLibraryElement((PsiElement)scope2)) {
            PsiFile psiFile2 = scope2;
            if (psiFile2 == null) {
                JSTypeHelper.$$$reportNull$$$0(16);
            }
            return psiFile2;
        }
        String string = type2.getResolvedTypeText();
        if (string == null) {
            JSTypeHelper.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
            case 2: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTypeNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areNamedTypesAssignable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTypeNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToNamedType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteLeftTypeAndCheckAssignable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForIndexing";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getScopeId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 16, 17 -> new IllegalStateException(string);
        };
    }
}

