/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSIndexBasedResolveUtil {
    private static final int MAX_FILES_TO_PROCESS = Integer.parseInt(System.getProperty("js.max.files.to.process", "10"));
    public static final int MAX_FILES_TO_PROCESS_BY_QNAME = MAX_FILES_TO_PROCESS * 3;

    public static void processAllSymbols(WalkUpResolveProcessor processor) {
        JSIndexBasedResolveUtil.processAllSymbols(processor, false, null, false, true);
    }

    public static void processAllSymbols(WalkUpResolveProcessor processor, boolean ignorePerformanceLimit) {
        JSIndexBasedResolveUtil.processAllSymbols(processor, ignorePerformanceLimit, null, false, true);
    }

    static void processAllSymbols(@NotNull WalkUpResolveProcessor processor, boolean ignorePerformanceLimit, @Nullable PsiFile limitingScope, boolean excludeGlobalTypeScript, boolean includeTypeOnlyContextSymbols) {
        PsiElement context2;
        GlobalSearchScope allScope;
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = allScope = DialectDetector.isTypeScript(context2 = processor.getContext()) ? TypeScriptConfigService.Provider.getConfigResolveScope(context2) : JSResolveUtil.getResolveScope(context2);
        if (excludeGlobalTypeScript) {
            allScope = TypeScriptClassResolver.excludeGlobalTypeScript(allScope);
        }
        if (limitingScope != null) {
            allScope = GlobalSearchScope.fileScope((PsiFile)limitingScope).intersectWith(allScope);
        }
        JSIndexBasedResolveUtil.processAllSymbols(processor, allScope, ignorePerformanceLimit, includeTypeOnlyContextSymbols);
    }

    private static void processAllSymbols(final @NotNull WalkUpResolveProcessor processor, @NotNull GlobalSearchScope includeScope, boolean ignorePerformanceLimit, boolean includeTypeOnlyContextSymbols) {
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(1);
        }
        if (includeScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(2);
        }
        PsiFile file = processor.getBaseFile();
        Project project = file.getProject();
        String name = processor.getRequiredName();
        Set resultsBeforeProcessingFromIndex = processor.getTaggedResolveResults().stream().map(result2 -> result2.result.getElement()).collect(Collectors.toSet());
        JSSymbolCollector collector = new JSSymbolCollector(resultsBeforeProcessingFromIndex, includeTypeOnlyContextSymbols);
        for (JSContextLevel level : processor.getTypeInfo().myContextLevels) {
            JSClassResolver.IncludeLocalMembersOptions includeLocalMembers;
            JSNamespace namespace = level.myNamespace;
            String qName = JSSymbolQualifiedNamesIndex.getQualifiedNameToIndex(name, namespace, true);
            PsiFile namespaceScope = level.myNamespace.getSource().getScope();
            PsiFile fileToIncludeLocal = null;
            if (namespaceScope != null) {
                fileToIncludeLocal = JSResolveUtil.getOriginalFile((PsiElement)namespaceScope);
            }
            GlobalSearchScope scope2 = JSTypeUtils.isLocalOrFromSource(namespace) && fileToIncludeLocal != null ? GlobalSearchScope.fileScope((PsiFile)fileToIncludeLocal) : includeScope;
            JSClassResolver.IncludeLocalMembersOptions includeLocalMembersOptions = includeLocalMembers = level.isFromComment() ? JSClassResolver.IncludeLocalMembersOptions.ALL : JSClassResolver.IncludeLocalMembersOptions.inFile(fileToIncludeLocal);
            if (ignorePerformanceLimit || JSIndexBasedResolveUtil.cheapEnoughToProcessByQName(includeScope, includeLocalMembers, project, qName)) {
                JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, scope2, includeLocalMembers, collector);
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_QNAME, (Object)collector.myCollectedElements.size());
                continue;
            }
            processor.setTooManyCandidates();
            return;
        }
        JSIndexBasedResolveUtil.checkElements(processor, collector);
        List<JSTaggedResolveResult> resultsWithCompleteMatches = processor.getTaggedResolveResults();
        boolean hasValidResult = false;
        for (JSTaggedResolveResult completeMatchResult : resultsWithCompleteMatches) {
            if (!completeMatchResult.result.isValidResult() || completeMatchResult.hasTag(JSTaggedResolveResult.ResolveResultTag.PARTIAL)) continue;
            hasValidResult = true;
            break;
        }
        if (!hasValidResult && !processor.addOnlyCompleteMatches()) {
            StubIndexKey<String, JSElement> indexKey;
            StubIndexKey<String, JSElement> stubIndexKey = processor.getTypeInfo().isGlobalContext() ? JSGlobalSymbolIndex.KEY : (indexKey = processor.getTypeInfo().isNonGlobalContext() ? JSNonGlobalSymbolIndex.KEY : JSSymbolIndex2.KEY);
            if (ignorePerformanceLimit || JSIndexBasedResolveUtil.cheapEnoughToProcess(includeScope, project, name, indexKey)) {
                JSClassResolver.processElementsByNameIncludingImplicit(name, includeScope, false, indexKey, collector);
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_NAME, (Object)collector.myCollectedElements.size());
                JSIndexBasedResolveUtil.checkElements(processor, collector);
            } else {
                processor.setTooManyCandidates();
                return;
            }
        }
        JSIndexBasedResolveUtil.processImplicitElementProxies(name, includeScope, project, new JSSymbolProcessor(){

            @Override
            public boolean acceptsFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processor.acceptsFile(file);
            }

            @Override
            public boolean process(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                processor.doQualifiedCheck(element);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptsFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean cheapEnoughToProcessByQName(@NotNull GlobalSearchScope allScope, @NotNull JSClassResolver.IncludeLocalMembersOptions includeLocalMembers, @NotNull Project project, @NotNull String name) {
        int maxFileCount2;
        Iterator files2;
        int maxFileCount1;
        Iterator files1;
        GlobalSearchScope scope1;
        if (allScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(3);
        }
        if (includeLocalMembers == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(5);
        }
        if (name == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(6);
        }
        if ((scope1 = includeLocalMembers.getScopeForGlobalSymbolIndex(name, allScope)) != null) {
            files1 = StubIndex.getInstance().getContainingFilesIterator(JSGlobalSymbolIndex.KEY, (Object)name, project, scope1);
            maxFileCount1 = StubIndex.getInstance().getMaxContainingFileCount(JSGlobalSymbolIndex.KEY, (Object)name, project, scope1);
        } else {
            files1 = null;
            maxFileCount1 = 0;
        }
        GlobalSearchScope scope2 = includeLocalMembers.getScopeForSymbolQualifiedNamesIndex(name, allScope);
        if (scope2 != null) {
            files2 = StubIndex.getInstance().getContainingFilesIterator(JSSymbolQualifiedNamesIndex.KEY, (Object)name, project, scope2);
            maxFileCount2 = StubIndex.getInstance().getMaxContainingFileCount(JSGlobalSymbolIndex.KEY, (Object)name, project, scope2);
        } else {
            files2 = null;
            maxFileCount2 = 0;
        }
        return JSIndexBasedResolveUtil.hasLessFilesInScope(scope1, files1, maxFileCount1, scope2, files2, maxFileCount2, MAX_FILES_TO_PROCESS_BY_QNAME);
    }

    private static boolean cheapEnoughToProcess(@NotNull GlobalSearchScope allScope, @NotNull Project project, @NotNull String name, @NotNull StubIndexKey<String, JSElement> indexKey) {
        if (allScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(9);
        }
        if (indexKey == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(10);
        }
        return JSIndexBasedResolveUtil.hasLessFilesInScope(allScope, project, name, indexKey, MAX_FILES_TO_PROCESS);
    }

    public static <T> boolean hasLessFilesInScope(@NotNull GlobalSearchScope scope2, @NotNull Project project, @NotNull T key2, @NotNull StubIndexKey<T, ?> indexKey, int filesLimit) {
        if (scope2 == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(12);
        }
        if (key2 == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(13);
        }
        if (indexKey == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(14);
        }
        Iterator files2 = StubIndex.getInstance().getContainingFilesIterator(indexKey, key2, project, scope2);
        int maxFileCount = StubIndex.getInstance().getMaxContainingFileCount(indexKey, key2, project, scope2);
        return JSIndexBasedResolveUtil.hasLessFilesInScope(scope2, files2, maxFileCount, null, null, 0, filesLimit);
    }

    private static boolean hasLessFilesInScope(@Nullable GlobalSearchScope scope1, @Nullable Iterator<VirtualFile> files1, int maxFileCount1, @Nullable GlobalSearchScope scope2, @Nullable Iterator<VirtualFile> files2, int maxFileCount2, int filesLimit) {
        if ((files1 != null ? maxFileCount1 : 0) + (files2 != null ? maxFileCount2 : 0) <= filesLimit) {
            return true;
        }
        int exactSize = 0;
        if (scope1 != null && files1 != null) {
            exactSize += JSIndexBasedResolveUtil.countFilesInScope(scope1, files1, filesLimit);
        }
        if (exactSize > filesLimit) {
            return false;
        }
        if (scope2 != null && files2 != null) {
            exactSize += JSIndexBasedResolveUtil.countFilesInScope(scope2, files2, filesLimit - exactSize);
        }
        return exactSize <= filesLimit;
    }

    private static int countFilesInScope(@NotNull GlobalSearchScope scope2, @NotNull Iterator<VirtualFile> files2, int filesLimit) {
        if (scope2 == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(15);
        }
        if (files2 == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(16);
        }
        int exactSize = 0;
        while (files2.hasNext()) {
            VirtualFile file = files2.next();
            if (file == null || scope2.contains(file)) {
                ++exactSize;
            }
            if (exactSize <= filesLimit) continue;
            return exactSize;
        }
        return exactSize;
    }

    private static void checkElements(WalkUpResolveProcessor processor, JSSymbolCollector collector) {
        collector.checkElements(element -> {
            ProgressManager.checkCanceled();
            if (!processor.acceptsFile(element.getContainingFile())) {
                return;
            }
            if (element instanceof JSQualifiedNamedElement || element instanceof JSImplicitElement) {
                processor.doQualifiedCheck((JSPsiElementBase)element);
            } else {
                processor.doUnqualifiedCheck((PsiElement)element);
            }
        });
    }

    public static boolean processImplicitElementProxies(@Nullable String name, @NotNull GlobalSearchScope scope2, @NotNull Project project, @NotNull JSSymbolProcessor processor) {
        if (scope2 == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(19);
        }
        Set<String> implicitKeys = name != null ? Collections.singleton(name) : FileBasedIndex.getInstance().getAllKeys(JSImplicitElementsIndex.INDEX_ID, project);
        ArrayList implicitElementProxies = new ArrayList();
        for (String key2 : implicitKeys) {
            FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)key2, null, (virtualFile, value) -> {
                implicitElementProxies.add(Pair.create((Object)virtualFile, (Object)value));
                return true;
            }, scope2);
        }
        for (Pair pair : implicitElementProxies) {
            VirtualFile virtualFile2 = (VirtualFile)pair.first;
            Collection value2 = (Collection)pair.second;
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile2 == null || !processor.acceptsFile(psiFile2)) continue;
            for (JSImplicitElementsIndex.JSElementProxy proxy : value2) {
                JSOffsetBasedImplicitElement element = proxy.toOffsetBasedImplicitElement(psiFile2);
                if (element.getUserString() != null || processor.process(element)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeScope";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeLocalMembers";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllSymbols";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "cheapEnoughToProcessByQName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "cheapEnoughToProcess";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "hasLessFilesInScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "countFilesInScope";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "processImplicitElementProxies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JSSymbolCollector
    implements Processor<JSPsiElementBase> {
        @NotNull
        private final List<PsiElement> myCollectedElements;
        @Nullable
        private Set<PsiElement> myCheckedElements;
        private Set<? super PsiElement> myProcessedElements;
        private final boolean myIncludeTypeOnlyContextSymbols;

        JSSymbolCollector(@NotNull Set<? super PsiElement> alreadyProcessed, boolean includeTypeOnlyContextSymbols) {
            if (alreadyProcessed == null) {
                JSSymbolCollector.$$$reportNull$$$0(0);
            }
            this.myIncludeTypeOnlyContextSymbols = includeTypeOnlyContextSymbols;
            this.myCollectedElements = new ArrayList<PsiElement>();
            this.myProcessedElements = alreadyProcessed;
        }

        public boolean process(JSPsiElementBase element) {
            ProgressManager.checkCanceled();
            if (this.myCheckedElements != null) {
                if (this.myProcessedElements == null) {
                    this.myProcessedElements = this.myCheckedElements;
                } else {
                    this.myProcessedElements.addAll(this.myCheckedElements);
                }
                this.myCheckedElements = null;
            }
            if (element instanceof JSFunctionExpression || element instanceof ES6Decorator || !this.myIncludeTypeOnlyContextSymbols && element instanceof TypeScriptInterface) {
                return true;
            }
            if (this.myProcessedElements == null || !this.myProcessedElements.contains(element)) {
                this.myCollectedElements.add((PsiElement)element);
            }
            return true;
        }

        public void checkElements(@NotNull Consumer<? super PsiElement> consumer) {
            if (consumer == null) {
                JSSymbolCollector.$$$reportNull$$$0(1);
            }
            HashSet<PsiElement> elements = new HashSet<PsiElement>(this.myCollectedElements.size());
            Consumer<PsiElement> elementConsumer = e -> {
                ProgressManager.checkCanceled();
                if (elements.add((PsiElement)e)) {
                    consumer.accept((PsiElement)e);
                }
            };
            this.myCollectedElements.forEach(elementConsumer);
            this.myCheckedElements = elements;
            this.myCollectedElements.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyProcessed";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$JSSymbolCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkElements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface JSSymbolProcessor {
        public boolean acceptsFile(@NotNull PsiFile var1);

        public boolean process(@NotNull JSPsiElementBase var1);
    }
}

