/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationCache;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JSEvaluableTypeResolver {
    @NotNull
    public static final JSEvaluableTypeResolver FOR_CACHING = new JSEvaluableTypeResolver(false, false);
    @NotNull
    private static final JSEvaluableTypeResolver PASS_PROPERTY_OWNER_TYPES = new JSEvaluableTypeResolver(true, true);
    @NotNull
    private static final JSEvaluableTypeResolver SKIP_PROPERTY_OWNER_TYPES = new JSEvaluableTypeResolver(true, false);
    private final boolean myUnwrapPropertyOwnerTypes;
    private final boolean myPassUnwrappedPropertyOwnerTypes;

    private JSEvaluableTypeResolver(boolean unwrapPropertyOwnerTypes, boolean passUnwrappedPropertyOwnerTypes) {
        this.myUnwrapPropertyOwnerTypes = unwrapPropertyOwnerTypes;
        this.myPassUnwrappedPropertyOwnerTypes = passUnwrappedPropertyOwnerTypes;
    }

    @NotNull
    public static JSEvaluableTypeResolver complete(boolean passPropertiesOwnerTypes) {
        JSEvaluableTypeResolver jSEvaluableTypeResolver = passPropertiesOwnerTypes ? PASS_PROPERTY_OWNER_TYPES : SKIP_PROPERTY_OWNER_TYPES;
        if (jSEvaluableTypeResolver == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(0);
        }
        return jSEvaluableTypeResolver;
    }

    @NotNull
    public JSTypeEvaluationResult unwrapRecursively(@NotNull JSEvaluableOnlyType type2, boolean isAdditionalType, @NotNull JSEvaluateContext context2) {
        Object element;
        if (type2 == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(2);
        }
        if (type2 instanceof JSTypeOfPsiElementBase && context2.isAstAccessAllowed((PsiElement)(element = ((JSTypeOfPsiElementBase)type2).getElement())) && ((JSTypeOfPsiElementBase)type2).matchesSourceElement() && !DialectDetector.isActionScript(element)) {
            JSTypeEvaluationResult cachedResult;
            boolean evaluatedAsExpression = element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element);
            JSEvaluateContext contextForCached = context2.withCombinedStrictness(type2.isSourceStrict());
            if (!evaluatedAsExpression) {
                contextForCached = contextForCached.withSource((PsiElement)element);
            }
            if ((cachedResult = JSEvaluationCache.getElementType(element, contextForCached)) == null) {
                cachedResult = new JSTypeEvaluationResult();
            }
            JSTypeEvaluationResult result2 = new JSTypeEvaluationResult();
            for (JSEvaluationResultElement resultElement : cachedResult.getResults()) {
                JSType resultElementType = resultElement.getTypeOrAdditionalType();
                if (resultElementType instanceof JSEvaluableOnlyType) {
                    JSEvaluationResultElement finalResultElement = resultElement;
                    JSTypeEvaluationResult newResult = (JSTypeEvaluationResult)JSEvaluationRecursionGuard.compute(resultElementType, resultElement.getEvaluateContext(), () -> this.unwrapRecursively((JSEvaluableOnlyType)resultElementType, finalResultElement.isAdditionalType() || isAdditionalType, finalResultElement.getEvaluateContext()));
                    List<Object> results = newResult == null ? Collections.emptyList() : newResult.getResults();
                    for (JSEvaluationResultElement jSEvaluationResultElement : results) {
                        result2.addResultElement(jSEvaluationResultElement);
                    }
                    continue;
                }
                if (isAdditionalType && !resultElement.isAdditionalType()) {
                    resultElement = new JSEvaluationResultElement(resultElementType, true, resultElement.getEvaluateContext());
                }
                result2.addResultElement(resultElement);
            }
            JSTypeEvaluationResult jSTypeEvaluationResult = result2;
            if (jSTypeEvaluationResult == null) {
                JSEvaluableTypeResolver.$$$reportNull$$$0(3);
            }
            return jSTypeEvaluationResult;
        }
        JSTypeEvaluationResult jSTypeEvaluationResult = this.doUnwrapRecursively(type2, isAdditionalType, context2);
        if (jSTypeEvaluationResult == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(4);
        }
        return jSTypeEvaluationResult;
    }

    @NotNull
    public JSTypeEvaluationResult doUnwrapRecursively(@NotNull JSEvaluableOnlyType type2, boolean isAdditionalType, @NotNull JSEvaluateContext context2) {
        JSTypeEvaluationResult jSTypeEvaluationResult;
        if (type2 == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(6);
        }
        JSEvaluationLogger.getInstance().startTask(() -> "Unwrap " + type2);
        JSTypeEvaluationResult result2 = null;
        Throwable throwable = null;
        try {
            JSTypeEvaluationResult jSTypeEvaluationResult2 = result2 = this.doUnwrapRecursivelyInternal(type2, isAdditionalType, context2);
            jSTypeEvaluationResult = jSTypeEvaluationResult2;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            JSTypeEvaluationResult _result = result2;
            JSEvaluationLogger.getInstance().finishTask(() -> " --> " + _result, throwable);
        }
        if (jSTypeEvaluationResult == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(7);
        }
        return jSTypeEvaluationResult;
    }

    @NotNull
    private JSTypeEvaluationResult doUnwrapRecursivelyInternal(@NotNull JSEvaluableOnlyType type2, boolean isAdditionalType, @NotNull JSEvaluateContext context2) {
        JSTypeEvaluationResultProcessor processor;
        if (type2 == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        if (type2 instanceof JSPropertiesOwnerType && !this.myUnwrapPropertyOwnerTypes) {
            JSTypeEvaluationResult result2 = new JSTypeEvaluationResult();
            result2.addResultElement(new JSEvaluationResultElement(type2, isAdditionalType, context2));
            JSTypeEvaluationResult jSTypeEvaluationResult = result2;
            if (jSTypeEvaluationResult == null) {
                JSEvaluableTypeResolver.$$$reportNull$$$0(10);
            }
            return jSTypeEvaluationResult;
        }
        JSEvaluationTask evaluatedOnce = (JSEvaluationTask)JSEvaluationRecursionGuard.compute(type2, context2, () -> type2.evaluate(context2));
        if (evaluatedOnce == null) {
            evaluatedOnce = JSEvaluationTasks.EMPTY;
        }
        JSEvaluationTask evaluatedCompletely = evaluatedOnce.transform(element -> {
            JSType typeOrAdditionalType = element.getTypeOrAdditionalType();
            if (typeOrAdditionalType instanceof JSEvaluableOnlyType) {
                JSEvaluateContext elementContext = element.getEvaluateContext();
                JSTypeEvaluationResult unwrapped = (JSTypeEvaluationResult)JSEvaluationRecursionGuard.compute(typeOrAdditionalType, elementContext, () -> this.unwrapRecursively((JSEvaluableOnlyType)typeOrAdditionalType, element.isAdditionalType(), elementContext));
                List<Object> unwrappedResults = unwrapped != null ? unwrapped.getResults() : Collections.emptyList();
                return unwrappedResults.isEmpty() ? JSEvaluableOnlyTypeBase.getTaskForUnknownElement(type2.getSourceElement(), context2) : JSEvaluationTasks.fromList(Collections.unmodifiableList(unwrappedResults));
            }
            return element;
        });
        JSTypeEvaluationResultProcessor jSTypeEvaluationResultProcessor = processor = isAdditionalType ? new JSAdditionalTypeEvaluationResultProcessor() : new JSTypeEvaluationResultProcessor();
        if (type2 instanceof JSPropertiesOwnerType && this.myPassUnwrappedPropertyOwnerTypes) {
            processor.process(type2, context2);
        }
        evaluatedCompletely.applyWithContext(processor, context2);
        JSTypeEvaluationResult jSTypeEvaluationResult = processor.getResult();
        if (jSTypeEvaluationResult == null) {
            JSEvaluableTypeResolver.$$$reportNull$$$0(11);
        }
        return jSTypeEvaluationResult;
    }

    public boolean willPassPropertiesOwnerTypes() {
        return !this.myUnwrapPropertyOwnerTypes || this.myPassUnwrappedPropertyOwnerTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluableTypeResolver";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "complete";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluableTypeResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapRecursively";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doUnwrapRecursively";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doUnwrapRecursivelyInternal";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrapRecursively";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doUnwrapRecursively";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doUnwrapRecursivelyInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private static final class JSAdditionalTypeEvaluationResultProcessor
    extends JSTypeEvaluationResultProcessor {
        private JSAdditionalTypeEvaluationResultProcessor() {
        }

        @Override
        public void process(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
            if (type2 == null) {
                JSAdditionalTypeEvaluationResultProcessor.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                JSAdditionalTypeEvaluationResultProcessor.$$$reportNull$$$0(1);
            }
            this.processAdditionalType(type2, evaluateContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "evaluateContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluableTypeResolver$JSAdditionalTypeEvaluationResultProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

