/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.evaluable.JSObjectLiteralExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSContextResolver;", "", "context", "Lcom/intellij/psi/PsiElement;", "isAstAccessAllowed", "", "(Lcom/intellij/psi/PsiElement;Z)V", "resolveResult", "applyTypeContext", "Lcom/intellij/lang/javascript/psi/JSNamespace;", "ns", "typeContext", "Lcom/intellij/lang/javascript/psi/types/JSTypeContext;", "buildProvidedNamespace", "resolvedElement", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "isStrict", "doResolveContext", "evaluateNamespaceLocally", "expression", "Lcom/intellij/lang/javascript/psi/JSExpression;", "findContextTypeFromComment", "container", "findFromParentExpression", "parentContainerGrandParent", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "findNamespace", "getContainingClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "parentFunctionOrClass", "looksLikeConstructor", "element", "proceedFromProperty", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "Companion", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSContextResolver.kt\ncom/intellij/lang/javascript/psi/resolve/JSContextResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n1#2:305\n*E\n"})
public final class JSContextResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement context;
    private final boolean isAstAccessAllowed;
    @Nullable
    private PsiElement resolveResult;
    @NotNull
    private static final JSDocBlockTags[] CLASS_MARKERS;

    private JSContextResolver(PsiElement context2, boolean isAstAccessAllowed) {
        this.context = context2;
        this.isAstAccessAllowed = isAstAccessAllowed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JSNamespace doResolveContext() {
        JSNamespace jSNamespace = this.findContextTypeFromComment(this.context);
        if (jSNamespace != null) {
            return jSNamespace;
        }
        JSQualifiedNamedElement parentFunctionOrClass = JSContextResolver.Companion.findMemberFunctionOrClass(this.context);
        JSNamespace jSNamespace2 = this.findContextTypeFromComment((PsiElement)parentFunctionOrClass);
        if (jSNamespace2 != null) {
            return jSNamespace2;
        }
        JSClass containingClass = this.getContainingClass(parentFunctionOrClass);
        if (containingClass != null) {
            JSQualifiedNamedElement member;
            Object object;
            Class[] classArray;
            JSQualifiedNamedElement jSQualifiedNamedElement;
            JSDocBlockTags[] jSDocBlockTagsArray;
            boolean isStrict = containingClass.getExtendsList() == null || this.isAstAccessAllowed && JSDocumentationUtils.hasJSDocTag(containingClass, Arrays.copyOf(jSDocBlockTagsArray = CLASS_MARKERS, jSDocBlockTagsArray.length));
            JSNamespace jSNamespace3 = this.buildProvidedNamespace(containingClass, isStrict);
            JSFunction jSFunction = parentFunctionOrClass instanceof JSFunction ? (JSFunction)parentFunctionOrClass : null;
            if (jSFunction != null) {
                jSQualifiedNamedElement = jSFunction;
            } else {
                classArray = new Class[]{JSFieldVariable.class};
                jSQualifiedNamedElement = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)this.context, (Class[])classArray);
            }
            if ((object = (member = jSQualifiedNamedElement)) == null || (object = object.getJSContext()) == null) {
                object = JSContext.UNKNOWN;
            }
            classArray = object;
            Intrinsics.checkNotNull((Object)classArray);
            Class[] classArray2 = classArray;
            JSTypeContext jSTypeContext = JSTypeContext.fromJSContext((JSContext)classArray2, true);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jSTypeContext), (String)"fromJSContext(...)");
            return this.applyTypeContext(jSNamespace3, jSTypeContext);
        }
        if (parentFunctionOrClass instanceof JSFunctionProperty) {
            return this.proceedFromProperty((JSProperty)parentFunctionOrClass);
        }
        if (parentFunctionOrClass instanceof JSFunctionExpression) {
            PsiElement context2 = ((JSFunctionExpression)parentFunctionOrClass).getContext();
            PsiElement psiElement = context2 instanceof JSParenthesizedExpression ? JSPsiImplUtils.getNonParenthesizeParent(context2) : context2;
            JSNamespace member = this.findContextTypeFromComment(psiElement);
            if (member != null) {
                return member;
            }
            if (psiElement instanceof JSAssignmentExpression && this.isAstAccessAllowed) {
                JSExpression jSExpression;
                JSDefinitionExpression definitionExpression;
                JSDefinitionExpression jSDefinitionExpression = definitionExpression = ((JSAssignmentExpression)psiElement).getDefinitionExpression();
                JSExpression jSExpression2 = jSExpression = jSDefinitionExpression != null ? jSDefinitionExpression.getExpression() : null;
                if (jSExpression instanceof JSReferenceExpression) {
                    JSExpression functionExpressionNameQualifier = ((JSReferenceExpression)jSExpression).getQualifier();
                    if (functionExpressionNameQualifier instanceof JSThisExpression) {
                        this.resolveResult = (PsiElement)functionExpressionNameQualifier;
                        JSNamespace jSNamespace4 = Companion.resolveContext((PsiElement)functionExpressionNameQualifier, true);
                        JSNamespace qualifierNs = jSNamespace4;
                        if (jSNamespace4 != null) return qualifierNs instanceof JSNamedType && ((JSNamedType)qualifierNs).getTypeContext() == JSTypeContext.INSTANCE ? qualifierNs.copyWithTypeContext(JSTypeContext.PROTOTYPE) : qualifierNs;
                        return null;
                    }
                    if (functionExpressionNameQualifier instanceof JSReferenceExpression) {
                        String functionExpressionNameQualifierText = ((JSReferenceExpression)functionExpressionNameQualifier).getReferenceName();
                        if (Intrinsics.areEqual((Object)"prototype", (Object)functionExpressionNameQualifierText)) {
                            JSExpression qualifier = ((JSReferenceExpression)functionExpressionNameQualifier).getQualifier();
                            if (qualifier != null) {
                                this.resolveResult = (PsiElement)qualifier;
                                return this.applyTypeContext(definitionExpression.getJSNamespace(), JSTypeContext.INSTANCE);
                            }
                        } else if (!this.looksLikeConstructor(definitionExpression) && !JSSymbolUtil.isExplicitExportReference((JSReferenceExpression)jSExpression)) {
                            JSNamespace jSNamespace5 = this.evaluateNamespaceLocally(functionExpressionNameQualifier);
                            return (JSNamespace)(jSNamespace5 != null ? jSNamespace5.copyWithStrict(false) : null);
                        }
                    }
                }
                if (definitionExpression == null) return null;
                return this.applyTypeContext(this.buildProvidedNamespace(definitionExpression, true), JSTypeContext.PROTOTYPE);
            }
            if (psiElement instanceof JSProperty) {
                return this.proceedFromProperty((JSProperty)psiElement);
            }
            if (psiElement instanceof JSNewExpression) {
                return this.findNamespace((JSExpression)psiElement);
            }
            if (psiElement instanceof JSReferenceExpression) {
                return this.findFromParentExpression((JSReferenceExpression)psiElement);
            }
            if (!(psiElement instanceof ES6ExportDefaultAssignment)) return this.applyTypeContext(this.findNamespace((JSExpression)((Object)parentFunctionOrClass)), JSTypeContext.PROTOTYPE);
            if (((JSFunctionExpression)parentFunctionOrClass).getName() != null) return this.applyTypeContext(this.findNamespace((JSExpression)((Object)parentFunctionOrClass)), JSTypeContext.PROTOTYPE);
            JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create("default", null);
            Intrinsics.checkNotNullExpressionValue((Object)jSQualifiedNameImpl, (String)"create(...)");
            JSQualifiedNameImpl qName = jSQualifiedNameImpl;
            return JSNamedTypeFactory.createNamespace((JSQualifiedName)qName, JSContext.INSTANCE, psiElement, true);
        }
        if (parentFunctionOrClass instanceof JSFunction) {
            JSNamespace ns = this.buildProvidedNamespace(parentFunctionOrClass, this.looksLikeConstructor(parentFunctionOrClass));
            return this.applyTypeContext(ns, JSTypeContext.PROTOTYPE);
        }
        if (!this.isAstAccessAllowed) return null;
        if (parentFunctionOrClass != null) return null;
        Class[] classArray = new Class[]{JSProperty.class};
        JSProperty property = (JSProperty)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.context, (Class[])classArray);
        if (property != null) {
            JSNamespace jSNamespace6 = this.proceedFromProperty(property);
            if (jSNamespace6 == null) return null;
            return jSNamespace6;
        }
        if (!(this.context instanceof JSVarStatement)) return null;
        JSVariable[] jSVariableArray = ((JSVarStatement)this.context).getVariables();
        Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
        JSVariable[] jSVariableArray2 = jSVariableArray;
        if (jSVariableArray2.length == 0) {
            return null;
        }
        boolean bl = false;
        if (bl) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        JSVariable jSVariable = jSVariableArray2[0];
        Intrinsics.checkNotNullExpressionValue((Object)jSVariable, (String)"get(...)");
        return this.buildProvidedNamespace(jSVariable, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean looksLikeConstructor(JSQualifiedNamedElement element) {
        String referencedName = element.getName();
        if (StringUtil.isEmpty((String)referencedName)) return false;
        String string = referencedName;
        Intrinsics.checkNotNull((Object)string);
        if (!Character.isUpperCase(string.charAt(0))) return false;
        return true;
    }

    private final JSNamespace findContextTypeFromComment(PsiElement container) {
        JSType jSType;
        return this.isAstAccessAllowed ? ((jSType = JSDocumentationUtils.findContextType(container)) instanceof JSNamespace ? (JSNamespace)jSType : null) : null;
    }

    private final JSNamespace findFromParentExpression(JSReferenceExpression parentContainerGrandParent) {
        JSArgumentList argumentList;
        PsiElement psiElement = parentContainerGrandParent.getParent();
        JSCallExpression jSCallExpression = psiElement instanceof JSCallExpression ? (JSCallExpression)psiElement : null;
        if (jSCallExpression == null) {
            return null;
        }
        JSCallExpression parentContainerGrandSecondParent = jSCallExpression;
        String referencedName = parentContainerGrandParent.getReferenceName();
        if (Intrinsics.areEqual((Object)"apply", (Object)referencedName)) {
            argumentList = parentContainerGrandSecondParent.getArgumentList();
            if (argumentList != null) {
                JSExpression arg0;
                JSExpression[] jSExpressionArray = argumentList.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
                JSExpression[] args = jSExpressionArray;
                if (args.length == 1 && (arg0 = args[0]) instanceof JSReferenceExpression) {
                    return this.evaluateNamespaceLocally(arg0);
                }
            }
        } else if (Intrinsics.areEqual((Object)"bind", (Object)referencedName) && (argumentList = parentContainerGrandSecondParent.getArgumentList()) != null) {
            JSExpression[] jSExpressionArray = argumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
            JSExpression[] args = jSExpressionArray;
            if (args.length == 1 && args[0] instanceof JSThisExpression) {
                JSExpression jSExpression = args[0];
                Intrinsics.checkNotNullExpressionValue((Object)jSExpression, (String)"get(...)");
                return Companion.resolveContext((PsiElement)jSExpression, this.isAstAccessAllowed);
            }
        }
        return null;
    }

    private final JSNamespace proceedFromProperty(JSProperty property) {
        PsiElement psiElement = JSStubBasedPsiTreeUtil.getParentOrNull((PsiElement)property);
        JSObjectLiteralExpression jSObjectLiteralExpression = psiElement instanceof JSObjectLiteralExpression ? (JSObjectLiteralExpression)psiElement : null;
        if (jSObjectLiteralExpression == null) {
            return null;
        }
        JSObjectLiteralExpression objectLiteral = jSObjectLiteralExpression;
        this.resolveResult = (PsiElement)objectLiteral;
        if (this.isAstAccessAllowed) {
            String[] stringArray;
            JSExpression methodExpression;
            PsiElement callExpression;
            PsiElement argumentList;
            String it = property.getName();
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)"get", (Object)it) || Intrinsics.areEqual((Object)"set", (Object)it);
            if (bl2 && (argumentList = objectLiteral.getParent()) instanceof JSArgumentList && (callExpression = argumentList.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)callExpression).getMethodExpression()) instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, stringArray = new String[]{"Object", "defineProperty"})) {
                JSExpression jSExpression = ((JSArgumentList)argumentList).getArguments()[0];
                Intrinsics.checkNotNullExpressionValue((Object)jSExpression, (String)"get(...)");
                return this.evaluateNamespaceLocally(jSExpression);
            }
        }
        if (this.isAstAccessAllowed) {
            for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                String context2 = handler.resolveContextFromProperty(objectLiteral, false);
                if (context2 == null) continue;
                JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.fromQualifiedName(context2);
                Intrinsics.checkNotNullExpressionValue((Object)jSQualifiedNameImpl, (String)"fromQualifiedName(...)");
                JSQualifiedNameImpl qName = jSQualifiedNameImpl;
                return JSNamedTypeFactory.createNamespace((JSQualifiedName)qName, JSContext.UNKNOWN, (PsiElement)objectLiteral, true);
            }
        }
        return this.findNamespace(objectLiteral);
    }

    private final JSNamespace findNamespace(JSExpression expression) {
        JSNamespace namespace;
        this.resolveResult = (PsiElement)expression;
        if (this.isAstAccessAllowed && (namespace = JSSymbolUtil.findNamespace(expression)) != null) {
            JSType jSType = namespace.copyWithStrict(false);
            Intrinsics.checkNotNull((Object)jSType, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSNamespace");
            return (JSNamespace)jSType;
        }
        JSQualifiedNamedElement initializedElement = JSPsiImplUtils.getInitializedElement(expression, this.isAstAccessAllowed);
        if (initializedElement != null) {
            return this.buildProvidedNamespace(initializedElement, true);
        }
        return null;
    }

    private final JSNamespace evaluateNamespaceLocally(JSExpression expression) {
        this.resolveResult = (PsiElement)expression;
        if (this.isAstAccessAllowed) {
            return JSSymbolUtil.evaluateNamespaceLocally(expression);
        }
        return null;
    }

    private final JSClass getContainingClass(JSQualifiedNamedElement parentFunctionOrClass) {
        PsiElement psiElement;
        PsiElement parentContainerParent;
        if (parentFunctionOrClass instanceof JSClass) {
            return (JSClass)parentFunctionOrClass;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = parentFunctionOrClass;
        PsiElement psiElement2 = parentContainerParent = jSQualifiedNamedElement != null ? jSQualifiedNamedElement.getContext() : (PsiElement)this.context.getContainingFile();
        if (this.isAstAccessAllowed && parentContainerParent instanceof JSFile) {
            parentContainerParent = JSResolveUtil.getClassReferenceForXmlFromContext(parentContainerParent);
        }
        return (psiElement = parentContainerParent) instanceof JSClass ? (JSClass)psiElement : null;
    }

    private final JSNamespace buildProvidedNamespace(JSQualifiedNamedElement resolvedElement, boolean isStrict) {
        this.resolveResult = (PsiElement)resolvedElement;
        return JSNamedTypeFactory.buildProvidedNamespace(resolvedElement, isStrict);
    }

    private final JSNamespace applyTypeContext(JSNamespace ns, JSTypeContext typeContext) {
        JSNamespace jSNamespace = ns;
        return jSNamespace != null ? jSNamespace.copyWithTypeContext(typeContext) : null;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final JSNamespace resolveContext(@NotNull PsiElement element, boolean isAstAccessAllowed) {
        return Companion.resolveContext(element, isAstAccessAllowed);
    }

    @JvmStatic
    public static final boolean resolveContext(@NotNull PsiElement element, @NotNull JSEvaluateContext evaluateContext, @NotNull JSTypeProcessor typeProcessor) {
        return Companion.resolveContext(element, evaluateContext, typeProcessor);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement resolveThisReference(@NotNull PsiElement element) {
        return Companion.resolveThisReference(element);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findContextElement(@NotNull PsiElement thisExpression) {
        return Companion.findContextElement(thisExpression);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final JSNamespace resolveContext(@NotNull PsiElement element) {
        return Companion.resolveContext(element);
    }

    public /* synthetic */ JSContextResolver(PsiElement context2, boolean isAstAccessAllowed, DefaultConstructorMarker $constructor_marker) {
        this(context2, isAstAccessAllowed);
    }

    static {
        JSDocBlockTags[] jSDocBlockTagsArray = new JSDocBlockTags[]{JSDocBlockTags.CLASS, JSDocBlockTags.MEMBER_OF, JSDocBlockTags.NAME, JSDocBlockTags.THIS, JSDocBlockTags.ALIAS};
        CLASS_MARKERS = jSDocBlockTagsArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\rH\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSContextResolver$Companion;", "", "()V", "CLASS_MARKERS", "", "Lcom/intellij/lang/javascript/psi/jsdoc/JSDocBlockTags;", "[Lcom/intellij/lang/javascript/psi/jsdoc/JSDocBlockTags;", "findContextElement", "Lcom/intellij/psi/PsiElement;", "thisExpression", "findMemberFunctionOrClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "resolveContext", "", "element", "evaluateContext", "Lcom/intellij/lang/javascript/psi/resolve/JSEvaluateContext;", "typeProcessor", "Lcom/intellij/lang/javascript/psi/resolve/JSTypeProcessor;", "Lcom/intellij/lang/javascript/psi/JSNamespace;", "isAstAccessAllowed", "resolveThisReference", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final JSNamespace resolveContext(@NotNull PsiElement element, boolean isAstAccessAllowed) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return new JSContextResolver(element, isAstAccessAllowed, null).doResolveContext();
        }

        public static /* synthetic */ JSNamespace resolveContext$default(Companion companion, PsiElement psiElement, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.resolveContext(psiElement, bl);
        }

        @JvmStatic
        public final boolean resolveContext(@NotNull PsiElement element, @NotNull JSEvaluateContext evaluateContext, @NotNull JSTypeProcessor typeProcessor) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
            Intrinsics.checkNotNullParameter((Object)typeProcessor, (String)"typeProcessor");
            JSContextResolver resolver = new JSContextResolver(element, evaluateContext.isAstAccessAllowed(element), null);
            JSNamespace resultNs = resolver.doResolveContext();
            PsiElement resolveResult = resolver.resolveResult;
            if (resolveResult instanceof JSObjectLiteralExpression) {
                typeProcessor.processAdditionalType(new JSObjectLiteralExpressionType((JSObjectLiteralExpression)resolveResult).copyWithStrict(false), evaluateContext);
            }
            if (resultNs != null) {
                typeProcessor.process(resultNs, evaluateContext);
            }
            return resultNs != null;
        }

        @JvmStatic
        @Nullable
        public final PsiElement resolveThisReference(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            JSContextResolver resolver = new JSContextResolver(element, true, null);
            JSNamespace ns = resolver.doResolveContext();
            JSNamespace jSNamespace = ns;
            if (jSNamespace == null || (jSNamespace = jSNamespace.getSourceElement()) == null) {
                jSNamespace = resolver.resolveResult;
            }
            return jSNamespace;
        }

        @JvmStatic
        @Nullable
        public final PsiElement findContextElement(@NotNull PsiElement thisExpression) {
            Intrinsics.checkNotNullParameter((Object)thisExpression, (String)"thisExpression");
            JSQualifiedNamedElement parentContainer = this.findMemberFunctionOrClass(thisExpression);
            if (parentContainer != null) {
                PsiElement psiElement = parentContainer.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                PsiElement parentContainerParent = psiElement;
                if (parentContainerParent instanceof JSClass) {
                    parentContainer = (JSQualifiedNamedElement)parentContainerParent;
                }
            }
            return (PsiElement)parentContainer;
        }

        private final JSQualifiedNamedElement findMemberFunctionOrClass(PsiElement thisExpression) {
            Class[] classArray = new Class[]{JSFunction.class, JSClass.class};
            JSQualifiedNamedElement parentContainer = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)thisExpression, (Class[])classArray);
            while (parentContainer instanceof JSFunction && ((JSFunction)parentContainer).isArrowFunction()) {
                classArray = new Class[]{JSFunction.class, JSClass.class};
                parentContainer = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)((PsiElement)parentContainer), (Class[])classArray);
            }
            return parentContainer;
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final JSNamespace resolveContext(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return com.intellij.lang.javascript.psi.resolve.JSContextResolver$Companion.resolveContext$default(this, element, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

