/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSObjectLiteralExpressionImpl
extends JSStubElementImpl<JSObjectLiteralExpressionStub>
implements JSObjectLiteralExpression {
    private static final TokenSet PROPERTIES_AND_SPREADS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.PROPERTIES, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.SPREAD_EXPRESSION})});

    public JSObjectLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSObjectLiteralExpressionImpl(JSObjectLiteralExpressionStub stub) {
        super(stub, JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    protected JSObjectLiteralExpressionImpl(JSObjectLiteralExpressionStub stub, IStubElementType type2) {
        super(stub, type2);
    }

    @Override
    public JSProperty @NotNull [] getProperties() {
        JSProperty[] jSPropertyArray = (JSProperty[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.PROPERTIES, JSProperty.ARRAY_FACTORY);
        if (jSPropertyArray == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return jSPropertyArray;
    }

    @Override
    @Nullable
    public JSProperty getFirstProperty() {
        return (JSProperty)JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSExtendedLanguagesTokenSetProvider.PROPERTIES);
    }

    @Override
    public JSProperty findProperty(String name) {
        if (name == null) {
            return null;
        }
        Collection<JSElement> namedElements = JSResolveUtil.findNamedElementsInScope(name, this);
        for (JSElement element : namedElements) {
            if (!(element instanceof JSProperty)) continue;
            return (JSProperty)element;
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSObjectLiteralExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public Icon getIcon(int flags) {
        return AllIcons.Json.Object;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        if (!(lastParent != null && place instanceof JSProperty || JSPropertyImpl.placeToProcessProperties(place))) {
            return true;
        }
        return JSResolveUtil.processDeclarationsInScope(this, processor, state, lastParent, place);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        PsiElement elt = super.addBefore(element, anchor);
        this.addCommaIfNeeded(elt);
        return elt;
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        PsiElement elt = super.addAfter(element, anchor);
        this.addCommaIfNeeded(elt);
        return elt;
    }

    private void addCommaIfNeeded(@Nullable PsiElement elt) {
        if (!(elt instanceof JSProperty)) {
            return;
        }
        JSChangeUtil.addCommaIfNeeded(elt, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, (x$0, x$1) -> super.addBefore((PsiElement)x$0, (PsiElement)x$1), (x$0, x$1) -> super.addAfter((PsiElement)x$0, (PsiElement)x$1));
    }

    @Override
    public JSExpression replace(@NotNull JSExpression other) {
        if (other == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        return JSChangeUtil.replaceExpression(this, other);
    }

    @Override
    public JSElement @NotNull [] getPropertiesIncludingSpreads() {
        JSElement[] jSElementArray = (JSElement[])this.getStubOrPsiChildren(PROPERTIES_AND_SPREADS, JSElement.ARRAY_FACTORY);
        if (jSElementArray == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        return jSElementArray;
    }

    @Override
    public boolean isEmpty() {
        return this.getFirstProperty() == null && this.getPropertiesIncludingSpreads().length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesIncludingSpreads";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

