/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionScriptAttributeListImpl
extends JSAttributeListImpl {
    private volatile JSAttribute[] myAttributes;
    private volatile Map<String, Object> myNameToAttributesMap;
    private static final Key<CachedValue<String>> ourCachedResolvedNsKey = Key.create((String)"ourCachedResolvedNs");
    private static final UserDataCache<CachedValue<String>, JSElement, Object> ourCachedOpenedNsesCache = new UserDataCache<CachedValue<String>, JSElement, Object>(){

        protected CachedValue<String> compute(JSElement jsElement, Object p) {
            return CachedValuesManager.getManager((Project)jsElement.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)ActionScriptPsiImplUtil.calcNamespaceReference((PsiElement)jsElement), new Object[]{jsElement.getContainingFile()}), false);
        }
    };

    public ActionScriptAttributeListImpl(ASTNode node) {
        super(node);
    }

    public ActionScriptAttributeListImpl(@NotNull JSAttributeListStub stub, @NotNull JSStubElementType<JSAttributeListStub, JSAttributeList> elementType) {
        if (stub == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(1);
        }
        super(stub, elementType);
    }

    public JSConditionalCompileVariableReference getConditionalCompileVariableReference() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null && !stub.hasConditionalCompilerVariable()) {
            return null;
        }
        ASTNode conditionalCompileVarRef = this.getNode().findChildByType(JSElementTypes.CONDITIONAL_COMPILE_VARIABLE_REFERENCE);
        return conditionalCompileVarRef != null ? (JSConditionalCompileVariableReference)conditionalCompileVarRef.getPsi() : null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(2);
        }
        if (element.getNode().getElementType() == JSTokenTypes.OVERRIDE_KEYWORD) {
            return JSChangeUtil.doDoAddBefore((PsiElement)this, element, this.getFirstChild());
        }
        return super.add(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSAttribute @NotNull [] getAttributes() {
        if (this.myAttributes == null) {
            ActionScriptAttributeListImpl actionScriptAttributeListImpl = this;
            synchronized (actionScriptAttributeListImpl) {
                if (this.myAttributes == null) {
                    this.myAttributes = (JSAttribute[])this.getStubOrPsiChildren(JSStubElementTypes.ATTRIBUTE, JSAttribute.ARRAY_FACTORY);
                }
            }
        }
        if (this.myAttributes == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(3);
        }
        return this.myAttributes;
    }

    @Override
    public JSAttribute @NotNull [] getAttributesByName(@NotNull String name) {
        if (name == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(4);
        }
        this.initAttributes();
        Object o = this.myNameToAttributesMap.get(name);
        if (o == null) {
            if (JSAttribute.EMPTY_ARRAY == null) {
                ActionScriptAttributeListImpl.$$$reportNull$$$0(5);
            }
            return JSAttribute.EMPTY_ARRAY;
        }
        if (o instanceof JSAttribute) {
            JSAttribute[] jSAttributeArray = new JSAttribute[]{(JSAttribute)o};
            if (jSAttributeArray == null) {
                ActionScriptAttributeListImpl.$$$reportNull$$$0(6);
            }
            return jSAttributeArray;
        }
        JSAttribute[] jSAttributeArray = (JSAttribute[])o;
        if (jSAttributeArray == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(7);
        }
        return jSAttributeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes() {
        if (this.myNameToAttributesMap == null) {
            ActionScriptAttributeListImpl actionScriptAttributeListImpl = this;
            synchronized (actionScriptAttributeListImpl) {
                if (this.myNameToAttributesMap == null) {
                    Map<String, Object> map = null;
                    for (JSAttribute attr : this.getAttributes()) {
                        String name = attr.getName();
                        if (name == null) continue;
                        if (map != null) {
                            Object o = map.get(name);
                            if (o == null) {
                                map.put(name, attr);
                                continue;
                            }
                            if (o instanceof JSAttribute) {
                                map.put(name, new JSAttribute[]{(JSAttribute)o, attr});
                                continue;
                            }
                            map.put(name, ArrayUtil.append((Object[])((JSAttribute[])o), (Object)attr, JSAttribute.class));
                            continue;
                        }
                        map = new HashMap();
                        map.put(name, attr);
                    }
                    if (map == null) {
                        map = Collections.emptyMap();
                    }
                    this.myNameToAttributesMap = map;
                }
            }
        }
    }

    @Override
    public JSAttribute findAttributeByName(@NotNull String name) {
        if (name == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(8);
        }
        this.initAttributes();
        Object o = this.myNameToAttributesMap.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof JSAttribute) {
            return (JSAttribute)o;
        }
        return ((JSAttribute[])o)[0];
    }

    @Nullable
    public String getNamespace() {
        JSAttributeListStub attributeListStub = (JSAttributeListStub)this.getGreenStub();
        if (attributeListStub != null) {
            return attributeListStub.getNamespace();
        }
        JSReferenceExpression namespaceElement = this.getNamespaceElement();
        return namespaceElement != null ? namespaceElement.getText() : null;
    }

    public JSReferenceExpression getNamespaceElement() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
        return node != null ? (JSReferenceExpression)node.getPsi() : null;
    }

    @Override
    public boolean hasModifier(@NotNull JSAttributeList.ModifierType modifier) {
        PsiElement parent;
        JSAttributeListStub stub;
        if (modifier == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(9);
        }
        if ((stub = (JSAttributeListStub)this.getGreenStub()) != null) {
            return stub.hasModifier(modifier);
        }
        if (this.hasExplicitModifier(modifier)) {
            return true;
        }
        if (modifier == JSAttributeList.ModifierType.STATIC && (parent = this.getParent()) instanceof JSNamespaceDeclaration) {
            PsiElement grandParent = JSResolveUtil.findParent(parent);
            return grandParent instanceof JSClass;
        }
        return false;
    }

    public String resolveNamespaceValue() {
        String ns = this.tryResolveNamespaceValueFromStub();
        if (ns != null) {
            return ns;
        }
        try {
            return (String)((CachedValue)ourCachedOpenedNsesCache.get(ourCachedResolvedNsKey, (UserDataHolder)this, null)).getValue();
        }
        catch (IndexNotReadyException ex) {
            return this.getNamespace();
        }
    }

    @Override
    public ES6Decorator @NotNull [] getDecorators() {
        if (ES6Decorator.EMPTY_ARRAY == null) {
            ActionScriptAttributeListImpl.$$$reportNull$$$0(10);
        }
        return ES6Decorator.EMPTY_ARRAY;
    }

    @Nullable
    public String tryResolveNamespaceValueFromStub() {
        String resolvedNamespace;
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null && !"-\"-".equals(resolvedNamespace = stub.getResolvedNamespace())) {
            return resolvedNamespace;
        }
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myNameToAttributesMap = null;
        this.myAttributes = null;
    }

    protected Object clone() {
        ActionScriptAttributeListImpl attrList = (ActionScriptAttributeListImpl)super.clone();
        attrList.myNameToAttributesMap = null;
        attrList.myAttributes = null;
        return attrList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesByName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 10 -> new IllegalStateException(string);
        };
    }
}

