/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeWithSignature;
import com.intellij.lang.javascript.ecmascript6.types.OverloadStrictness;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.TypeScriptSatisfiesExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionParameterExpectedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSReturnedExpressionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeEvaluator
extends JSElementVisitor {
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final JSExpectedTypeKind myExpectedTypeKind;
    @Nullable
    protected final PsiElement myParent;
    @Nullable
    private JSType myResult;

    public ExpectedTypeEvaluator(@NotNull PsiElement element, @NotNull JSExpectedTypeKind expectedTypeKind) {
        if (element == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myExpectedTypeKind = expectedTypeKind;
        this.myParent = this.myElement.getParent();
    }

    private static JSType findExpectedTypeWithNewEvaluator(@NotNull JSExpression element, @NotNull JSExpectedTypeKind kind) {
        if (element == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(3);
        }
        return JSDialectSpecificHandlersFactory.findExpectedType(element, kind);
    }

    protected void setResult(@Nullable JSType result2) {
        this.myResult = result2;
    }

    @Nullable
    protected JSType getResult() {
        return this.myResult;
    }

    @Nullable
    public final JSType findExpectedType() {
        Language language = this.myElement.getLanguage();
        List handlers = JSFrameworkSpecificHandler.EP_NAME.allForLanguageOrAny(language);
        List types2 = handlers.stream().map(factory -> factory.findExpectedType(this.myElement, this.myParent, this.myExpectedTypeKind)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!types2.isEmpty()) {
            return JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(this.myElement, true), types2);
        }
        if (this.myParent == null) {
            return null;
        }
        if (!(this.myParent instanceof JSProperty) && this.myExpectedTypeKind == JSExpectedTypeKind.TYPE_CHECKING && !this.isTypeCheckingSupported()) {
            return null;
        }
        this.myParent.accept((PsiElementVisitor)this);
        JSType result2 = this.getResult();
        if (result2 == null || this.myExpectedTypeKind == JSExpectedTypeKind.TYPE_CHECKING && !this.isTypeCheckingSupported() && !result2.isSourceStrict()) {
            return null;
        }
        return this.convertToContextual(result2);
    }

    protected boolean isTypeCheckingSupported() {
        return false;
    }

    @Nullable
    private JSType convertToContextual(@Nullable JSType type2) {
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, this.myElement);
        if (this.myExpectedTypeKind == JSExpectedTypeKind.CONTEXTUAL) {
            if (expanded instanceof JSUnionType) {
                return JSCompositeTypeFactory.createContextualUnionType(((JSUnionType)expanded).getTypes(), JSTypeSourceFactory.createTypeSource(this.myElement, true));
            }
            return expanded;
        }
        if ((this.myExpectedTypeKind == JSExpectedTypeKind.WIDENING || this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) && expanded instanceof TypeScriptConditionalTypeJSTypeImpl && JSTypeUtils.hasForeignGenericParameter(((TypeScriptConditionalTypeJSTypeImpl)expanded).getCheckedType())) {
            ArrayList<JSType> allTypes = new ArrayList<JSType>();
            JSTypeUtils.addAllUnionParts(((TypeScriptConditionalTypeJSTypeImpl)expanded).getTypeIfTrue(), allTypes);
            JSTypeUtils.addAllUnionParts(((TypeScriptConditionalTypeJSTypeImpl)expanded).getTypeIfFalse(), allTypes);
            return JSCompositeTypeFactory.createContextualUnionType(allTypes, JSTypeSourceFactory.createTypeSource(this.myElement, true));
        }
        return expanded;
    }

    @Override
    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (node.isShorthandArrowFunction()) {
            JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(node);
            if (returnExpression != null) {
                this.appendExpectedReturnType(returnExpression, (PsiElement)returnExpression, node);
            }
            return;
        }
        super.visitJSFunctionExpression(node);
    }

    @Override
    public void visitJSSpreadExpression(@NotNull JSSpreadExpression spreadExpression) {
        JSType spreadExpectedType;
        if (spreadExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(5);
        }
        if ((spreadExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator(spreadExpression, this.myExpectedTypeKind)) != null) {
            this.setResult(new JSArrayTypeImpl(spreadExpectedType, JSTypeSourceFactory.createTypeSource((PsiElement)spreadExpression, true)));
        }
        super.visitJSSpreadExpression(spreadExpression);
    }

    @Override
    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        JSFunction fun;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(6);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)this.myParent, (Class[])new Class[]{JSFunction.class})) == null) {
            return;
        }
        if (!(fun instanceof JSExpression) && this.myExpectedTypeKind.isContextual() && fun.getReturnTypeElement() == null) {
            return;
        }
        this.appendExpectedReturnType(node.getExpression(), (PsiElement)node, fun);
    }

    private void appendExpectedReturnType(@Nullable JSExpression expression, PsiElement sourceNode, JSFunction fun) {
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
            this.appendReturnResultForExpected(expression, sourceNode, fun);
        }
        if (this.myExpectedTypeKind.isContextual()) {
            this.appendReturnResultForContextual(sourceNode, fun);
        }
    }

    private void appendReturnResultForContextual(PsiElement sourceNode, JSFunction fun) {
        JSType returnType = ExpectedTypeEvaluator.getReturnTypeUnwrappingAsync(fun);
        if (returnType != null && !ExpectedTypeEvaluator.isInferredReturnType(returnType)) {
            JSTypeSource typeSource = returnType.getSource();
            if (typeSource.isStrict()) {
                this.setResult(returnType);
            }
        } else {
            this.addTypeFromFunctionExpression(sourceNode, fun);
        }
    }

    @Nullable
    private static JSType getReturnTypeUnwrappingAsync(JSFunction fun) {
        JSType type2 = fun.getReturnType();
        if (fun.isAsync()) {
            JSType promiseComponentType;
            JSType jSType = promiseComponentType = type2 == null ? null : JSTypeUtils.getPromiseComponentTypeOrNull(type2);
            if (promiseComponentType != null) {
                return promiseComponentType;
            }
        }
        return type2;
    }

    private static boolean isInferredReturnType(@Nullable JSType returnType) {
        return returnType instanceof JSCodeBasedType || returnType instanceof JSUnionType && ((JSUnionType)returnType).getTypes().stream().anyMatch(ExpectedTypeEvaluator::isInferredReturnType);
    }

    private void appendReturnResultForExpected(JSExpression expression, PsiElement sourceNode, JSFunction fun) {
        JSTypeSource typeSource;
        JSType returnType = ExpectedTypeEvaluator.getReturnTypeUnwrappingAsync(fun);
        JSTypeSource jSTypeSource = typeSource = returnType != null ? returnType.getSource() : null;
        if (returnType != null && typeSource.isStrict()) {
            if (returnType instanceof JSUnionType) {
                List filtered = ContainerUtil.filter(((JSUnionType)returnType).getTypes(), t -> !ExpectedTypeEvaluator.isSelfInducedType(expression, fun, t, t.getSourceElement()));
                if (ContainerUtil.filter((Collection)filtered, t -> !JSTypeUtils.isNullOrUndefinedType(t)).isEmpty()) {
                    return;
                }
                returnType = JSCompositeTypeFactory.createUnionType(typeSource, filtered);
            } else if (ExpectedTypeEvaluator.isSelfInducedType(expression, fun, returnType, typeSource.getSourceElement())) {
                this.addTypeFromFunctionExpression(sourceNode, fun);
                return;
            }
            this.setResult(returnType);
        }
    }

    private static boolean isSelfInducedType(JSExpression expression, JSFunction fun, JSType returnType, PsiElement sourceElement) {
        if (sourceElement == null) {
            return false;
        }
        if (returnType instanceof JSReturnedExpressionType) {
            returnType = returnType.substitute();
            sourceElement = returnType.getSourceElement();
        }
        return sourceElement == JSUtils.unparenthesize(expression);
    }

    private void addTypeFromFunctionExpression(@NotNull PsiElement node, @Nullable JSFunction fun) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (fun instanceof JSFunctionExpression) {
            JSType parentExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSFunctionExpression)fun, this.myExpectedTypeKind);
            if (parentExpectedType instanceof JSFunctionTypeImpl) {
                this.setResult(((JSFunctionTypeImpl)parentExpectedType).getReturnType());
            } else {
                ArrayList types2 = new ArrayList();
                JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
                    if (t instanceof JSFunctionTypeImpl) {
                        types2.add(((JSFunctionTypeImpl)t).getReturnType());
                    }
                    return true;
                }), parentExpectedType);
                if (!types2.isEmpty()) {
                    this.setResult(JSCompositeTypeFactory.createContextualUnionType(types2, JSTypeSourceFactory.createTypeSource(node, true)));
                }
            }
        }
    }

    @Override
    public void visitJSIfStatement(@NotNull JSIfStatement node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCondition() == this.myElement) {
            this.setResult(this.createBooleanType());
        }
    }

    @Override
    public void visitJSLoopStatement(@NotNull JSLoopStatement node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCondition() == this.myElement) {
            this.setResult(this.createBooleanType());
        }
    }

    @Override
    public void visitJSPrefixExpression(@NotNull JSPrefixExpression node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (ES6PsiUtil.isAwaitExpression((PsiElement)node)) {
            JSType jsType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator(node, this.myExpectedTypeKind);
            if (jsType != null) {
                this.setResult(JSTypeUtils.wrapInPromiseType(jsType, JSTypeSourceFactory.createTypeSource((PsiElement)node, true)));
            }
            return;
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (!(JSTokenTypes.EXCL != node.getOperationSign() || node.getParent() instanceof JSPrefixExpression && JSTokenTypes.EXCL == ((JSPrefixExpression)node.getParent()).getOperationSign())) {
            this.setResult(this.createBooleanType());
        }
    }

    @Override
    public void visitJSThrowStatement(@NotNull JSThrowStatement node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        this.evaluateThrowType();
    }

    @Override
    public void visitJSThrowExpression(@NotNull JSThrowExpression node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        this.evaluateThrowType();
    }

    private void evaluateThrowType() {
        PsiComment docComment;
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, JSFunction.class);
        if (fun != null && (docComment = JSDocumentationUtils.findDocComment(fun)) != null) {
            final Ref throwsTypeFromCommentRef = new Ref();
            JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)docComment, docComment.getNode(), new JSDocCommentVisitor(){

                @Override
                public void visitThrowsTag(@NotNull JSDocTag tag) {
                    String type2;
                    if (tag == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((type2 = tag.getTypeText()) != null) {
                        throwsTypeFromCommentRef.set((Object)type2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "visitThrowsTag"));
                }
            });
            String throwsTypeFromComment = (String)throwsTypeFromCommentRef.get();
            if (throwsTypeFromComment != null) {
                this.setResult(JSTypeParser.createType(fun.getProject(), throwsTypeFromComment, JSTypeSourceFactory.createTypeSource(this.myParent, true)));
                return;
            }
        }
        this.setResult(this.createNamedType("Error", this.myParent));
    }

    @Override
    public void visitJSConditionalExpression(@NotNull JSConditionalExpression node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(13);
        }
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && node.getCondition() == this.myElement) {
            this.setResult(this.createBooleanType());
        } else {
            JSType parentType = JSDialectSpecificHandlersFactory.findExpectedType(node, this.myExpectedTypeKind);
            if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
                JSExpression otherExpr;
                JSExpression then = JSUtils.unparenthesize((JSExpression)node.getThenBranch());
                JSExpression elze = JSUtils.unparenthesize((JSExpression)node.getElseBranch());
                JSExpression jSExpression = then == this.myElement ? elze : (otherExpr = elze == this.myElement ? then : null);
                if (otherExpr != null) {
                    JSType leftType = JSResolveUtil.getExpressionJSType(otherExpr);
                    this.assignFromParentOrOtherSide(parentType, leftType, null);
                }
            }
            if (this.getResult() == null) {
                this.setResult(parentType);
            }
        }
    }

    @Override
    public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(14);
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getIndexExpression() == this.myElement) {
            this.evaluateIndexedAccessType(node);
        }
    }

    protected void evaluateIndexedAccessType(JSIndexedPropertyAccessExpression node) {
        this.setResult(this.createNamedType("number", this.myParent));
    }

    @Override
    public void visitJSYieldExpression(@NotNull JSYieldExpression statement) {
        JSFunction function2;
        if (statement == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(15);
        }
        if ((function2 = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)statement, (Class[])new Class[]{JSFunction.class})) == null || !function2.isGenerator()) {
            return;
        }
        if (function2.getReturnTypeElement() == null && this.myExpectedTypeKind.isContextual()) {
            return;
        }
        JSType returnType = function2.getReturnType();
        if (returnType == null) {
            return;
        }
        JSType type2 = JSTypeUtils.getIterableComponentType(returnType);
        if (type2 != null) {
            this.setResult(type2);
        }
    }

    @Override
    public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(16);
        }
        IElementType opType = node.getOperationSign();
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && node.getROperand() == this.myElement) {
            if (JSTokenTypes.OROR == opType || JSTokenTypes.ANDAND == opType) {
                this.setResult(this.createBooleanType());
            } else {
                JSExpression lOperand = node.getLOperand();
                if (lOperand != null) {
                    JSType type2 = this.getQualifiedExpressionType(lOperand);
                    if (type2 instanceof JSLiteralType && (JSTokenTypes.ARITHMETIC_OPERATIONS.contains(opType) || JSTokenTypes.EQUALITY_OPERATIONS.contains(opType) && lOperand instanceof JSLiteralExpression)) {
                        type2 = ((JSLiteralType)type2).asPrimitiveType();
                    }
                    this.setResult(type2);
                }
            }
        }
        JSType parentType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator(node, this.myExpectedTypeKind);
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED && parentType != null) {
            if (this.myExpectedTypeKind.isContextual() && node.getROperand() == this.myElement) {
                if (parentType instanceof JSCodeBasedType) {
                    PsiElement sourceElement = parentType.getSource().getSourceElement();
                    parentType = sourceElement != null ? null : parentType.substitute();
                }
                this.setResult(this.fixResultForOrOrRightOp(parentType, node.getLOperand()));
            } else {
                this.setResult(parentType);
            }
            return;
        }
        JSExpression otherExpr = null;
        if (JSTokenTypes.OROR == opType && node.getROperand() == this.myElement) {
            otherExpr = node.getLOperand();
        }
        if (JSTokenTypes.OROR == opType && node.getLOperand() == this.myElement) {
            otherExpr = node.getROperand();
        }
        if (otherExpr != null) {
            JSType leftType = JSResolveUtil.getExpressionJSType(otherExpr);
            this.assignFromParentOrOtherSide(parentType, leftType, null);
        }
    }

    protected JSType getQualifiedExpressionType(JSExpression qualifier) {
        return JSResolveUtil.getExpressionJSType(qualifier);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    protected JSType fixResultForOrOrRightOp(@Nullable JSType type2, @Nullable JSExpression operand) {
        return type2;
    }

    private void assignFromParentOrOtherSide(JSType parentType, JSType leftType, Collection<JSType> miscTypes) {
        leftType = JSTypeGuardUtil.getBaseTypeOfLiteralType(leftType);
        if (parentType == null && miscTypes == null) {
            if (leftType != null) {
                this.setResult(leftType);
            }
        } else if (leftType == null && miscTypes == null) {
            this.setResult(parentType);
        } else {
            int count;
            int n = count = miscTypes != null ? miscTypes.size() : 0;
            if (parentType != null) {
                ++count;
            }
            if (leftType != null) {
                ++count;
            }
            ArrayList<JSType> typeList = new ArrayList<JSType>(count);
            if (parentType != null) {
                typeList.add(parentType);
            }
            if (leftType != null) {
                typeList.add(leftType);
            }
            if (miscTypes != null) {
                typeList.addAll(miscTypes);
            }
            this.setResult(JSCompositeTypeFactory.createContextualUnionType(typeList, JSTypeSourceFactory.createTypeSource(this.myElement, false)));
        }
    }

    @Override
    public void visitJSCaseClause(@NotNull JSCaseClause node) {
        JSExpression switchExpression;
        JSSwitchStatement switchStatement;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCaseExpression() == this.myElement && (switchStatement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myParent, JSSwitchStatement.class)) != null && (switchExpression = switchStatement.getSwitchExpression()) != null) {
            this.setResult(this.getQualifiedExpressionType(switchExpression));
        }
    }

    @Override
    public void visitJSObjectLiteralExpression(@NotNull JSObjectLiteralExpression node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(18);
        }
        if (!(this.myElement instanceof JSProperty)) {
            return;
        }
        JSType parentExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator(node, this.myExpectedTypeKind);
        if (parentExpectedType == null) {
            return;
        }
        this.forProperty((JSProperty)this.myElement, node, parentExpectedType);
    }

    @Override
    public void visitJSProperty(@NotNull JSProperty node) {
        PsiElement parent;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(19);
        }
        if (!((parent = node.getParent()) instanceof JSObjectLiteralExpression)) {
            return;
        }
        JSType parentExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSObjectLiteralExpression)parent, this.myExpectedTypeKind);
        if (parentExpectedType == null) {
            return;
        }
        this.forProperty(node, (JSObjectLiteralExpression)parent, parentExpectedType);
    }

    protected void forProperty(@NotNull JSProperty propertyForExpectedType, @NotNull JSObjectLiteralExpression literal, @NotNull JSType parentExpectedType) {
        if (propertyForExpectedType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(20);
        }
        if (literal == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(21);
        }
        if (parentExpectedType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(22);
        }
        if (ExpectedTypeEvaluator.hasElementInSource((PsiElement)literal, parentExpectedType)) {
            return;
        }
        if (parentExpectedType instanceof JSUnionOrIntersectionType && ((JSUnionOrIntersectionType)parentExpectedType).getTypes().stream().anyMatch(el -> ExpectedTypeEvaluator.hasElementInSource((PsiElement)literal, el))) {
            return;
        }
        String name = propertyForExpectedType.getName();
        if (propertyForExpectedType instanceof JSComputedPropertyNameOwner && StringUtil.isEmpty((String)name)) {
            name = TypeScriptTypeMemberParser.tryGetComputedName((JSComputedPropertyNameOwner)((Object)propertyForExpectedType));
        }
        if (!StringUtil.isEmpty((String)name)) {
            ArrayList allTypes = new ArrayList();
            String finalName = name;
            JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)type2 -> !ExpectedTypeEvaluator.addExpectedObjectPropertyType(type2, finalName, allTypes)), parentExpectedType);
            List<JSType> types2 = JSCompositeTypeBaseImpl.flattenTypes(allTypes, JSUnionType.class);
            if (!types2.isEmpty()) {
                this.setResult(JSCompositeTypeFactory.createContextualUnionType(types2, JSTypeSourceFactory.createTypeSource((PsiElement)propertyForExpectedType, true)));
            }
        }
    }

    private static boolean hasElementInSource(@NotNull PsiElement parent, @NotNull JSType currentType) {
        PsiElement sourceElement;
        if (parent == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(23);
        }
        if (currentType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(24);
        }
        if (currentType instanceof JSWidenType) {
            currentType = ((JSWidenType)currentType).getOriginalType();
        }
        return currentType instanceof JSCodeBasedType && (parent == (sourceElement = currentType.getSourceElement()) || sourceElement instanceof JSVariable && ((JSVariable)sourceElement).getInitializer() == parent);
    }

    private static boolean addExpectedObjectPropertyType(@Nullable JSType parentExpectedType, @NotNull String name, @NotNull List<JSType> allTypes) {
        if (name == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(25);
        }
        if (allTypes == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(26);
        }
        return parentExpectedType != null && ExpectedTypeEvaluator.addFromRecordType(name, allTypes, parentExpectedType);
    }

    private static boolean addFromRecordType(@NotNull String name, @NotNull List<JSType> allTypes, @NotNull JSType jsType) {
        JSRecordType recordType;
        JSRecordType.PropertySignature propertySignature;
        if (name == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(27);
        }
        if (allTypes == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(28);
        }
        if (jsType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(29);
        }
        if ((propertySignature = (recordType = jsType.asRecordType()).findPropertySignature(name)) != null) {
            ContainerUtil.addIfNotNull(allTypes, (Object)propertySignature.getJSType());
            return true;
        }
        JSRecordType.IndexSignature indexer = JSRecordTypeImpl.findApplicableIndexer(recordType, new JSStringLiteralTypeImpl(name, false, recordType.getSource()));
        if (indexer != null) {
            ContainerUtil.addIfNotNull(allTypes, (Object)indexer.getMemberType());
            return true;
        }
        return false;
    }

    @Override
    public void visitJSArrayLiteralExpression(@NotNull JSArrayLiteralExpression node) {
        long index;
        JSType result2;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(30);
        }
        if (!(this.myElement instanceof JSExpression)) {
            return;
        }
        JSType arrayType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator(node, this.myExpectedTypeKind);
        if (arrayType != null && (result2 = ExpectedTypeEvaluator.getArrayElementTypeForIndex(arrayType, index = (long)node.indexOf((JSExpression)this.myElement), JSTypeSourceFactory.createTypeSource((PsiElement)node, true))) != null) {
            this.setResult(result2);
        }
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && !TypeScriptTypeRelations.isTypeOrUnionOf(arrayType, JSTupleType.class)) {
            ArrayList<JSType> allItemTypes = new ArrayList<JSType>();
            boolean found = false;
            for (JSExpression expr : StreamEx.of(node.getExpressionStream())) {
                if (expr == null) continue;
                if (expr == this.myElement) {
                    found = true;
                    continue;
                }
                JSType expressionType = JSResolveUtil.getExpressionJSType(expr);
                if (expressionType == null) continue;
                allItemTypes.add(expressionType);
            }
            if (!found) {
                return;
            }
            this.assignFromParentOrOtherSide(this.getResult(), null, allItemTypes);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static JSType getArrayElementTypeForIndex(@NotNull JSType arrayType, long index, @NotNull JSTypeSource jSTypeSource) {
        if (arrayType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(31);
        }
        if (jSTypeSource == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(32);
        }
        if (JSTypeUtils.isSingleTypeAlias(arrayType)) {
            arrayType = arrayType.substitute();
        }
        if (arrayType instanceof JSUnionOrIntersectionType) {
            List<JSType> components = ((JSUnionOrIntersectionType)arrayType).getTypes();
            ArrayList<JSType> arrayTypes = new ArrayList<JSType>(components.size());
            for (JSType type2 : components) {
                JSType partType = ExpectedTypeEvaluator.assignFromArray(type2, index);
                if (partType == null) continue;
                arrayTypes.add(partType instanceof JSSpreadType ? ((JSSpreadType)((Object)partType)).getComponentType() : partType);
            }
            if (!arrayTypes.isEmpty()) {
                void typeSource;
                return JSCompositeTypeFactory.createUnionType((JSTypeSource)typeSource, arrayTypes);
            }
            return null;
        }
        return ExpectedTypeEvaluator.assignFromArray(arrayType, index);
    }

    @Nullable
    private static JSType assignFromArray(@NotNull JSType arrayType, long index) {
        if (arrayType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(33);
        }
        if (arrayType instanceof JSGenericTypeImpl) {
            arrayType = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(arrayType);
        }
        if (index >= 0L && arrayType.isTypeScript() && !(arrayType instanceof JSUtilType)) {
            JSRecordType type2 = arrayType.asRecordType();
            JSRecordType.PropertySignature propertySignature = type2.findPropertySignature(String.valueOf(index));
            if (propertySignature != null) {
                return propertySignature.getJSType();
            }
            if (arrayType instanceof JSTupleType) {
                return null;
            }
            JSRecordType.IndexSignature indexer = type2.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            if (indexer != null) {
                return indexer.getMemberType();
            }
        }
        return JSTypeUtils.getIterableComponentType(arrayType);
    }

    @Override
    public void visitJSParenthesizedExpression(@NotNull JSParenthesizedExpression node) {
        JSType typeFromComment;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(34);
        }
        if (DialectDetector.isJavaScript((PsiElement)node) && (typeFromComment = JSDocumentationUtils.findTypeFromInlineComment((PsiElement)node)) != null) {
            this.setResult(typeFromComment);
            return;
        }
        this.setResult(ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator(node, this.myExpectedTypeKind));
    }

    @Override
    public void visitTypeScriptCastExpression(@NotNull TypeScriptCastExpression node) {
        TypeScriptType type2;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(35);
        }
        if ((type2 = node.getType()) != null) {
            if (!node.isConstCast()) {
                this.setResult(type2.getJSType());
            } else {
                this.setResult(ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator(node, this.myExpectedTypeKind));
            }
        }
    }

    @Override
    public void visitTypeScriptSatisfiesExpression(@NotNull TypeScriptSatisfiesExpression node) {
        TypeScriptType type2;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(36);
        }
        if ((type2 = node.getType()) != null) {
            this.setResult(type2.getJSType());
            return;
        }
        super.visitTypeScriptSatisfiesExpression(node);
    }

    @Override
    public void visitJSStringTemplateExpression(@NotNull JSStringTemplateExpression node) {
        int argumentIndex;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(37);
        }
        if ((argumentIndex = ArrayUtil.find((Object[])node.getArguments(), (Object)this.myElement)) < 0) {
            return;
        }
        ES6TaggedTemplateExpression taggedTemplateExpression = (ES6TaggedTemplateExpression)ObjectUtils.tryCast((Object)node.getParent(), ES6TaggedTemplateExpression.class);
        if (taggedTemplateExpression == null) {
            return;
        }
        this.handleFunctionCall(taggedTemplateExpression, argumentIndex + node.getFirstArgumentIndex());
    }

    @Override
    public void visitJSArgumentList(@NotNull JSArgumentList node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(38);
        }
        int paramIndex = ExpectedTypeEvaluator.getParameterIndexInArgumentList(node, this.myElement);
        PsiElement firstChild = node.getFirstChild();
        if (firstChild == null) {
            return;
        }
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        this.handleFunctionCall(originalElement, paramIndex);
    }

    public static int getParameterIndexInArgumentList(@Nullable JSArgumentList node, PsiElement expression) {
        if (node == null) {
            return 0;
        }
        int _paramIndex = 0;
        for (JSExpression expr : node.getArguments()) {
            if (expr == expression) break;
            ++_paramIndex;
        }
        return _paramIndex;
    }

    private void handleFunctionCall(@NotNull JSCallLikeExpression callLikeExpression, int paramIndex) {
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(39);
        }
        this.setResult(new JSFunctionParameterExpectedTypeImpl(callLikeExpression, paramIndex, this.myExpectedTypeKind));
    }

    /*
     * WARNING - void declaration
     */
    public static JSType handleFunctionCallType(@NotNull JSCallLikeExpression callLikeExpression, int paramIndex, @NotNull JSExpectedTypeKind expectedTypeKind) {
        void var9_18;
        JSExpression methodExpression;
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(40);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (!((methodExpression = callLikeExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return ExpectedTypeEvaluator.evaluateParamFromExpressionType(JSResolveUtil.getExpressionJSType(methodExpression), paramIndex, callLikeExpression, (PsiElement)methodExpression, expectedTypeKind);
        }
        Object[] results = ExpectedTypeEvaluator.resolveFunctionCall(callLikeExpression, (JSReferenceExpression)methodExpression, expectedTypeKind);
        results = TypeScriptImplicitOverloadedAliasElement.unwrapElements((ResolveResult[])results);
        ArrayList<JSTypeWithSignature> possibleResults = new ArrayList<JSTypeWithSignature>();
        for (ResolveResult resolveResult : results) {
            PsiElement psiElement = resolveResult.getElement();
            if (psiElement == null || !psiElement.isValid()) continue;
            if (psiElement instanceof JSParameter) {
                JSType index;
                JSType definedParameterType = ((JSParameter)psiElement).getJSType();
                JSEvaluateContext context2 = new JSEvaluateContext(null);
                JSType type2 = definedParameterType != null ? definedParameterType : JSContextTypeEvaluator.getParameterType((JSParameter)psiElement, context2, expectedTypeKind);
                if (!((type2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, (PsiElement)methodExpression)) instanceof JSFunctionTypeImpl) || (index = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type2, paramIndex)) == null) continue;
                possibleResults.add(new JSTypeWithSignature(index));
                continue;
            }
            List<JSFunctionWithSubstitutor> functionsWithSubstitutor = ExpectedTypeEvaluator.calcFunctions(callLikeExpression, methodExpression, psiElement, expectedTypeKind);
            if (functionsWithSubstitutor.size() == 0) continue;
            for (JSFunctionWithSubstitutor functionWithSubstitutor : functionsWithSubstitutor) {
                JSType methodType;
                JSFunctionType functionType2;
                JSType type3;
                JSFunctionItem matchedFunction = functionWithSubstitutor.myFunctionItem;
                JSTypeSubstitutor typeSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
                if (typeSubstitutor.isEmpty()) {
                    ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, possibleResults);
                    continue;
                }
                if (!(matchedFunction instanceof JSFunction) || !((type3 = JSTypeUtils.applyGenericArguments(functionType2 = TypeScriptTypeParser.buildFunctionType(matchedFunction), typeSubstitutor)) instanceof JSFunctionTypeImpl)) continue;
                boolean addedNonGenericTypes = false;
                if (JSTypeUtils.hasForeignGenericParameter(type3) && (methodType = JSResolveUtil.getExpressionJSType(callLikeExpression.getMethodExpression())) != null) {
                    JSRecordType recordType = methodType.asRecordType();
                    for (JSRecordType.CallSignature signature : recordType.getCallSignatures()) {
                        addedNonGenericTypes = true;
                        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, (JSFunctionTypeImpl)signature.getFunctionType(), possibleResults);
                    }
                }
                if (addedNonGenericTypes) continue;
                ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, (JSFunctionTypeImpl)type3, possibleResults);
            }
        }
        if (!possibleResults.isEmpty()) {
            if (possibleResults.size() == 1) {
                JSType type4;
                JSParameterItem jSParameterItem;
                JSParameterItem[] jSParameterItemArray;
                JSTypeWithSignature signature = (JSTypeWithSignature)possibleResults.get(0);
                JSType result2 = signature.evaluateGenerics(callLikeExpression, expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_FOR_THIS_IN_LITERAL ? -1 : paramIndex, expectedTypeKind);
                if (!ExpectedTypeEvaluator.hasStrictQualifierType(methodExpression)) {
                    result2 = JSTypeUtils.copyWithStrict(result2, false);
                }
                JSFunctionItem function2 = signature.getFunction();
                if (expectedTypeKind == JSExpectedTypeKind.EXPECTED && function2 != null && paramIndex == (jSParameterItemArray = function2.getParameters()).length - 1 && (jSParameterItem = jSParameterItemArray[paramIndex]).isRest() && (type4 = JSTypeUtils.getIterableComponentType(result2)) != null) {
                    result2 = JSCompositeTypeFactory.createContextualUnionType(Arrays.asList(result2, type4), JSTypeSourceFactory.createTypeSource((PsiElement)callLikeExpression, true));
                }
                if (expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER && !ContainerUtil.exists((Object[])results, el -> el.getElement() instanceof JSFunctionItem)) {
                    JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)callLikeExpression, true);
                    return new TypeScriptOverloadContextualType(jSTypeSource, Collections.singletonList(new JSTypeWithSignature(result2, signature.getFunction())), paramIndex, callLikeExpression);
                }
                return result2;
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)callLikeExpression, true);
            TypeScriptOverloadContextualType contextualType = new TypeScriptOverloadContextualType(source, possibleResults, paramIndex, callLikeExpression);
            return expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS || expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER ? contextualType : contextualType.asCompositeWithAppliedGenerics(expectedTypeKind);
        }
        ArrayList<JSType> types2 = new ArrayList<JSType>(results.length);
        Object[] objectArray = results;
        int n = objectArray.length;
        boolean bl = false;
        while (var9_18 < n) {
            ResolveResult resolveResult = objectArray[var9_18];
            JSType jsType = JSResolveUtil.getElementJSType(resolveResult.getElement());
            JSType paramType = ExpectedTypeEvaluator.evaluateParamFromExpressionType(jsType, paramIndex, callLikeExpression, (PsiElement)methodExpression, expectedTypeKind);
            if (paramType != null) {
                types2.add(paramType);
            }
            ++var9_18;
        }
        return JSCompositeTypeFactory.createContextualUnionType(types2, JSTypeSourceFactory.createTypeSource((PsiElement)methodExpression, ExpectedTypeEvaluator.hasStrictQualifierType(methodExpression)));
    }

    private static ResolveResult @NotNull [] resolveFunctionCall(@NotNull JSCallLikeExpression callLikeExpression, @NotNull JSReferenceExpression methodExpression, @NotNull JSExpectedTypeKind expectedTypeKind) {
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(42);
        }
        if (methodExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(43);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(44);
        }
        if (DialectDetector.isActionScript((PsiElement)callLikeExpression)) {
            ResolveResult[] resolveResultArray = methodExpression.multiResolve(false);
            if (resolveResultArray == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(45);
            }
            return resolveResultArray;
        }
        if (expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER) {
            ResolveResult[] results = methodExpression.multiResolve(true);
            if (results.length <= 1 || !JSResolveUtil.isResolveStrict((PsiReference)methodExpression, results)) {
                if (results == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(46);
                }
                return results;
            }
            ResolveResult[] resolveResultArray = new JSTypeSignatureChooser(callLikeExpression).chooseOverload(results, OverloadStrictness.NO_INFERRED_RETURN_TYPE_CHECK);
            if (resolveResultArray == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(47);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = methodExpression.multiResolve(expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS || expectedTypeKind.isInferenceDepthExceeded());
        if (resolveResultArray == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(48);
        }
        return resolveResultArray;
    }

    @Nullable
    private static JSType evaluateParamFromExpressionType(@Nullable JSType type2, int paramIndex, @NotNull JSCallLikeExpression callLikeExpression, @Nullable PsiElement expression, @NotNull JSExpectedTypeKind expectedTypeKind) {
        List types2;
        List list2;
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(49);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(50);
        }
        if ((list2 = JSTypeUtils.getFunctionType(type2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, (PsiElement)callLikeExpression), expression instanceof JSSuperExpression || expression != null && callLikeExpression.isNewExpression(), expression).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        List functionTypes = (expectedTypeKind.isContextual() ? StreamEx.of(new JSTypeSignatureChooser(callLikeExpression).chooseOverload(list2, OverloadStrictness.NO_RESOLVE)).map(el -> el.getJsFunction()) : StreamEx.of(list2).select(JSFunctionType.class)).toList();
        if (!(functionTypes.size() != 1 && expectedTypeKind != JSExpectedTypeKind.EXPECTED || (types2 = ContainerUtil.mapNotNull((Collection)functionTypes, el -> ExpectedTypeEvaluator.evaluateFunctionParameterType(el, paramIndex))).isEmpty())) {
            return JSCompositeTypeFactory.createContextualUnionType(types2, JSTypeSourceFactory.createTypeSource((PsiElement)callLikeExpression, true));
        }
        return null;
    }

    @Nullable
    private static JSType evaluateFunctionParameterType(@NotNull JSFunctionType type2, int paramIndex) {
        if (type2 == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(51);
        }
        List<JSParameterTypeDecorator> parameters = type2.getParameters();
        if (paramIndex >= 0 && paramIndex < parameters.size()) {
            JSParameterTypeDecorator matchingParam = parameters.get(paramIndex);
            return matchingParam.getSimpleType();
        }
        return null;
    }

    @Override
    public void visitJSVariable(@NotNull JSVariable node) {
        JSType type2;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(52);
        }
        if ((type2 = ExpectedTypeEvaluator.getExplicitlyDeclaredType(node)) != null) {
            this.setResult(type2);
        }
    }

    @Nullable
    private static JSType getExplicitlyDeclaredType(@NotNull JSVariable node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(53);
        }
        if (node.getTypeElement() != null) {
            return node.getJSType();
        }
        if (DialectDetector.isTypeScript((PsiElement)node)) {
            return null;
        }
        JSType type2 = node.getJSType();
        if (type2 == null) {
            return null;
        }
        return node instanceof JSVariableBaseImpl ? ((JSVariableBaseImpl)node).doGetExplicitlyDeclaredType() : type2;
    }

    @Override
    public void visitJSDestructuringElement(@NotNull JSDestructuringElement node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(54);
        }
        if (!DialectDetector.isTypeScript((PsiElement)node) || node.getTypeElement() != null) {
            this.setResult(node.getJSType());
        }
    }

    @Override
    public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression node) {
        JSExpression lOperand;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(55);
        }
        if ((lOperand = node.getLOperand()) != null) {
            JSType expressionType;
            if ((lOperand = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)lOperand)) instanceof JSDefinitionExpression) {
                PsiElement resolve2;
                JSType type2;
                if (!DialectDetector.isTypeScript((PsiElement)node) && (type2 = ((JSDefinitionExpression)lOperand).getTypeFromComment()) != null) {
                    this.setResult(type2);
                    return;
                }
                JSExpression expression = ((JSDefinitionExpression)lOperand).getExpression();
                if (expression instanceof JSReferenceExpression && (resolve2 = ((JSReferenceExpression)expression).resolve()) != null && JSResolveUtil.isSameReference((JSReferenceExpression)expression, resolve2)) {
                    return;
                }
            }
            if ((expressionType = JSResolveUtil.getExpressionJSType(lOperand, this.myExpectedTypeKind.isContextual())) instanceof JSLiteralType && JSTokenTypes.ASSIGNMENT_MODIFYING_OPERATIONS.contains(node.getOperationSign())) {
                expressionType = ((JSLiteralType)expressionType).asPrimitiveType();
            }
            this.setResult(expressionType);
        }
    }

    protected void findRestParameterExpectedType(JSParameterItem param) {
        this.setResult(this.createNamedType("Object", this.myElement));
    }

    @NotNull
    protected JSType createBooleanType() {
        JSType jSType = this.createNamedType("boolean", this.myParent);
        if (jSType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(56);
        }
        return jSType;
    }

    @NotNull
    protected JSType createNamedType(String name, PsiElement context2) {
        JSType jSType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(context2, true), JSContext.INSTANCE);
        if (jSType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(57);
        }
        return jSType;
    }

    private static boolean hasStrictQualifierType(JSExpression methodExpr) {
        JSType expressionType;
        JSExpression qualifier;
        if (methodExpr instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)methodExpr) && (qualifier = ((JSReferenceExpression)methodExpr).getQualifier()) != null && (expressionType = JSResolveUtil.getExpressionJSType(qualifier)) != null) {
            return TypeScriptUtil.isStrictType(expressionType);
        }
        return true;
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(58);
        }
        if (matchedFunction == null) {
            return;
        }
        JSParameterItem[] params = matchedFunction.getParameters();
        if (params.length == 0) {
            return;
        }
        ArrayList<JSType> parameterTypes = new ArrayList<JSType>(params.length);
        for (JSParameterItem item : params) {
            parameterTypes.add(item.getSimpleType());
        }
        boolean isLastRest = params[params.length - 1].isRest();
        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, parameterTypes, isLastRest, possibleResults);
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @Nullable JSFunctionTypeImpl matchedFunctionType, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(59);
        }
        if (matchedFunctionType == null) {
            return;
        }
        List<JSParameterTypeDecorator> parameters = matchedFunctionType.getParameters();
        if (parameters.isEmpty()) {
            return;
        }
        List parameterTypes = ContainerUtil.map(parameters, JSParameterItem::getSimpleType);
        boolean isLastRest = parameters.get(parameters.size() - 1).isRest();
        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, parameterTypes, isLastRest, possibleResults);
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @NotNull List<JSType> params, boolean isLastRest, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (params == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(60);
        }
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(61);
        }
        JSType param = null;
        if (paramIndex < params.size()) {
            param = params.get(paramIndex);
        } else if (params.size() > 0 && isLastRest) {
            param = (JSType)ContainerUtil.getLastItem(params);
        }
        if (param != null) {
            possibleResults.add(new JSTypeWithSignature(param, matchedFunction));
        }
    }

    @NotNull
    protected static List<JSFunctionWithSubstitutor> calcFunctions(@NotNull JSCallLikeExpression callLikeExpression, @NotNull JSExpression methodExpression, @NotNull PsiElement resolvedElement, @NotNull JSExpectedTypeKind expectedTypeKind) {
        Collection<JSFunctionWithSubstitutor> functions;
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(62);
        }
        if (methodExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(63);
        }
        if (resolvedElement == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(64);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(65);
        }
        if ((functions = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(resolvedElement, (PsiElement)methodExpression, !DialectDetector.isTypeScript(resolvedElement))).size() == 0) {
            List<JSFunctionWithSubstitutor> list2 = Collections.emptyList();
            if (list2 == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(66);
            }
            return list2;
        }
        if (expectedTypeKind == JSExpectedTypeKind.EXPECTED && functions.size() == 1) {
            JSFunctionItem functionItem;
            JSFunctionWithSubstitutor overload = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functions);
            JSFunctionItem jSFunctionItem = functionItem = overload == null ? null : overload.myFunctionItem;
            if (functionItem instanceof TypeScriptFunction) {
                ArrayList<JSFunctionWithSubstitutor> overloads = new ArrayList<JSFunctionWithSubstitutor>();
                for (JSFunctionItem jSFunctionItem2 : TypeScriptPsiUtil.getAllOverloadSignatures(functionItem)) {
                    overloads.add(new JSFunctionWithSubstitutor(jSFunctionItem2, overload.myTypeSubstitutor));
                }
                ArrayList<JSFunctionWithSubstitutor> arrayList = overloads;
                if (arrayList == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(67);
                }
                return arrayList;
            }
        }
        if (functions.size() == 1) {
            return new SmartList(functions);
        }
        return ExpectedTypeEvaluator.chooseOverload(callLikeExpression, functions, expectedTypeKind);
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> chooseOverload(@NotNull JSCallLikeExpression callLikeExpression, @NotNull Collection<JSFunctionWithSubstitutor> functions, @NotNull JSExpectedTypeKind expectedTypeKind) {
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(68);
        }
        if (functions == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(69);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(70);
        }
        if (expectedTypeKind.isContextual()) {
            List collect = ContainerUtil.map(functions, el -> el.myFunctionItem);
            if (expectedTypeKind != JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS && expectedTypeKind != JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER) {
                JSFunctionItem item = TypeScriptSignatureChooser.resolveOverloads(callLikeExpression, collect);
                if (item != null) {
                    List list2 = ContainerUtil.filter(functions, el -> item.equals(el.myFunctionItem));
                    if (list2 == null) {
                        ExpectedTypeEvaluator.$$$reportNull$$$0(71);
                    }
                    return list2;
                }
            } else {
                List<JSFunctionItem> items = new JSTypeSignatureChooser(callLikeExpression).chooseOverloadFunctions(collect, OverloadStrictness.NO_RESOLVE);
                HashMap<JSFunctionItem, JSFunctionWithSubstitutor> map = new HashMap<JSFunctionItem, JSFunctionWithSubstitutor>(functions.size());
                for (JSFunctionWithSubstitutor function2 : functions) {
                    map.put(function2.myFunctionItem, function2);
                }
                List list3 = ContainerUtil.mapNotNull(items, map::get);
                if (list3 == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(72);
                }
                return list3;
            }
        }
        return new SmartList(functions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 45, 46, 47, 48, 56, 57, 66, 67, 71, 72 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 41: 
            case 44: 
            case 50: 
            case 65: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spreadExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyForExpectedType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExpectedType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTypes";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 39: 
            case 40: 
            case 42: 
            case 49: 
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callLikeExpression";
                break;
            }
            case 43: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 56: 
            case 57: 
            case 66: 
            case 67: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 58: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleResults";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunctionCall";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createBooleanType";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedType";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFunctions";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseOverload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExpectedTypeWithNewEvaluator";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSSpreadExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReturnStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromFunctionExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitJSIfStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitJSLoopStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitJSPrefixExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitJSThrowStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitJSThrowExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitJSConditionalExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitJSIndexedPropertyAccessExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitJSYieldExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitJSBinaryExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitJSCaseClause";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitJSObjectLiteralExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitJSProperty";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "forProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasElementInSource";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addExpectedObjectPropertyType";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addFromRecordType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitJSArrayLiteralExpression";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementTypeForIndex";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "assignFromArray";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitJSParenthesizedExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptCastExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptSatisfiesExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitJSStringTemplateExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitJSArgumentList";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "handleFunctionCall";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "handleFunctionCallType";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionCall";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 56: 
            case 57: 
            case 66: 
            case 67: 
            case 71: 
            case 72: {
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "evaluateParamFromExpressionType";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "evaluateFunctionParameterType";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVariable";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitlyDeclaredType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitJSDestructuringElement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAssignmentExpression";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleTypes";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "calcFunctions";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 45, 46, 47, 48, 56, 57, 66, 67, 71, 72 -> new IllegalStateException(string);
        };
    }
}

