/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class VirtualFilesVisitorCommand
extends AbstractCommand {
    private static final int MAX_CHUNK_SIZE = 32;
    private static final int PARALLELISM = Math.max(1, JobSchedulerImpl.getJobPoolParallelism() - 2);

    public VirtualFilesVisitorCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            VirtualFilesVisitorCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Project project;
        VirtualFile root;
        if (context2 == null) {
            VirtualFilesVisitorCommand.$$$reportNull$$$0(1);
        }
        if ((root = ProjectUtil.guessProjectDir((Project)(project = context2.getProject()))) == null) {
            Promise promise = Promises.rejectedPromise((String)"Can't find project root");
            if (promise == null) {
                VirtualFilesVisitorCommand.$$$reportNull$$$0(2);
            }
            return promise;
        }
        List buckets = (List)ReadAction.compute(() -> {
            final ArrayList filesToProcess = new ArrayList();
            final AtomicInteger taskIndex = new AtomicInteger(0);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file.equals(root)) {
                        return true;
                    }
                    if (LocalFileSystem.getInstance().isSymLink(file)) {
                        return true;
                    }
                    if (VirtualFilesVisitorCommand.this.isContentOnly() && (!ProjectFileIndex.getInstance((Project)project).isInContent(file) || ProjectFileIndex.getInstance((Project)project).isInLibrary(file))) {
                        return false;
                    }
                    if (VirtualFilesVisitorCommand.this.isAcceptable(file)) {
                        List list2 = filesToProcess;
                        synchronized (list2) {
                            int i = taskIndex.getAndIncrement();
                            int bucket = i % PARALLELISM + i / (32 * PARALLELISM) * PARALLELISM;
                            while (filesToProcess.size() <= bucket) {
                                filesToProcess.add(new ArrayList());
                            }
                            ((List)filesToProcess.get(bucket)).add(file);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/performanceTesting/VirtualFilesVisitorCommand$1", "visitFile"));
                }
            });
            return filesToProcess;
        });
        final AsyncPromise result2 = new AsyncPromise();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Performance tasks", (int)PARALLELISM);
        final List futures = ContainerUtil.map((Collection)buckets, it -> executorService.submit(this.createTask((List<VirtualFile>)it, root, context2)));
        final AtomicBoolean isCanceled = new AtomicBoolean(false);
        Task.Backgroundable task = new Task.Backgroundable(project, JavaScriptBundle.message("progress.title.executing.performance.task.on.files", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                while (true) {
                    if (isCanceled.get()) {
                        indicator.cancel();
                        result2.setError("Canceled");
                        break;
                    }
                    long completed = futures.stream().filter(it -> it.isDone() || it.isCancelled()).count();
                    if (completed == (long)futures.size()) {
                        result2.setResult(new Object());
                        break;
                    }
                    indicator.setFraction((double)completed / (double)futures.size());
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ignored) {
                        result2.setError("Interrupted");
                        break;
                    }
                }
            }

            public void onCancel() {
                isCanceled.set(true);
                for (Future future : futures) {
                    future.cancel(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/performanceTesting/VirtualFilesVisitorCommand$2", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            VirtualFilesVisitorCommand.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    protected boolean isContentOnly() {
        return false;
    }

    protected abstract boolean isAcceptable(@NotNull VirtualFile var1);

    @NotNull
    protected abstract Runnable createTask(@NotNull List<VirtualFile> var1, @NotNull VirtualFile var2, @NotNull PlaybackContext var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/VirtualFilesVisitorCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/VirtualFilesVisitorCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

