/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSCompareParsersCommand
extends VirtualFilesVisitorCommand {
    private static final JSLanguageDialect BASE_LANGUAGE = JavaScriptSupportLoader.ECMA_SCRIPT_6;
    private static final JSLanguageDialect TARGET_LANGUAGE = JavaScriptSupportLoader.FLOW_JS;
    @NonNls
    public static final String PREFIX = "%jsCompareParsers";

    public JSCompareParsersCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(1);
        }
        if (!JavaScriptIndex.isAcceptableFile(file)) {
            return false;
        }
        FileType type2 = file.getFileType();
        return type2 instanceof LanguageFileType && ((LanguageFileType)type2).getLanguage() instanceof JSLanguageDialect && ((JSLanguageDialect)((LanguageFileType)type2).getLanguage()).getOptionHolder().isJavaScript();
    }

    @Override
    @NotNull
    protected Runnable createTask(@NotNull List<VirtualFile> files2, @NotNull VirtualFile root, @NotNull PlaybackContext context2) {
        if (files2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(2);
        }
        if (root == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(4);
        }
        Runnable runnable = () -> {
            for (VirtualFile file : files2) {
                try {
                    JSCompareParsersCommand.compareParsersOnFile(file, root, context2);
                }
                catch (Exception e) {
                    Logger.getInstance(JSCompareParsersCommand.class).error("Failed to compare " + file.getPath(), (Throwable)e);
                }
            }
        };
        if (runnable == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(5);
        }
        return runnable;
    }

    private static void compareParsersOnFile(@NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull PlaybackContext context2) throws Exception {
        Project project;
        String path2;
        if (file == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(6);
        }
        if (root == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(8);
        }
        if ((path2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/')) == null) {
            return;
        }
        String code = VfsUtilCore.loadText((VirtualFile)file);
        PsiFile psiFile2 = JSCompareParsersCommand.parseWithLanguage(TARGET_LANGUAGE, code, project = context2.getProject());
        if (psiFile2 == null) {
            context2.error("Failed to parse " + file.getPath(), -1);
            return;
        }
        PsiFile psiFileBase = JSCompareParsersCommand.parseWithLanguage(BASE_LANGUAGE, code, project);
        if (psiFileBase == null) {
            context2.error("Failed to parse " + file.getPath(), -1);
            return;
        }
        Integer psiFileBaseErrors = (Integer)ReadAction.compute(() -> PsiTreeUtil.collectElementsOfType((PsiElement)psiFileBase, (Class[])new Class[]{PsiErrorElement.class}).size());
        if (psiFileBaseErrors == 0 && !((Boolean)ReadAction.compute(() -> JSCompareParsersCommand.parsedEquivalently(psiFile2, psiFileBase))).booleanValue()) {
            String tree = (String)ReadAction.compute(() -> DebugUtil.psiToString((PsiElement)psiFile2, (boolean)false));
            String treeBase = (String)ReadAction.compute(() -> DebugUtil.psiToString((PsiElement)psiFileBase, (boolean)false));
            context2.error("Diff " + file.getPath(), -1);
        }
    }

    private static boolean parsedEquivalently(@NotNull PsiFile file1, @NotNull PsiFile file2) {
        if (file1 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(10);
        }
        Iterator iterator1 = SyntaxTraverser.psiTraverser((PsiElement)file1).iterator();
        Iterator iterator2 = SyntaxTraverser.psiTraverser((PsiElement)file2).iterator();
        iterator1.next();
        iterator2.next();
        while (iterator1.hasNext()) {
            IElementType type2;
            if (!iterator2.hasNext()) {
                return false;
            }
            PsiElement element1 = (PsiElement)iterator1.next();
            PsiElement element2 = (PsiElement)iterator2.next();
            IElementType type1 = element1.getNode().getElementType();
            if (type1 == (type2 = element2.getNode().getElementType()) || JSKeywordSets.IDENTIFIER_NAMES.contains(type1) && JSKeywordSets.IDENTIFIER_NAMES.contains(type2)) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private static PsiFile parseWithLanguage(@NotNull JSLanguageDialect language, @NotNull String code, @NotNull Project project) {
        LightVirtualFile file;
        if (language == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(11);
        }
        if (code == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(12);
        }
        if (project == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(13);
        }
        if (!SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)(file = new LightVirtualFile("js.js", (Language)language, (CharSequence)code)))) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        }
        SingleRootFileViewProvider provider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, false);
        return provider.getPsi((Language)language);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/JSCompareParsersCommand";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSCompareParsersCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareParsersOnFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsedEquivalently";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseWithLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

