/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.ecmascript6.psi.impl.JSImportScope;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.providers.ES6ExportedCandidatesProvider;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonJSCandidatesProvider
extends JSImportCandidatesBase {
    @Nullable
    private MultiMap<String, JSElement> myLocal;

    public CommonJSCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
    }

    @NotNull
    private MultiMap<String, JSElement> getLocals() {
        MultiMap<String, JSElement> local = this.myLocal;
        if (local == null) {
            PsiElement place = this.myPlaceInfo.getPlace();
            JSImportScope scope2 = new JSImportScope(place.getProject(), this.myPlaceInfo.getFile(), JSResolveUtil.getResolveScope(place), JSModuleStatusOwner.ModuleStatus.COMMONJS);
            Collection<JSPsiElementBase> candidates = JSClassResolver.getInstance().findNamespaceMembersIncludingLocal("exports", (GlobalSearchScope)scope2);
            MultiMap<String, JSElement> multiMap = this.fillLocals(this.myPlaceInfo.getPlace(), candidates);
            if (multiMap == null) {
                CommonJSCandidatesProvider.$$$reportNull$$$0(1);
            }
            return multiMap;
        }
        MultiMap<String, JSElement> multiMap = local;
        if (multiMap == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, JSElement> fillLocals(PsiElement place, Collection<JSPsiElementBase> candidates) {
        MultiMap local = MultiMap.create();
        for (JSPsiElementBase candidate : candidates) {
            ProgressManager.checkCanceled();
            String name = candidate.getName();
            if (!JSNamesValidation.isIdentifier(name, place)) continue;
            local.putValue((Object)name, (Object)candidate);
        }
        this.myLocal = local;
        MultiMap multiMap = local;
        if (multiMap == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    @Override
    public void processCandidates(@NotNull String name, @NotNull JSCandidatesProcessor processor) {
        if (name == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(5);
        }
        Collection bases = this.getLocals().get((Object)name);
        StreamEx.of((Collection)bases).nonNull().map(el -> ES6ExportedCandidatesProvider.createCandidate(name, el, this.myPlaceInfo)).forEach(processor::processCandidate);
    }

    @Override
    public void collectNames(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(6);
        }
        this.getLocals().keySet().forEach(key2 -> {
            if (key2 != null) {
                consumer.accept((String)key2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/CommonJSCandidatesProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/CommonJSCandidatesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocals";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fillLocals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            if (placeInfo.getImportContext() != JSImportPlaceInfo.ImportContext.SIMPLE || DialectDetector.isTypeScript(placeInfo.getPlace()) || placeInfo.isStrictTypeContext()) {
                return null;
            }
            return new CommonJSCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/CommonJSCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

