/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.filter;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.filter.JSImportCandidatesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/MergedInternalModuleElementsFilter;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "()V", "qNames", "", "", "accept", "", "candidate", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "Factory", "intellij.javascript.impl"})
public final class MergedInternalModuleElementsFilter
implements JSImportCandidatesFilter {
    @NotNull
    private final Set<String> qNames = new LinkedHashSet();

    @Override
    public boolean accept(@NotNull JSImportCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        VirtualFile elementFile = candidate.getElementFile();
        if (elementFile != null && NodeModuleUtil.hasNodeModulesDirInPath(elementFile, null)) {
            return true;
        }
        PsiElement psiElement = candidate.getElement();
        if (psiElement == null) {
            return true;
        }
        PsiElement element = psiElement;
        String string = JSQualifiedNamedElementRenderer.getQualifiedName(element);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        String qName = string;
        if (((CharSequence)qName).length() == 0) {
            return true;
        }
        if (ES6PsiUtil.findExternalModule(element) == null) {
            return true;
        }
        return this.qNames.add(qName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/MergedInternalModuleElementsFilter$Factory;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter$FilterFactory;", "()V", "createFilter", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "candidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "intellij.javascript.impl"})
    public static final class Factory
    implements JSImportCandidatesFilter.FilterFactory {
        @Override
        @NotNull
        public JSImportCandidatesFilter createFilter(@NotNull List<? extends JSImportCandidate> candidates) {
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            return new MergedInternalModuleElementsFilter();
        }
    }
}

