/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.LastImportRequireInScope;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutorBase;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAddRequireExecutor
extends JSAddImportExecutorBase {
    @NotNull
    private static PsiElement getPlaceFile(@NotNull PsiElement place) {
        PsiElement scope2;
        if (place == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = (scope2 = PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{JSEmbeddedContent.class, JSFile.class})) != null ? scope2 : place;
        if (psiElement == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    public JSAddRequireExecutor(@NotNull PsiElement place) {
        if (place == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(2);
        }
        super(JSAddRequireExecutor.getPlaceFile(place));
    }

    @Override
    public int priority() {
        return -1;
    }

    @Override
    protected void createImportOrUpdateExistingInner(@NotNull JSImportDescriptor descriptor) {
        if (descriptor == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(3);
        }
        PsiElement place = this.getPlace();
        JSImportExportType type2 = descriptor.getImportType();
        if (type2.isSpecifier() && JSCodeStyleSettings.isMergeImports(place) && this.addToExistingRequire(descriptor)) {
            return;
        }
        if (type2.isComposite()) {
            return;
        }
        String text2 = JSAddRequireExecutor.getRequireCallText(place, descriptor);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)place.getProject()).createFileFromText("dummy.js", (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text2);
        PsiElement created = dummyFile.getFirstChild();
        if (created == null) {
            return;
        }
        PsiElement last = new LastImportRequireInScope(false).findAndSelect(place);
        Pair anchor = last != null ? Pair.create((Object)true, (Object)last) : ES6ImportPsiUtil.findPlaceForImport(place);
        ES6CreateImportUtil.insertPsiElementToScope(created, place, (Pair<Boolean, PsiElement>)anchor, null);
        if (last instanceof PsiComment) {
            place.addAfter(JSChangeUtil.createNewLine(last), last);
        }
    }

    private boolean addToExistingRequire(JSImportDescriptor descriptor) {
        PsiElement[] topChildren;
        PsiElement place = this.getPlace();
        for (PsiElement topChild : topChildren = place.getChildren()) {
            JSInitializerOwner[] declarations;
            if (!(topChild instanceof JSVarStatement)) continue;
            for (JSInitializerOwner declaration : declarations = ((JSVarStatement)topChild).getDeclarations()) {
                String modulePath;
                if (!(declaration instanceof JSDestructuringElement)) continue;
                JSDestructuringContainer target = ((JSDestructuringElement)declaration).getTarget();
                JSExpression initializer = declaration.getInitializer();
                if (!(target instanceof JSDestructuringObject) || !(initializer instanceof JSCallExpression) || (modulePath = CommonJSUtil.getModulePathIfRequireCall((JSCallExpression)initializer)) == null || !modulePath.equals(descriptor.getModuleName())) continue;
                WriteCommandAction.writeCommandAction((Project)place.getProject(), (PsiFile[])new PsiFile[]{place.getContainingFile()}).withName(JavaScriptBundle.message("add.variable.to.require", new Object[0])).run(() -> ES6ChangeUtil.addDestructuringProperty((JSDestructuringObject)target, descriptor.getEffectiveName()));
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getImportStatementText(@NotNull JSImportDescriptor descriptor) {
        if (descriptor == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(4);
        }
        return JSAddRequireExecutor.getRequireCallText(this.getPlace(), descriptor);
    }

    @NotNull
    public static String getRequireCallText(@Nullable PsiElement place, @NotNull JSImportDescriptor descriptor) {
        String semicolon;
        if (descriptor == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(5);
        }
        String varName = descriptor.getImportedName();
        boolean isConst = DialectDetector.hasFeature(place, JSLanguageFeature.CONST_DEFINITIONS);
        JSImportExportType importType = descriptor.getImportType();
        boolean isFileImport = !importType.isSpecifier();
        boolean isDestructuring = isConst && !isFileImport;
        String prefix = isConst ? "const " : "var ";
        String quote = place == null ? "\"" : JSCodeStyleSettings.getQuote(place);
        String call = "require(" + quote + descriptor.getModuleName() + quote + ")";
        String string = semicolon = place == null ? "" : JSCodeStyleSettings.getSemicolon(place);
        if (isDestructuring) {
            String spaces = JSCodeStyleSettings.getSettings((PsiElement)place).SPACES_WITHIN_OBJECT_LITERAL_BRACES ? " " : "";
            String propertyName = descriptor.getExportedName() != null && !descriptor.getExportedName().equals(varName) ? descriptor.getExportedName() + " : " : "";
            String string2 = prefix + "{" + spaces + propertyName + varName + spaces + "} = " + call + semicolon;
            if (string2 == null) {
                JSAddRequireExecutor.$$$reportNull$$$0(6);
            }
            return string2;
        }
        String postfix = isFileImport ? "" : "." + descriptor.getExportedName();
        String string3 = prefix + varName + " = " + call + postfix + semicolon;
        if (string3 == null) {
            JSAddRequireExecutor.$$$reportNull$$$0(7);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSAddRequireExecutor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSAddRequireExecutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequireCallText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceFile";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createImportOrUpdateExistingInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportStatementText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRequireCallText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7 -> new IllegalStateException(string);
        };
    }
}

