/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.lang.javascript.modules.diagram.JSModulesDiagramProvider;
import com.intellij.lang.javascript.modules.diagram.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagram.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagram.JSStructuralUiNode;
import com.intellij.lang.javascript.modules.diagram.Rainbow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSStructuralDiagramModel
extends DiagramDataModel<JSStructuralDiagramItem> {
    private final List<? extends JSStructuralUiNode> myNodes;
    private final List<? extends JSStructuralUiEdge> myEdges;
    private final ModificationTracker myModificationTracker;
    private final CachedColorGenerator myColoredGenerator;
    private final CachedColorGenerator myGrayGenerator;
    private final CachedColorGenerator myInProjectGenerator;

    JSStructuralDiagramModel(@NotNull Project project, @NotNull JSModulesDiagramProvider provider, List<? extends JSStructuralUiNode> nodes, List<? extends JSStructuralUiEdge> edges) {
        if (project == null) {
            JSStructuralDiagramModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            JSStructuralDiagramModel.$$$reportNull$$$0(1);
        }
        super(project, (DiagramProvider)provider);
        this.myNodes = nodes;
        this.myEdges = edges;
        this.myModificationTracker = () -> 0L;
        this.myColoredGenerator = new CachedColorGenerator(Rainbow.createGenerator((Condition<? super Rainbow.ColorGroup>)((Condition)cg -> !Rainbow.ColorGroup.light_gray.equals(cg) && !Rainbow.ColorGroup.gray.equals(cg) && !Rainbow.ColorGroup.light_yellow.equals(cg) && !Rainbow.ColorGroup.yellow.equals(cg)), null, !StartupUiUtil.isUnderDarcula()));
        this.myGrayGenerator = new CachedColorGenerator(Rainbow.createGenerator((Condition<? super Rainbow.ColorGroup>)((Condition)cg -> Rainbow.ColorGroup.light_gray.equals(cg) || Rainbow.ColorGroup.grayForDarculaBg.equals(cg)), null, !StartupUiUtil.isUnderDarcula()));
        this.myInProjectGenerator = new CachedColorGenerator(() -> LightColors.YELLOW);
    }

    public void dispose() {
    }

    @NotNull
    public Collection<? extends DiagramNode<JSStructuralDiagramItem>> getNodes() {
        List<? extends JSStructuralUiNode> list2 = this.myNodes;
        if (list2 == null) {
            JSStructuralDiagramModel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public Collection<? extends DiagramEdge<JSStructuralDiagramItem>> getEdges() {
        List<? extends JSStructuralUiEdge> list2 = this.myEdges;
        if (list2 == null) {
            JSStructuralDiagramModel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<JSStructuralDiagramItem> n) {
        if (n == null) {
            JSStructuralDiagramModel.$$$reportNull$$$0(4);
        }
        String string = n.getTooltip();
        if (string == null) {
            JSStructuralDiagramModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public DiagramNode<JSStructuralDiagramItem> addElement(JSStructuralDiagramItem element) {
        return null;
    }

    public void refreshDataModel() {
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = this.myModificationTracker;
        if (modificationTracker == null) {
            JSStructuralDiagramModel.$$$reportNull$$$0(6);
        }
        return modificationTracker;
    }

    public CachedColorGenerator getColoredGenerator() {
        return this.myColoredGenerator;
    }

    public CachedColorGenerator getGrayGenerator() {
        return this.myGrayGenerator;
    }

    public CachedColorGenerator getInProjectGenerator() {
        return this.myInProjectGenerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSStructuralDiagramModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSStructuralDiagramModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    static final class CachedColorGenerator {
        private final Rainbow.ColorGenerator myGenerator;
        private final Map<String, Color> myCache = new HashMap<String, Color>();

        public CachedColorGenerator(Rainbow.ColorGenerator generator) {
            this.myGenerator = generator;
        }

        public Color generate(@NotNull String name) {
            Color color;
            if (name == null) {
                CachedColorGenerator.$$$reportNull$$$0(0);
            }
            if ((color = this.myCache.get(name)) != null) {
                return color;
            }
            color = this.myGenerator.getColor();
            this.myCache.put(name, color);
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/diagram/JSStructuralDiagramModel$CachedColorGenerator", "generate"));
        }
    }
}

