/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.JSLiteralExpressionReferenceInfo;
import com.intellij.lang.javascript.modules.JSModuleReferenceExpressionInfo;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.LocalReferenceResolver;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeValueImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSImportReferenceQuickFixProviderBase
implements JSUnresolvedReferenceErrorUpdater {
    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info2, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] resolveResults, boolean isTypeContext) {
        JSExpression qualifier;
        if (info2 == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(1);
        }
        if (resolveResults == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(2);
        }
        if ((qualifier = node.getQualifier()) != null) {
            return;
        }
        if (!DialectDetector.isJavaScript((PsiElement)node) || !JSImportReferenceQuickFixProviderBase.checkContext((PsiElement)node)) {
            return;
        }
        ProblemHighlightType unresolvedReferenceHighlightType = JSImportReferenceQuickFixProviderBase.getUnresolvedReferenceHighlightType(node);
        if (!ProblemHighlightType.LIKE_UNKNOWN_SYMBOL.equals((Object)unresolvedReferenceHighlightType)) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)node.getText()))) {
            return;
        }
        JSModuleReferenceExpressionInfo moduleReferenceInfo = new JSModuleReferenceExpressionInfo(node);
        if (moduleReferenceInfo.getContextName() == null) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)moduleReferenceInfo.getParentName()))) {
            return;
        }
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo, resolveResults);
        if (modulesSuggester == null) {
            return;
        }
        JSImportReferenceQuickFixProviderBase.processResolvedElements((PsiElement)node, modulesSuggester, resolveResults, info2);
    }

    private static boolean checkContext(PsiElement node) {
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class);
        if (embeddedContent != null) {
            PsiElement parent;
            if (embeddedContent.getParent() instanceof JSEmbeddedContent) {
                embeddedContent = (JSEmbeddedContent)embeddedContent.getParent();
            }
            return !((parent = embeddedContent.getParent()) instanceof XmlAttributeValue) || parent instanceof JSXmlAttributeValueImpl;
        }
        return true;
    }

    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info2, @NotNull JSXmlLiteralExpression node) {
        if (info2 == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(4);
        }
        if (!(this.isJsxSupported((PsiElement)node) && DialectDetector.isJavaScript((PsiElement)node.getContainingFile()) && JSImportReferenceQuickFixProviderBase.checkContext((PsiElement)node))) {
            return;
        }
        String name = node.getName();
        if (!JSXResolveUtil.isComponentName(name)) {
            return;
        }
        boolean isResolved = JSXResolveUtil.areReferencesResolvedOrEmpty(node);
        if (isResolved) {
            return;
        }
        JSLiteralExpressionReferenceInfo moduleReferenceInfo = new JSLiteralExpressionReferenceInfo(node);
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo, ResolveResult.EMPTY_ARRAY);
        if (modulesSuggester == null) {
            return;
        }
        JSImportReferenceQuickFixProviderBase.processResolvedElements((PsiElement)node, modulesSuggester, ResolveResult.EMPTY_ARRAY, info2);
    }

    private static void processResolvedElements(@NotNull PsiElement node, @NotNull JsModulesSuggester modulesSuggester, ResolveResult @NotNull [] resolveResults, @NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info2) {
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(5);
        }
        if (modulesSuggester == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(6);
        }
        if (info2 == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(7);
        }
        if (resolveResults == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(8);
        }
        if (!JSImportReferenceQuickFixProviderBase.shouldAddFixes(node, resolveResults, modulesSuggester)) {
            return;
        }
        List<LocalQuickFix> newFixes = modulesSuggester.findFixes(resolveResults);
        if (newFixes.isEmpty()) {
            return;
        }
        info2.updateMessage(modulesSuggester.getMessage(newFixes));
        Collection<LocalQuickFix> fixes = JSImportReferenceQuickFixProviderBase.sortAndFilter(newFixes);
        info2.addAll(fixes);
    }

    @Nullable
    protected abstract JsModulesSuggester createSuggester(@NotNull PsiElement var1, @NotNull ModuleReferenceInfo var2, ResolveResult @NotNull [] var3);

    @NotNull
    public static Collection<LocalQuickFix> sortAndFilter(@NotNull Collection<LocalQuickFix> fixes) {
        if (fixes == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(9);
        }
        if (fixes.size() > 10) {
            List<LocalQuickFix> list2 = new ArrayList<LocalQuickFix>(fixes).subList(0, 10);
            if (list2 == null) {
                JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(10);
            }
            return list2;
        }
        Collection<LocalQuickFix> collection = fixes;
        if (collection == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(11);
        }
        return collection;
    }

    private static ProblemHighlightType getUnresolvedReferenceHighlightType(JSReferenceExpression node) {
        if (node.getQualifier() == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    private static boolean shouldAddFixes(@NotNull PsiElement refExpression, ResolveResult @NotNull [] resolveResults, @NotNull JsModulesSuggester modulesSuggester) {
        if (refExpression == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(12);
        }
        if (modulesSuggester == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(13);
        }
        if (resolveResults == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(14);
        }
        if (JSResolveResult.isTooManyCandidatesResult(resolveResults)) {
            return false;
        }
        PsiFile file = refExpression.getContainingFile();
        if (new LocalReferenceResolver(file).checkResolveResults(resolveResults)) {
            return false;
        }
        for (ResolveResult result2 : resolveResults) {
            if (result2.isValidResult()) {
                return false;
            }
            if (result2 instanceof JSResolveResult && ((JSResolveResult)result2).getES6Import() != null) {
                return false;
            }
            if (!modulesSuggester.isResolvedGlobally(result2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isForBrowser(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(15);
        }
        if (vf == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(16);
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        return mappings.isLibraryInScopeFor(vf, "HTML");
    }

    protected boolean isJsxSupported(@NotNull PsiElement node) {
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(17);
        }
        return DialectDetector.isJSX((PsiElement)node.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesSuggester";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportReferenceQuickFixProviderBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportReferenceQuickFixProviderBase";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateError";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sortAndFilter";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddFixes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isForBrowser";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isJsxSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

