/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.formatter.StandardJSCodeStyle;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardJSCodeStyleNotifierProvider
implements EditorNotificationProvider,
DumbAware {
    @NonNls
    private static final String CLOSED = "standardjs.codestyle.accepted";

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            StandardJSCodeStyleNotifierProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            StandardJSCodeStyleNotifierProvider.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (LightEdit.owns((Project)project)) {
            return null;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        if (propertiesComponent.getBoolean(CLOSED) || StandardJSCodeStyle.isInstalled(project)) {
            return null;
        }
        if (!file.isWritable() || JSProjectUtil.isInLibrary(file, project) || JSLibraryUtil.isProbableLibraryFile(file)) {
            return null;
        }
        if (!StandardJSCodeStyleNotifierProvider.isPackageJsonWithDependency(file)) {
            return null;
        }
        return fileEditor2 -> {
            if (ApplicationManager.getApplication().isUnitTestMode() || !(fileEditor2 instanceof TextEditor)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(LightColors.YELLOW, EditorNotificationPanel.Status.Info).text(JavaScriptBundle.message("standardjs.editor.notification.can.be.enabled.text", new Object[0]));
            panel2.createActionLabel(JavaScriptBundle.message("standardjs.editor.notification.action", new Object[0]), () -> {
                StandardJSCodeStyle.install(project);
                propertiesComponent.setValue(CLOSED, true);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            }, false);
            panel2.createActionLabel(JavaScriptBundle.message("standardjs.editor.notification.do.not.show.text", new Object[0]), () -> {
                propertiesComponent.setValue(CLOSED, true);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            }, false);
            return panel2;
        };
    }

    private static boolean isPackageJsonWithDependency(@NotNull VirtualFile file) {
        if (file == null) {
            StandardJSCodeStyleNotifierProvider.$$$reportNull$$$0(2);
        }
        return PackageJsonUtil.isPackageJsonFile(file) && PackageJsonData.getOrCreate(file).isDependencyOfAnyType("standard");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPackageJsonWithDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

