/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.GlobPatternUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.SemVer;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EslintUtil {
    public static final String DEFAULT_IGNORE_FILENAME = ".eslintignore";
    public static final String CONFIG_SECTION_NAME = "eslintConfig";
    public static final String ESLINTIGNORE_PACKAGE_SECTION_NAME = "eslintIgnore";
    public static final String PACKAGE_NAME = "eslint";
    public static final String DEFAULT_CONFIG_PREFIX = ".eslintrc";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".cjs", ".yaml", ".yml", ".json"};
    private static final String[] FLAT_CONFIG_NAMES = new String[]{"eslint.config.js", "eslint.config.cjs", "eslint.config.mjs"};
    private static final String USE_FLAT_CONFIG_ENV_VAR = "ESLINT_USE_FLAT_CONFIG";
    private static final String[] FLAT_AND_LEGACY_CONFIG_NAMES = new String[CONFIG_EXTENSIONS.length + FLAT_CONFIG_NAMES.length];
    private static final String[] FLAT_AND_LEGACY_CONFIGS_AND_PACKAGE_JSON;

    private EslintUtil() {
    }

    public static boolean isUseFlatConfigMode(@Nullable SemVer eslintVersion, boolean flatConfigFileExists) {
        if (eslintVersion == null) {
            return false;
        }
        int majorVersion = eslintVersion.getMajor();
        if (majorVersion < 8) {
            return false;
        }
        if (majorVersion == 8) {
            String flatConfigEnvVar = System.getenv(USE_FLAT_CONFIG_ENV_VAR);
            return "true".equals(flatConfigEnvVar) || !"false".equals(flatConfigEnvVar) && flatConfigFileExists;
        }
        if (majorVersion == 9) {
            String flatConfigEnvVar = System.getenv(USE_FLAT_CONFIG_ENV_VAR);
            return !"false".equals(flatConfigEnvVar);
        }
        return true;
    }

    public static boolean isFlatConfigFileName(@NotNull String fileName) {
        if (fileName == null) {
            EslintUtil.$$$reportNull$$$0(0);
        }
        return ArrayUtil.contains((String)fileName, (String[])FLAT_CONFIG_NAMES);
    }

    public static boolean isLegacyConfigFileName(@NotNull String fileName) {
        if (fileName == null) {
            EslintUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.startsWith((CharSequence)fileName, (CharSequence)DEFAULT_CONFIG_PREFIX)) {
            for (String ext : CONFIG_EXTENSIONS) {
                if (fileName.length() != DEFAULT_CONFIG_PREFIX.length() + ext.length() || !StringUtil.endsWith((CharSequence)fileName, (CharSequence)ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFlatOrLegacyConfigFile(@NotNull PsiElement element) {
        PsiFile psiFile2;
        if (element == null) {
            EslintUtil.$$$reportNull$$$0(2);
        }
        psiFile2 = (psiFile2 = element.getContainingFile()) != null ? psiFile2.getOriginalFile() : null;
        VirtualFile file = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        return file != null && EslintUtil.isFlatOrLegacyConfigFile(file);
    }

    public static boolean isFlatOrLegacyConfigFile(@NotNull VirtualFile file) {
        if (file == null) {
            EslintUtil.$$$reportNull$$$0(3);
        }
        if (!file.isValid() || file.isDirectory()) {
            return false;
        }
        return EslintUtil.isFlatConfigFileName(file.getName()) || EslintUtil.isLegacyConfigFileName(file.getName());
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsWithPackageJsonUpFileSystem(@NotNull VirtualFile fileToLint) {
        if (fileToLint == null) {
            EslintUtil.$$$reportNull$$$0(4);
        }
        List<VirtualFile> list2 = JSLinterConfigFileUtil.findAllFilesUpToFileSystemRoot(fileToLint, FLAT_AND_LEGACY_CONFIGS_AND_PACKAGE_JSON);
        if (list2 == null) {
            EslintUtil.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public static List<VirtualFile> findAllFlatAndLegacyConfigFiles(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(6);
        }
        List<VirtualFile> list2 = JSLinterConfigFileUtil.findAllConfigs(project, FLAT_AND_LEGACY_CONFIG_NAMES);
        if (list2 == null) {
            EslintUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public static boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(8);
        }
        return JSLinterConfigFileUtil.hasConfigFiles(project, FLAT_AND_LEGACY_CONFIG_NAMES);
    }

    @Nullable
    public static JsonObject getConfigRootObject(@NotNull PsiFile configFile) {
        JsonObject eslintRootObject;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(9);
        }
        JsonObject jsonObject = eslintRootObject = configFile instanceof JsonFile ? JsonUtil.getTopLevelObject((JsonFile)((JsonFile)configFile)) : null;
        if (eslintRootObject != null && PackageJsonUtil.isPackageJsonFile(configFile)) {
            eslintRootObject = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)eslintRootObject, (String)CONFIG_SECTION_NAME, JsonObject.class);
        }
        return eslintRootObject;
    }

    @Nullable
    public static VirtualFile findDistinctConfigInContentRoots(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(10);
        }
        return JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, Arrays.asList(FLAT_AND_LEGACY_CONFIGS_AND_PACKAGE_JSON), (Condition<? super VirtualFile>)((Condition)file -> {
            if (PackageJsonUtil.isPackageJsonFile(file)) {
                return PackageJsonData.getOrCreate(file).getTopLevelProperties().contains(CONFIG_SECTION_NAME);
            }
            return true;
        }));
    }

    @Nullable
    public static VirtualFile lookupIgnoreFile(@NotNull VirtualFile virtualFile, @NotNull VirtualFile stopAt) {
        if (virtualFile == null) {
            EslintUtil.$$$reportNull$$$0(11);
        }
        if (stopAt == null) {
            EslintUtil.$$$reportNull$$$0(12);
        }
        return JSLinterConfigFileUtil.findFileUpToRoot(virtualFile, new String[]{DEFAULT_IGNORE_FILENAME}, stopAt);
    }

    public static boolean isPossiblyAcceptableFileType(@NotNull PsiFile file) {
        if (file == null) {
            EslintUtil.$$$reportNull$$$0(13);
        }
        return EslintUtil.getFileKind(file) != null;
    }

    @Nullable
    public static FileKind getFileKind(@NotNull PsiFile psiFile2) {
        String additionalExtensions;
        VirtualFile virtualFile;
        if (psiFile2 == null) {
            EslintUtil.$$$reportNull$$$0(14);
        }
        if ((virtualFile = psiFile2.getVirtualFile()) == null) {
            return null;
        }
        try {
            additionalExtensions = Registry.stringValue((String)"eslint.additional.file.extensions");
        }
        catch (MissingResourceException e) {
            additionalExtensions = null;
        }
        if (!StringUtil.isEmpty((String)additionalExtensions)) {
            String fileExtension = virtualFile.getExtension();
            for (String extension : additionalExtensions.split(",")) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)(extension = StringUtil.trimStart((String)StringUtil.trim((String)extension), (String)".")), (CharSequence)fileExtension)) continue;
                return FileKind.JavaScriptAndOther;
            }
        }
        String filesPattern = ((EslintState)EslintConfiguration.getInstance(psiFile2.getProject()).getExtendedState().getState()).getFilesPattern();
        if (!GlobPatternUtil.isFileMatchingGlobPattern(psiFile2.getProject(), filesPattern, virtualFile)) {
            return null;
        }
        FileType fileType = psiFile2.getFileType();
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType)) {
            return FileKind.TypeScript;
        }
        if (JSLinterUtil.isPureHtmlFile(psiFile2)) {
            return FileKind.Html;
        }
        if (JSLinterUtil.isVueFile(psiFile2)) {
            if (FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)HtmlFileType.INSTANCE)) {
                return FileKind.Html;
            }
            return FileKind.Vue;
        }
        return FileKind.JavaScriptAndOther;
    }

    static {
        for (int i = 0; i < CONFIG_EXTENSIONS.length; ++i) {
            EslintUtil.FLAT_AND_LEGACY_CONFIG_NAMES[i] = DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSIONS[i];
        }
        System.arraycopy(FLAT_CONFIG_NAMES, 0, FLAT_AND_LEGACY_CONFIG_NAMES, CONFIG_EXTENSIONS.length, FLAT_CONFIG_NAMES.length);
        FLAT_AND_LEGACY_CONFIGS_AND_PACKAGE_JSON = new String[FLAT_AND_LEGACY_CONFIG_NAMES.length + 1];
        System.arraycopy(FLAT_AND_LEGACY_CONFIG_NAMES, 0, FLAT_AND_LEGACY_CONFIGS_AND_PACKAGE_JSON, 0, FLAT_AND_LEGACY_CONFIG_NAMES.length);
        EslintUtil.FLAT_AND_LEGACY_CONFIGS_AND_PACKAGE_JSON[EslintUtil.FLAT_AND_LEGACY_CONFIGS_AND_PACKAGE_JSON.length - 1] = "package.json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFlatAndLegacyConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFlatConfigFileName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLegacyConfigFileName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFlatOrLegacyConfigFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllFlatAndLegacyConfigFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigRootObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDistinctConfigInContentRoots";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lookupIgnoreFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPossiblyAcceptableFileType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileKind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }

    public static enum FileKind {
        TypeScript("ts"),
        Html("html"),
        Vue("vue"),
        JavaScriptAndOther("js_and_other");

        private final String myStringValue;

        private FileKind(String stringValue) {
            this.myStringValue = stringValue;
        }

        public String getStringValue() {
            return this.myStringValue;
        }
    }
}

