/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintPanel;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.SwingHelper;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u001cH\u0003J\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/lang/javascript/linter/eslint/EslintPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "fullModeDialog", "", "(Lcom/intellij/openapi/project/Project;Z)V", "additionalRulesDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "configFileView", "Lcom/intellij/lang/javascript/linter/ui/JSLinterConfigFileView;", "configurationPanel", "Lcom/intellij/ui/dsl/builder/Panel;", "eslintPackageField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "Lorg/jetbrains/annotations/NotNull;", "extraOptions", "Lcom/intellij/ui/RawCommandLineEditor;", "packageErrorLabel", "Ljavax/swing/JLabel;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "workDirPatternsComponent", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "adjustUiForPackage", "", "nodePackage", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "buildEslintState", "Lcom/intellij/lang/javascript/linter/eslint/EslintState$Builder;", "changeSlashesInFirstPathIfItIsWindowsAbsolutePath", "", "input", "slashInReturnedString", "", "createAdditionalRulesDirField", "createWorkDirPatternsComponent", "formatErrorMessage", "packageRef", "handleEnableStatusChanged", "enabled", "setState", "state", "Lcom/intellij/lang/javascript/linter/eslint/EslintState;", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nEslintPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EslintPanel.kt\ncom/intellij/lang/javascript/linter/eslint/EslintPanel\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,210:1\n107#2:211\n79#2,22:212\n*S KotlinDebug\n*F\n+ 1 EslintPanel.kt\ncom/intellij/lang/javascript/linter/eslint/EslintPanel\n*L\n187#1:211\n187#1:212,22\n*E\n"})
public final class EslintPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean fullModeDialog;
    @NotNull
    private final JSLinterConfigFileView configFileView;
    @NotNull
    private final NodePackageField eslintPackageField;
    @NotNull
    private final ComponentWithBrowseButton<ExpandableTextField> workDirPatternsComponent;
    @NotNull
    private final TextFieldWithBrowseButton additionalRulesDirField;
    @NotNull
    private final RawCommandLineEditor extraOptions;
    private JLabel packageErrorLabel;
    private Panel configurationPanel;
    @JvmField
    @NotNull
    public final DialogPanel panel;

    /*
     * WARNING - void declaration
     */
    public EslintPanel(@NotNull Project project, boolean fullModeDialog) {
        void $this$eslintPackageField_u24lambda_u242;
        void $this$configFileView_u24lambda_u241;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.fullModeDialog = fullModeDialog;
        Object object = objectArray = new JSLinterConfigFileView(project, new JSLinterConfigFileTexts(JavaScriptBundle.message("javascript.linter.configurable.config.autoSearch.title", new Object[0]), JavaScriptBundle.message("eslint.configurable.config.autoSearch.description.bodyInnerHtml", new Object[0]), JavaScriptBundle.message("eslint.configurable.config.select.config.text", new Object[0])), null);
        EslintPanel eslintPanel = this;
        boolean $i$a$-apply-EslintPanel$configFileView$22 = false;
        $this$configFileView_u24lambda_u241.setAdditionalConfigFilesProducer((NotNullProducer<List<VirtualFile>>)((NotNullProducer)() -> EslintPanel.configFileView$lambda$1$lambda$0(project)));
        eslintPanel.configFileView = objectArray;
        object = new String[]{"eslint", "standard"};
        Object $i$a$-apply-EslintPanel$configFileView$22 = object = AutodetectLinterPackage.createNodePackageField(project, CollectionsKt.listOf((Object[])object), this.configFileView);
        eslintPanel = this;
        boolean bl = false;
        $this$eslintPackageField_u24lambda_u242.addPackageRefSelectionListener((Consumer<NodePackageRef>)((Consumer)this::adjustUiForPackage));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
        eslintPanel.eslintPackageField = object;
        this.workDirPatternsComponent = this.createWorkDirPatternsComponent(project);
        this.additionalRulesDirField = this.createAdditionalRulesDirField(project);
        this.extraOptions = new RawCommandLineEditor();
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ EslintPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = JavaScriptBundle.message("eslint.configurable.eslintPackage.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EslintPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)((Object)EslintPanel.access$getEslintPackageField$p(this.this$0))).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EslintPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        EslintPanel.access$setPackageErrorLabel$p(this.this$0, (JLabel)$this$row.label("").applyToComponent((Function1)panel.1.INSTANCE).getComponent());
                    }
                }), (int)1, null);
                String string2 = JavaScriptBundle.message("eslint.configurable.label.working.directories", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EslintPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell.comment$default((Cell)$this$row.cell((JComponent)EslintPanel.access$getWorkDirPatternsComponent$p(this.this$0)), (String)JavaScriptBundle.message("eslint.configurable.working.directories.comment", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                EslintPanel.access$setConfigurationPanel$p(this.this$0, $this$panel.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ EslintPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ EslintPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)EslintPanel.access$getConfigFileView$p(this.this$0).getComponent()).align((Align)AlignX.FILL.INSTANCE).applyToComponent((Function1)panel.1.INSTANCE);
                            }
                        }), (int)1, null);
                        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
                        String string = JavaScriptBundle.message("eslint.configurable.additionalRulesDir.label", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ EslintPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)EslintPanel.access$getAdditionalRulesDirField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                            }
                        });
                        String string2 = JavaScriptBundle.message("eslint.configurable.extraOptions.label", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ EslintPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)EslintPanel.access$getExtraOptions$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                            }
                        });
                        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
                    }
                }));
            }
        }));
    }

    public final void handleEnableStatusChanged(boolean enabled) {
        NodePackageRef nodePackageRef = this.eslintPackageField.getSelectedRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getSelectedRef(...)");
        NodePackageRef selectedRef = nodePackageRef;
        this.adjustUiForPackage(selectedRef);
        if (selectedRef == AutodetectLinterPackage.INSTANCE) {
            this.configFileView.setEnabled(false);
        }
        this.configFileView.onEnabledStateChanged(enabled);
    }

    public final void setState(@NotNull EslintState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.eslintPackageField.setSelectedRef(state.getNodePackageRef());
        ExpandableTextField expandableTextField = (ExpandableTextField)this.workDirPatternsComponent.getChildComponent();
        String string = state.getWorkDirPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkDirPatterns(...)");
        expandableTextField.setText(this.changeSlashesInFirstPathIfItIsWindowsAbsolutePath(string, '\\'));
        this.configFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.configFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        this.additionalRulesDirField.setText(FileUtil.toSystemDependentName((String)state.getAdditionalRulesDirPath()));
        this.extraOptions.setText(state.getExtraOptions());
        if (this.fullModeDialog) {
            this.configFileView.setPreferredWidthToComponents();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.additionalRulesDirField);
        }
        NodePackageRef nodePackageRef = state.getNodePackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getNodePackageRef(...)");
        this.adjustUiForPackage(nodePackageRef);
    }

    @NotNull
    public final EslintState.Builder buildEslintState() {
        NodePackageRef nodePackageRef = this.eslintPackageField.getSelectedRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getSelectedRef(...)");
        NodePackageRef selected = nodePackageRef;
        EslintState.Builder builder2 = new EslintState.Builder();
        builder2.setEslintPackage(selected);
        String string = ((ExpandableTextField)this.workDirPatternsComponent.getChildComponent()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String wdPatterns = this.changeSlashesInFirstPathIfItIsWindowsAbsolutePath(((Object)StringsKt.trim((CharSequence)string)).toString(), '/');
        builder2.setWorkDirPatterns(wdPatterns);
        builder2.setCustomConfigFilePath(this.configFileView.getCustomConfigFilePath());
        builder2.setCustomConfigFileUsed(this.configFileView.isCustomConfigFileUsed());
        String string2 = this.additionalRulesDirField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        builder2.setAdditionalRulesDirPath(FileUtil.toSystemIndependentName((String)((Object)StringsKt.trim((CharSequence)string2)).toString()));
        builder2.setExtraOptions(this.extraOptions.getText());
        return builder2;
    }

    private final ComponentWithBrowseButton<ExpandableTextField> createWorkDirPatternsComponent(Project project) {
        Function parser2 = EslintPanel::createWorkDirPatternsComponent$lambda$3;
        Function joiner = EslintPanel::createWorkDirPatternsComponent$lambda$4;
        ExpandableTextField workDirPatternsTextField = new ExpandableTextField(parser2, joiner);
        workDirPatternsTextField.getEmptyText().setText(JavaScriptBundle.message("eslint.configurable.working.dir.field.empty.text", new Object[0]));
        ComponentWithBrowseButton result2 = new ComponentWithBrowseButton((JComponent)workDirPatternsTextField, null);
        result2.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createMultipleFoldersDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        return result2;
    }

    private final TextFieldWithBrowseButton createAdditionalRulesDirField(Project project) {
        TextFieldWithBrowseButton result2 = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)result2, (String)JavaScriptBundle.message("eslint.configurable.additionalRulesDir.browseDialogTitle", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return result2;
    }

    private final void adjustUiForPackage(NodePackageRef nodePackage) {
        String error = this.formatErrorMessage(nodePackage);
        JLabel jLabel = this.packageErrorLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageErrorLabel");
            jLabel = null;
        }
        jLabel.setText(JSLinterUtil.getRedErrorTextHtml(error));
        JLabel jLabel2 = this.packageErrorLabel;
        if (jLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageErrorLabel");
            jLabel2 = null;
        }
        jLabel2.setVisible(!StringsKt.isBlank((CharSequence)error));
        Panel panel2 = this.configurationPanel;
        if (panel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationPanel");
            panel2 = null;
        }
        panel2.visible(!Companion.isStandardJs(nodePackage));
    }

    @InspectionMessage
    private final String formatErrorMessage(NodePackageRef packageRef) {
        String string;
        NodePackage pkg = packageRef.getConstantPackage();
        if (pkg == null) {
            string = "";
        } else {
            String string2 = pkg.getSystemDependentPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSystemDependentPath(...)");
            String $this$trim$iv = string2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                String string3 = JavaScriptBundle.message("javascript.linter.error.empty.path", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            } else if (!pkg.isValid()) {
                String string4 = JavaScriptBundle.message("eslint.error.package.directory.expected", new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            } else {
                string = "";
            }
        }
        return string;
    }

    private final String changeSlashesInFirstPathIfItIsWindowsAbsolutePath(String input, char slashInReturnedString) {
        String string;
        if (!SystemInfo.isWindows) {
            return input;
        }
        if (((CharSequence)input).length() == 0) {
            return input;
        }
        int semicolonIndex = StringsKt.indexOf$default((CharSequence)input, (char)';', (int)0, (boolean)false, (int)6, null);
        if (semicolonIndex < 0) {
            string = input;
        } else {
            String string2 = input.substring(0, semicolonIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        String firstPath = string;
        boolean windowsAbsolutePath = OSAgnosticPathUtil.isAbsoluteDosPath((String)firstPath);
        if (windowsAbsolutePath) {
            String string3;
            char oldChar = slashInReturnedString == '\\' ? (char)'/' : '\\';
            String string4 = StringsKt.replace$default((String)firstPath, (char)oldChar, (char)slashInReturnedString, (boolean)false, (int)4, null);
            if (semicolonIndex > 0) {
                String string5 = input.substring(semicolonIndex);
                string3 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                string3 = "";
            }
            return string4 + string3;
        }
        return input;
    }

    private static final List configFileView$lambda$1$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return EslintUtil.findAllFlatAndLegacyConfigFiles($project);
    }

    private static final List createWorkDirPatternsComponent$lambda$3(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return StringUtil.split((String)s, (String)";");
    }

    private static final String createWorkDirPatternsComponent$lambda$4(List strings) {
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        return StringUtil.join((Collection)strings, (String)";");
    }

    @JvmStatic
    public static final boolean isStandardJs(@NotNull NodePackageRef nodePackage) {
        return Companion.isStandardJs(nodePackage);
    }

    public static final /* synthetic */ NodePackageField access$getEslintPackageField$p(EslintPanel $this) {
        return $this.eslintPackageField;
    }

    public static final /* synthetic */ void access$setPackageErrorLabel$p(EslintPanel $this, JLabel jLabel) {
        $this.packageErrorLabel = jLabel;
    }

    public static final /* synthetic */ ComponentWithBrowseButton access$getWorkDirPatternsComponent$p(EslintPanel $this) {
        return $this.workDirPatternsComponent;
    }

    public static final /* synthetic */ void access$setConfigurationPanel$p(EslintPanel $this, Panel panel2) {
        $this.configurationPanel = panel2;
    }

    public static final /* synthetic */ JSLinterConfigFileView access$getConfigFileView$p(EslintPanel $this) {
        return $this.configFileView;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getAdditionalRulesDirField$p(EslintPanel $this) {
        return $this.additionalRulesDirField;
    }

    public static final /* synthetic */ RawCommandLineEditor access$getExtraOptions$p(EslintPanel $this) {
        return $this.extraOptions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/EslintPanel$Companion;", "", "()V", "isStandardJs", "", "nodePackage", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isStandardJs(@NotNull NodePackageRef nodePackage) {
            NodePackage constantPackage;
            Intrinsics.checkNotNullParameter((Object)nodePackage, (String)"nodePackage");
            NodePackage nodePackage2 = constantPackage = nodePackage.getConstantPackage();
            String packageName = nodePackage2 != null ? nodePackage2.getName() : null;
            return Intrinsics.areEqual((Object)"standard", (Object)packageName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

