/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actionsOnSave.ActionOnSaveBackedByOwnConfigurable;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.NewLinterView;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintBottomContent;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintPanel;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.FormBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintConfigurable
extends UntypedJSLinterConfigurable {
    public static final String ID = "settings.javascript.linters.eslint";

    public EslintConfigurable(@NotNull Project project) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    public EslintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(1);
        }
        super(project, fullModeDialog);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JavaScriptBundle.message("settings.javascript.linters.eslint.configurable.name", new Object[0]);
    }

    @Override
    @NotNull
    protected NewEslintView createView() {
        return new NewEslintView(this.getProject(), this.getDisplayName(), new EslintPanel(this.getProject(), this.isFullModeDialog()));
    }

    public void reset() {
        NewEslintView view = this.getEslintView();
        if (view == null) {
            return;
        }
        view.setExtendedState(this.loadUiState());
        view.reset();
        this.resizeDialogToFitPreferredSize(view);
    }

    public void apply() {
        NewEslintView view = this.getEslintView();
        if (view == null) {
            return;
        }
        ExtendedLinterState extendedStateFromUi = view.getExtendedState();
        EslintState eslintStateFromUi = (EslintState)extendedStateFromUi.getState();
        boolean isStandardJS = EslintPanel.isStandardJs(eslintStateFromUi.getNodePackageRef());
        if (isStandardJS) {
            NodePackage nodePackage = Objects.requireNonNull(eslintStateFromUi.getNodePackageRef().getConstantPackage());
            StandardJSState standardJsState = new StandardJSState(nodePackage);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), standardJsState), StandardJSConfiguration.class);
            EslintState eslintState = new EslintState.Builder().setFilesPattern(eslintStateFromUi.getFilesPattern()).setRunOnSave(eslintStateFromUi.isRunOnSave()).build();
            this.setExtendedState(ExtendedLinterState.create(false, eslintState), EslintConfiguration.class);
        } else {
            this.setExtendedState(ExtendedLinterState.create(false, StandardJSState.DEFAULT), StandardJSConfiguration.class);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), eslintStateFromUi), EslintConfiguration.class);
        }
        view.apply();
        EslintLanguageServiceManager.getInstance(this.myProject).terminateServices();
        StandardJSLanguageServiceManager.getInstance(this.myProject).terminateServices();
    }

    @Override
    public boolean isModified() {
        NewEslintView view = this.getEslintView();
        if (view == null) {
            return false;
        }
        return !this.loadUiState().equals(view.getExtendedState()) || view.isModified();
    }

    private NewEslintView getEslintView() {
        return (NewEslintView)this.myView;
    }

    @NotNull
    private ExtendedLinterState<EslintState> loadUiState() {
        ExtendedLinterState eslintExtendedState = this.getExtendedState(EslintConfiguration.class);
        ExtendedLinterState standardJsExtendedState = this.getExtendedState(StandardJSConfiguration.class);
        EslintState eslintState = (EslintState)eslintExtendedState.getState();
        StandardJSState standardJSState = (StandardJSState)standardJsExtendedState.getState();
        boolean isStandardJS = standardJsExtendedState.isEnabled();
        EslintState uiState = isStandardJS ? new EslintState.Builder().setEslintPackage(NodePackageRef.create(standardJSState.getNodePackage())).setFilesPattern(eslintState.getFilesPattern()).setRunOnSave(eslintState.isRunOnSave()).build() : eslintState;
        ExtendedLinterState<EslintState> extendedLinterState = ExtendedLinterState.create(eslintExtendedState.isEnabled() || standardJsExtendedState.isEnabled(), uiState);
        if (extendedLinterState == null) {
            EslintConfigurable.$$$reportNull$$$0(2);
        }
        return extendedLinterState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUiState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class NewEslintView
    extends NewLinterView<EslintState> {
        private final EslintPanel myEslintPanel;
        private EslintBottomContent bottomContent;
        private boolean myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled;

        NewEslintView(Project project, String displayName, EslintPanel eslintPanel) {
            super(project, displayName, (JComponent)eslintPanel.panel, ".eslintrc.*");
            this.myEslintPanel = eslintPanel;
        }

        @Override
        protected void addBottomComponents(@NotNull FormBuilder builder2) {
            if (builder2 == null) {
                NewEslintView.$$$reportNull$$$0(0);
            }
            this.bottomContent = new EslintBottomContent();
            builder2.addComponent((JComponent)this.bottomContent.panel);
        }

        @Override
        protected void setState(@NotNull EslintState state) {
            if (state == null) {
                NewEslintView.$$$reportNull$$$0(1);
            }
            this.myEslintPanel.setState(state);
            this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled = state.isRunOnSave();
            this.bottomContent.runForFilesField.setText(state.getFilesPattern());
            this.bottomContent.runOnSaveCheckBox.setSelected(state.isRunOnSave());
        }

        @Override
        @NotNull
        protected EslintState getStateWithConfiguredAutomatically() {
            EslintState eslintState = new EslintState.Builder().setFilesPattern(this.bottomContent.runForFilesField.getText().trim()).setRunOnSave(this.bottomContent.runOnSaveCheckBox.isSelected()).build().withLinterPackage(AutodetectLinterPackage.INSTANCE);
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(2);
            }
            return eslintState;
        }

        @Override
        protected void handleEnabledStatusChanged(boolean enabled) {
            this.myEslintPanel.handleEnableStatusChanged(enabled);
            this.bottomContent.setRunForFilesRowEnabled(enabled);
            boolean checkBoxWasEnabled = this.bottomContent.runOnSaveCheckBox.isEnabled();
            this.bottomContent.runOnSaveCheckBox.setEnabled(enabled);
            if (checkBoxWasEnabled && !enabled) {
                this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled = this.bottomContent.runOnSaveCheckBox.isSelected();
                this.bottomContent.runOnSaveCheckBox.setSelected(false);
            }
            if (!checkBoxWasEnabled && enabled) {
                this.bottomContent.runOnSaveCheckBox.setSelected(this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled);
            }
        }

        @Override
        @NotNull
        protected EslintState getState() {
            EslintState.Builder builder2 = this.myEslintPanel.buildEslintState();
            builder2.setFilesPattern(this.bottomContent.runForFilesField.getText().trim());
            builder2.setRunOnSave(this.bottomContent.runOnSaveCheckBox.isEnabled() && this.bottomContent.runOnSaveCheckBox.isSelected());
            EslintState eslintState = builder2.build();
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(3);
            }
            return eslintState;
        }

        private JCheckBox getRunOnSaveCheckBox() {
            return this.bottomContent.runOnSaveCheckBox;
        }

        private boolean isDisabledRadioButtonSelected() {
            return this.myDisabledRb.isSelected();
        }

        boolean isAutomaticRadioButtonSelected() {
            return this.myConfigureAutomaticallyRadioRb.isSelected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateWithConfiguredAutomatically";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addBottomComponents";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static class EsLintOnSaveActionInfo
    extends ActionOnSaveBackedByOwnConfigurable<EslintConfigurable> {
        EsLintOnSaveActionInfo(@NotNull ActionOnSaveContext context2) {
            if (context2 == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(0);
            }
            super(context2, EslintConfigurable.ID, EslintConfigurable.class);
        }

        @NotNull
        public String getActionOnSaveName() {
            String string = JavaScriptBundle.message("eslint.run.on.save.checkbox.on.actions.on.save.page", new Object[0]);
            if (string == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected boolean isApplicableAccordingToStoredState() {
            return EslintConfiguration.getInstance(this.getProject()).isEnabled() || StandardJSConfiguration.getInstance(this.getProject()).isEnabled();
        }

        protected boolean isApplicableAccordingToUiState(@NotNull EslintConfigurable configurable) {
            JCheckBox runOnSaveCheckBox;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(2);
            }
            return (runOnSaveCheckBox = configurable.getEslintView().getRunOnSaveCheckBox()).isVisible() && runOnSaveCheckBox.isEnabled();
        }

        @Nullable
        protected ActionOnSaveComment getCommentAccordingToStoredState() {
            ExtendedLinterState state = EslintConfiguration.getInstance(this.getProject()).getExtendedState();
            if (!state.isEnabled()) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.disabled.comment", new Object[0]));
            }
            String propertyName = "js.linters.configure.manually.selectedeslint";
            if (NewLinterView.isValidAutomaticState((JSNpmLinterState)state.getState()) && !PropertiesComponent.getInstance((Project)this.getProject()).getBoolean(propertyName, false)) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.auto.configuration.comment", new Object[0]));
            }
            return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.manual.configuration.comment", new Object[0]));
        }

        @Nullable
        protected ActionOnSaveComment getCommentAccordingToUiState(@NotNull EslintConfigurable configurable) {
            NewEslintView view;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(3);
            }
            if ((view = configurable.getEslintView()).isDisabledRadioButtonSelected()) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.disabled.comment", new Object[0]));
            }
            if (view.isAutomaticRadioButtonSelected()) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.auto.configuration.comment", new Object[0]));
            }
            return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.manual.configuration.comment", new Object[0]));
        }

        protected boolean isActionOnSaveEnabledAccordingToStoredState() {
            return EslintConfiguration.getInstance(this.getProject()).isFixOnSaveEnabled() || StandardJSConfiguration.getInstance(this.getProject()).isFixOnSaveEnabled();
        }

        protected boolean isActionOnSaveEnabledAccordingToUiState(@NotNull EslintConfigurable configurable) {
            JCheckBox runOnSaveCheckBox;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(4);
            }
            return (runOnSaveCheckBox = configurable.getEslintView().getRunOnSaveCheckBox()).isVisible() && runOnSaveCheckBox.isEnabled() && runOnSaveCheckBox.isSelected();
        }

        protected void setActionOnSaveEnabled(@NotNull EslintConfigurable configurable, boolean enabled) {
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(5);
            }
            JCheckBox runOnSaveCheckBox = configurable.getEslintView().getRunOnSaveCheckBox();
            runOnSaveCheckBox.setSelected(enabled);
        }

        @NotNull
        public List<? extends ActionLink> getActionLinks() {
            String linkText = (String)this.getValueFromSavedStateOrFromUiState(this::getOpenEsLintPageTextAccordingToStoredState, EsLintOnSaveActionInfo::getOpenEsLintPageTextAccordingToUiState);
            List<ActionLink> list2 = Collections.singletonList(this.createGoToPageInSettingsLink(linkText, EslintConfigurable.ID));
            if (list2 == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        private String getOpenEsLintPageTextAccordingToStoredState() {
            ExtendedLinterState state = EslintConfiguration.getInstance(this.getProject()).getExtendedState();
            String string = state.isEnabled() ? IdeBundle.message((String)"actions.on.save.link.configure", (Object[])new Object[0]) : JavaScriptBundle.message("eslint.run.on.save.link.enable.eslint", new Object[0]);
            if (string == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        private static String getOpenEsLintPageTextAccordingToUiState(@NotNull EslintConfigurable configurable) {
            ExtendedLinterState state;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(8);
            }
            String string = (state = configurable.getEslintView().getExtendedState()).isEnabled() ? IdeBundle.message((String)"actions.on.save.link.configure", (Object[])new Object[0]) : JavaScriptBundle.message("eslint.run.on.save.link.enable.eslint", new Object[0]);
            if (string == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$EsLintOnSaveActionInfo";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$EsLintOnSaveActionInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionOnSaveName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionLinks";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOpenEsLintPageTextAccordingToStoredState";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOpenEsLintPageTextAccordingToUiState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicableAccordingToUiState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentAccordingToUiState";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isActionOnSaveEnabledAccordingToUiState";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionOnSaveEnabled";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getOpenEsLintPageTextAccordingToUiState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6, 7, 9 -> new IllegalStateException(string);
            };
        }
    }
}

