/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.library.LibraryCommitChangesMerger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.util.messages.Topic;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class JSLibraryManager
extends ScriptingLibraryManager
implements Disposable {
    @Topic.ProjectLevel
    public static final Topic<JSLibraryManagerChangeListener> TOPIC = new Topic(JSLibraryManagerChangeListener.class, Topic.BroadcastDirection.NONE);
    private static final Logger LOG = Logger.getInstance(JSLibraryManager.class);
    private final LibraryCommitChangesMerger myCommitChangesMerger = new LibraryCommitChangesMerger(this, 300L);
    private JSLibraryMappings myLibraryMappings;

    public JSLibraryManager(Project project) {
        super(project, JSLibraryKind.INSTANCE);
    }

    protected void initPredefinedLibraries(@NotNull ScriptingLibraryTable libraryTable) {
        if (libraryTable == null) {
            JSLibraryManager.$$$reportNull$$$0(0);
        }
        for (ScriptingLibraryModel library : this.getPredefinedLibraryManager().getLibraryModels()) {
            libraryTable.addPredefinedLibrary(library);
        }
    }

    public void commitChangesWithReason(@NotNull RootsChangeRescanningInfo info2, @Nullable String reason) {
        if (info2 == null) {
            JSLibraryManager.$$$reportNull$$$0(1);
        }
        LOG.info("Firing rootsChanged event" + (String)(reason != null ? " due to " + reason : ""));
        this.commitChanges(info2);
    }

    public void commitChanges(@Nullable RootsChangeRescanningInfo info2) {
        this.getPredefinedLibraryManager().invalidatePredefinedLibrariesCache();
        super.commitChanges(info2);
        if (!this.getProject().isDisposed()) {
            ((JSLibraryManagerChangeListener)this.getProject().getMessageBus().syncPublisher(TOPIC)).onChange();
        }
    }

    @NotNull
    public ScriptingLibraryMappings getLibraryMappings() {
        JSLibraryMappings libraryMappings = this.myLibraryMappings;
        if (libraryMappings == null) {
            this.myLibraryMappings = libraryMappings = JSLibraryMappings.getInstance(this.getProject());
        }
        JSLibraryMappings jSLibraryMappings = libraryMappings;
        if (jSLibraryMappings == null) {
            JSLibraryManager.$$$reportNull$$$0(2);
        }
        return jSLibraryMappings;
    }

    public void dispose() {
    }

    @NotNull
    public static JSLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            JSLibraryManager.$$$reportNull$$$0(3);
        }
        JSLibraryManager jSLibraryManager = (JSLibraryManager)((Object)project.getService(JSLibraryManager.class));
        if (jSLibraryManager == null) {
            JSLibraryManager.$$$reportNull$$$0(4);
        }
        return jSLibraryManager;
    }

    @NotNull
    private JSPredefinedLibraryManager getPredefinedLibraryManager() {
        JSPredefinedLibraryManager jSPredefinedLibraryManager = JSPredefinedLibraryManager.getPredefinedLibraryManager(this.getProject());
        if (jSPredefinedLibraryManager == null) {
            JSLibraryManager.$$$reportNull$$$0(5);
        }
        return jSPredefinedLibraryManager;
    }

    public void scheduleCommitChanges(@Nullable RootsChangeRescanningInfo info2) {
        this.myCommitChangesMerger.request(info2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initPredefinedLibraries";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commitChangesWithReason";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface JSLibraryManagerChangeListener {
        public void onChange();
    }
}

