/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSInitializeFieldsIntentionBase
extends JavaScriptIntention {
    private static final String FIELD_VISIBILITY = "JSInitializeFieldsIntentionBase.visibility";
    private final boolean myHeadlessEnvironment;
    protected static final String TRUE = Boolean.TRUE.toString();
    protected static final String FALSE = Boolean.FALSE.toString();
    private static final Set<String> EMPTY_STRING_SET = new HashSet<String>();
    private MyVisibilityChooser myDropdown = null;

    public JSInitializeFieldsIntentionBase() {
        this.setText(this.getFamilyName());
        this.myHeadlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        List selectedElements;
        if (project == null) {
            JSInitializeFieldsIntentionBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSInitializeFieldsIntentionBase.$$$reportNull$$$0(1);
        }
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        assert (function2 != null);
        Set<String> names = JSInitializeFieldsIntentionBase.collectNamesToImplement(function2, this.includeImplicitFields(function2));
        assert (!names.isEmpty());
        List<? extends PsiElement> elements = this.collectNamedElements(function2, names);
        if (names.size() > 1 && !this.myHeadlessEnvironment) {
            JSFieldIntroducerMemberChooser chooser = new JSFieldIntroducerMemberChooser(elements, project);
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return;
            }
            List selected = chooser.getSelectedElements();
            if (selected == null) {
                return;
            }
            selectedElements = ContainerUtil.map((Collection)selected, e -> (JSNamedElement)e.getPsiElement());
        } else {
            selectedElements = ContainerUtil.map(elements, e -> (JSNamedElement)e);
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.doInvoke(project, function2, selectedElements));
    }

    @NotNull
    protected List<? extends PsiElement> collectNamedElements(JSFunction function2, Set<String> names) {
        List list2 = ContainerUtil.filter((Object[])function2.getParameters(), p -> p instanceof JSParameter && names.contains(((JSParameter)p).getName()));
        if (list2 == null) {
            JSInitializeFieldsIntentionBase.$$$reportNull$$$0(2);
        }
        return list2;
    }

    protected abstract void doInvoke(Project var1, JSFunction var2, List<JSNamedElement> var3);

    @NlsContexts.DialogTitle
    protected abstract String getDialogTitle();

    protected abstract ImplicitFields includeImplicitFields(PsiElement var1);

    @NotNull
    @IntentionName
    protected String getSingleText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSInitializeFieldsIntentionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSInitializeFieldsIntentionBase.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSInitializeFieldsIntentionBase.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        if (function2 == null || !function2.isConstructor()) {
            return false;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(function2);
        if (dialect == null || !this.isPassingDialect(dialect)) {
            return false;
        }
        JSParameterList parameterList = function2.getParameterList();
        if (!this.isPassingLocation(element, function2, parameterList)) {
            return false;
        }
        Set<String> names = JSInitializeFieldsIntentionBase.collectNamesToImplement(function2, this.includeImplicitFields(function2));
        if (names.isEmpty()) {
            return false;
        }
        if (names.size() == 1) {
            this.setText(this.getSingleText());
        } else {
            this.setText(this.getFamilyName());
        }
        return true;
    }

    protected boolean isPassingDialect(DialectOptionHolder dialect) {
        return dialect.isTypeScript || dialect.isJavaScript();
    }

    protected boolean isPassingLocation(@NotNull PsiElement element, JSFunction function2, JSParameterList parameterList) {
        if (element == null) {
            JSInitializeFieldsIntentionBase.$$$reportNull$$$0(6);
        }
        return PsiTreeUtil.isAncestor((PsiElement)parameterList, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)function2.getNameIdentifier(), (PsiElement)element, (boolean)false);
    }

    public boolean startInWriteAction() {
        return this.myHeadlessEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> collectNamesToImplement(JSFunction function2, ImplicitFields checkImplicit) {
        JSClass clazz = JSResolveUtil.getClassOfContext(function2);
        if (clazz == null) {
            return EMPTY_STRING_SET;
        }
        HashSet<String> names = new HashSet<String>();
        if (checkImplicit != ImplicitFields.ONLY_IMPLICIT) {
            void var6_9;
            JSParameterListElement[] jSParameterListElementArray = function2.getParameters();
            int n = jSParameterListElementArray.length;
            boolean bl = false;
            while (var6_9 < n) {
                JSParameterListElement parameter = jSParameterListElementArray[var6_9];
                if (!(parameter instanceof JSParameter) || TypeScriptPsiUtil.isFieldParameter((JSParameter)parameter)) {
                    return EMPTY_STRING_SET;
                }
                String name = parameter.getName();
                if (name == null) {
                    return EMPTY_STRING_SET;
                }
                names.add(name);
                ++var6_9;
            }
        }
        JBIterable expressions = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function2).forceIgnore(e -> e instanceof JSFunction)).filter(JSReferenceExpression.class).filter(e -> e.getQualifier() instanceof JSThisExpression && e.getParent() instanceof JSDefinitionExpression);
        if (checkImplicit != ImplicitFields.EXCLUDE) {
            if (checkImplicit == ImplicitFields.ONLY_IMPLICIT) {
                expressions.map(e -> e.getReferenceName()).addAllTo(names);
            } else {
                names.removeAll(expressions.map(e -> e.getReferenceName()).toList());
            }
        }
        if (checkImplicit != ImplicitFields.ONLY_IMPLICIT) {
            Set otherNames = expressions.map(e -> e.getParent()).filter(JSDefinitionExpression.class).map(e -> e.getParent()).filter(JSAssignmentExpression.class).map(e -> e.getROperand()).filter(JSReferenceExpression.class).filter(r -> r.getQualifier() == null).filter(r -> ArrayUtil.contains((Object)r.resolve(), (Object[])function2.getParameters())).map(r -> r.getReferenceName()).toSet();
            names.removeAll(otherNames);
        }
        for (JSElement jSElement : clazz.getMembers()) {
            names.remove(jSElement.getName());
        }
        return names;
    }

    protected static PsiElement computeClassAnchor(JSFunction function2) {
        JSClass jsClass = JSResolveUtil.getClassOfContext(function2);
        PsiElement anchor = (PsiElement)ArrayUtil.getLastElement((Object[])jsClass.getFields());
        anchor = anchor == null ? JSInitializeFieldsIntentionBase.getLBrace(jsClass) : anchor.getParent();
        return anchor;
    }

    protected static PsiElement getLBrace(PsiElement jsClass) {
        return Objects.requireNonNull(jsClass.getNode().findChildByType(JSTokenTypes.LBRACE)).getPsi();
    }

    protected PsiElement addClassMember(Project project, PsiElement anchor, JSLanguageDialect dialect, String text2) {
        PsiElement member = JSChangeUtil.createClassMemberFromText(project, text2, dialect).getPsi();
        this.applyAccessType((JSAttributeListOwner)member, project);
        return anchor.getParent().addAfter(member, anchor);
    }

    protected void applyAccessType(JSAttributeListOwner member, Project project) {
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(member);
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PRIVATE;
        if (this.myDropdown != null) {
            JSAttributeList.AccessType type2 = this.myDropdown.getAccessType();
            if (type2 != null) {
                accessType = type2;
            }
        } else {
            String value = PropertiesComponent.getInstance((Project)project).getValue(FIELD_VISIBILITY);
            if (value != null) {
                accessType = JSVisibilityUtil.getAccessType(value);
            }
        }
        wrapper.overrideAccessType(accessType);
        wrapper.applyTo(member);
    }

    protected JComponent @Nullable [] getOptionControls() {
        JComponent[] jComponentArray = new JComponent[1];
        this.myDropdown = new MyVisibilityChooser();
        jComponentArray[0] = this.myDropdown;
        return jComponentArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSInitializeFieldsIntentionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSInitializeFieldsIntentionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamedElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPassingLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisibilityChooser
    extends JPanel
    implements OptionComponent {
        private final JComboBox<JSAttributeList.AccessType> myDropdown;

        private MyVisibilityChooser() {
            this.setLayout(new BoxLayout(this, 2));
            this.add(new JLabel(JavaScriptBundle.message("initialize.fields.intention.visibility", new Object[0])));
            this.myDropdown = new JComboBox<JSAttributeList.AccessType>((ComboBoxModel)new EnumComboBoxModel<JSAttributeList.AccessType>(JSAttributeList.AccessType.class){

                @NotNull
                protected EnumSet<JSAttributeList.AccessType> createEnumSet(@NotNull Class<JSAttributeList.AccessType> en) {
                    if (en == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    EnumSet set = super.createEnumSet(en);
                    set.remove((Object)JSAttributeList.AccessType.PACKAGE_LOCAL);
                    EnumSet enumSet = set;
                    if (enumSet == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return enumSet;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "en";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/intentions/JSInitializeFieldsIntentionBase$MyVisibilityChooser$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/intentions/JSInitializeFieldsIntentionBase$MyVisibilityChooser$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createEnumSet";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createEnumSet";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            }){

                @Override
                public ListCellRenderer<? super JSAttributeList.AccessType> getRenderer() {
                    return SimpleListCellRenderer.create((String)"", JSVisibilityUtil::getVisibilityKeyword);
                }
            };
            this.add(this.myDropdown);
        }

        @Override
        @NotNull
        public String getKey() {
            return JSInitializeFieldsIntentionBase.FIELD_VISIBILITY;
        }

        @Override
        @NotNull
        public String getValue() {
            Object item = this.myDropdown.getSelectedItem();
            if (!(item instanceof JSAttributeList.AccessType)) {
                String string = this.getDefaultValue();
                if (string == null) {
                    MyVisibilityChooser.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = JSVisibilityUtil.getVisibilityKeyword((JSAttributeList.AccessType)((Object)item));
            if (string == null) {
                MyVisibilityChooser.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDefaultValue() {
            String string = JSVisibilityUtil.getVisibilityKeyword(JSAttributeList.AccessType.PRIVATE);
            if (string == null) {
                MyVisibilityChooser.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void init(String value) {
            this.myDropdown.setSelectedItem((Object)JSVisibilityUtil.getAccessType(value));
        }

        @Nullable
        public JSAttributeList.AccessType getAccessType() {
            return (JSAttributeList.AccessType)((Object)ObjectUtils.tryCast((Object)this.myDropdown.getSelectedItem(), JSAttributeList.AccessType.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/intentions/JSInitializeFieldsIntentionBase$MyVisibilityChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected static enum ImplicitFields {
        INCLUDE,
        ONLY_IMPLICIT,
        EXCLUDE;

    }

    private final class JSFieldIntroducerMemberChooser
    extends MemberChooser<JSNamedElementNode> {
        private final Project myProject;
        private MemberChooser.ShowContainersAction myShowContainersAction;

        private JSFieldIntroducerMemberChooser(List<? extends PsiElement> elements, Project project) {
            super((ClassMember[])((JSNamedElementNode[])ContainerUtil.map2Array(elements, (Object[])new JSNamedElementNode[0], e -> new JSNamedElementNode((JSPsiNamedElementBase)e))), false, true, project);
            this.myProject = project;
            this.setTitle(JSInitializeFieldsIntentionBase.this.getDialogTitle());
            this.setCopyJavadocVisible(false);
            JComponent[] controls = JSInitializeFieldsIntentionBase.this.getOptionControls();
            if (controls != null) {
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
                for (JComponent c2 : controls) {
                    if (!(c2 instanceof OptionComponent)) continue;
                    ((OptionComponent)((Object)c2)).init(propertiesComponent.getValue(((OptionComponent)((Object)c2)).getKey(), ((OptionComponent)((Object)c2)).getDefaultValue()));
                }
                this.myOptionControls = controls;
                this.init();
            }
        }

        protected void fillToolbarActions(DefaultActionGroup group) {
            super.fillToolbarActions(group);
            this.setShowClasses(true);
            group.remove((AnAction)this.myShowContainersAction);
        }

        protected MemberChooser.ShowContainersAction getShowContainersAction() {
            this.myShowContainersAction = super.getShowContainersAction();
            return this.myShowContainersAction;
        }

        protected void doOKAction() {
            if (this.myOptionControls != null) {
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
                for (JComponent c2 : this.myOptionControls) {
                    if (!(c2 instanceof OptionComponent)) continue;
                    String value = ((OptionComponent)((Object)c2)).getValue();
                    String defaultValue = ((OptionComponent)((Object)c2)).getDefaultValue();
                    String key2 = ((OptionComponent)((Object)c2)).getKey();
                    String currentValue = propertiesComponent.getValue(key2);
                    if ((currentValue != null || Objects.equals(value, defaultValue)) && Objects.equals(value, currentValue)) continue;
                    propertiesComponent.setValue(key2, value);
                }
            }
            super.doOKAction();
        }

        public void dispose() {
            super.dispose();
            this.myShowContainersAction = null;
        }
    }

    protected static interface OptionComponent {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        @NotNull
        public String getDefaultValue();

        public void init(String var1);
    }
}

