/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JSInitializeFieldsIntentionBase;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSInitializeFieldsIntention
extends JSInitializeFieldsIntentionBase {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.intention.init.fields", new Object[0]);
        if (string == null) {
            JSInitializeFieldsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected String getDialogTitle() {
        return JavaScriptBundle.message("javascript.intention.init.fields.dialog.title", new Object[0]);
    }

    @Override
    protected JSInitializeFieldsIntentionBase.ImplicitFields includeImplicitFields(PsiElement context2) {
        if (DialectDetector.isTypeScript(context2)) {
            return JSInitializeFieldsIntentionBase.ImplicitFields.EXCLUDE;
        }
        return JSInitializeFieldsIntentionBase.ImplicitFields.INCLUDE;
    }

    @Override
    protected void doInvoke(Project project, JSFunction function2, List<JSNamedElement> elements) {
        JSExpression expression;
        JSBlockStatement block = function2.getBlock();
        if (block == null) {
            return;
        }
        Object blockAnchor = JSInitializeFieldsIntention.getLBrace(block);
        JSSourceElement firstElement = (JSSourceElement)ArrayUtil.getFirstElement((Object[])block.getStatementListItems());
        if (firstElement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)firstElement).getExpression()) instanceof JSCallExpression && ((JSCallExpression)expression).getMethodExpression() instanceof JSSuperExpression) {
            blockAnchor = firstElement;
        }
        PsiElement anchor = JSInitializeFieldsIntention.computeClassAnchor(function2);
        JSClass clazz = JSResolveUtil.getClassOfContext(function2);
        HashSet<String> existingMembers = new HashSet<String>();
        for (JSElement jSElement : clazz.getMembers()) {
            if (!(jSElement instanceof JSNamedElement)) continue;
            existingMembers.add(((JSNamedElement)jSElement).getName());
        }
        String semicolon = JSCodeStyleSettings.getSemicolon(function2);
        JSLanguageDialect jSLanguageDialect = DialectDetector.languageDialectOfElement(function2);
        for (JSNamedElement element : elements) {
            String name = element.getName();
            if (!existingMembers.contains(name)) {
                String text2 = element.getText() + semicolon;
                anchor = this.addClassMember(project, anchor, jSLanguageDialect, text2);
            }
            JSStatement statement = JSPsiElementFactory.createJSStatement("this." + name + " = " + name + semicolon, function2);
            blockAnchor = blockAnchor.getParent().addAfter((PsiElement)statement, blockAnchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSInitializeFieldsIntention", "getFamilyName"));
    }
}

