/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.unusedsymbols;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolsPass;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSSymbolReferenceCache {
    private static final Key<ReferenceCachingSearcher> CACHED_VALUE_KEY = Key.create((String)"js.symbol.reference.cache.key");
    private static boolean ourAssertOnFindUsages = false;

    private JSSymbolReferenceCache() {
    }

    public static boolean calcUnused(@NotNull PsiElement element) {
        ThreeState usedFromCache;
        if (element == null) {
            JSSymbolReferenceCache.$$$reportNull$$$0(0);
        }
        if ((usedFromCache = JSSymbolReferenceCache.isUsedImplicitlyOrFromCache(element)) != ThreeState.UNSURE) {
            return !usedFromCache.toBoolean();
        }
        return JSSymbolReferenceCache.getReferenceSearcher(element).findAnyReference(null) == null;
    }

    @NotNull
    public static ReferenceCachingSearcher getReferenceSearcher(@NotNull PsiElement element) {
        ReferenceCachingSearcher cachedValue;
        if (element == null) {
            JSSymbolReferenceCache.$$$reportNull$$$0(1);
        }
        if ((cachedValue = (ReferenceCachingSearcher)element.getUserData(CACHED_VALUE_KEY)) == null) {
            element.putUserData(CACHED_VALUE_KEY, (Object)new ReferenceCachingSearcherImpl(element));
            cachedValue = (ReferenceCachingSearcher)element.getUserData(CACHED_VALUE_KEY);
            if (cachedValue == null) {
                Logger.getInstance(JSSymbolReferenceCache.class).error("Unsynchronized user data");
                cachedValue = new ReferenceCachingSearcherImpl(element);
            }
        }
        ReferenceCachingSearcher referenceCachingSearcher = cachedValue;
        if (referenceCachingSearcher == null) {
            JSSymbolReferenceCache.$$$reportNull$$$0(2);
        }
        return referenceCachingSearcher;
    }

    @NotNull
    public static ThreeState isUsedImplicitlyOrFromCache(@NotNull PsiElement element) {
        if (element == null) {
            JSSymbolReferenceCache.$$$reportNull$$$0(3);
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitUsage(element)) continue;
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSSymbolReferenceCache.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        Collection<PsiReference> fromCache = JSSymbolReferenceCache.getReferenceSearcher(element).getReferenceFromCache();
        ThreeState threeState = fromCache == null ? ThreeState.UNSURE : ThreeState.fromBoolean((!fromCache.isEmpty() ? 1 : 0) != 0);
        if (threeState == null) {
            JSSymbolReferenceCache.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    @TestOnly
    public static void assertOnFindUsages(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSSymbolReferenceCache.$$$reportNull$$$0(6);
        }
        ourAssertOnFindUsages = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnFindUsages = false;
            }
        });
    }

    private static void findUsagesStarted() {
        if (ourAssertOnFindUsages) {
            throw new IllegalStateException("Find usages must not be called at this moment");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceSearcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "isUsedImplicitlyOrFromCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcUnused";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceSearcher";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUsedImplicitlyOrFromCache";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertOnFindUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static interface ReferenceCachingSearcher {
        @Nullable
        default public PsiReference findAnyReference(@Nullable PsiFile scopeLimit) {
            return (PsiReference)ContainerUtil.getFirstItem(this.findReferences(1, scopeLimit));
        }

        @NotNull
        public Collection<PsiReference> findReferences(int var1, @Nullable PsiFile var2);

        public void saveNoReferencesFound();

        @Nullable
        public Collection<PsiReference> getReferenceFromCache();
    }

    private static class ReferenceCachingSearcherImpl
    implements ReferenceCachingSearcher {
        @NotNull
        private final PsiElement myElement;
        @Nullable
        private volatile SearchResult mySearchResult;

        private ReferenceCachingSearcherImpl(@NotNull PsiElement element) {
            if (element == null) {
                ReferenceCachingSearcherImpl.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        @NotNull
        public Collection<PsiReference> findReferences(int limit, @Nullable PsiFile scopeLimit) {
            SearchResult searchResult = this.mySearchResult;
            if (searchResult != null && limit <= searchResult.myLimit) {
                Collection<PsiReference> references = searchResult.getReferences(this.myElement, limit);
                if (references != null) {
                    Collection<PsiReference> collection = references;
                    if (collection == null) {
                        ReferenceCachingSearcherImpl.$$$reportNull$$$0(1);
                    }
                    return collection;
                }
                this.mySearchResult = null;
            }
            JSSymbolReferenceCache.findUsagesStarted();
            SearchScope scope2 = this.getScopeForSearch(scopeLimit);
            Query psiReferenceQuery = ReferencesSearch.search((PsiElement)this.myElement, (SearchScope)scope2, (boolean)true);
            MySearchProcessor processor = new MySearchProcessor(this.myElement, limit);
            psiReferenceQuery.forEach((Processor)processor);
            Collection<PsiReference> references = processor.getFoundReferences();
            if (scopeLimit == null || !references.isEmpty()) {
                this.mySearchResult = SearchResult.create(references, limit, this.myElement.getProject());
            }
            Collection<PsiReference> collection = references;
            if (collection == null) {
                ReferenceCachingSearcherImpl.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        private SearchScope getScopeForSearch(@Nullable PsiFile scopeLimit) {
            PsiFile file;
            if (scopeLimit != null) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)scopeLimit);
                if (globalSearchScope == null) {
                    ReferenceCachingSearcherImpl.$$$reportNull$$$0(3);
                }
                return globalSearchScope;
            }
            GlobalSearchScope scope2 = JSUnusedGlobalSymbolsPass.getScopeForSearch(this.myElement);
            if (scope2 == null && (file = this.myElement.getContainingFile()) != null && file.getVirtualFile() == null) {
                return new LocalSearchScope((PsiElement)file);
            }
            if (scope2 == null) {
                scope2 = this.myElement.getUseScope();
            }
            GlobalSearchScope globalSearchScope = scope2;
            if (globalSearchScope == null) {
                ReferenceCachingSearcherImpl.$$$reportNull$$$0(4);
            }
            return globalSearchScope;
        }

        @Override
        public void saveNoReferencesFound() {
            this.mySearchResult = SearchResult.noReferences(this.myElement.getProject());
        }

        @Override
        @Nullable
        public Collection<PsiReference> getReferenceFromCache() {
            SearchResult searchResult = this.mySearchResult;
            return searchResult != null ? searchResult.getReferences(this.myElement, 1) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache$ReferenceCachingSearcherImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache$ReferenceCachingSearcherImpl";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findReferences";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScopeForSearch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class SearchResult {
        private final Collection<SoftlyCachedValue<PsiReference>> myReferences;
        private final SoftlyCachedValue<?> myNoReferencesResult;
        private final int myLimit;

        private SearchResult(@NotNull Collection<PsiReference> references, int limit, @NotNull Project project) {
            if (references == null) {
                SearchResult.$$$reportNull$$$0(0);
            }
            if (project == null) {
                SearchResult.$$$reportNull$$$0(1);
            }
            if (references.isEmpty()) {
                this.myReferences = null;
                this.myNoReferencesResult = new SoftlyCachedValue(Optional.empty(), new ReferenceModificationTracker(null, project));
                this.myLimit = Integer.MAX_VALUE;
            } else {
                this.myReferences = ContainerUtil.map(references, it -> new SoftlyCachedValue<PsiReference>((PsiReference)it, new ReferenceModificationTracker((PsiReference)it, project)));
                this.myNoReferencesResult = null;
                this.myLimit = limit;
            }
        }

        @NotNull
        public static SearchResult create(@NotNull Collection<PsiReference> references, int limit, @NotNull Project project) {
            if (references == null) {
                SearchResult.$$$reportNull$$$0(2);
            }
            if (project == null) {
                SearchResult.$$$reportNull$$$0(3);
            }
            return new SearchResult(references, limit, project);
        }

        @NotNull
        public static SearchResult noReferences(@NotNull Project project) {
            if (project == null) {
                SearchResult.$$$reportNull$$$0(4);
            }
            return SearchResult.create(Collections.emptyList(), 1, project);
        }

        @Nullable
        public Collection<PsiReference> getReferences(@NotNull PsiElement resolve2, int limit) {
            if (resolve2 == null) {
                SearchResult.$$$reportNull$$$0(5);
            }
            if (this.myNoReferencesResult != null) {
                return this.myNoReferencesResult.getUpToDateOrNull() == null ? null : Collections.emptyList();
            }
            if (this.myReferences == null) {
                throw new IllegalStateException("SearchResult constructor contract broken");
            }
            ArrayList<PsiReference> result2 = new ArrayList<PsiReference>(this.myReferences.size());
            int outdatedRefs = 0;
            for (SoftlyCachedValue<PsiReference> reference : this.myReferences) {
                PsiReference ref = reference.getUpToDateOrNull();
                if (ref != null && ref.getElement().isValid() && ref.isReferenceTo(resolve2)) {
                    result2.add(ref);
                } else {
                    ++outdatedRefs;
                }
                if (result2.size() >= limit) {
                    return result2;
                }
                if (this.myReferences.size() - outdatedRefs >= limit) continue;
                return null;
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolve";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache$SearchResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "noReferences";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getReferences";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ReferenceModificationTracker
    implements ModificationTracker {
        @Nullable
        private final PsiReference myReference;
        @NotNull
        private final Project myProject;

        private ReferenceModificationTracker(@Nullable PsiReference reference, @NotNull Project project) {
            if (project == null) {
                ReferenceModificationTracker.$$$reportNull$$$0(0);
            }
            this.myReference = reference;
            this.myProject = project;
        }

        public long getModificationCount() {
            if (this.myReference == null) {
                return PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
            }
            PsiElement element = this.myReference.getElement();
            if (!element.isValid()) {
                return ModificationTracker.EVER_CHANGED.getModificationCount();
            }
            for (PsiReference reference : element.getReferences()) {
                if (reference == null || !ReferenceModificationTracker.areSameReferencesOfElement(reference, this.myReference)) continue;
                return 0L;
            }
            return ModificationTracker.EVER_CHANGED.getModificationCount();
        }

        private static boolean areSameReferencesOfElement(@NotNull PsiReference reference1, @NotNull PsiReference reference2) {
            if (reference1 == null) {
                ReferenceModificationTracker.$$$reportNull$$$0(1);
            }
            if (reference2 == null) {
                ReferenceModificationTracker.$$$reportNull$$$0(2);
            }
            return reference1.equals(reference2) || reference1.getClass().equals(reference2.getClass()) && reference1.getRangeInElement().equals((Object)reference2.getRangeInElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache$ReferenceModificationTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areSameReferencesOfElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySearchProcessor
    implements Processor<PsiReference> {
        private final PsiElement myElementToSearch;
        private final int myLimit;
        private final Collection<PsiReference> myRef = Collections.synchronizedCollection(new ArrayList());

        MySearchProcessor(PsiElement elementToSearch, int limit) {
            this.myElementToSearch = elementToSearch;
            this.myLimit = limit;
        }

        public boolean process(PsiReference psiReference) {
            PsiElement parent;
            PsiElement psiElement = psiReference.getElement();
            if (JSResolveUtil.isSelfReference(psiElement) || this.isNegligibleReference(psiElement)) {
                return true;
            }
            if (this.myElementToSearch instanceof JSDefinitionExpression && (parent = psiElement.getParent()) instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression && parent.getParent().getParent() instanceof JSExpressionStatement) {
                return true;
            }
            this.myRef.add(psiReference);
            return this.myRef.size() < this.myLimit;
        }

        @NotNull
        public Collection<PsiReference> getFoundReferences() {
            Collection<PsiReference> collection = this.myRef;
            if (collection == null) {
                MySearchProcessor.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private boolean isNegligibleReference(@NotNull PsiElement referenceElement) {
            ES6ExportDeclaration declaration;
            if (referenceElement == null) {
                MySearchProcessor.$$$reportNull$$$0(1);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myElementToSearch, (PsiElement)referenceElement, (boolean)false)) {
                if (this.myElementToSearch instanceof JSClass) {
                    return true;
                }
                JSFunction callback = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, JSFunction.class);
                return callback == null || !PsiTreeUtil.isAncestor((PsiElement)this.myElementToSearch, (PsiElement)callback, (boolean)true);
            }
            return referenceElement instanceof ES6ExportSpecifier && ((ES6ExportSpecifier)referenceElement).getAlias() == null && (declaration = ((ES6ExportSpecifier)referenceElement).getDeclaration()) != null && declaration.getFromClause() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache$MySearchProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFoundReferences";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSSymbolReferenceCache$MySearchProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isNegligibleReference";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

