/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIgnoredPromiseFromCallInspection
extends JSInspection {
    private static final Set<String> TEST_NAMES = Set.of("test", "it", "context", "describe");
    static final Set<String> PROMISE_CHAIN_CALLS = Set.of("then", "catch", "finally");

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFile(@NotNull JSFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file).forceIgnore(e -> e instanceof JSFunction && JSIgnoredPromiseFromCallInspection.isAsyncFunction((JSFunction)e))).forceIgnore(e -> 1.isPossiblyTestCall(e))).filter(JSCallExpression.class).forEach(this::validateCall);
            }

            private static boolean isPossiblyTestCall(PsiElement e) {
                if (!(e instanceof JSCallExpression)) {
                    return false;
                }
                JSReferenceExpression reference = (JSReferenceExpression)ObjectUtils.tryCast((Object)((JSCallExpression)e).getMethodExpression(), JSReferenceExpression.class);
                if (reference == null || reference.getQualifier() != null || reference.getReferenceName() == null) {
                    return false;
                }
                return TEST_NAMES.contains(reference.getReferenceName());
            }

            private void validateCall(@NotNull JSCallExpression node) {
                DialectOptionHolder optionHolder;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((optionHolder = DialectDetector.dialectOfElement((PsiElement)node)) == null || optionHolder.isECMA4) {
                    return;
                }
                PositionKind positionKind = JSIgnoredPromiseFromCallInspection.getPositionKind(node);
                if (positionKind == PositionKind.Unsuitable) {
                    return;
                }
                JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)node.getMethodExpression(), JSReferenceExpression.class);
                if (referenceExpression == null) {
                    return;
                }
                String referenceName = referenceExpression.getReferenceName();
                if (JSIgnoredPromiseFromCallInspection.returnsPromiseType(node)) {
                    JSFunction ownerFunction;
                    if (positionKind == PositionKind.Statement && referenceName != null && PROMISE_CHAIN_CALLS.contains(referenceName)) {
                        return;
                    }
                    PsiElement referenceNameElement = referenceExpression.getReferenceNameElement();
                    if (referenceNameElement != null && !JSIgnoredPromiseFromCallInspection.isAsyncFunction(ownerFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class))) {
                        if (positionKind == PositionKind.Statement) {
                            holder.registerProblem(referenceNameElement, JavaScriptBundle.message("js.inspection.promise.ignored.problem.descriptor", referenceName), new LocalQuickFix[]{new AddThenFix(node)});
                        } else if (positionKind == PositionKind.ValueExpected) {
                            holder.registerProblem(referenceNameElement, JavaScriptBundle.message("js.inspection.promise.value.expected.problem.descriptor", referenceName), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSIgnoredPromiseFromCallInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validateCall";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Contract(value="null -> false")
    public static boolean isAsyncFunction(@Nullable JSFunction expression) {
        JSAttributeList list2 = expression == null ? null : expression.getAttributeList();
        return list2 != null && list2.hasModifier(JSAttributeList.ModifierType.ASYNC);
    }

    private static boolean returnsPromiseType(@NotNull JSExpression expression) {
        List types2;
        JSTypeEvaluationResult resolveResult;
        List results;
        if (expression == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(2);
        }
        List list2 = results = (resolveResult = JSTypeEvaluator.getElementType((PsiElement)expression)) == null ? Collections.emptyList() : resolveResult.getResults();
        if (DialectDetector.isTypeScript((PsiElement)expression)) {
            results = ContainerUtil.filter(results, r -> r.getEvaluateContext().isStrict());
        }
        return !(types2 = ContainerUtil.mapNotNull(results, e -> e.getType())).isEmpty() && ContainerUtil.and((Iterable)types2, element -> JSTypeUtils.isExactlyPromiseLikeType(element) || JSIgnoredPromiseFromCallInspection.implementsPromiseLike(element));
    }

    private static boolean implementsPromiseLike(@Nullable JSType expressionType) {
        Collection<? extends PsiElement> resolvedTypes = TypeScriptTypeParser.resolveElementsByType(expressionType);
        return !resolvedTypes.isEmpty() && ContainerUtil.and(resolvedTypes, typeResolveResult -> JSIgnoredPromiseFromCallInspection.implementsPromiseLike(typeResolveResult instanceof JSClass ? (JSClass)typeResolveResult : null));
    }

    private static boolean implementsPromiseLike(@Nullable JSClass resolvedClass) {
        if (resolvedClass == null) {
            return false;
        }
        Ref implementationFound = new Ref((Object)false);
        JSClassUtils.processClassesInHierarchy(resolvedClass, true, (aClass, substitutor, fromImplements) -> {
            if ("PromiseLike".equals(aClass.getName())) {
                implementationFound.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)implementationFound.get();
    }

    private static PositionKind getPositionKind(@NotNull JSCallExpression call) {
        PsiElement parent;
        if (call == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(3);
        }
        if ((parent = JSUtils.getParentSkipParentheses((PsiElement)call)) instanceof JSExpressionStatement) {
            return PositionKind.Statement;
        }
        if (parent instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == call) {
            return PositionKind.ValueExpected;
        }
        return PositionKind.Unsuitable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSIgnoredPromiseFromCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "returnsPromiseType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPositionKind";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum PositionKind {
        Statement,
        ValueExpected,
        Unsuitable;

    }

    static class AddThenFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        AddThenFix(JSCallExpression node) {
            super((PsiElement)node);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.add.then.fix", new Object[0]);
            if (string == null) {
                AddThenFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message("js.add.then.fix", new Object[0]);
            if (string == null) {
                AddThenFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddThenFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                AddThenFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                AddThenFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                AddThenFix.$$$reportNull$$$0(5);
            }
            return super.isAvailable(project, file, editor, startElement, endElement) && startElement instanceof JSCallExpression;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddThenFix.$$$reportNull$$$0(6);
            }
            if (file == null) {
                AddThenFix.$$$reportNull$$$0(7);
            }
            if (startElement == null) {
                AddThenFix.$$$reportNull$$$0(8);
            }
            if (endElement == null) {
                AddThenFix.$$$reportNull$$$0(9);
            }
            if (editor == null) {
                return;
            }
            JSCallExpression element = (JSCallExpression)startElement;
            boolean needsParenthesis = JSParenthesesUtils.needsParenthesis(element, JSPsiElementFactory.createJSExpression("a.b", (PsiElement)element));
            Object text2 = element.getText();
            if (needsParenthesis) {
                text2 = "(" + (String)text2 + ")";
            }
            JSCallExpression newElement = (JSCallExpression)element.replace(JSPsiElementFactory.createJSExpression((String)text2 + ".then(r => r)", (PsiElement)element));
            JSFunctionExpression argument = (JSFunctionExpression)newElement.getArguments()[0];
            JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(argument);
            assert (expression != null);
            int offset = expression.getTextOffset();
            expression.delete();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            editor.getDocument().insertString(offset - 1, (CharSequence)" ");
            editor.getCaretModel().moveToOffset(offset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSIgnoredPromiseFromCallInspection$AddThenFix";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSIgnoredPromiseFromCallInspection$AddThenFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }
}

