/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSCommentMatchesSignatureInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSDocComment(@NotNull JSDocComment docComment) {
                JSFunction function2;
                if (docComment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((function2 = JSDocumentationUtils.findFunctionAppliedTo(docComment)) != null) {
                    UpdateFunctionCommentQuickFix fix = null;
                    JSDocumentationUtils.JSDocParametersMappingToFunctionInfo info2 = JSDocumentationUtils.checkDocCommentMatchesFunctionSignature(docComment, function2);
                    if (info2 != null && info2.hasParamTag()) {
                        JSParameter[] parameters;
                        List<Pair<Integer, String>> paramsToAdd = info2.getParamsToAdd();
                        Map<Integer, String> paramsToRemove = info2.getParamsToRemove();
                        HashSet<Integer> paramsIndicesToRemove = new HashSet<Integer>(paramsToRemove.size());
                        fix = new UpdateFunctionCommentQuickFix(paramsIndicesToRemove, paramsToAdd);
                        JSDocTag[] tags = paramsToRemove.isEmpty() ? JSDocTag.EMPTY_ARRAY : docComment.getTags();
                        for (Map.Entry<Integer, String> entry : paramsToRemove.entrySet()) {
                            JSElement elementToHighlight;
                            int a = entry.getKey();
                            String b = entry.getValue();
                            paramsIndicesToRemove.add(a);
                            JSDocTag tag = tags[a];
                            JSDocTagType type2 = tag.getType();
                            JSElement jSElement = elementToHighlight = type2 != null ? type2 : tag;
                            if (b != null) continue;
                            String message = JavaScriptBundle.message("js.comment.matches.signature.inspection.problem2", "without name");
                            holder.registerProblem((PsiElement)elementToHighlight, message, new LocalQuickFix[]{fix});
                        }
                        JSParameter[] jSParameterArray = parameters = paramsToAdd.isEmpty() ? null : function2.getParameterVariables();
                        if (parameters != null) {
                            HashMap<String, Integer> parameterIndexes = new HashMap<String, Integer>(parameters.length);
                            for (int i = 0; i < parameters.length; ++i) {
                                parameterIndexes.put(parameters[i].getName(), i);
                            }
                            for (Pair<Integer, String> entry : paramsToAdd) {
                                holder.registerProblem((PsiElement)parameters[(Integer)parameterIndexes.get(entry.getSecond())], JavaScriptBundle.message("js.comment.matches.signature.inspection.problem1", entry.getSecond()), new LocalQuickFix[]{fix});
                            }
                        }
                    }
                    for (JSDocTag tag : docComment.getTags()) {
                        JSDocTagNamepath namepath = tag.getNamepath();
                        if (namepath == null) continue;
                        for (PsiReference ref : namepath.getReferences()) {
                            if (!(ref instanceof JSDocParamReference) || !XmlHighlightVisitor.hasBadResolve((PsiReference)ref, (boolean)false)) continue;
                            holder.registerProblem(ref.getElement(), ref.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)ref), LocalQuickFix.notNullElements((LocalQuickFix)fix));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$1", "visitJSDocComment"));
            }
        };
    }

    private static class UpdateFunctionCommentQuickFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final Set<Integer> myParamsToRemove;
        @FileModifier.SafeFieldForPreview
        private final List<Pair<Integer, String>> myParamsToAdd;

        UpdateFunctionCommentQuickFix(Set<Integer> paramsToRemove, List<Pair<Integer, String>> paramsToAdd) {
            this.myParamsToRemove = paramsToRemove;
            this.myParamsToAdd = paramsToAdd;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.comment.matches.signature.inspection.quickfix", new Object[0]);
            if (string == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            JSFunction function2;
            PsiElement element;
            if (project == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof JSParameter) {
                function2 = ((JSParameter)element).getDeclaringFunction();
            } else {
                JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, JSDocComment.class);
                JSFunction jSFunction = function2 = docComment != null ? JSDocumentationUtils.findFunctionAppliedTo(docComment) : null;
            }
            if (function2 == null) {
                return;
            }
            ArrayList<Pair<Integer, String>> tagsToAdd = new ArrayList<Pair<Integer, String>>(this.myParamsToAdd.size());
            for (Pair<Integer, String> pair : this.myParamsToAdd) {
                tagsToAdd.add((Pair<Integer, String>)Pair.create((Object)((Integer)pair.first), (Object)("param " + (String)pair.second)));
            }
            JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes(function2, tagsToAdd, null, this.myParamsToRemove);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

