/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.injections;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.injections.JSInjectionUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.annotations.NotNull;

public final class JSInjectionController {
    private static final Key<ParameterizedCachedValue<HtmlInjectionKind, PsiElement>> WILL_INJECT_HTML_CACHE_KEY = Key.create((String)"willInjectHtml");

    private JSInjectionController() {
    }

    public static boolean willInjectCss(@NotNull PsiElement languageInjectionHost) {
        JSLiteralExpression jsLiteralExpression;
        if (languageInjectionHost == null) {
            JSInjectionController.$$$reportNull$$$0(0);
        }
        JSLiteralExpression jSLiteralExpression = jsLiteralExpression = languageInjectionHost instanceof JSLiteralExpression ? (JSLiteralExpression)languageInjectionHost : null;
        if (jsLiteralExpression == null) {
            return false;
        }
        if (JavaScriptReferenceContributor.isAcceptableCssLiteralPlace((PsiElement)jsLiteralExpression, false)) {
            return JSInjectionController.checkValidAndNontrivialCss(JSInjectionUtil.getQuotedLiteralText(jsLiteralExpression));
        }
        return false;
    }

    private static boolean checkValidAndNontrivialCss(String text2) {
        if (StringUtil.containsChar((String)text2, (char)'?')) {
            return false;
        }
        if (StringUtil.containsChar((String)text2, (char)'%')) {
            return false;
        }
        if (text2.contains("##")) {
            return false;
        }
        if (text2.length() == 1 && (text2.charAt(0) == '#' || text2.charAt(0) == '.')) {
            return false;
        }
        if (StringUtil.containsChar((String)text2, (char)'#')) {
            int diesIndex = text2.indexOf(35);
            while (diesIndex == 0 || diesIndex > 0 && (text2.charAt(diesIndex - 1) == '\'' || text2.charAt(diesIndex - 1) != '=')) {
                diesIndex = text2.indexOf(35, diesIndex + 1);
            }
            if (diesIndex >= 0) {
                return false;
            }
        }
        if (text2.contains("[]")) {
            return false;
        }
        int eqPos = text2.indexOf(61);
        if (eqPos != -1) {
            int valuePos;
            for (valuePos = eqPos + 1; valuePos < text2.length() && Character.isWhitespace(text2.charAt(valuePos)); ++valuePos) {
            }
            if (valuePos < text2.length() && Character.isDigit(text2.charAt(valuePos))) {
                return false;
            }
        }
        return !JavaScriptReferenceContributor.isSimpleCss(text2);
    }

    public static HtmlInjectionKind willInjectHtml(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(1);
        }
        return (HtmlInjectionKind)((Object)CachedValuesManager.getManager((Project)topElement.getProject()).getParameterizedCachedValue((UserDataHolder)topElement, WILL_INJECT_HTML_CACHE_KEY, param -> new CachedValueProvider.Result((Object)JSInjectionController.willInjectInJSInternal(param), new Object[]{param}), false, (Object)topElement));
    }

    private static HtmlInjectionKind willInjectInJSInternal(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(2);
        }
        if (DialectDetector.isActionScript(topElement)) {
            return HtmlInjectionKind.NONE;
        }
        if (!topElement.textContains('<')) {
            return HtmlInjectionKind.NONE;
        }
        String text2 = JSInjectionUtil.getConcatenationText(JSInjectionUtil.getConcatenationParts(topElement));
        int length = text2.length();
        int tagStart = text2.indexOf(60);
        if (tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text2.charAt(tagStart + 1)) || tagStart < length - 2 && text2.charAt(tagStart + 1) == '/' && Character.isLetter(text2.charAt(tagStart + 2)) || tagStart < length - 3 && text2.charAt(tagStart + 1) == '!' && text2.charAt(tagStart + 2) == '-' && text2.charAt(tagStart + 3) == '-' || tagStart < length - 2 && text2.charAt(tagStart + 1) == '!' && (text2.charAt(tagStart + 2) == 'd' || text2.charAt(tagStart + 2) == 'D')) && text2.indexOf(62, tagStart) > 0) {
            return JSInjectionController.isPossiblyReactJSX(text2) ? HtmlInjectionKind.REACT_JSX : HtmlInjectionKind.HTML;
        }
        return HtmlInjectionKind.NONE;
    }

    private static boolean isPossiblyReactJSX(@NotNull String text2) {
        if (text2 == null) {
            JSInjectionController.$$$reportNull$$$0(3);
        }
        int doubleQuoteCount = 0;
        int singleQuoteCount = 0;
        boolean hasEq = false;
        for (int i = 0; i < text2.length(); ++i) {
            char c2 = text2.charAt(i);
            if (c2 == '\"') {
                ++doubleQuoteCount;
                hasEq = false;
                continue;
            }
            if (c2 == '\'') {
                ++singleQuoteCount;
                hasEq = false;
                continue;
            }
            if (Character.isWhitespace(c2)) continue;
            if (c2 == '=') {
                hasEq = true;
                continue;
            }
            if (doubleQuoteCount % 2 == 0 && singleQuoteCount % 2 == 0 && hasEq && c2 == '{') {
                return true;
            }
            hasEq = false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageInjectionHost";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/injections/JSInjectionController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "willInjectCss";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "willInjectHtml";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "willInjectInJSInternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPossiblyReactJSX";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum HtmlInjectionKind {
        HTML,
        REACT_JSX,
        NONE;

    }
}

