/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.InheritorsCodeVisionProvider;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSBasicGutterIconNavigationHandler;
import com.intellij.lang.javascript.highlighting.JavaScriptLineMarkerProvider;
import com.intellij.lang.javascript.hints.JSCodeVisionLocationKind;
import com.intellij.lang.javascript.hints.JSCodeVisionLocations;
import com.intellij.lang.javascript.hints.JSCodeVisionUsageCollector;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Query;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0017\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/hints/JSInheritorsCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/InheritorsCodeVisionProvider;", "()V", "id", "", "getId", "()Ljava/lang/String;", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "acceptsElement", "", "element", "Lcom/intellij/psi/PsiElement;", "acceptsFile", "file", "Lcom/intellij/psi/PsiFile;", "calculateHint", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "Lorg/jetbrains/annotations/Nls;", "getHint", "getHintForSettingsPreview", "getVisionInfo", "handleClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Ljava/awt/event/MouseEvent;", "logClickToFUS", "hint", "intellij.javascript.impl"})
public final class JSInheritorsCodeVisionProvider
extends InheritorsCodeVisionProvider {
    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JSCodeVisionLocations.INSTANCE.acceptsFile(file);
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return JSCodeVisionLocations.INSTANCE.isImportantLocation(element);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo preview = this.getHintForSettingsPreview(element, file);
        if (preview != null) {
            return preview;
        }
        return this.calculateHint(element);
    }

    private final CodeVisionProviderBase.CodeVisionInfo calculateHint(PsiElement element) {
        if (element instanceof JSClass) {
            Query<JSClass> inheritorsClassQuery = JSClassSearch.searchClassInheritors((JSClass)element, true);
            Intrinsics.checkNotNull(inheritorsClassQuery);
            int count = CollectionsKt.count((Iterable)((Iterable)inheritorsClassQuery));
            if (count > 0) {
                Object[] objectArray = new Object[]{count};
                String string = JavaScriptBundle.message("code.vision.inheritors.hint", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return new CodeVisionProviderBase.CodeVisionInfo(string, Integer.valueOf(count), false, 4, null);
            }
        } else if (element instanceof JSPsiElementBase) {
            JSClass jSClass = JSUtils.getMemberContainingClass(element);
            if (jSClass == null) {
                return null;
            }
            JSClass clazz = jSClass;
            Query<JSPsiElementBase> query2 = clazz.isInterface() ? JSMembersSearch.searchImplementingMembers((JSPsiElementBase)element, true) : JSMembersSearch.searchOverridingMembers((JSPsiElementBase)element, true);
            Intrinsics.checkNotNull(query2);
            int count = CollectionsKt.count((Iterable)((Iterable)query2));
            if (count > 0) {
                String string;
                if (clazz.isInterface()) {
                    var6_9 = new Object[]{count};
                    string = JavaScriptBundle.message("code.vision.implementations.hint", var6_9);
                } else {
                    var6_9 = new Object[]{count};
                    string = JavaScriptBundle.message("code.vision.overrides.hint", var6_9);
                }
                String string2 = string;
                Intrinsics.checkNotNull((Object)string2);
                return new CodeVisionProviderBase.CodeVisionInfo(string2, Integer.valueOf(count), false, 4, null);
            }
        }
        return null;
    }

    @Nls
    private final CodeVisionProviderBase.CodeVisionInfo getHintForSettingsPreview(PsiElement element, PsiFile file) {
        if (element instanceof JSClass && file.getVirtualFile() == null && Intrinsics.areEqual((Object)((JSClass)element).getName(), (Object)"MyButton")) {
            String string = file.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"class MyButton { }\nclass AnimatedButton extends MyButton { }")) {
                Object[] objectArray = new Object[]{1};
                String string2 = JavaScriptBundle.message("code.vision.inheritors.hint", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return new CodeVisionProviderBase.CodeVisionInfo(string2, Integer.valueOf(1), false, 4, null);
            }
        }
        return null;
    }

    public void handleClick(@NotNull Editor editor, @NotNull PsiElement element, @Nullable MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof JSClass) {
            JSBasicGutterIconNavigationHandler<JSClass> jSBasicGutterIconNavigationHandler;
            if (((JSClass)element).isInterface()) {
                JSBasicGutterIconNavigationHandler<JSClass> jSBasicGutterIconNavigationHandler2 = JavaScriptLineMarkerProvider.ourClassInheritorsNavHandler;
                jSBasicGutterIconNavigationHandler = jSBasicGutterIconNavigationHandler2;
                Intrinsics.checkNotNullExpressionValue(jSBasicGutterIconNavigationHandler2, (String)"ourClassInheritorsNavHandler");
            } else {
                JSBasicGutterIconNavigationHandler<JSClass> jSBasicGutterIconNavigationHandler3 = JavaScriptLineMarkerProvider.ourInterfaceImplementationsNavHandler;
                jSBasicGutterIconNavigationHandler = jSBasicGutterIconNavigationHandler3;
                Intrinsics.checkNotNullExpressionValue(jSBasicGutterIconNavigationHandler3, (String)"ourInterfaceImplementationsNavHandler");
            }
            JSBasicGutterIconNavigationHandler<JSClass> navigationHandler = jSBasicGutterIconNavigationHandler;
            PsiElement nameIdentifier = ((JSClass)element).getNameIdentifier();
            if (nameIdentifier != null) {
                navigationHandler.navigate(event, nameIdentifier);
            }
        } else if (element instanceof JSPsiElementBase && element instanceof JSNamedElement) {
            JSClass clazz = JSUtils.getMemberContainingClass(element);
            JSBasicGutterIconNavigationHandler<JSPsiElementBase> handler = clazz.isInterface() ? JavaScriptLineMarkerProvider.ourImplementingMembersNavHandler : JavaScriptLineMarkerProvider.ourOverridingMembersNavHandler;
            PsiElement nameIdentifier = ((JSNamedElement)element).getNameIdentifier();
            if (nameIdentifier != null) {
                handler.navigate(event, nameIdentifier);
            }
        }
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        JSCodeVisionLocationKind jSCodeVisionLocationKind = JSCodeVisionLocations.INSTANCE.getLocationKind(element);
        if (jSCodeVisionLocationKind == null) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.OTHER;
        }
        JSCodeVisionLocationKind location = jSCodeVisionLocationKind;
        JSCodeVisionUsageCollector.INSTANCE.getIMPLEMENTATION_CLICKED_EVENT_ID().log(element.getProject(), (Object)location);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return "js.inheritors";
    }
}

