/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.highlighting.JSBasicGutterIconNavigationHandler;
import com.intellij.lang.javascript.highlighting.TypeScriptSourceMappingLineMarkerProviderKt;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.CollectionQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\b\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\b\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptSourceMappingLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "declarationMarker", "element", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "getIcon", "Ljavax/swing/Icon;", "getLineMarkerInfo", "getName", "", "isClassMethodFromExportedScope", "", "psiElement", "isFromExportedScope", "sourceMarker", "DeclarationHandler", "Info", "SourceHandler", "intellij.javascript.impl"})
public final class TypeScriptSourceMappingLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message("linemarker.javascript.sources", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ImplementedMethod");
        return icon;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement)) continue;
            if (TypeScriptUtil.isDefinitionFile(((JSQualifiedNamedElement)psiElement).getContainingFile())) {
                this.sourceMarker((JSQualifiedNamedElement)psiElement, result2);
                continue;
            }
            if (!DialectDetector.isJavaScript(psiElement)) continue;
            this.declarationMarker((JSQualifiedNamedElement)psiElement, result2);
        }
    }

    private final void sourceMarker(JSQualifiedNamedElement element, Collection<? super LineMarkerInfo<?>> result2) {
        String name = element.getName();
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        if (!this.isFromExportedScope((PsiElement)element) && !this.isClassMethodFromExportedScope((PsiElement)element)) {
            return;
        }
        List jsSources = TypeScriptSourceMappingLineMarkerProviderKt.access$getJSElements(element);
        if (jsSources.isEmpty()) {
            return;
        }
        PsiElement psiElement = JSBasicGutterIconNavigationHandler.getPlaceForLineMarker((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPlaceForLineMarker(...)");
        PsiElement place = psiElement;
        Icon icon = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ImplementedMethod");
        String string = JavaScriptBundle.message("linemarker.javascript.sources", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        result2.add((LineMarkerInfo<?>)new Info(place, icon, string, (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)new SourceHandler())));
    }

    private final void declarationMarker(JSQualifiedNamedElement element, Collection<? super LineMarkerInfo<?>> result2) {
        String name = element.getName();
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        if (!this.isFromExportedScope((PsiElement)element) && !this.isClassMethodFromExportedScope((PsiElement)element)) {
            return;
        }
        List declarations = TypeScriptSourceMappingLineMarkerProviderKt.access$getDeclarationElements(element);
        if (declarations.isEmpty()) {
            return;
        }
        PsiElement psiElement = JSBasicGutterIconNavigationHandler.getPlaceForLineMarker((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPlaceForLineMarker(...)");
        PsiElement place = psiElement;
        Icon icon = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ImplementingMethod");
        String string = JavaScriptBundle.message("linemarker.typescript.declaration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        result2.add((LineMarkerInfo<?>)new Info(place, icon, string, (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)new DeclarationHandler())));
    }

    private final boolean isFromExportedScope(PsiElement psiElement) {
        PsiElement parent = JSResolveUtil.findParent(psiElement);
        if (parent instanceof JSExportAssignment) {
            parent = ((JSExportAssignment)parent).getParent();
        }
        return ES6PsiUtil.isExportScope(parent);
    }

    private final boolean isClassMethodFromExportedScope(PsiElement psiElement) {
        PsiElement parent = JSResolveUtil.findParent(psiElement);
        return parent instanceof JSClass && !(parent instanceof TypeScriptCompileTimeType) && this.isFromExportedScope(parent);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptSourceMappingLineMarkerProvider$DeclarationHandler;", "Lcom/intellij/lang/javascript/highlighting/JSBasicGutterIconNavigationHandler;", "Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;", "()V", "getTitle", "", "elt", "size", "", "search", "Lcom/intellij/util/Query;", "intellij.javascript.impl"})
    public static final class DeclarationHandler
    extends JSBasicGutterIconNavigationHandler<JSPsiNamedElementBase> {
        @Override
        @NotNull
        protected String getTitle(@NotNull JSPsiNamedElementBase elt, int size) {
            Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
            String string = new JSNamedElementPresenter((PsiElement)elt).describeWithShortName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"describeWithShortName(...)");
            return string;
        }

        @Override
        @Nullable
        public Query<JSPsiNamedElementBase> search(@NotNull JSPsiNamedElementBase elt) {
            List jsSourceElements;
            Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
            if (elt instanceof JSQualifiedNamedElement && !((Collection)(jsSourceElements = TypeScriptSourceMappingLineMarkerProviderKt.access$getDeclarationElements((JSQualifiedNamedElement)elt))).isEmpty()) {
                return (Query)new CollectionQuery((Collection)jsSourceElements);
            }
            return EmptyQuery.getEmptyQuery();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0016J\u001a\u0010\u000e\u001a\u00020\u00052\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptSourceMappingLineMarkerProvider$Info;", "Lcom/intellij/codeInsight/daemon/MergeableLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "psiElement", "icon", "Ljavax/swing/Icon;", "text", "", "navHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "(Lcom/intellij/psi/PsiElement;Ljavax/swing/Icon;Ljava/lang/String;Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;)V", "canMergeWith", "", "info", "getCommonIcon", "infos", "", "intellij.javascript.impl"})
    public static final class Info
    extends MergeableLineMarkerInfo<PsiElement> {
        public Info(@NotNull PsiElement psiElement, @NotNull Icon icon, final @NotNull String text2, @NotNull GutterIconNavigationHandler<PsiElement> navHandler) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(navHandler, (String)"navHandler");
            super(psiElement, psiElement.getTextRange(), icon, arg_0 -> Info._init_$lambda$0((Function1)new Function1<PsiElement, String>(){

                public final String invoke(PsiElement it) {
                    return text2;
                }
            }, arg_0), navHandler, GutterIconRenderer.Alignment.RIGHT, () -> Info._init_$lambda$1(text2));
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info2) {
            Intrinsics.checkNotNullParameter(info2, (String)"info");
            return info2 instanceof Info;
        }

        @NotNull
        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            Icon icon = infos.get(0).getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }

        private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final String _init_$lambda$1(String $text) {
            Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
            return $text;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptSourceMappingLineMarkerProvider$SourceHandler;", "Lcom/intellij/lang/javascript/highlighting/JSBasicGutterIconNavigationHandler;", "Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;", "()V", "getTitle", "", "elt", "size", "", "search", "Lcom/intellij/util/Query;", "intellij.javascript.impl"})
    public static final class SourceHandler
    extends JSBasicGutterIconNavigationHandler<JSPsiNamedElementBase> {
        @Override
        @NotNull
        protected String getTitle(@NotNull JSPsiNamedElementBase elt, int size) {
            Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
            String string = new JSNamedElementPresenter((PsiElement)elt).describeWithShortName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"describeWithShortName(...)");
            return string;
        }

        @Override
        @Nullable
        public Query<JSPsiNamedElementBase> search(@NotNull JSPsiNamedElementBase elt) {
            List jsSourceElements;
            Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
            if (elt instanceof JSQualifiedNamedElement && !((Collection)(jsSourceElements = TypeScriptSourceMappingLineMarkerProviderKt.access$getJSElements((JSQualifiedNamedElement)elt))).isEmpty()) {
                return (Query)new CollectionQuery((Collection)jsSourceElements);
            }
            return EmptyQuery.getEmptyQuery();
        }
    }
}

