/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlightDescriptor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TypeScriptHighlighter
extends JSHighlighter {
    public static final TextAttributesKey TS_KEYWORD;
    public static final TextAttributesKey TS_STRING;
    public static final TextAttributesKey TS_NUMBER;
    public static final TextAttributesKey TS_REGEXP;
    public static final TextAttributesKey TS_LINE_COMMENT;
    public static final TextAttributesKey TS_BLOCK_COMMENT;
    public static final TextAttributesKey TS_DOC_COMMENT;
    public static final TextAttributesKey TS_OPERATION_SIGN;
    public static final TextAttributesKey TS_PARENTHS;
    public static final TextAttributesKey TS_BRACKETS;
    public static final TextAttributesKey TS_BRACES;
    public static final TextAttributesKey TS_COMMA;
    public static final TextAttributesKey TS_DOT;
    public static final TextAttributesKey TS_SEMICOLON;
    public static final TextAttributesKey TS_BAD_CHARACTER;
    public static final TextAttributesKey TS_DOC_TAG;
    public static final TextAttributesKey TS_DOC_TAG_NAMEPATH;
    public static final TextAttributesKey TS_DOC_TYPE;
    public static final TextAttributesKey TS_VALID_STRING_ESCAPE;
    public static final TextAttributesKey TS_INVALID_STRING_ESCAPE;
    public static final TextAttributesKey TS_LOCAL_VARIABLE;
    public static final TextAttributesKey TS_PARAMETER;
    public static final TextAttributesKey TS_TYPE_PARAMETER;
    public static final TextAttributesKey TS_INSTANCE_MEMBER_VARIABLE;
    public static final TextAttributesKey TS_STATIC_MEMBER_VARIABLE;
    public static final TextAttributesKey TS_ENUM_MEMBER;
    public static final TextAttributesKey TS_GLOBAL_VARIABLE;
    public static final TextAttributesKey TS_GLOBAL_FUNCTION;
    public static final TextAttributesKey TS_LOCAL_FUNCTION;
    public static final TextAttributesKey TS_DECORATOR;
    public static final TextAttributesKey TS_STATIC_MEMBER_FUNCTION;
    public static final TextAttributesKey TS_INSTANCE_MEMBER_FUNCTION;
    public static final TextAttributesKey TS_CLASS;
    public static final TextAttributesKey TS_INTERFACE;
    public static final TextAttributesKey TS_ENUM;
    public static final TextAttributesKey TS_TYPE_ALIAS;
    public static final TextAttributesKey TS_PRIMITIVE_TYPES;
    public static final TextAttributesKey TS_MODULE_NAME;
    public static final TextAttributesKey FUNCTION_ARROW;
    public static final TextAttributesKey TS_EXPORTED_VARIABLE;
    public static final TextAttributesKey TS_EXPORTED_FUNCTION;
    public static final TextAttributesKey TS_EXPORTED_CLASS;
    public static final TextAttributesKey TS_LABEL;
    public static final TextAttributesKey TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS;
    public static final TextAttributesKey TS_INJECTED_LANGUAGE_FRAGMENT;
    public static final TextAttributesKey TS_TYPE_GUARD;
    private static final Map<IElementType, TextAttributesKey> tsKeys;
    private static final Map<TextAttributesKey, TextAttributesKey> ourJsToTSKeyMap;

    public TypeScriptHighlighter(boolean skipKeywordHighlights) {
        this(TypeScriptLanguageDialect.DIALECT_OPTION_HOLDER, skipKeywordHighlights);
    }

    public TypeScriptHighlighter(@NotNull DialectOptionHolder holder, boolean skipKeywordHighlights) {
        if (holder == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(0);
        }
        super(holder, skipKeywordHighlights);
    }

    @Override
    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (tokenType == JSDocTokenTypes.DOC_TAG_NAME) {
            TextAttributesKey[] textAttributesKeyArray = TypeScriptHighlighter.pack((TextAttributesKey)TS_DOC_COMMENT, (TextAttributesKey)TS_DOC_TAG);
            if (textAttributesKeyArray == null) {
                TypeScriptHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey key2 = tsKeys.get(tokenType);
        TextAttributesKey[] textAttributesKeyArray = key2 == null ? super.getTokenHighlights(tokenType) : TypeScriptHighlighter.pack((TextAttributesKey)key2);
        if (textAttributesKeyArray == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(2);
        }
        return textAttributesKeyArray;
    }

    @Override
    @NotNull
    public TokenSet getKeywords() {
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{super.getKeywords(), JSKeywordSets.TYPESCRIPT_RESERVED_WORDS});
        if (tokenSet == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TextAttributesKey getMappedKey(@NotNull TextAttributesKey original) {
        if (original == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(4);
        }
        TextAttributesKey textAttributesKey = ourJsToTSKeyMap.getOrDefault(original, original);
        if (textAttributesKey == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(5);
        }
        return textAttributesKey;
    }

    static {
        IElementType[] javadoc;
        TS_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"TS.KEYWORD", (TextAttributesKey)JSHighlighter.JS_KEYWORD);
        TS_STRING = TextAttributesKey.createTextAttributesKey((String)"TS.STRING", (TextAttributesKey)JSHighlighter.JS_STRING);
        TS_NUMBER = TextAttributesKey.createTextAttributesKey((String)"TS.NUMBER", (TextAttributesKey)JSHighlighter.JS_NUMBER);
        TS_REGEXP = TextAttributesKey.createTextAttributesKey((String)"TS.REGEXP", (TextAttributesKey)JSHighlighter.JS_REGEXP);
        TS_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"TS.LINE_COMMENT", (TextAttributesKey)JSHighlighter.JS_LINE_COMMENT);
        TS_BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"TS.BLOCK_COMMENT", (TextAttributesKey)JSHighlighter.JS_BLOCK_COMMENT);
        TS_DOC_COMMENT = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_COMMENT", (TextAttributesKey)JSHighlighter.JS_DOC_COMMENT);
        TS_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"TS.OPERATION_SIGN", (TextAttributesKey)JSHighlighter.JS_OPERATION_SIGN);
        TS_PARENTHS = TextAttributesKey.createTextAttributesKey((String)"TS.PARENTHS", (TextAttributesKey)JSHighlighter.JS_PARENTHS);
        TS_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"TS.BRACKETS", (TextAttributesKey)JSHighlighter.JS_BRACKETS);
        TS_BRACES = TextAttributesKey.createTextAttributesKey((String)"TS.BRACES", (TextAttributesKey)JSHighlighter.JS_BRACES);
        TS_COMMA = TextAttributesKey.createTextAttributesKey((String)"TS.COMMA", (TextAttributesKey)JSHighlighter.JS_COMMA);
        TS_DOT = TextAttributesKey.createTextAttributesKey((String)"TS.DOT", (TextAttributesKey)JSHighlighter.JS_DOT);
        TS_SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"TS.SEMICOLON", (TextAttributesKey)JSHighlighter.JS_SEMICOLON);
        TS_BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"TS.BADCHARACTER", (TextAttributesKey)JSHighlighter.JS_BAD_CHARACTER);
        TS_DOC_TAG = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_TAG", (TextAttributesKey)JSHighlighter.JS_DOC_TAG);
        TS_DOC_TAG_NAMEPATH = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_TAG_NAMEPATH", (TextAttributesKey)JSHighlighter.JS_DOC_TAG_NAMEPATH);
        TS_DOC_TYPE = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_TYPE", (TextAttributesKey)TS_DOC_TAG_NAMEPATH);
        TS_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"TS.VALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_VALID_STRING_ESCAPE);
        TS_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"TS.INVALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_INVALID_STRING_ESCAPE);
        TS_LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.LOCAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_LOCAL_VARIABLE);
        TS_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"TS.PARAMETER", (TextAttributesKey)JSHighlighter.JS_PARAMETER);
        TS_TYPE_PARAMETER = TypeScriptHighlightDescriptor.TYPE_PARAMETER.getOrCreateTextAttributesKey();
        TS_INSTANCE_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.INSTANCE_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
        TS_STATIC_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.STATIC_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_VARIABLE);
        TS_ENUM_MEMBER = TypeScriptHighlightDescriptor.ENUM_MEMBER.getOrCreateTextAttributesKey();
        TS_GLOBAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.GLOBAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_GLOBAL_VARIABLE);
        TS_GLOBAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.GLOBAL_FUNCTION", (TextAttributesKey)JSHighlighter.JS_GLOBAL_FUNCTION);
        TS_LOCAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.LOCAL_FUNCTION", (TextAttributesKey)JSHighlighter.JS_LOCAL_FUNCTION);
        TS_DECORATOR = TextAttributesKey.createTextAttributesKey((String)"TS.DECORATOR", (TextAttributesKey)JSHighlighter.ES6_DECORATOR);
        TS_STATIC_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.STATIC_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_FUNCTION);
        TS_INSTANCE_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.INSTANCE_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION);
        TS_CLASS = TextAttributesKey.createTextAttributesKey((String)"TS.CLASS", (TextAttributesKey)JSHighlighter.JS_CLASS);
        TS_INTERFACE = TextAttributesKey.createTextAttributesKey((String)"TS.INTERFACE", (TextAttributesKey)DefaultLanguageHighlighterColors.INTERFACE_NAME);
        TS_ENUM = TypeScriptHighlightDescriptor.ENUM.getOrCreateTextAttributesKey();
        TS_TYPE_ALIAS = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE.ALIAS", (TextAttributesKey)TS_INTERFACE);
        TS_PRIMITIVE_TYPES = TextAttributesKey.createTextAttributesKey((String)"TS.PRIMITIVE.TYPES", (TextAttributesKey)TS_KEYWORD);
        TS_MODULE_NAME = TypeScriptHighlightDescriptor.MODULE_NAME.getOrCreateTextAttributesKey();
        FUNCTION_ARROW = TextAttributesKey.createTextAttributesKey((String)"TS.FUNCTION_ARROW", (TextAttributesKey)JSHighlighter.FUNCTION_ARROW);
        TS_EXPORTED_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.EXPORTED_VARIABLE", (TextAttributesKey)TS_GLOBAL_VARIABLE);
        TS_EXPORTED_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.EXPORTED_FUNCTION", (TextAttributesKey)TS_GLOBAL_FUNCTION);
        TS_EXPORTED_CLASS = TextAttributesKey.createTextAttributesKey((String)"TS.EXPORTED_CLASS", (TextAttributesKey)TS_CLASS);
        TS_LABEL = TextAttributesKey.createTextAttributesKey((String)"TS.LABEL", (TextAttributesKey)JS_LABEL);
        TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS = TextAttributesKey.createTextAttributesKey((String)"TS.TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS", (TextAttributesKey)JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS);
        TS_INJECTED_LANGUAGE_FRAGMENT = EditorColors.createInjectedLanguageFragmentKey((Language)JavaScriptSupportLoader.TYPESCRIPT);
        TS_TYPE_GUARD = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE_GUARD");
        ourJsToTSKeyMap = new HashMap<TextAttributesKey, TextAttributesKey>();
        tsKeys = new HashMap<IElementType, TextAttributesKey>();
        SyntaxHighlighterBase.fillMap(tsKeys, (TokenSet)OPERATORS_LIKE, (TextAttributesKey)TS_OPERATION_SIGN);
        TypeScriptHighlighter.fillMap(tsKeys, (TokenSet)JSKeywordSets.TYPESCRIPT_RESERVED_WORDS, (TextAttributesKey)TS_KEYWORD);
        tsKeys.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, TS_VALID_STRING_ESCAPE);
        tsKeys.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, TS_INVALID_STRING_ESCAPE);
        tsKeys.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, TS_INVALID_STRING_ESCAPE);
        tsKeys.put(JSTokenTypes.NUMERIC_LITERAL, TS_NUMBER);
        tsKeys.put(JSTokenTypes.STRING_LITERAL, TS_STRING);
        tsKeys.put(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, TS_STRING);
        tsKeys.put(JSTokenTypes.STRING_TEMPLATE_PART, TS_STRING);
        tsKeys.put(JSTokenTypes.BACKQUOTE, TS_STRING);
        tsKeys.put(JSTokenTypes.REGEXP_LITERAL, TS_REGEXP);
        tsKeys.put(JSTokenTypes.LPAR, TS_PARENTHS);
        tsKeys.put(JSTokenTypes.RPAR, TS_PARENTHS);
        tsKeys.put(JSTokenTypes.LBRACE, TS_BRACES);
        tsKeys.put(JSTokenTypes.RBRACE, TS_BRACES);
        tsKeys.put(JSTokenTypes.XML_LBRACE, TS_BRACES);
        tsKeys.put(JSTokenTypes.XML_RBRACE, TS_BRACES);
        tsKeys.put(JSTokenTypes.LBRACKET, TS_BRACKETS);
        tsKeys.put(JSTokenTypes.RBRACKET, TS_BRACKETS);
        tsKeys.put(JSTokenTypes.COMMA, TS_COMMA);
        tsKeys.put(JSTokenTypes.DOT, TS_DOT);
        tsKeys.put(JSTokenTypes.SEMICOLON, TS_SEMICOLON);
        tsKeys.put(JSTokenTypes.C_STYLE_COMMENT, TS_BLOCK_COMMENT);
        tsKeys.put(JSTokenTypes.XML_STYLE_COMMENT, TS_BLOCK_COMMENT);
        tsKeys.put(JSTokenTypes.DOC_COMMENT, TS_DOC_COMMENT);
        tsKeys.put(JSTokenTypes.END_OF_LINE_COMMENT, TS_LINE_COMMENT);
        tsKeys.put(JSTokenTypes.BAD_CHARACTER, TS_BAD_CHARACTER);
        tsKeys.put(JSTokenTypes.EQGT, FUNCTION_ARROW);
        for (IElementType type3 : javadoc = IElementType.enumerate(type2 -> type2 instanceof JSDocElementType)) {
            tsKeys.put(type3, TS_DOC_COMMENT);
        }
        tsKeys.put(JSDocTokenTypes.DOC_DESCRIPTION, TS_DOC_COMMENT);
        tsKeys.put(JSDocTokenTypes.DOC_TAG_TYPE, TS_DOC_COMMENT);
        tsKeys.put(JSDocTokenTypes.DOC_TAG_NAMEPATH, TS_DOC_COMMENT);
        ourJsToTSKeyMap.put(JS_PARAMETER, TS_PARAMETER);
        ourJsToTSKeyMap.put(JS_INSTANCE_MEMBER_VARIABLE, TS_INSTANCE_MEMBER_VARIABLE);
        ourJsToTSKeyMap.put(JS_LOCAL_VARIABLE, TS_LOCAL_VARIABLE);
        ourJsToTSKeyMap.put(JS_GLOBAL_VARIABLE, TS_GLOBAL_VARIABLE);
        ourJsToTSKeyMap.put(JS_GLOBAL_FUNCTION, TS_GLOBAL_FUNCTION);
        ourJsToTSKeyMap.put(JS_LOCAL_FUNCTION, TS_LOCAL_FUNCTION);
        ourJsToTSKeyMap.put(ES6_DECORATOR, TS_DECORATOR);
        ourJsToTSKeyMap.put(JS_INSTANCE_MEMBER_FUNCTION, TS_INSTANCE_MEMBER_FUNCTION);
        ourJsToTSKeyMap.put(JS_STATIC_MEMBER_FUNCTION, TS_STATIC_MEMBER_FUNCTION);
        ourJsToTSKeyMap.put(JS_STATIC_MEMBER_VARIABLE, TS_STATIC_MEMBER_VARIABLE);
        ourJsToTSKeyMap.put(JS_CLASS, TS_CLASS);
        ourJsToTSKeyMap.put(JS_INTERFACE, TS_INTERFACE);
        ourJsToTSKeyMap.put(JS_TYPE_ALIAS, TS_TYPE_ALIAS);
        ourJsToTSKeyMap.put(JS_DOC_COMMENT, TS_DOC_COMMENT);
        ourJsToTSKeyMap.put(JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS, TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS);
        ourJsToTSKeyMap.put(JS_EXPORTED_VARIABLE, TS_EXPORTED_VARIABLE);
        ourJsToTSKeyMap.put(JS_EXPORTED_FUNCTION, TS_EXPORTED_FUNCTION);
        ourJsToTSKeyMap.put(JS_EXPORTED_CLASS, TS_EXPORTED_CLASS);
        ourJsToTSKeyMap.put(JS_LABEL, TS_LABEL);
        ourJsToTSKeyMap.put(JS_KEYWORD, TS_KEYWORD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/TypeScriptHighlighter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/TypeScriptHighlighter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMappedKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    public static final class XmlTokenHighlighter
    implements EmbeddedTokenHighlighter {
        @NotNull
        public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
            MultiMap map = MultiMap.create();
            map.putAllValues(tsKeys);
            MultiMap multiMap = map;
            if (multiMap == null) {
                XmlTokenHighlighter.$$$reportNull$$$0(0);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/TypeScriptHighlighter$XmlTokenHighlighter", "getEmbeddedTokenAttributes"));
        }
    }
}

