/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.completion.HtmlCompletionContributor;
import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.highlighting.JSSpellcheckerProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.spellchecker.inspections.CommentSplitter;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class JSSpellcheckingStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JSLiteralExpression> myLiteralTokenizer = new JSLiteralTokenizer();
    private final Tokenizer<JSProperty> myPropertyTokenizer = new MyPropertyTokenizer();
    private final Tokenizer<JSNamedElement> myAttributeValueTokenizer = new MyAttributeValueTokenizer();
    private final Tokenizer<PsiElement> myDescriptionTokenizer = new MyDescriptionTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement identifier;
        for (JSSpellcheckerProvider provider : (JSSpellcheckerProvider[])JSSpellcheckerProvider.EP.getExtensions()) {
            Tokenizer tokenizer = provider.getTokenizer(element);
            if (tokenizer == null) continue;
            Tokenizer tokenizer2 = tokenizer;
            if (tokenizer2 == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer2;
        }
        if (element instanceof TypeScriptFunctionType) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element instanceof TypeScriptModule && (identifier = ((TypeScriptModule)element).getNameIdentifier()) instanceof JSLiteralExpression) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        PsiElement parent = element.getParent();
        if (element instanceof JSFunctionExpression && parent instanceof PsiNameIdentifierOwner) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        if (element instanceof JSLiteralExpression) {
            if (element instanceof JSXmlLiteralExpression) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(4);
                }
                return tokenizer;
            }
            if (parent instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression && ((JSCallExpression)parent.getParent()).isRequireCall()) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(5);
                }
                return tokenizer;
            }
            Tokenizer<JSLiteralExpression> tokenizer = this.myLiteralTokenizer;
            if (tokenizer == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(6);
            }
            return tokenizer;
        }
        if (element instanceof JSAttribute) {
            PsiReference psiReference = element.getReference();
            if (psiReference != null && psiReference.resolve() != null) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(7);
                }
                return tokenizer;
            }
        } else if (element instanceof JSProperty || element instanceof TypeScriptPropertySignature) {
            PsiElement node = ((JSNamedElement)element).getNameIdentifier();
            if (node != null && (node.textContains('\'') || node.textContains('\"'))) {
                String text2 = node.getText();
                if (!StringUtil.isJavaIdentifier((String)text2)) {
                    Tokenizer<JSNamedElement> tokenizer = this.myAttributeValueTokenizer;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(8);
                    }
                    return tokenizer;
                }
                Tokenizer<JSProperty> tokenizer = this.myPropertyTokenizer;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(9);
                }
                return tokenizer;
            }
        } else {
            if (element instanceof JSDefinitionExpression) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(10);
                }
                return tokenizer;
            }
            if (element instanceof JSQualifiedNamedElement) {
                JSQualifiedNamedElement qualifiedNamedElement = (JSQualifiedNamedElement)element;
                PsiElement node = qualifiedNamedElement.getNameIdentifier();
                if (node != null && node.textContains('.')) {
                    Tokenizer<JSNamedElement> tokenizer = this.myAttributeValueTokenizer;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(11);
                    }
                    return tokenizer;
                }
            } else if (element instanceof XmlAttributeValue) {
                if (HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)((XmlAttribute)parent)).length > 0) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(12);
                    }
                    return tokenizer;
                }
            } else {
                if (element instanceof XmlText) {
                    Tokenizer tokenizer = TEXT_TOKENIZER;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(13);
                    }
                    return tokenizer;
                }
                if (element.getNode().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA && element.getParent() instanceof JSDocDescription) {
                    Tokenizer<PsiElement> tokenizer = this.myDescriptionTokenizer;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(14);
                    }
                    return tokenizer;
                }
                if (element instanceof JSDocComment) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(15);
                    }
                    return tokenizer;
                }
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            JSSpellcheckingStrategy.$$$reportNull$$$0(16);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
    }

    public static class JSLiteralTokenizer
    extends EscapeSequenceTokenizer<JSLiteralExpression> {
        public void tokenize(@NotNull JSLiteralExpression element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                JSLiteralTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                JSLiteralTokenizer.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiLanguageInjectionHost && InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles((PsiElement)element) != null) {
                return;
            }
            if (this.shouldNotCheckLiteral(element)) {
                return;
            }
            if (element instanceof JSStringTemplateExpression && ((JSStringTemplateExpression)element).getArguments().length > 0) {
                for (TextRange range : ((JSStringTemplateExpression)element).getStringRanges()) {
                    JSLiteralTokenizer.consumeRange(element, range, consumer);
                }
            } else {
                TextRange unquotedRange = JSStringUtil.getStringLiteralOrTemplateUnquotedRange(element.getText());
                JSLiteralTokenizer.consumeRange(element, unquotedRange, consumer);
            }
        }

        private static void consumeRange(JSLiteralExpression element, TextRange range, TokenConsumer consumer) {
            String rangeText = range.substring(element.getText());
            if (rangeText.contains("\\")) {
                StringBuilder unescapedText = new StringBuilder();
                JSStringLiteralEscaper.SourceOffsets offsets = new JSStringLiteralEscaper.SourceOffsets();
                JSStringLiteralEscaper.parseStringCharacters((String)rangeText, (StringBuilder)unescapedText, (JSStringLiteralEscaper.SourceOffsets)offsets, (boolean)element.isRegExpLiteral(), (boolean)(element instanceof JSStringTemplateExpression));
                JSLiteralTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets.toOffsetArray(), (int)range.getStartOffset());
            } else {
                consumer.consumeToken((PsiElement)element, element.getText(), false, 0, range, (Splitter)PlainTextSplitter.getInstance());
            }
        }

        protected boolean shouldNotCheckLiteral(@NotNull JSLiteralExpression element) {
            if (element == null) {
                JSLiteralTokenizer.$$$reportNull$$$0(2);
            }
            return !element.isQuotedLiteral() || element.getTextLength() < 3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$JSLiteralTokenizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tokenize";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldNotCheckLiteral";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPropertyTokenizer
    extends Tokenizer<JSProperty> {
        private MyPropertyTokenizer() {
        }

        public void tokenize(@NotNull JSProperty element, @NotNull TokenConsumer consumer) {
            PsiElement node;
            if (element == null) {
                MyPropertyTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyPropertyTokenizer.$$$reportNull$$$0(1);
            }
            if ((node = element.getNameIdentifier()) != null) {
                String text2 = StringUtil.unquoteString((String)node.getText());
                consumer.consumeToken(node, text2, true, 1, TextRange.allOf((String)text2), (Splitter)IdentifierSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyPropertyTokenizer";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAttributeValueTokenizer
    extends Tokenizer<JSNamedElement> {
        private MyAttributeValueTokenizer() {
        }

        public void tokenize(@NotNull JSNamedElement property, @NotNull TokenConsumer consumer) {
            PsiElement node;
            if (property == null) {
                MyAttributeValueTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyAttributeValueTokenizer.$$$reportNull$$$0(1);
            }
            if ((node = property.getNameIdentifier()) != null) {
                consumer.consumeToken(node, true, (Splitter)TextSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "property";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyAttributeValueTokenizer";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDescriptionTokenizer
    extends Tokenizer<PsiElement> {
        private MyDescriptionTokenizer() {
        }

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                MyDescriptionTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyDescriptionTokenizer.$$$reportNull$$$0(1);
            }
            consumer.consumeToken(element, (Splitter)CommentSplitter.getInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyDescriptionTokenizer";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

