/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSGenerateAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Pair<Editor, PsiFile> editorAndPsiFile = BaseJSGenerateAction.getEditorAndPsiFile(e);
        this.getGenerateHandler().invoke(project, (Editor)editorAndPsiFile.first, (PsiFile)editorAndPsiFile.second);
    }

    private static Pair<Editor, PsiFile> getEditorAndPsiFile(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return Pair.create(null, null);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile psiFile2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file != null && JavaScriptSupportLoader.isFlexMxmFile(file)) {
            boolean commit = ApplicationManager.getApplication().isDispatchThread();
            editor = BaseCodeInsightAction.getInjectedEditor((Project)project, (Editor)editor, (boolean)commit);
            psiFile2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        }
        return Pair.create((Object)editor, (Object)psiFile2);
    }

    @NotNull
    protected abstract BaseJSGenerateHandler getGenerateHandler();

    public void update(@NotNull AnActionEvent e) {
        PsiFile psiFile2;
        Editor editor;
        if (e == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(2);
        }
        Pair<Editor, PsiFile> editorAndPsiFile = BaseJSGenerateAction.getEditorAndPsiFile(e);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        PsiElement jsClass = this.getMemberContainer(file, editor = (Editor)editorAndPsiFile.first, psiFile2 = (PsiFile)editorAndPsiFile.second);
        boolean status = jsClass != null && this.isApplicableForMemberContainer(jsClass, psiFile2, editor);
        e.getPresentation().setEnabledAndVisible(status);
    }

    @Nullable
    protected PsiElement getMemberContainer(@Nullable VirtualFile file, @Nullable Editor editor, @Nullable PsiFile psiFile2) {
        if (file != null && psiFile2 != null && editor != null) {
            return BaseJSGenerateHandler.findClassOrObjectLiteral(psiFile2, editor, (Condition<? super PsiElement>)((Condition)element -> DialectDetector.dialectOfElement(element) != null && JSClassUtils.canHaveClasses(element)));
        }
        return null;
    }

    protected boolean isApplicableForMemberContainer(@NotNull PsiElement jsClass, PsiFile psiFile2, @NotNull Editor editor) {
        if (jsClass == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(4);
        }
        return BaseJSGenerateAction.isClassWithMembersToGenerate(jsClass) || jsClass instanceof JSObjectLiteralExpression && BaseJSGenerateAction.hasReasonableExpectedType((JSExpression)jsClass);
    }

    private static boolean hasReasonableExpectedType(@NotNull JSExpression jsClass) {
        JSType type2;
        if (jsClass == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(5);
        }
        return (type2 = JSDialectSpecificHandlersFactory.findExpectedType(jsClass)) != null && !(type2 instanceof JSAnyType);
    }

    public static boolean isClassWithMembersToGenerate(PsiElement jsClass) {
        return jsClass instanceof JSClass && !((JSClass)jsClass).isInterface() && !(jsClass instanceof TypeScriptEnum) && !(jsClass instanceof TypeScriptTypeAlias);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/generation/BaseJSGenerateAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/generation/BaseJSGenerateAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableForMemberContainer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasReasonableExpectedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

