/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSDirectFileReferenceResolver;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSFileModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.modules.JSPathResolution;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSParsedPathElement;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSSimpleFileReferenceRootsProviderKt;
import com.intellij.lang.javascript.modules.JSFileResolveRootsProvider;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.PathUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\bH\u0014J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0010H\u0014J\u001e\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100(2\u0006\u0010)\u001a\u00020\u0010H\u0002J\b\u0010*\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010-\u001a\u00020\bH\u0002J\u0013\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0004\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u00102\b\u00101\u001a\u0004\u0018\u00010\u0010H\u0002J \u00102\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\b2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u0010H\u0002J0\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\b2\u0006\u00106\u001a\u00020\u00102\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00100(2\u0006\u00108\u001a\u00020\u001cH\u0014J0\u00109\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\b2\u0006\u00106\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00100(H\u0004J(\u0010:\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\b2\u0006\u00106\u001a\u00020\u00102\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00100(H\u0004J3\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00072\u0006\u0010?\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010@J\u0012\u0010A\u001a\u0004\u0018\u00010\u00102\u0006\u0010B\u001a\u00020\u0010H\u0002J+\u0010C\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00072\u0006\u0010B\u001a\u00020\u0010H\u0004\u00a2\u0006\u0002\u0010DJ+\u0010E\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00072\u0006\u0010?\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010DJ\u001b\u0010F\u001a\b\u0012\u0004\u0012\u00020>0\u00072\u0006\u0010G\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010HJ3\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u00142\f\u0010K\u001a\b\u0012\u0004\u0012\u00020>0\u00072\u0006\u0010$\u001a\u00020\b2\u0006\u00103\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010LJ\u0010\u0010M\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u0010H\u0002J\u0016\u0010N\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0010J\u0018\u0010O\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0010J\u001a\u0010P\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0010\u0010Q\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\bH\u0002J+\u0010R\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00072\u0006\u0010%\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010DJ\u001a\u0010S\u001a\u0004\u0018\u00010\u00102\u0006\u00106\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\bH\u0002J\b\u0010U\u001a\u00020+H\u0016J\b\u0010V\u001a\u00020+H\u0016J\u0014\u0010W\u001a\u0004\u0018\u00010\u00102\b\u00101\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010X\u001a\u0004\u0018\u00010\u00102\u0006\u0010B\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\bH\u0002J+\u0010Y\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00072\u0006\u0010B\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010DJS\u0010Z\u001a\u0004\u0018\u0001H[\"\u0004\b\u0000\u0010\\\"\b\b\u0001\u0010[*\u00020]*\u0014\u0012\u0004\u0012\u0002H\\\u0012\n\u0012\b\u0012\u0004\u0012\u0002H[0\u00110^2\u0006\u0010_\u001a\u0002H\\2\u0014\u0010`\u001a\u0010\u0012\u0004\u0012\u0002H\\\u0012\u0006\u0012\u0004\u0018\u0001H[0aH\u0002\u00a2\u0006\u0002\u0010bJI\u0010c\u001a\u0002H[\"\u0004\b\u0000\u0010\\\"\b\b\u0001\u0010[*\u00020]*\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u0002H[0^2\u0006\u0010_\u001a\u0002H\\2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u0002H[0aH\u0002\u00a2\u0006\u0002\u0010bR\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR,\u0010\r\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl;", "Lcom/intellij/lang/javascript/config/JSDirectFileReferenceResolver;", "project", "Lcom/intellij/openapi/project/Project;", "resolveContext", "Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "defaultExtensions", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSImportResolveContext;[Ljava/lang/String;)V", "getDefaultExtensions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "loadModuleForLastPartWithModificationCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/util/Optional;", "loadNodeModuleFromDirectoryCache", "pathMappingsCache", "Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResolveContext", "()Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "suffixWithExtensions", "toPreferredFileModuleCache", "useCaches", "", "allowDirectResolve", "name", "chooseBetterMatched", "oldCandidate", "newCandidate", "collectRoots", "", "moduleName", "contextFile", "createResolved", "list", "", "target", "dropCaches", "", "findRootDirWithLongestPrefix", "candidate", "getExtensionsWithSuffixes", "isReDirectCandidate", "canonicalFile", "file", "loadAndRemap", "ref", "currentRoot", "loadModuleForLastPart", "parent", "result", "resolveDirectory", "loadModuleForLastPartDirectly", "loadModuleForLastPartWithModification", "loadModuleFromFileOrDirectory", "relativePath", "elements", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "containingDirectory", "(Ljava/lang/String;[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;Lcom/intellij/openapi/vfs/VirtualFile;Z)Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "loadNodeModuleFromDirectory", "directory", "loader", "(Ljava/lang/String;[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "nodeLoadModuleByRelativeName", "parseTextElements", "suffix", "(Ljava/lang/String;)[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "reMapElements", "pathResolution", "subElements", "(Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;Ljava/lang/String;Ljava/lang/String;)Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "remapToTypeScriptSourceDirectory", "resolveDirectFile", "resolveFileModule", "resolveFileModuleImpl", "resolveFromPathMappings", "resolveModuleWithElements", "resolvePathElement", "path", "startCaching", "stopCaching", "toPreferredFileModule", "tryAddingExtensions", "tryLoadModuleUsingRootDirs", "computeNullableWithCache", "V", "K", "", "", "key", "compute", "Lkotlin/Function1;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "computeWithCache", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSFileImportsResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSFileImportsResolverImpl.kt\ncom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,532:1\n37#2,2:533\n13374#3,3:535\n13309#3,2:539\n1#4:538\n1864#5,3:541\n23#6:544\n*S KotlinDebug\n*F\n+ 1 JSFileImportsResolverImpl.kt\ncom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl\n*L\n59#1:533,2\n167#1:535,3\n348#1:539,2\n443#1:541,3\n472#1:544\n*E\n"})
public class JSFileImportsResolverImpl
implements JSDirectFileReferenceResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final JSImportResolveContext resolveContext;
    @NotNull
    private final String[] defaultExtensions;
    private boolean useCaches;
    @NotNull
    private final ConcurrentHashMap<String, JSPathResolution> pathMappingsCache;
    @NotNull
    private final ConcurrentHashMap<Pair<String, VirtualFile>, Optional<VirtualFile>> loadModuleForLastPartWithModificationCache;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, Optional<VirtualFile>> loadNodeModuleFromDirectoryCache;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, VirtualFile> toPreferredFileModuleCache;
    @NotNull
    private final String[] suffixWithExtensions;

    public JSFileImportsResolverImpl(@NotNull Project project, @NotNull JSImportResolveContext resolveContext, @NotNull String[] defaultExtensions) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resolveContext, (String)"resolveContext");
        Intrinsics.checkNotNullParameter((Object)defaultExtensions, (String)"defaultExtensions");
        this.project = project;
        this.resolveContext = resolveContext;
        this.defaultExtensions = defaultExtensions;
        this.pathMappingsCache = new ConcurrentHashMap();
        this.loadModuleForLastPartWithModificationCache = new ConcurrentHashMap();
        this.loadNodeModuleFromDirectoryCache = new ConcurrentHashMap();
        this.toPreferredFileModuleCache = new ConcurrentHashMap();
        JSFileImportsResolverImpl jSFileImportsResolverImpl = this;
        if (this.resolveContext.getModuleSuffixes().isEmpty()) {
            stringArray = this.defaultExtensions;
        } else {
            List mutableList = new ArrayList();
            String[] stringArray2 = this.defaultExtensions;
            int n = stringArray2.length;
            JSFileImportsResolverImpl jSFileImportsResolverImpl2 = jSFileImportsResolverImpl;
            for (int i = 0; i < n; ++i) {
                String extension = stringArray2[i];
                for (String moduleSuffix : this.resolveContext.getModuleSuffixes()) {
                    Intrinsics.checkNotNull((Object)moduleSuffix);
                    if (((CharSequence)moduleSuffix).length() == 0) continue;
                    mutableList.add(moduleSuffix + extension);
                }
                mutableList.add(extension);
            }
            jSFileImportsResolverImpl = jSFileImportsResolverImpl2;
            Collection $this$toTypedArray$iv = mutableList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        }
        jSFileImportsResolverImpl.suffixWithExtensions = stringArray;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final JSImportResolveContext getResolveContext() {
        return this.resolveContext;
    }

    @NotNull
    protected final String[] getDefaultExtensions() {
        return this.defaultExtensions;
    }

    @NotNull
    protected final String[] getExtensionsWithSuffixes() {
        return this.suffixWithExtensions;
    }

    public void startCaching() {
        this.useCaches = true;
        this.dropCaches();
    }

    public void stopCaching() {
        this.useCaches = false;
        this.dropCaches();
    }

    @Nullable
    public final VirtualFile resolveFileModule(@NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        return this.resolveFileModuleImpl(moduleName, contextFile);
    }

    private final VirtualFile resolveFileModuleImpl(String moduleName, VirtualFile contextFile) {
        ProgressManager.checkCanceled();
        return this.resolveModuleWithElements(moduleName, this.parseTextElements(moduleName), contextFile).resolvedTarget();
    }

    @Override
    @NotNull
    public final JSPathResolution resolveDirectFile(@NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        ProgressManager.checkCanceled();
        return this.resolveModuleWithElements(moduleName, this.parseTextElements(moduleName), contextFile);
    }

    private final void dropCaches() {
        this.pathMappingsCache.clear();
        this.loadModuleForLastPartWithModificationCache.clear();
        this.loadNodeModuleFromDirectoryCache.clear();
        this.toPreferredFileModuleCache.clear();
    }

    private final JSPathResolution resolveModuleWithElements(String moduleName, JSParsedPathElement[] elements, VirtualFile contextFile) {
        if (elements.length == 1 && StringsKt.startsWith$default((String)moduleName, (String)"lib.", (boolean)false, (int)2, null)) {
            String libShortName = StringsKt.removeSurrounding((String)moduleName, (CharSequence)"lib.", (CharSequence)".d.ts");
            VirtualFile libFile = TypeScriptLibraryProvider.getService(this.project).findLibraryByShortName(libShortName);
            if (libFile != null) {
                return new JSPathResolution(CollectionsKt.listOf((Object)libFile), true, false);
            }
        }
        JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
        JSPathResolution partialResolved = jSPathResolution;
        if (!JSFileReferencesUtil.isRelative(moduleName)) {
            JSPathResolution fromMapping = this.resolveFromPathMappings(moduleName);
            if (fromMapping.isFullChainResolved()) {
                return fromMapping;
            }
            partialResolved = fromMapping;
        }
        Collection<VirtualFile> roots = this.collectRoots(moduleName, contextFile);
        JSParsedPathElement[] parsedElements = this.parseTextElements(moduleName);
        for (VirtualFile root : roots) {
            ProgressManager.checkCanceled();
            JSPathResolution result2 = this.loader(moduleName, parsedElements, root);
            if (!result2.isFullChainResolved()) {
                partialResolved = this.chooseBetterMatched(partialResolved, result2);
                continue;
            }
            return result2;
        }
        if (JSSimpleFileReferenceRootsProviderKt.isExternalModuleNameRelative(moduleName)) {
            VirtualFile root;
            root = contextFile instanceof VirtualFileWindow ? ((VirtualFileWindow)contextFile).getDelegate() : contextFile;
            Intrinsics.checkNotNull((Object)root);
            VirtualFile effectiveFile = root;
            VirtualFile virtualFile = effectiveFile.getParent();
            if (virtualFile == null) {
                JSPathResolution jSPathResolution2 = JSPathResolution.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution2, (String)"EMPTY");
                return jSPathResolution2;
            }
            VirtualFile containingDirectory = virtualFile;
            JSPathResolution fromRootDirs = this.tryLoadModuleUsingRootDirs(moduleName, elements, containingDirectory);
            if (fromRootDirs.isFullChainResolved()) {
                return fromRootDirs;
            }
        }
        return partialResolved;
    }

    private final JSPathResolution chooseBetterMatched(JSPathResolution oldCandidate, JSPathResolution newCandidate) {
        int currentSize = oldCandidate.size();
        return newCandidate.size() > currentSize ? newCandidate : oldCandidate;
    }

    @NotNull
    protected Collection<VirtualFile> collectRoots(@NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        JSFileResolveRootsProvider jSFileResolveRootsProvider = this.resolveContext.getRootsProvider();
        Intrinsics.checkNotNullExpressionValue((Object)jSFileResolveRootsProvider, (String)"getRootsProvider(...)");
        JSFileResolveRootsProvider rootsProvider = jSFileResolveRootsProvider;
        return rootsProvider.getDefaultRoots(this.project, moduleName, contextFile);
    }

    @NotNull
    protected final JSPathResolution loader(@NotNull String relativePath, @NotNull JSParsedPathElement[] elements, @NotNull VirtualFile directory) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (!this.resolveContext.isNodeLikeResolution()) {
            return this.loadModuleFromFileOrDirectory(relativePath, elements, directory, false);
        }
        return this.nodeLoadModuleByRelativeName(relativePath, elements, directory);
    }

    /*
     * WARNING - void declaration
     */
    private final JSPathResolution loadModuleFromFileOrDirectory(String relativePath, JSParsedPathElement[] elements, VirtualFile containingDirectory, boolean resolveDirectory) {
        if (StringsKt.endsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null) && !resolveDirectory) {
            JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
            return jSPathResolution;
        }
        List result2 = new ArrayList();
        VirtualFile parent = null;
        parent = containingDirectory;
        JSParsedPathElement[] $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (JSParsedPathElement item$iv : $this$forEachIndexed$iv) {
            JSPathResolution candidate;
            boolean isLast;
            void jsParsedPathElement;
            int n = index$iv++;
            JSParsedPathElement jSParsedPathElement = item$iv;
            int index = n;
            boolean bl = false;
            String name = jsParsedPathElement.getText();
            boolean bl2 = isLast = index == elements.length - 1;
            if (!isLast || StringsKt.endsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null) && resolveDirectory) {
                VirtualFile resolved = this.resolvePathElement(parent, name);
                if (resolved == null) {
                    return new JSPathResolution(result2, false, false);
                }
                VirtualFile next = resolved;
                if (isLast && next.isDirectory()) {
                    next = this.loadNodeModuleFromDirectory(next);
                }
                if (next == null) {
                    if (resolved.isDirectory()) {
                        return this.createResolved(result2, resolved);
                    }
                    return new JSPathResolution(result2, false, false);
                }
                parent = next;
                result2.add(next);
                continue;
            }
            JSPathResolution jSPathResolution = candidate = this.loadModuleForLastPart(name, parent, result2, resolveDirectory);
            if (jSPathResolution == null) continue;
            return jSPathResolution;
        }
        return new JSPathResolution(result2, result2.size() == elements.length, false);
    }

    @Nullable
    protected JSPathResolution loadModuleForLastPart(@NotNull String name, @NotNull VirtualFile parent, @NotNull List<VirtualFile> result2, boolean resolveDirectory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        JSPathResolution jSPathResolution = this.loadModuleForLastPartDirectly(name, parent, resolveDirectory, result2);
        if (jSPathResolution != null) {
            JSPathResolution it = jSPathResolution;
            boolean bl = false;
            return it;
        }
        JSPathResolution jSPathResolution2 = this.loadModuleForLastPartWithModification(name, parent, result2);
        if (jSPathResolution2 != null) {
            JSPathResolution it = jSPathResolution2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Nullable
    protected final JSPathResolution loadModuleForLastPartDirectly(@NotNull String name, @NotNull VirtualFile parent, boolean resolveDirectory, @NotNull List<VirtualFile> result2) {
        VirtualFile exactFile;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (this.allowDirectResolve(name) && (exactFile = this.resolvePathElement(parent, name)) != null) {
            VirtualFile loaded;
            if (resolveDirectory && exactFile.isDirectory() && (loaded = this.loadNodeModuleFromDirectory(exactFile)) != null) {
                return this.createResolved(result2, loaded);
            }
            if (!exactFile.isDirectory() || this.resolveContext.isAllowFolders()) {
                return this.createResolved(result2, exactFile);
            }
        }
        return null;
    }

    @Nullable
    protected final JSPathResolution loadModuleForLastPartWithModification(@NotNull String name, @NotNull VirtualFile parent, @NotNull List<VirtualFile> result2) {
        JSPathResolution jSPathResolution;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        VirtualFile virtualFile = (VirtualFile)this.computeNullableWithCache((Map)this.loadModuleForLastPartWithModificationCache, new Pair((Object)name, (Object)parent), (Function1)new Function1<Pair<? extends String, ? extends VirtualFile>, VirtualFile>(this, parent, name){
            final /* synthetic */ JSFileImportsResolverImpl this$0;
            final /* synthetic */ VirtualFile $parent;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
                this.$name = $name;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(@NotNull Pair<String, ? extends VirtualFile> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                VirtualFile candidateWithExtension = JSFileImportsResolverImpl.access$tryAddingExtensions(this.this$0, this.$parent, this.$name);
                if (candidateWithExtension != null) {
                    return candidateWithExtension;
                }
                if (TypeScriptUtil.isJavaScriptFile(this.$name)) {
                    String string = FileUtil.getNameWithoutExtension((String)this.$name);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                    String nameWithoutExtension = string;
                    VirtualFile tsCandidateForJSFile = JSFileImportsResolverImpl.access$tryAddingExtensions(this.this$0, this.$parent, nameWithoutExtension);
                    if (tsCandidateForJSFile != null && !tsCandidateForJSFile.isDirectory()) {
                        return tsCandidateForJSFile;
                    }
                }
                Collection<JSImportResolveContext.PrefixPostfix> collection = this.this$0.getResolveContext().getPrefixPostfix();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getPrefixPostfix(...)");
                Collection<JSImportResolveContext.PrefixPostfix> prefixPostfixes = collection;
                for (JSImportResolveContext.PrefixPostfix prefixPostfix : prefixPostfixes) {
                    VirtualFile candidate;
                    String postfix;
                    String prefix;
                    Intrinsics.checkNotNullExpressionValue((Object)prefixPostfix.prefix, (String)"prefix");
                    Intrinsics.checkNotNullExpressionValue((Object)prefixPostfix.postfix, (String)"postfix");
                    if (StringsKt.startsWith$default((String)this.$name, (String)prefix, (boolean)false, (int)2, null)) continue;
                    String effectivePostfix = StringsKt.endsWith$default((String)this.$name, (String)postfix, (boolean)false, (int)2, null) ? "" : postfix;
                    VirtualFile virtualFile = candidate = this.$parent.findChild(prefix + this.$name + effectivePostfix);
                    if (virtualFile == null) continue;
                    return virtualFile;
                }
                return null;
            }
        });
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            jSPathResolution = this.createResolved(result2, it);
        } else {
            jSPathResolution = null;
        }
        return jSPathResolution;
    }

    private final JSPathResolution tryLoadModuleUsingRootDirs(String moduleName, JSParsedPathElement[] elements, VirtualFile directory) {
        Collection<VirtualFile> collection = this.resolveContext.getRootDirs();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRootDirs(...)");
        Collection<VirtualFile> rootDirs = collection;
        if (rootDirs.isEmpty()) {
            JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
            return jSPathResolution;
        }
        String candidatePath = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(directory, moduleName);
        Intrinsics.checkNotNull((Object)candidatePath);
        VirtualFile rootDir = this.findRootDirWithLongestPrefix(candidatePath);
        if (rootDir != null) {
            String string = candidatePath.substring(rootDir.getPath().length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String suffix = string;
            JSParsedPathElement[] restElements = this.parseTextElements(suffix);
            List result2 = new ArrayList();
            VirtualFile curr = directory;
            int n = elements.length - restElements.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile resolved = this.resolvePathElement(curr, elements[i].getText());
                if (resolved == null) {
                    JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
                    return jSPathResolution;
                }
                result2.add(resolved);
                curr = resolved;
            }
            for (VirtualFile currentRoot : rootDirs) {
                if (Intrinsics.areEqual((Object)currentRoot, (Object)rootDir)) continue;
                Intrinsics.checkNotNull((Object)currentRoot);
                JSPathResolution resolvedFromRoot = this.loader(suffix, restElements, currentRoot);
                if (!resolvedFromRoot.isFullChainResolved()) continue;
                List<VirtualFile> list2 = resolvedFromRoot.getChain();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getChain(...)");
                result2.addAll((Collection)list2);
                return new JSPathResolution(result2, true, false);
            }
        }
        JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
        return jSPathResolution;
    }

    private final JSPathResolution createResolved(List<VirtualFile> list2, VirtualFile target) {
        VirtualFile virtualFile = this.toPreferredFileModule(target);
        Intrinsics.checkNotNull((Object)virtualFile);
        list2.add(virtualFile);
        return new JSPathResolution(list2, true, false);
    }

    private final VirtualFile resolvePathElement(VirtualFile parent, String path2) {
        if (Intrinsics.areEqual((Object)path2, (Object)".") || ((CharSequence)path2).length() == 0) {
            return parent;
        }
        if (Intrinsics.areEqual((Object)path2, (Object)"..")) {
            return parent.getParent();
        }
        if (!PathUtilRt.isValidFileName((String)path2, (boolean)false)) {
            return null;
        }
        return parent.findChild(path2);
    }

    protected boolean allowDirectResolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return true;
    }

    private final JSPathResolution nodeLoadModuleByRelativeName(String relativePath, JSParsedPathElement[] elements, VirtualFile containingDirectory) {
        boolean isTypesRemapped;
        JSParsedPathElement[] toProcessParts;
        JSPathResolution resolved;
        String moduleNameForProcessing = relativePath;
        if (NodeModuleUtil.isTypesDir(containingDirectory) && StringsKt.startsWith$default((String)relativePath, (String)"@", (boolean)false, (int)2, null)) {
            moduleNameForProcessing = TypeScriptFileImportsResolverImpl.Companion.convertToTypesDirectory(moduleNameForProcessing);
        }
        if ((resolved = this.loadModuleFromFileOrDirectory(moduleNameForProcessing, toProcessParts = (isTypesRemapped = !Intrinsics.areEqual((Object)moduleNameForProcessing, (Object)relativePath)) ? this.parseTextElements(moduleNameForProcessing) : elements, containingDirectory, true)).size() == 0 || !isTypesRemapped) {
            return resolved;
        }
        List result2 = new ArrayList();
        for (VirtualFile virtualFile : resolved.getChain()) {
            if (result2.size() == 0) {
                Intrinsics.checkNotNull((Object)virtualFile);
                result2.add(virtualFile);
            }
            Intrinsics.checkNotNull((Object)virtualFile);
            result2.add(virtualFile);
        }
        return new JSPathResolution(result2, resolved.isFullChainResolved(), false);
    }

    private final JSParsedPathElement[] parseTextElements(String suffix) {
        return JSParsedPathElement.Parser.parseReferenceText(suffix, this.resolveContext.isUrlEncoded());
    }

    private final VirtualFile tryAddingExtensions(VirtualFile directory, String name) {
        String[] $this$forEach$iv = this.getExtensionsWithSuffixes();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            VirtualFile candidate;
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String fileName = name + it;
            if (!PathUtilRt.isValidFileName((String)fileName, (boolean)true) || (candidate = directory.findChild(fileName)) == null) continue;
            return candidate;
        }
        return null;
    }

    private final VirtualFile findRootDirWithLongestPrefix(String candidate) {
        VirtualFile matchedRootDir = null;
        Object matchedNormalizedPrefix = null;
        for (VirtualFile rootDir : this.resolveContext.getRootDirs()) {
            String rootDirPath = rootDir.getPath() + "/";
            boolean isLongestMatchingPrefix = StringsKt.startsWith$default((String)candidate, (String)rootDirPath, (boolean)false, (int)2, null) && (matchedNormalizedPrefix == null || ((String)matchedNormalizedPrefix).length() < rootDirPath.length());
            if (!isLongestMatchingPrefix) continue;
            matchedRootDir = rootDir;
            matchedNormalizedPrefix = rootDirPath;
        }
        return matchedRootDir;
    }

    private final JSPathResolution resolveFromPathMappings(String moduleName) {
        JSModulePathMappings<? extends JSModulePathSubstitution> jSModulePathMappings = this.resolveContext.pathsMappings();
        Intrinsics.checkNotNullExpressionValue(jSModulePathMappings, (String)"pathsMappings(...)");
        JSModulePathMappings<? extends JSModulePathSubstitution> mappings = jSModulePathMappings;
        if (mappings.isEmpty()) {
            JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
            return jSPathResolution;
        }
        return (JSPathResolution)this.computeWithCache(this.pathMappingsCache, moduleName, (Function1)new Function1<String, JSPathResolution>(moduleName, mappings, this){
            final /* synthetic */ String $moduleName;
            final /* synthetic */ JSModulePathMappings<JSModulePathSubstitution> $mappings;
            final /* synthetic */ JSFileImportsResolverImpl this$0;
            {
                this.$moduleName = $moduleName;
                this.$mappings = $mappings;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JSPathResolution invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Collection<String> collection = JSPathMappingsUtil.substituteMappings(this.$moduleName, this.$mappings);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"substituteMappings(...)");
                Collection<String> substituteMappings = collection;
                Collection<VirtualFile> collection2 = this.this$0.getResolveContext().getMappingRoots();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getMappingRoots(...)");
                Collection<VirtualFile> mappingRoots = collection2;
                JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
                JSPathResolution partialResolved = jSPathResolution;
                VirtualFile[] virtualFileArray = ManagingFS.getInstance().getRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRoots(...)");
                VirtualFile[] roots = virtualFileArray;
                for (String mapping : substituteMappings) {
                    String fsRoot;
                    for (VirtualFile baseRoot : mappingRoots) {
                        ProgressManager.checkCanceled();
                        Intrinsics.checkNotNull((Object)mapping);
                        Intrinsics.checkNotNull((Object)baseRoot);
                        JSPathResolution remapped = JSFileImportsResolverImpl.access$loadAndRemap(this.this$0, this.$moduleName, mapping, baseRoot);
                        if (remapped.isFullChainResolved()) {
                            return remapped;
                        }
                        partialResolved = JSFileImportsResolverImpl.access$chooseBetterMatched(this.this$0, partialResolved, remapped);
                    }
                    String string = FileUtil.extractRootPath((String)mapping);
                    if (string == null) {
                        Intrinsics.checkNotNull((Object)mapping);
                        string = StringsKt.startsWith$default((String)mapping, (String)"/", (boolean)false, (int)2, null) ? "/" : null;
                    }
                    if ((fsRoot = string) == null) continue;
                    for (VirtualFile fsRootFile : roots) {
                        String independentPath;
                        if (!Intrinsics.areEqual((Object)fsRootFile.getName(), (Object)fsRoot) || fsRootFile == null) continue;
                        Intrinsics.checkNotNull((Object)mapping);
                        String string2 = mapping.substring(fsRoot.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)string2), (String)"toSystemIndependentName(...)");
                        JSPathResolution fsRemapped = JSFileImportsResolverImpl.access$loadAndRemap(this.this$0, this.$moduleName, independentPath, fsRootFile);
                        if (fsRemapped.isFullChainResolved()) {
                            return fsRemapped;
                        }
                        partialResolved = JSFileImportsResolverImpl.access$chooseBetterMatched(this.this$0, partialResolved, fsRemapped);
                    }
                }
                return partialResolved;
            }
        });
    }

    private final JSPathResolution loadAndRemap(String moduleName, String ref, VirtualFile currentRoot) {
        JSParsedPathElement[] subElements = this.parseTextElements(ref);
        JSPathResolution newCandidate = this.loader(ref, subElements, currentRoot);
        return this.reMapElements(newCandidate, subElements, moduleName, ref);
    }

    /*
     * WARNING - void declaration
     */
    private final JSPathResolution reMapElements(JSPathResolution pathResolution, JSParsedPathElement[] subElements, String moduleName, String ref) {
        Object[] originalElements = this.parseTextElements(moduleName);
        int counter2 = Math.min(originalElements.length, subElements.length);
        List fullChain = new ArrayList();
        List<VirtualFile> list2 = pathResolution.getChain();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getChain(...)");
        fullChain.addAll((Collection)list2);
        if (subElements.length > fullChain.size()) {
            int n = subElements.length - fullChain.size();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                fullChain.add(null);
            }
        }
        List reversedResult = CollectionsKt.reversed((Iterable)fullChain);
        List reversedElements = ArraysKt.reversed((Object[])originalElements);
        List chainProcessed = new ArrayList();
        VirtualFile lastElement = null;
        boolean chainIsBroken = false;
        Iterable $this$forEachIndexed$iv = reversedElements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void currPath;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSParsedPathElement jSParsedPathElement = (JSParsedPathElement)item$iv;
            int i = n;
            boolean bl = false;
            if (chainIsBroken || i >= counter2) {
                chainProcessed.add(lastElement);
                continue;
            }
            VirtualFile currFile = (VirtualFile)reversedResult.get(i);
            if (i == 0) {
                chainProcessed.add(currFile);
                lastElement = currFile;
                continue;
            }
            if (currFile == null) {
                chainProcessed.add(null);
                lastElement = null;
                continue;
            }
            chainProcessed.add(currFile);
            lastElement = currFile;
            if (Intrinsics.areEqual((Object)currFile.getName(), (Object)currPath.getText())) continue;
            chainIsBroken = true;
        }
        List newChain = CollectionsKt.filterNotNull((Iterable)CollectionsKt.reversed((Iterable)chainProcessed));
        if (pathResolution.isFullChainResolved() && newChain.size() != originalElements.length) {
            JSFileImportsResolverImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JSFileImportsResolverImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Incorrect state of mapped chain: " + moduleName + " and mapped " + ref);
        }
        return new JSPathResolution(newChain, pathResolution.isFullChainResolved(), true);
    }

    private final VirtualFile loadNodeModuleFromDirectory(VirtualFile directory) {
        return (VirtualFile)this.computeNullableWithCache((Map)this.loadNodeModuleFromDirectoryCache, directory, (Function1)new Function1<VirtualFile, VirtualFile>(this, directory){
            final /* synthetic */ JSFileImportsResolverImpl this$0;
            final /* synthetic */ VirtualFile $directory;
            {
                this.this$0 = $receiver;
                this.$directory = $directory;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JSDirectorySearchProcessor jSDirectorySearchProcessor = this.this$0.getResolveContext().getNodeModuleSearchProcessor();
                Intrinsics.checkNotNullExpressionValue((Object)jSDirectorySearchProcessor, (String)"getNodeModuleSearchProcessor(...)");
                JSDirectorySearchProcessor processor = jSDirectorySearchProcessor;
                VirtualFile moduleMainFile = processor.loadDirectory(this.$directory);
                if (moduleMainFile == null) return null;
                String string = moduleMainFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!this.this$0.allowDirectResolve(string)) return null;
                VirtualFile virtualFile = moduleMainFile;
                return virtualFile;
            }
        });
    }

    private final VirtualFile toPreferredFileModule(VirtualFile file) {
        if (file == null) {
            return null;
        }
        if (this.resolveContext.preserveSymlinks()) {
            return file;
        }
        return (VirtualFile)this.computeWithCache(this.toPreferredFileModuleCache, file, (Function1)new Function1<VirtualFile, VirtualFile>(this, file){
            final /* synthetic */ JSFileImportsResolverImpl this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final VirtualFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VirtualFile virtualFile = JSFileModuleReference.getCanonicalPreferredFile(this.this$0.getProject(), this.$file);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getCanonicalPreferredFile(...)");
                VirtualFile canonicalFile = virtualFile;
                if (JSFileImportsResolverImpl.access$isReDirectCandidate(this.this$0, canonicalFile, this.$file)) {
                    return JSFileImportsResolverImpl.access$remapToTypeScriptSourceDirectory(this.this$0, canonicalFile);
                }
                return canonicalFile;
            }
        });
    }

    private final boolean isReDirectCandidate(VirtualFile canonicalFile, VirtualFile file) {
        if (!TypeScriptUtil.isDefinitionFile(canonicalFile)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)canonicalFile, (Object)file) || !VfsUtil.isAncestor((VirtualFile)canonicalFile, (VirtualFile)this.resolveContext.contextDirectory(), (boolean)true);
    }

    private final VirtualFile remapToTypeScriptSourceDirectory(VirtualFile canonicalFile) {
        VirtualFile virtualFile = TypeScriptConfigUtil.getParentConfigWithName(canonicalFile, "tsconfig.json");
        if (virtualFile == null) {
            return canonicalFile;
        }
        VirtualFile parentConfig = virtualFile;
        if (!VfsUtil.isAncestor((VirtualFile)parentConfig.getParent(), (VirtualFile)this.resolveContext.contextDirectory(), (boolean)false)) {
            TypeScriptConfig typeScriptConfig = TypeScriptConfigService.Provider.get(this.project).parseConfigFile(parentConfig);
            if (typeScriptConfig == null) {
                return canonicalFile;
            }
            TypeScriptConfig tsConfig = typeScriptConfig;
            VirtualFile virtualFile2 = TypeScriptImportPathBuilder.detectRootDir(this.project, tsConfig);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"detectRootDir(...)");
            VirtualFile sourceRoot = virtualFile2;
            VirtualFile virtualFile3 = tsConfig.getEffectiveOutDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getEffectiveOutDirectory(...)");
            VirtualFile outRoot = virtualFile3;
            if (Intrinsics.areEqual((Object)sourceRoot, (Object)outRoot)) {
                return canonicalFile;
            }
            TypeScriptSymlinkLinkedProject linked = new TypeScriptSymlinkLinkedProject(tsConfig.getConfigDirectory(), tsConfig.getConfigDirectory(), sourceRoot, outRoot, "");
            VirtualFile fromProjectStructure = linked.getSourceFileByLinkedFile(canonicalFile);
            if (fromProjectStructure != null) {
                return fromProjectStructure;
            }
        }
        return canonicalFile;
    }

    private final <K, V> V computeNullableWithCache(Map<K, Optional<V>> $this$computeNullableWithCache, K key2, Function1<? super K, ? extends V> compute) {
        return (V)(this.useCaches ? $this$computeNullableWithCache.computeIfAbsent(key2, arg_0 -> JSFileImportsResolverImpl.computeNullableWithCache$lambda$7((Function1)new Function1<K, Optional<V>>(compute){
            final /* synthetic */ Function1<K, V> $compute;
            {
                this.$compute = $compute;
                super(1);
            }

            @NotNull
            public final Optional<V> invoke(K it) {
                return Optional.ofNullable(this.$compute.invoke(it));
            }
        }, arg_0)).orElse(null) : compute.invoke(key2));
    }

    private final <K, V> V computeWithCache(Map<K, V> $this$computeWithCache, K key2, Function1<? super K, ? extends V> compute) {
        Object object;
        if (this.useCaches) {
            Object object2 = $this$computeWithCache.computeIfAbsent(key2, arg_0 -> JSFileImportsResolverImpl.computeWithCache$lambda$8((Function1)new Function1<K, V>(compute){
                final /* synthetic */ Function1<K, V> $compute;
                {
                    this.$compute = $compute;
                    super(1);
                }

                @NotNull
                public final V invoke(K it) {
                    return (V)this.$compute.invoke(it);
                }
            }, arg_0));
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"computeIfAbsent(...)");
        } else {
            object = compute.invoke(key2);
        }
        return (V)object;
    }

    private static final Optional computeNullableWithCache$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Object computeWithCache$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    public static final /* synthetic */ VirtualFile access$tryAddingExtensions(JSFileImportsResolverImpl $this, VirtualFile directory, String name) {
        return $this.tryAddingExtensions(directory, name);
    }

    public static final /* synthetic */ JSPathResolution access$loadAndRemap(JSFileImportsResolverImpl $this, String moduleName, String ref, VirtualFile currentRoot) {
        return $this.loadAndRemap(moduleName, ref, currentRoot);
    }

    public static final /* synthetic */ JSPathResolution access$chooseBetterMatched(JSFileImportsResolverImpl $this, JSPathResolution oldCandidate, JSPathResolution newCandidate) {
        return $this.chooseBetterMatched(oldCandidate, newCandidate);
    }

    public static final /* synthetic */ boolean access$isReDirectCandidate(JSFileImportsResolverImpl $this, VirtualFile canonicalFile, VirtualFile file) {
        return $this.isReDirectCandidate(canonicalFile, file);
    }

    public static final /* synthetic */ VirtualFile access$remapToTypeScriptSourceDirectory(JSFileImportsResolverImpl $this, VirtualFile canonicalFile) {
        return $this.remapToTypeScriptSourceDirectory(canonicalFile);
    }
}

