/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSConditionalExpressionAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final CommonCodeStyleSettings mySettings;
    private final TokenSet myPartsTokenSet;
    private final Alignment myAlignment1;
    private final Alignment myAlignment2;

    public JSConditionalExpressionAlignmentFactory(CommonCodeStyleSettings settings2, TokenSet partsTokenSet) {
        this.mySettings = settings2;
        this.myPartsTokenSet = partsTokenSet;
        this.myAlignment1 = Alignment.createAlignment();
        this.myAlignment2 = Alignment.createChildAlignment((Alignment)this.myAlignment1);
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        if (child == null) {
            JSConditionalExpressionAlignmentFactory.$$$reportNull$$$0(0);
        }
        if (!this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            return null;
        }
        IElementType childElementType = child.getElementType();
        if (this.myPartsTokenSet.contains(childElementType)) {
            return this.myAlignment1;
        }
        if (childElementType == JSTokenTypes.COLON || childElementType == JSTokenTypes.QUEST) {
            return this.myAlignment2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSConditionalExpressionAlignmentFactory", "getAlignment"));
    }
}

