/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.properties.CommaSeparatedValues;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.PresentableEnum;
import java.util.Optional;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCodeStyleSettings
extends CustomCodeStyleSettings {
    public static final JSXAttributeValuePresentation DEFAULT_JSX_VALUE = JSXAttributeValuePresentation.BRACES;
    private int myVersion = 0;
    public int INDENT_PACKAGE_CHILDREN = 0;
    public boolean USE_SEMICOLON_AFTER_STATEMENT = true;
    public boolean FORCE_SEMICOLON_STYLE = false;
    protected static final boolean DEFAULT_USE_EXPLICIT_JS_EXTENSION = false;
    public boolean SPACE_BEFORE_TYPE_COLON = false;
    public boolean SPACE_AFTER_TYPE_COLON = true;
    public boolean SPACE_BEFORE_GENERATOR_MULT = false;
    public boolean SPACE_AFTER_GENERATOR_MULT = true;
    public String FIELD_PREFIX = "_";
    public String PROPERTY_PREFIX = "";
    public JSFileNameStyle FILE_NAME_STYLE = JSFileNameStyle.RELAXED;
    public static final int DO_NOT_INDENT = 0;
    public static final int INDENT = 1;
    public boolean SPACE_BEFORE_PROPERTY_COLON = false;
    public boolean SPACE_AFTER_PROPERTY_COLON = true;
    public static final int DO_NOT_ALIGN = 0;
    public static final int ALIGN_ON_VALUE = 1;
    public static final int ALIGN_ON_COLON = 2;
    @ObjectLiteralAlignment
    public int ALIGN_OBJECT_PROPERTIES = 0;
    @VarStatementAlignment
    public int ALIGN_VAR_STATEMENTS = 0;
    public boolean SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS = false;
    public boolean SPACE_AFTER_DOTS_IN_REST_PARAMETER = false;
    public boolean SPACE_BEFORE_FUNCTION_LEFT_PARENTH = true;
    public boolean SPACE_BEFORE_CLASS_LBRACE = true;
    public boolean REFORMAT_C_STYLE_COMMENTS = false;
    public boolean USE_PUBLIC_MODIFIER = false;
    public boolean PREFER_AS_TYPE_CAST = false;
    public boolean USE_DOUBLE_QUOTES = true;
    public boolean FORCE_QUOTE_STYlE = false;
    public boolean PREFER_EXPLICIT_TYPES_VARS_FIELDS = false;
    public boolean PREFER_EXPLICIT_TYPES_FUNCTION_RETURNS = false;
    public boolean PREFER_EXPLICIT_TYPES_FUNCTION_EXPRESSION_RETURNS = false;
    public boolean COMMA_ON_NEW_LINE = false;
    public TrailingCommaOption ENFORCE_TRAILING_COMMA = TrailingCommaOption.Keep;
    public JSXAttributeValuePresentation JSX_ATTRIBUTE_VALUE = DEFAULT_JSX_VALUE;
    public UseExplicitExtension USE_EXPLICIT_JS_EXTENSION = UseExplicitExtension.AUTO;
    public UseImportType USE_IMPORT_TYPE = UseImportType.AUTO;
    @CommonCodeStyleSettings.WrapConstant
    public int VAR_DECLARATION_WRAP = 1;
    @CommonCodeStyleSettings.WrapConstant
    public int OBJECT_LITERAL_WRAP = 5;
    @CommonCodeStyleSettings.WrapConstant
    public int OBJECT_TYPES_WRAP = 5;
    @CommonCodeStyleSettings.WrapConstant
    public int IMPORTS_WRAP = 5;
    @CommonCodeStyleSettings.WrapConstant
    public int UNION_TYPES_WRAP = 5;
    public boolean SPACES_WITHIN_OBJECT_LITERAL_BRACES = false;
    public boolean SPACES_WITHIN_IMPORTS = false;
    public boolean ALIGN_IMPORTS = false;
    public boolean ALIGN_UNION_TYPES = false;
    public boolean SPACES_WITHIN_UNION_TYPES = true;
    public boolean INDENT_CHAINED_CALLS = true;
    public boolean USE_CHAINED_CALLS_GROUP_INDENTS = false;
    public boolean CHAINED_CALL_DOT_ON_NEW_LINE = true;
    public boolean SPACE_AROUND_ARROW_FUNCTION_OPERATOR = true;
    public boolean SPACE_BEFORE_ASYNC_ARROW_LPAREN = true;
    public boolean SPACES_WITHIN_OBJECT_TYPE_BRACES = true;
    public boolean SPACE_WITHIN_TYPE_ASSERTION = false;
    public int BLANK_LINES_AROUND_FUNCTION = 1;
    public boolean SPACES_WITHIN_INTERPOLATION_EXPRESSIONS = false;
    public boolean SPACE_BEFORE_UNARY_NOT = false;
    public boolean SPACE_AFTER_UNARY_NOT = false;
    public boolean IMPORT_SORT_MEMBERS = true;
    public boolean IMPORT_SORT_MODULE_NAME = false;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int FUNCTION_EXPRESSION_BRACE_STYLE = 1;
    @CommaSeparatedValues
    public String BLACKLIST_IMPORTS = "rxjs/Rx,node_modules/**,**/node_modules/**,@angular/material,@angular/material/typings/**";
    public BooleanWithGlobalOption IMPORT_MERGE_MEMBERS = BooleanWithGlobalOption.GLOBAL;
    public BooleanWithGlobalOption IMPORT_PREFER_ABSOLUTE_PATH = BooleanWithGlobalOption.GLOBAL;
    public BooleanWithGlobalOption IMPORT_USE_NODE_RESOLUTION = BooleanWithGlobalOption.TRUE;
    public PathMappingOption USE_PATH_MAPPING = PathMappingOption.ALWAYS;

    public void readExternal(Element parentElement) throws InvalidDataException {
        int version2;
        super.readExternal(parentElement);
        Element sectionElement = parentElement.getChild(this.getTagName());
        if (sectionElement != null && (version2 = StringUtil.parseInt((String)sectionElement.getAttributeValue("version"), (int)-1)) > 0) {
            this.myVersion = version2;
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(0);
        }
        super.writeExternal(parentElement, parentSettings);
        Element element = parentElement.getChild(this.getTagName());
        if (element != null) {
            element.setAttribute("version", Integer.toString(this.myVersion));
        }
    }

    public JSCodeStyleSettings clone() {
        JSCodeStyleSettings clone = (JSCodeStyleSettings)((Object)super.clone());
        clone.myVersion = this.myVersion;
        return clone;
    }

    @NotNull
    protected Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(1);
        }
        return javascriptLanguage;
    }

    @NotNull
    protected static BooleanWithGlobalOption convertToBooleanWithGlobalOption(boolean value) {
        BooleanWithGlobalOption booleanWithGlobalOption = value ? BooleanWithGlobalOption.TRUE : BooleanWithGlobalOption.FALSE;
        if (booleanWithGlobalOption == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(2);
        }
        return booleanWithGlobalOption;
    }

    protected JSCodeStyleSettings(CodeStyleSettings container) {
        super("JSCodeStyleSettings", container);
    }

    protected JSCodeStyleSettings(String tagName, CodeStyleSettings container) {
        super(tagName, container);
    }

    public static String getSemicolon(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(3);
        }
        return JSCodeStyleSettings.getSettings((PsiElement)context2).USE_SEMICOLON_AFTER_STATEMENT ? ";" : "";
    }

    @NotNull
    public static JSCodeStyleSettings getSettings(@NotNull PsiElement element) {
        if (element == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(4);
        }
        Class<? extends JSCodeStyleSettings> codeStyleSettingsClass = JSCodeStyleSettings.getSettingsClass(DialectDetector.languageDialectOfElement(element));
        return JSCodeStyleSettings.getCustomSettings(element.getProject(), element.getContainingFile(), codeStyleSettingsClass);
    }

    @NotNull
    private static JSCodeStyleSettings getCustomSettings(@NotNull Project project, @Nullable PsiFile file, @NotNull Class<? extends JSCodeStyleSettings> codeStyleSettingsClass) {
        if (project == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(5);
        }
        if (codeStyleSettingsClass == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(6);
        }
        CodeStyleSettings settings2 = file != null ? CodeStyle.getSettings((PsiFile)file) : CodeStyle.getSettings((Project)project);
        JSCodeStyleSettings jSCodeStyleSettings = (JSCodeStyleSettings)settings2.getCustomSettings(codeStyleSettingsClass);
        if (jSCodeStyleSettings == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(7);
        }
        return jSCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings getCommonSettings(@NotNull PsiElement element) {
        if (element == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(8);
        }
        Language language = DialectDetector.languageOfElement(element);
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getSettings((PsiFile)element.getContainingFile()).getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(9);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static Class<? extends JSCodeStyleSettings> getSettingsClass(@Nullable Language dialect) {
        Class<? extends JSCodeStyleSettings> clazz = JSHandlersFactory.forLanguage(dialect).getCodeStyleSettingsClass();
        if (clazz == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(10);
        }
        return clazz;
    }

    @NotNull
    public static String getQuote(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(11);
        }
        String string = String.valueOf(JSCodeStyleSettings.getQuoteChar(context2));
        if (string == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String wrapWithQuotes(@NotNull PsiElement context2, @NotNull String text2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(14);
        }
        String quote = JSCodeStyleSettings.getQuote(context2);
        String string = quote + text2 + quote;
        if (string == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static char getQuoteChar(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(16);
        }
        return Optional.ofNullable((JSEmbeddedContent)PsiTreeUtil.getContextOfType((PsiElement)context2, (Class[])new Class[]{JSEmbeddedContent.class})).map(JSEmbeddedContent::getQuoteChar).orElseGet(() -> Character.valueOf(JSCodeStyleSettings.getSettings((PsiElement)context2).USE_DOUBLE_QUOTES ? (char)'\"' : (char)'\'')).charValue();
    }

    @NotNull
    public static String getLineCommentPrefix(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(17);
        }
        CommonCodeStyleSettings settings2 = JSCodeStyleSettings.getCommonSettings(context2);
        return settings2.LINE_COMMENT_ADD_SPACE ? " " : "";
    }

    public void setMergeImports(boolean value) {
        this.IMPORT_MERGE_MEMBERS = value ? BooleanWithGlobalOption.TRUE : BooleanWithGlobalOption.FALSE;
    }

    public static boolean isMergeImports(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(18);
        }
        return JSCodeStyleSettings.getSettings(context2).isMergeImports();
    }

    public boolean isMergeImports() {
        BooleanWithGlobalOption setting = this.IMPORT_MERGE_MEMBERS;
        if (setting == BooleanWithGlobalOption.GLOBAL) {
            return JSApplicationSettings.getInstance().isMergeImports();
        }
        return setting.toBoolean();
    }

    public void setUseAbsolutePath(boolean value) {
        this.IMPORT_PREFER_ABSOLUTE_PATH = JSCodeStyleSettings.convertToBooleanWithGlobalOption(value);
    }

    public static boolean isUseAbsolutePath(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(19);
        }
        JSCodeStyleSettings settings2 = JSCodeStyleSettings.getSettings(context2);
        BooleanWithGlobalOption setting = settings2.IMPORT_PREFER_ABSOLUTE_PATH;
        return setting == BooleanWithGlobalOption.GLOBAL ? JSApplicationSettings.getInstance().isUseAbsoluteConfigPath() : setting.toBoolean().booleanValue();
    }

    public void setNodeResolution(boolean value) {
        this.IMPORT_USE_NODE_RESOLUTION = JSCodeStyleSettings.convertToBooleanWithGlobalOption(value);
    }

    public static boolean isUseNodeResolution(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(20);
        }
        JSCodeStyleSettings settings2 = JSCodeStyleSettings.getSettings(context2);
        return settings2.isUseNodeResolution();
    }

    public boolean isUseNodeResolution() {
        return this.IMPORT_USE_NODE_RESOLUTION == BooleanWithGlobalOption.GLOBAL ? JSApplicationSettings.getInstance().isUseNodeModulesResolutionImports() : this.IMPORT_USE_NODE_RESOLUTION.toBoolean().booleanValue();
    }

    @NotNull
    public static JSXAttributeValuePresentation getJSXAttributeValue(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(21);
        }
        JSCodeStyleSettings settings2 = JSCodeStyleSettings.getCustomSettings(context2.getProject(), context2.getContainingFile(), JSCodeStyleSettings.class);
        JSXAttributeValuePresentation jSXAttributeValuePresentation = settings2.JSX_ATTRIBUTE_VALUE;
        if (jSXAttributeValuePresentation == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(22);
        }
        return jSXAttributeValuePresentation;
    }

    @NotNull
    public UseExplicitExtension getUseExplicitJSExtension() {
        UseExplicitExtension useExplicitExtension = this.USE_EXPLICIT_JS_EXTENSION;
        if (useExplicitExtension == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(23);
        }
        return useExplicitExtension;
    }

    public void setUseExplicitJSExtension(@NotNull UseExplicitExtension value) {
        if (value == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(24);
        }
        this.USE_EXPLICIT_JS_EXTENSION = value;
    }

    @NotNull
    public UseImportType getUseImportType() {
        UseImportType useImportType = this.USE_IMPORT_TYPE;
        if (useImportType == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(25);
        }
        return useImportType;
    }

    public void setUseImportType(@NotNull UseImportType useImportType) {
        if (useImportType == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(26);
        }
        this.USE_IMPORT_TYPE = useImportType;
    }

    public String[] getBlacklistImports() {
        return StringUtil.isEmpty((String)this.BLACKLIST_IMPORTS) ? ArrayUtilRt.EMPTY_STRING_ARRAY : this.BLACKLIST_IMPORTS.split(",");
    }

    public static boolean isPreferExplicitVariableTypes(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(27);
        }
        return JSCodeStyleSettings.getSettings((PsiElement)context2).PREFER_EXPLICIT_TYPES_VARS_FIELDS;
    }

    public static boolean isPreferExplicitReturnTypes(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(28);
        }
        return JSCodeStyleSettings.getSettings((PsiElement)context2).PREFER_EXPLICIT_TYPES_FUNCTION_RETURNS;
    }

    public static boolean isLocalDeclarationsAtScopeStart(@NotNull PsiElement element) {
        if (element == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(29);
        }
        return JSCodeStyleSettings.getInspectionTool(element.getProject(), JSDeclarationsAtScopeStartInspection.SHORT_NAME, LocalInspectionTool.class, element, true) != null;
    }

    @Nullable
    public static <T> T getInspectionTool(@NotNull Project project, @NotNull String shortName, @NotNull Class<T> toolClass, @Nullable PsiElement context2, boolean checkEnabled) {
        InspectionProfileImpl inspectionProfile;
        LocalInspectionToolWrapper localInspectionToolWrapper;
        if (project == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(30);
        }
        if (shortName == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(31);
        }
        if (toolClass == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(32);
        }
        if ((localInspectionToolWrapper = (LocalInspectionToolWrapper)(inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile()).getInspectionTool(shortName, project)) != null && (!checkEnabled || inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)shortName), context2))) {
            return toolClass.cast(localInspectionToolWrapper.getTool());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 7, 9, 10, 12, 15, 22, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSCodeStyleSettings";
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettingsClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useImportType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSCodeStyleSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBooleanWithGlobalOption";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuote";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSXAttributeValue";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseExplicitJSExtension";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseImportType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSemicolon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQuote";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteChar";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentPrefix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMergeImports";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isUseAbsolutePath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isUseNodeResolution";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJSXAttributeValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setUseExplicitJSExtension";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setUseImportType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isPreferExplicitVariableTypes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isPreferExplicitReturnTypes";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isLocalDeclarationsAtScopeStart";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTool";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 7, 9, 10, 12, 15, 22, 23, 25 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BooleanWithGlobalOption {
        GLOBAL{

            @Override
            public Boolean toBoolean() {
                return null;
            }
        }
        ,
        TRUE{

            @Override
            public Boolean toBoolean() {
                return true;
            }
        }
        ,
        FALSE{

            @Override
            public Boolean toBoolean() {
                return false;
            }
        };


        public abstract Boolean toBoolean();
    }

    public static enum JSFileNameStyle implements PresentableEnum
    {
        RELAXED("js.code.style.file.name.relaxed.style"),
        CAMEL_CASE("js.code.style.file.name.camel.style"),
        PASCAL_CASE("js.code.style.file.name.pascal.style"),
        SNAKE_CASE("js.code.style.file.name.snake.style"),
        LISP_CASE("js.code.style.file.name.lisp.style"),
        MIXED("js.code.style.file.name.mixed.style");

        private final String myKey;

        private JSFileNameStyle(String key2) {
            this.myKey = key2;
        }

        public String getPresentableText() {
            return JavaScriptBundle.message(this.myKey, new Object[0]);
        }
    }

    public static enum TrailingCommaOption {
        Keep,
        Remove,
        WhenMultiline;

    }

    public static enum JSXAttributeValuePresentation implements PresentableEnum
    {
        QUOTES("Quotes", "jsx.code.style.attribute.default.value.quotes"),
        BRACES("Braces", "jsx.code.style.attribute.default.value.braces"),
        TYPE_BASED("Based on type", "jsx.code.style.attribute.default.value.typebased"),
        NONE("None", "jsx.code.style.attribute.default.value.none");

        private final String myStored;
        private final String myPresentableTextKey;

        private JSXAttributeValuePresentation(String stored, String presentableTextKey) {
            this.myStored = stored;
            this.myPresentableTextKey = presentableTextKey;
        }

        public String toString() {
            return this.myStored;
        }

        public String getPresentableText() {
            return JavaScriptBundle.message(this.myPresentableTextKey, new Object[0]);
        }
    }

    public static enum UseExplicitExtension {
        AUTO,
        ALWAYS_JS,
        NEVER;

    }

    public static enum UseImportType {
        AUTO,
        ALWAYS,
        NEVER;

    }

    public static enum PathMappingOption implements PresentableEnum
    {
        ALWAYS("es6.code.style.path.mapping.always"),
        DIFFERENT_PATHS("es6.code.style.path.mapping.different.paths"),
        NEVER("es6.code.style.path.mapping.never");

        @NotNull
        private final String myPresentableTextKey;

        private PathMappingOption(String presentableTextKey) {
            if (presentableTextKey == null) {
                PathMappingOption.$$$reportNull$$$0(0);
            }
            this.myPresentableTextKey = presentableTextKey;
        }

        public String getPresentableText() {
            return JavaScriptBundle.message(this.myPresentableTextKey, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableTextKey", "com/intellij/lang/javascript/formatter/JSCodeStyleSettings$PathMappingOption", "<init>"));
        }
    }

    public static @interface VarStatementAlignment {
        public static final int ALIGN_MULTIPLE_ASSIGNMENTS = 2;
        public static final int ALIGN_MULTIPLE_VARS = 1;
    }

    public static @interface ObjectLiteralAlignment {
    }
}

