/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.formatter.PostFormatProcessorUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import org.jetbrains.annotations.NotNull;

final class JSBracePostFormatProcessor
implements PostFormatProcessor {
    JSBracePostFormatProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings2) {
        if (source == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = PostFormatProcessorUtil.processElement(source, (childElement, childRange) -> JSBracePostFormatProcessor.processJS(settings2, childElement, childRange));
        if (psiElement == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings2) {
        if (source == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings2 == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(5);
        }
        TextRange textRange2 = PostFormatProcessorUtil.processText(source, rangeToReformat, (childElement, childRange) -> JSBracePostFormatProcessor.processJS(settings2, childElement, childRange));
        if (textRange2 == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange2;
    }

    @NotNull
    private static TextRange processJS(@NotNull CodeStyleSettings settings2, PsiElement childElement, TextRange childRange) {
        if (settings2 == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(7);
        }
        JSBraceEnforcer jsBraceEnforcer = new JSBraceEnforcer(settings2, childElement, childRange);
        TextRange textRange2 = jsBraceEnforcer.processElementRange();
        if (textRange2 == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(8);
        }
        return textRange2;
    }

    private static void removeIfWhitespace(PsiElement sibling) {
        if (sibling instanceof PsiWhiteSpace) {
            CodeEditUtil.removeChild((ASTNode)sibling.getParent().getNode(), (ASTNode)sibling.getNode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processJS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processJS";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 8 -> new IllegalStateException(string);
        };
    }

    private static class JSBraceEnforcer
    extends JSRecursiveElementVisitor {
        private final CommonCodeStyleSettings mySettings;
        private final PostFormatProcessorHelper myPostFormatProcessor;
        private final PsiElement jsRootElement;
        private final Project myProject;
        private boolean changed;

        JSBraceEnforcer(@NotNull CodeStyleSettings settings2, @NotNull PsiElement element, @NotNull TextRange rangeToReformat) {
            if (settings2 == null) {
                JSBraceEnforcer.$$$reportNull$$$0(0);
            }
            if (element == null) {
                JSBraceEnforcer.$$$reportNull$$$0(1);
            }
            if (rangeToReformat == null) {
                JSBraceEnforcer.$$$reportNull$$$0(2);
            }
            this.myProject = element.getProject();
            this.jsRootElement = element;
            this.mySettings = settings2.getCommonSettings(JSLanguageUtil.getLanguageDialect(element));
            this.myPostFormatProcessor = new PostFormatProcessorHelper(this.mySettings);
            this.myPostFormatProcessor.setResultTextRange(rangeToReformat);
        }

        @Override
        public void visitJSIfStatement(@NotNull JSIfStatement node) {
            if (node == null) {
                JSBraceEnforcer.$$$reportNull$$$0(3);
            }
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSIfStatement(node);
                this.processStatement(node, (JSStatement)node.getThenBranch(), this.mySettings.IF_BRACE_FORCE);
                if (!(node.getElseBranch() instanceof JSIfStatement) || !this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.processStatement(node, (JSStatement)node.getElseBranch(), this.mySettings.IF_BRACE_FORCE);
                }
            }
        }

        @Override
        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement node) {
            if (node == null) {
                JSBraceEnforcer.$$$reportNull$$$0(4);
            }
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSDoWhileStatement(node);
                this.processStatement(node, node.getBody(), this.mySettings.DOWHILE_BRACE_FORCE);
            }
        }

        @Override
        public void visitJSWhileStatement(@NotNull JSWhileStatement node) {
            if (node == null) {
                JSBraceEnforcer.$$$reportNull$$$0(5);
            }
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSWhileStatement(node);
                this.processStatement(node, node.getBody(), this.mySettings.WHILE_BRACE_FORCE);
            }
        }

        @Override
        public void visitJSForStatement(@NotNull JSForStatement node) {
            if (node == null) {
                JSBraceEnforcer.$$$reportNull$$$0(6);
            }
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForStatement(node);
                this.processStatement(node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        @Override
        public void visitJSForInStatement(@NotNull JSForInStatement node) {
            if (node == null) {
                JSBraceEnforcer.$$$reportNull$$$0(7);
            }
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForInStatement(node);
                this.processStatement(node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        private void processStatement(JSStatement statement, JSStatement blockCandidate, int options) {
            if (blockCandidate instanceof JSBlockStatement || blockCandidate == null) {
                return;
            }
            if (options == 3 || options == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)statement)) {
                this.replaceWithBlock(statement, blockCandidate);
            }
        }

        private void replaceWithBlock(@NotNull JSStatement parent, JSStatement blockCandidate) {
            if (parent == null) {
                JSBraceEnforcer.$$$reportNull$$$0(8);
            }
            assert (parent.isValid());
            if (!this.myPostFormatProcessor.isElementFullyInRange((PsiElement)blockCandidate)) {
                return;
            }
            String oldText = blockCandidate.getText();
            String block = "{" + oldText + "\n}";
            int oldTextLength = parent.getTextLength();
            ASTNode replacement = JSChangeUtil.createJSTreeFromTextWithContext(block, (PsiElement)parent);
            if (replacement == null) {
                return;
            }
            ASTNode parentNode = parent.getNode();
            JSBracePostFormatProcessor.removeIfWhitespace(blockCandidate.getNextSibling());
            JSBracePostFormatProcessor.removeIfWhitespace(blockCandidate.getPrevSibling());
            CodeEditUtil.replaceChild((ASTNode)parentNode, (ASTNode)blockCandidate.getNode(), (ASTNode)replacement);
            this.myPostFormatProcessor.updateResultRange(oldTextLength, parent.getTextLength());
            this.changed = true;
        }

        public TextRange processElementRange() {
            if (this.mySettings.IF_BRACE_FORCE == 0 && this.mySettings.FOR_BRACE_FORCE == 0 && this.mySettings.WHILE_BRACE_FORCE == 0 && this.mySettings.DOWHILE_BRACE_FORCE == 0) {
                return this.myPostFormatProcessor.getResultTextRange();
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
            codeStyleManager.performActionWithFormatterDisabled(() -> {
                this.jsRootElement.accept((PsiElementVisitor)this);
                if (!this.changed) {
                    return;
                }
                TextRange resultRange = this.myPostFormatProcessor.getResultTextRange();
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)this.myProject);
                Document doc = this.jsRootElement.getContainingFile().getViewProvider().getDocument();
                if (doc != null) {
                    docManager.doPostponedOperationsAndUnblockDocument(doc);
                    codeStyleManager.reformatRange(this.jsRootElement, resultRange.getStartOffset(), resultRange.getEndOffset(), true);
                }
            });
            return this.myPostFormatProcessor.getResultTextRange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeToReformat";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor$JSBraceEnforcer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIfStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDoWhileStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSWhileStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceWithBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

