/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSLanguageServiceProvider;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProvider;", "Lcom/intellij/openapi/project/PossiblyDumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAllServices", "", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "getService", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDumbAware", "", "isHighlightingCandidate", "intellij.javascript.impl"})
public final class FlowJSLanguageServiceProvider
implements JSLanguageServiceProvider,
PossiblyDumbAware {
    @NotNull
    private final Project project;

    public FlowJSLanguageServiceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public List<JSLanguageService> getAllServices() {
        List<JSLanguageService> list2 = FlowJSServerManager.getInstance(this.project).getAllServers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllServers(...)");
        return list2;
    }

    @Override
    @Nullable
    public JSLanguageService getService(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid()) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        return FlowJSServerManager.getService(psiFile3);
    }

    @Override
    public boolean isHighlightingCandidate(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FlowJSServerService.isAcceptableFile(file, FlowJSLanguageServiceProvider::isHighlightingCandidate$lambda$0);
    }

    public boolean isDumbAware() {
        return false;
    }

    private static final boolean isHighlightingCandidate$lambda$0(VirtualFile it) {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(it.getName());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType type2 = fileType;
        return Intrinsics.areEqual((Object)type2, (Object)UnknownFileType.INSTANCE) || DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type2);
    }
}

