/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.FlowModuleReference;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowModuleReferenceContributor
implements JSModuleReferenceContributor {
    @Override
    public PsiReference @NotNull [] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(0);
        }
        if (host == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(1);
        }
        if (unquotedRefText.startsWith(".")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FlowModuleReferenceContributor.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        FlowJSConfig config = FlowModuleReferenceContributor.getFlowConfig(host);
        if (config == null || config.getMapping() == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FlowModuleReferenceContributor.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new FlowModuleReference(host, unquotedRefText, offset, config)};
        if (psiReferenceArray == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static FlowJSConfig getFlowConfig(@NotNull PsiElement host) {
        VirtualFile file;
        if (host == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(5);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)host)) == null) {
            return null;
        }
        return FlowJSConfigService.getService(host.getProject()).getNearestConfig(file, true);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(6);
        }
        return !DumbService.isDumb((Project)host.getProject()) && DialectDetector.isFlow(host);
    }

    @Override
    public int getDefaultWeight() {
        return JSModuleBaseReference.ModuleTypes.JSDOC_MODULE.weight();
    }

    @Override
    @NotNull
    public Collection<?> getDependencies(@NotNull String unquoted, @NotNull PsiElement host) {
        FlowJSConfig config;
        if (unquoted == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(7);
        }
        if (host == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(8);
        }
        if ((config = FlowModuleReferenceContributor.getFlowConfig(host)) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                FlowModuleReferenceContributor.$$$reportNull$$$0(9);
            }
            return list2;
        }
        Set<VirtualFile> set = Collections.singleton(config.getConfigFile());
        if (set == null) {
            FlowModuleReferenceContributor.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowModuleReferenceContributor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquoted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowModuleReferenceContributor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFlowConfig";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 10 -> new IllegalStateException(string);
        };
    }
}

