/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSSettings {
    @Tag(value="service-enabled")
    private boolean isTypeCheckingEnabled = true;
    @Tag(value="exe-path")
    @NotNull
    private String myFlowPath = "";
    @Tag(value="other-services-enabled")
    private boolean isOtherServicesEnabled = true;
    @Tag(value="auto-save")
    private boolean isAutoSaveEnabled = true;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowJSSettings settings2 = (FlowJSSettings)o;
        if (!this.myFlowPath.equals(settings2.myFlowPath)) {
            return false;
        }
        if (this.isTypeCheckingEnabled != settings2.isTypeCheckingEnabled) {
            return false;
        }
        if (this.isOtherServicesEnabled != settings2.isOtherServicesEnabled) {
            return false;
        }
        return this.isAutoSaveEnabled == settings2.isAutoSaveEnabled;
    }

    public int hashCode() {
        int result2 = this.myFlowPath.hashCode();
        result2 = 31 * result2 + (this.isTypeCheckingEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.isOtherServicesEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.isAutoSaveEnabled ? 0 : 1);
        return result2;
    }

    public String toString() {
        return "FlowSettings{myFlowPath='" + this.myFlowPath + "'}";
    }

    public boolean isTypeCheckingEnabled() {
        return this.isTypeCheckingEnabled;
    }

    public boolean isOtherServicesEnabled() {
        return this.isOtherServicesEnabled;
    }

    @NotNull
    public String getFlowExecutablePath() {
        String string = this.myFlowPath;
        if (string == null) {
            FlowJSSettings.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public FlowJSExecutable getFlowExecutable() {
        return StringUtil.isEmpty((String)this.myFlowPath) ? null : new FlowJSExecutable(new File(this.myFlowPath));
    }

    public boolean isAutoSaveEnabled() {
        return this.isAutoSaveEnabled;
    }

    public void setTypeCheckingEnabled(boolean typeCheckingEnabled) {
        this.isTypeCheckingEnabled = typeCheckingEnabled;
    }

    public void setFlowPath(@NotNull String flowPath) {
        if (flowPath == null) {
            FlowJSSettings.$$$reportNull$$$0(1);
        }
        this.myFlowPath = flowPath;
    }

    public void setOtherServicesEnabled(boolean otherServicesEnabled) {
        this.isOtherServicesEnabled = otherServicesEnabled;
    }

    public void setAutoSaveEnabled(boolean autoSaveEnabled) {
        this.isAutoSaveEnabled = autoSaveEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowExecutablePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFlowPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class FlowJSExecutable {
        @NotNull
        private final File myFile;

        public FlowJSExecutable(@NotNull File file) {
            if (file == null) {
                FlowJSExecutable.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @NotNull
        public GeneralCommandLine createCommandLine(@NotNull Project project) {
            GeneralCommandLine result2;
            if (project == null) {
                FlowJSExecutable.$$$reportNull$$$0(1);
            }
            if (this.myFile.isDirectory()) {
                String nodePath;
                NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreter();
                if (interpreter2 instanceof NodeJsLocalInterpreter) {
                    nodePath = ((NodeJsLocalInterpreter)interpreter2).getInterpreterSystemDependentPath();
                } else {
                    if (!(interpreter2 instanceof WslNodeInterpreter)) {
                        Logger.getInstance(FlowJSExecutable.class).error("Can't find node interpreter");
                    }
                    nodePath = SystemInfo.isWindows ? "node.exe" : "node";
                }
                NodePackage flowBinPackage = new NodePackage(this.myFile.getPath());
                File binFile = flowBinPackage.findBinFile("flow", null);
                if (binFile == null) {
                    Logger.getInstance(FlowJSExecutable.class).warn("Can't find bin file");
                    binFile = new File(this.myFile, "cli.js");
                }
                result2 = new GeneralCommandLine(new String[]{nodePath, binFile.getAbsolutePath()});
            } else {
                result2 = new GeneralCommandLine(new String[]{this.myFile.getAbsolutePath()});
            }
            result2.setWorkDirectory(project.getBasePath());
            GeneralCommandLine generalCommandLine = result2;
            if (generalCommandLine == null) {
                FlowJSExecutable.$$$reportNull$$$0(2);
            }
            return generalCommandLine;
        }

        @NotNull
        public String getPackageOrExePath() {
            String string = this.myFile.getAbsolutePath();
            if (string == null) {
                FlowJSExecutable.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public CompletableFuture<String> evaluateVersion(@NotNull Project project) {
            if (project == null) {
                FlowJSExecutable.$$$reportNull$$$0(4);
            }
            final CompletableFuture<String> versionFuture = new CompletableFuture<String>();
            if (!FileUtil.exists((String)this.getPackageOrExePath())) {
                versionFuture.completeExceptionally(new Throwable(JavaScriptBundle.message("js.flow.enable.flow.service.error", new Object[0])));
                CompletableFuture<String> completableFuture = versionFuture;
                if (completableFuture == null) {
                    FlowJSExecutable.$$$reportNull$$$0(5);
                }
                return completableFuture;
            }
            GeneralCommandLine line = this.createCommandLine(project);
            line.addParameter("version");
            line.addParameter("--json");
            line.setWorkDirectory(project.getBasePath());
            try {
                OSProcessHandler handler = new OSProcessHandler(line);
                final StringBuilder resultJson = new StringBuilder();
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String text2 = event.getText();
                            resultJson.append(text2);
                            JsonElement element = FlowJSStandardOutputProtocol.parseJsonSafe(resultJson.toString());
                            if (element instanceof JsonObject) {
                                String version2 = "UNKNOWN";
                                JsonElement semver = ((JsonObject)element).get("semver");
                                if (semver instanceof JsonPrimitive) {
                                    version2 = semver.getAsString();
                                }
                                versionFuture.complete(version2);
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            versionFuture.completeExceptionally(new Throwable(event.getText()));
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (!versionFuture.isDone()) {
                            String message = JavaScriptBundle.message("js.flow.enable.flow.service.error.on.checking", resultJson.length() > 0 ? resultJson.toString() : "Empty process output");
                            versionFuture.completeExceptionally(new Throwable(message));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings$FlowJSExecutable$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                handler.startNotify();
            }
            catch (ExecutionException e) {
                versionFuture.completeExceptionally(new Throwable(JavaScriptBundle.message("js.flow.enable.flow.service.error.on.checking", e.getMessage())));
            }
            CompletableFuture<String> completableFuture = versionFuture;
            if (completableFuture == null) {
                FlowJSExecutable.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettings$FlowJSExecutable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings$FlowJSExecutable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommandLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageOrExePath";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluateVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCommandLine";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateVersion";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

