/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.FlowJSCliService;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class FlowJSServerManager
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConcurrentMap<VirtualFile, NotNullLazyValue<FlowJSServerService>> myConfigDirToServer;

    public FlowJSServerManager(@NotNull Project project) {
        if (project == null) {
            FlowJSServerManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfigDirToServer = new ConcurrentHashMap<VirtualFile, NotNullLazyValue<FlowJSServerService>>();
    }

    public static FlowJSServerManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlowJSServerManager.$$$reportNull$$$0(1);
        }
        return (FlowJSServerManager)project.getService(FlowJSServerManager.class);
    }

    @Nullable
    public static FlowJSServerService getService(@NotNull PsiFile file) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(2);
        }
        return FlowJSServerManager.getService(file, true);
    }

    public static FlowJSServerService getService(@NotNull PsiFile file, boolean onlyStarted) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(3);
        }
        return FlowJSServerManager.getInstance(file.getProject()).getServiceImpl(file, onlyStarted);
    }

    public static boolean isServiceOfFile(@NotNull VirtualFile file, @NotNull FlowJSServerService service2, @NotNull Project project) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(4);
        }
        if (service2 == null) {
            FlowJSServerManager.$$$reportNull$$$0(5);
        }
        if (project == null) {
            FlowJSServerManager.$$$reportNull$$$0(6);
        }
        VirtualFile directory = service2.getConfig().getConfigDirectory();
        FlowJSConfig fileConfig = FlowJSConfigService.getService(project).getNearestConfig(file);
        return fileConfig != null && directory.equals(fileConfig.getConfigDirectory());
    }

    @Nullable
    private FlowJSServerService getServiceImpl(@NotNull PsiFile file, boolean onlyStarted) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(7);
        }
        Project project = file.getProject();
        FlowJSConfig config = this.getConfigForService(file.getVirtualFile());
        if (config == null) {
            return null;
        }
        NotNullLazyValue newServerServiceLazy = NotNullLazyValue.atomicLazy(() -> {
            boolean useLsp = FlowJSServerManager.preferLsp();
            if (useLsp) {
                try {
                    useLsp = FlowJSServerService.isLspAvailable(project);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            FlowJSServerService service2 = useLsp ? new FlowJSLspService(config, project) : new FlowJSCliService(config, project);
            Disposer.register((Disposable)this, (Disposable)service2);
            return service2;
        });
        NotNullLazyValue serverServiceLazy = this.myConfigDirToServer.putIfAbsent(config.getConfigDirectory(), (NotNullLazyValue<FlowJSServerService>)newServerServiceLazy);
        if (serverServiceLazy == null) {
            serverServiceLazy = newServerServiceLazy;
        }
        FlowJSServerService serverService = (FlowJSServerService)serverServiceLazy.getValue();
        if (onlyStarted && !serverService.isServiceStarted()) {
            return null;
        }
        return serverService;
    }

    @Nullable
    public FlowJSConfig getConfigForService(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(8);
        }
        if (!this.isFlowAvailable(file)) {
            return null;
        }
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        return configService.getNearestConfig(file);
    }

    public static boolean preferLsp() {
        return Registry.is((String)"javascript.flow.use.lsp");
    }

    public boolean isFlowAvailable() {
        return this.isFlowAvailable(null);
    }

    private boolean isFlowAvailable(@Nullable VirtualFile file) {
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return false;
        }
        FlowJSSettings.FlowJSExecutable flowExecutable = FlowJSSettingsManager.getFlowExecutable(file, this.myProject);
        if (flowExecutable == null) {
            return false;
        }
        VirtualFile executableFile = LocalFileSystem.getInstance().findFileByPath(flowExecutable.getPackageOrExePath());
        return executableFile != null;
    }

    @NotNull
    public List<FlowJSServerService> getAllServers() {
        List list2 = ContainerUtil.map(this.myConfigDirToServer.values(), value -> (FlowJSServerService)value.getValue());
        if (list2 == null) {
            FlowJSServerManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    public void dispose() {
        this.myConfigDirToServer.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSServerManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isServiceOfFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getServiceImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForService";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

