/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSErrorInspection
extends JSInspection
implements CustomSuppressableInspectionTool,
PairedUnfairLocalInspectionTool {
    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(0);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    public SuppressIntentionAction @Nullable [] getSuppressActions(@Nullable PsiElement element) {
        return SuppressIntentionAction.EMPTY_ARRAY;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(3);
        }
        if (this.myOnTheFly) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                FlowJSErrorInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                FlowJSServerService service2;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((service2 = FlowJSServerManager.getService(file)) == null) {
                    return;
                }
                if (!FlowJSAnnotation.hasFlowAnnotation(file)) {
                    return;
                }
                Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                if (document2 == null) {
                    return;
                }
                CompletableFuture highlight = service2.highlight(file);
                List errors = (List)JSLanguageServiceUtil.awaitFuture(highlight);
                if (errors != null) {
                    FlowJSErrorInspection.reportErrors(errors, file, document2, holder);
                }
                super.visitFile(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSErrorInspection$1", "visitFile"));
            }
        };
    }

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void reportErrors(@NotNull List<? extends JSAnnotationError> annotationResult, @NotNull PsiFile file, @NotNull Document document2, @NotNull ProblemsHolder holder) {
        if (annotationResult == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(6);
        }
        if (file == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(7);
        }
        if (document2 == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(9);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        for (JSAnnotationError jSAnnotationError : annotationResult) {
            JSLanguageServiceUtil.PsiElementInfo info2;
            if (StringUtil.isEmpty((String)jSAnnotationError.getAbsoluteFilePath()) || !FileUtil.pathsEqual((String)jSAnnotationError.getAbsoluteFilePath(), (String)virtualFile.getCanonicalPath()) || (info2 = JSLanguageServiceUtil.getElementInfo(file, document2, jSAnnotationError)) == null) continue;
            PsiElement element = info2.getElement();
            holder.registerProblem((PsiElement)(element != null ? element : file), info2.getRange(), jSAnnotationError.getDescription(), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSErrorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSErrorInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionForBatchShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportErrors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

