/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaScriptEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        DialectOptionHolder dialect;
        if (file == null) {
            JavaScriptEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaScriptEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            JavaScriptEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            JavaScriptEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            JavaScriptEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(4);
        }
        if ((dialect = DialectDetector.dialectOfElement((PsiElement)file)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return super.preprocessEnter(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler);
    }

    protected int getRBraceOffset(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        int fileLength;
        CharSequence text2;
        int offset;
        if (file == null) {
            JavaScriptEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JavaScriptEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(6);
        }
        if ((offset = CharArrayUtil.shiftForward((CharSequence)(text2 = editor.getDocument().getCharsSequence()), (int)caretOffset, (String)" \t")) < (fileLength = text2.length()) && ")];,%?".indexOf(text2.charAt(offset)) < 0 && (text2.charAt(offset) != '<' || offset + 1 < fileLength || text2.charAt(offset + 1) != '/')) {
            offset = (Integer)this.calculateOffsetToInsertClosingBrace((PsiFile)file, (CharSequence)text2, (int)offset).second;
        }
        return Math.min(offset, fileLength);
    }

    protected int calculateOffsetToInsertClosingBraceInsideElement(PsiElement element) {
        PsiElement next;
        JSExpression lOperand;
        JSExpression expression;
        if (element instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)element).getExpression()) instanceof JSCommaExpression && (lOperand = ((JSCommaExpression)expression).getLOperand()) != null) {
            return lOperand.getTextRange().getEndOffset();
        }
        if (element instanceof JSProperty && (next = element.getNextSibling()) instanceof JSProperty && next.getText().startsWith(".")) {
            ASTNode nextNext = TreeUtil.nextLeaf((ASTNode)next.getNode());
            if (nextNext != null && nextNext.getElementType() == JSTokenTypes.RPAR && element.textContains('(')) {
                return nextNext.getTextRange().getEndOffset();
            }
            return next.getTextRange().getEndOffset();
        }
        return super.calculateOffsetToInsertClosingBraceInsideElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptEnterAfterUnmatchedBraceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRBraceOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

