/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlockJoinLinesHandler
implements JoinLinesHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(JSBlockJoinLinesHandler.class);

    public int tryJoinLines(@NotNull Document document2, @NotNull PsiFile psiFile2, int start, int end) {
        JSFunction parentFunc;
        if (document2 == null) {
            JSBlockJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (psiFile2 == null) {
            JSBlockJoinLinesHandler.$$$reportNull$$$0(1);
        }
        PsiElement elementAtStartLineEnd = psiFile2.findElementAt(start);
        PsiElement elementAtNextLineStart = psiFile2.findElementAt(end);
        if (elementAtStartLineEnd == null || elementAtNextLineStart == null) {
            return -1;
        }
        if (!(elementAtStartLineEnd instanceof LeafPsiElement) || ((LeafPsiElement)elementAtStartLineEnd).getElementType() != JSTokenTypes.LBRACE) {
            return -1;
        }
        PsiElement codeBlock = elementAtStartLineEnd.getParent();
        if (!(codeBlock instanceof JSBlockStatement)) {
            return -1;
        }
        PsiElement parentStatement = codeBlock.getParent();
        if (!JSBlockJoinLinesHandler.canHaveBlockWithoutBraces(parentStatement)) {
            return -1;
        }
        if (JSBlockJoinLinesHandler.getForceBraceSetting(parentStatement) == 3) {
            return -1;
        }
        Object foundStatement = null;
        for (PsiElement element = elementAtStartLineEnd.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiWhiteSpace) continue;
            if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == JSTokenTypes.RBRACE && element.getParent() == codeBlock) {
                if (foundStatement != null) break;
                return -1;
            }
            if (foundStatement != null) {
                return -1;
            }
            foundStatement = element;
        }
        if (!(foundStatement instanceof JSStatement)) {
            return -1;
        }
        if (parentStatement instanceof JSIfStatement && ((JSIfStatement)parentStatement).getThenBranch() == codeBlock && ((JSIfStatement)parentStatement).getElseBranch() != null) {
            return -1;
        }
        if (foundStatement instanceof JSReturnStatement && parentStatement instanceof JSFunction && (parentFunc = (JSFunction)parentStatement).isArrowFunction()) {
            JSExpression returnExpression = ((JSReturnStatement)foundStatement).getExpression();
            if (returnExpression == null) {
                return -1;
            }
            foundStatement = returnExpression;
        }
        try {
            PsiElement newStatement = codeBlock.replace(foundStatement);
            return newStatement.getTextRange().getStartOffset();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return -1;
        }
    }

    private static boolean canHaveBlockWithoutBraces(@Nullable PsiElement parent) {
        JSFunction function2;
        return parent instanceof JSIfStatement || parent instanceof JSLoopStatement || parent instanceof JSBlockStatement || parent instanceof JSFunction && (function2 = (JSFunction)parent).isArrowFunction();
    }

    private static int getForceBraceSetting(PsiElement statement) {
        CodeStyleSettings settings2 = CodeStyle.getSettings((PsiFile)statement.getContainingFile());
        CommonCodeStyleSettings codeStyleSettings = settings2.getCommonSettings(DialectDetector.languageOfElement(statement));
        if (statement instanceof JSIfStatement) {
            return codeStyleSettings.IF_BRACE_FORCE;
        }
        if (statement instanceof JSWhileStatement) {
            return codeStyleSettings.WHILE_BRACE_FORCE;
        }
        if (statement instanceof JSForStatement || statement instanceof JSForInStatement) {
            return codeStyleSettings.FOR_BRACE_FORCE;
        }
        if (statement instanceof JSDoWhileStatement) {
            return codeStyleSettings.DOWHILE_BRACE_FORCE;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/editing/JSBlockJoinLinesHandler";
        objectArray[2] = "tryJoinLines";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

