/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.idea.AppMode;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeEvaluator;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleNameIndexKt;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumLiteralType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSPluginPathManager;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptUtil {
    public static final FileType[] TYPESCRIPT_FILE_TYPES_ARRAY = new FileType[]{TypeScriptFileType.INSTANCE, TypeScriptJSXFileType.INSTANCE};
    public static final Collection<FileType> TYPESCRIPT_FILE_TYPES = List.of(TYPESCRIPT_FILE_TYPES_ARRAY);
    public static final String TYPESCRIPT_FILE_EXTENSION = ".ts";
    public static final String TYPESCRIPT_MJS_FILE_EXTENSION = ".mts";
    public static final String TYPESCRIPT_CJS_FILE_EXTENSION = ".cts";
    public static final String TYPESCRIPT_JSX_FILE_EXTENSION = ".tsx";
    public static final String JS_FILE_EXTENSION = ".js";
    public static final String JSX_FILE_EXTENSION = ".jsx";
    public static final String JS_MJS_FILE_EXTENSION = ".mjs";
    public static final String JS_CJS_FILE_EXTENSION = ".cjs";
    public static final String TYPESCRIPT_DECLARATIONS_FILE_EXTENSION = ".d.ts";
    public static final String TYPESCRIPT_DECLARATIONS_MJS_FILE_EXTENSION = ".d.mts";
    public static final String TYPESCRIPT_DECLARATIONS_CJS_FILE_EXTENSION = ".d.cts";
    public static final String[] TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS = new String[]{".ts", ".mts", ".cts", ".tsx"};
    public static final String[] TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS = new String[]{".d.ts", ".d.mts", ".d.cts"};
    public static final String[] TYPESCRIPT_EXTENSIONS = ArrayUtil.mergeArrays((String[])TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS, (String[])TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
    public static final String[] JAVASCRIPT_EXTENSIONS = new String[]{".js", ".jsx", ".mjs", ".cjs"};
    public static final String @NotNull [] TYPESCRIPT_AND_JS_EXTENSIONS = ArrayUtil.mergeArrays((String[])TYPESCRIPT_EXTENSIONS, (String[])JAVASCRIPT_EXTENSIONS);
    @NotNull
    public static final Map<String, String> TS_SOURCE_TO_DECLARATION_EXTENSION = Map.of(".ts", ".d.ts", ".tsx", ".d.ts", ".mts", ".d.mts", ".cts", ".d.cts");
    public static final String COMPILER_DIRECTORY_NAME = "jsLanguageServicesImpl";
    public static final Function<PsiElement, TypeScriptInterface> TYPESCRIPT_INTERFACE_FILTER = element -> element instanceof TypeScriptInterface ? (TypeScriptInterface)element : null;
    public static final String TYPINGS = "typings";
    public static final String TS_CONFIG = "tsconfig";
    public static final String TYPES = "types";
    public static final String EXTERNAL = "external";
    public static final String LIB_PREFIX = "lib.";

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> resolveConstructorFunctions(@NotNull TypeScriptClass clazz, @Nullable PsiElement methodExpression) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(0);
        }
        HashSet<TypeScriptClass> visitedClasses = new HashSet<TypeScriptClass>();
        ArrayDeque<TypeScriptClass> classQueue = new ArrayDeque<TypeScriptClass>();
        if (methodExpression != null) {
            PsiElement parent = methodExpression.getParent();
            if (!(methodExpression instanceof JSNewExpression) && !(parent instanceof JSNewExpression)) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(1);
                }
                return list2;
            }
        }
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            TypeScriptClass currentClass;
            JSClass rawClass = (JSClass)classQueue.poll();
            if (!(rawClass instanceof TypeScriptClass) || !visitedClasses.add(currentClass = (TypeScriptClass)rawClass)) continue;
            Object[] constructors = currentClass.getConstructors();
            if (constructors.length > 0) {
                List list3 = ContainerUtil.map((Object[])constructors, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list3 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(2);
                }
                return list3;
            }
            Collection<JSFunction> indirectConstructors = currentClass.getIndirectSuperConstructors();
            if (!indirectConstructors.isEmpty()) {
                List list4 = ContainerUtil.map(indirectConstructors, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list4 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(3);
                }
                return list4;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        List list5 = ContainerUtil.emptyList();
        if (list5 == null) {
            TypeScriptUtil.$$$reportNull$$$0(4);
        }
        return list5;
    }

    @Nullable
    public static VirtualFile getFileByRelativePath(@NotNull String referencePath, @Nullable VirtualFile currentParent, @NotNull VirtualFileSystem system) {
        int lastSplash;
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(5);
        }
        if (system == null) {
            TypeScriptUtil.$$$reportNull$$$0(6);
        }
        String path2 = (lastSplash = referencePath.lastIndexOf("/")) > 0 ? referencePath.substring(0, lastSplash) : "";
        String nameOrPartOfName = lastSplash > 0 ? referencePath.substring(lastSplash + 1) : referencePath;
        VirtualFile directParent = TypeScriptUtil.getParentDirectory(currentParent, system, path2);
        if (directParent == null) {
            return null;
        }
        boolean isJs = TypeScriptUtil.isJavaScriptFile(referencePath);
        String original = nameOrPartOfName;
        VirtualFile imported = null;
        if (isJs) {
            nameOrPartOfName = FileUtil.getNameWithoutExtension((String)nameOrPartOfName);
        } else {
            imported = directParent.findChild(nameOrPartOfName);
        }
        if (imported != null && !imported.isDirectory()) {
            return imported;
        }
        for (String extension : TYPESCRIPT_EXTENSIONS) {
            VirtualFile candidate = directParent.findChild(nameOrPartOfName + extension);
            if (candidate == null) continue;
            return candidate;
        }
        return isJs ? directParent.findChild(original) : null;
    }

    @Nullable
    private static VirtualFile getParentDirectory(@Nullable VirtualFile currentParent, @NotNull VirtualFileSystem system, @NotNull String path2) {
        if (system == null) {
            TypeScriptUtil.$$$reportNull$$$0(7);
        }
        if (path2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(8);
        }
        if (path2.isEmpty()) {
            return currentParent;
        }
        return currentParent == null ? system.findFileByPath(path2) : currentParent.findFileByRelativePath(path2);
    }

    @RequiresReadLock
    @NotNull
    public static Collection<TypeScriptModule> findExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleText) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(9);
        }
        if (unquotedEscapedModuleText == null) {
            TypeScriptUtil.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.softAssertReadAccess();
        String quoted = StringUtil.wrapWithDoubleQuote((String)JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleText));
        GlobalSearchScope scope2 = TypeScriptUtil.createScopeWithFilterByNodeModules((PsiElement)refFile, (PsiElement)refFile);
        Collection modules2 = StubIndex.getElements(TypeScriptExternalModuleNameIndexKt.getIndexKey(), (Object)quoted, (Project)refFile.getProject(), (GlobalSearchScope)scope2, TypeScriptModule.class);
        if (!modules2.isEmpty()) {
            ArrayList<TypeScriptModule> result2 = new ArrayList<TypeScriptModule>();
            for (TypeScriptModule module : modules2) {
                if (module.isAugmentation()) continue;
                result2.add(module);
            }
            if (!ContainerUtil.isEmpty(result2)) {
                ArrayList<TypeScriptModule> arrayList = result2;
                if (arrayList == null) {
                    TypeScriptUtil.$$$reportNull$$$0(11);
                }
                return arrayList;
            }
        }
        List<TypeScriptModule> list2 = Collections.emptyList();
        if (list2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public static ResolveResult[] findPatternBasedExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleName, @NotNull Project project) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(13);
        }
        if (unquotedEscapedModuleName == null) {
            TypeScriptUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String unquotedModuleName = JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleName);
        Collection<TypeScriptModule> patternExternalModules = TypeScriptUtil.getAllPatternExternalModules(project, (PsiElement)refFile);
        List patterns = ContainerUtil.map(patternExternalModules, module -> JSPathMappingsUtil.createPatternForString(StringUtil.unquoteString((String)module.getExternalModuleText()), false));
        Pair path2 = JSPathMappingsUtil.findMaxElementByPaths(unquotedModuleName, patterns);
        if (path2 != null && path2.getFirst() != null) {
            ArrayList<JSResolveResult> resultPatternModules = new ArrayList<JSResolveResult>();
            String pattern = StringUtil.wrapWithDoubleQuote((String)((JSModulePattern)path2.getFirst()).getPattern());
            for (TypeScriptModule module2 : patternExternalModules) {
                if (!pattern.equals(module2.getExternalModuleText())) continue;
                resultPatternModules.add(new JSResolveResult(module2));
            }
            return resultPatternModules.toArray(ResolveResult.EMPTY_ARRAY);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static Collection<TypeScriptModule> getAllRegularExternalModules(@NotNull Project project, @NotNull PsiElement owner) {
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(16);
        }
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(17);
        }
        return TypeScriptUtil.getAllRegularExternalModules(project, TypeScriptUtil.createScopeWithFilterByNodeModules(owner, owner));
    }

    public static Collection<TypeScriptModule> getAllRegularExternalModules(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(18);
        }
        if (scope2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(19);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"reg", (Project)project, (GlobalSearchScope)scope2, TypeScriptModule.class);
    }

    @NotNull
    public static GlobalSearchScope createScopeWithFilterByNodeModules(@NotNull PsiElement context2, @NotNull PsiElement excludeNodeModules) {
        if (context2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(20);
        }
        if (excludeNodeModules == null) {
            TypeScriptUtil.$$$reportNull$$$0(21);
        }
        return TypeScriptUtil.createFilterByNodeModuleScope(JSResolveUtil.getResolveScope(context2), excludeNodeModules);
    }

    public static Collection<TypeScriptModule> getAllPatternExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(22);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"pat", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner, owner), TypeScriptModule.class);
    }

    public static Collection<TypeScriptModule> getAllAugmentationModules(@NotNull Project project, @NotNull PsiElement scopeElement) {
        GlobalSearchScope scope2;
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(23);
        }
        if (scopeElement == null) {
            TypeScriptUtil.$$$reportNull$$$0(24);
        }
        IdFilter filter = (scope2 = TypeScriptUtil.buildScopeByElement(scopeElement)) instanceof GlobalSearchScopeWithIdFilter ? ((GlobalSearchScopeWithIdFilter)scope2).getFilter() : null;
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"aug", (Project)project, (GlobalSearchScope)scope2, (IdFilter)filter, TypeScriptModule.class);
    }

    @NotNull
    private static GlobalSearchScope buildScopeByElement(@NotNull PsiElement scopeElement) {
        VirtualFile file;
        if (scopeElement == null) {
            TypeScriptUtil.$$$reportNull$$$0(25);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)scopeElement)) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                TypeScriptUtil.$$$reportNull$$$0(26);
            }
            return globalSearchScope;
        }
        if (scopeElement instanceof JsonFile) {
            String name = ((JsonFile)scopeElement).getName();
            if ("package.json".equals(name)) {
                GlobalSearchScope globalSearchScope = TypeScriptUtil.createPackageJsonScope(file);
                if (globalSearchScope == null) {
                    TypeScriptUtil.$$$reportNull$$$0(27);
                }
                return globalSearchScope;
            }
            return TypeScriptUtil.createConfigScope(scopeElement.getProject(), file);
        }
        return TypeScriptUtil.createPsiElementScope(scopeElement, file);
    }

    @Nullable
    public static VirtualFile getPackageJsonOutsideNodeModules(VirtualFile virtualFile) {
        VirtualFile startFile = JSLibraryUtil.findAncestorLibraryDir(virtualFile, "node_modules");
        if (startFile == null) {
            startFile = virtualFile;
        }
        return JSLibraryUtil.findConfigFile(startFile, "package.json");
    }

    @NotNull
    private static GlobalSearchScope createPsiElementScope(@NotNull PsiElement scopeElement, @NotNull VirtualFile file) {
        if (scopeElement == null) {
            TypeScriptUtil.$$$reportNull$$$0(28);
        }
        if (file == null) {
            TypeScriptUtil.$$$reportNull$$$0(29);
        }
        TypeScriptConfigService.IntPredicate predicate = TypeScriptConfigService.Provider.get(scopeElement.getProject()).getFilterId(file);
        return new GlobalSearchScopeWithIdFilter(JSResolveUtil.getResolveScope(scopeElement), predicate);
    }

    @NotNull
    private static GlobalSearchScope createConfigScope(@NotNull Project project, @NotNull VirtualFile configFile) {
        TypeScriptConfigService service2;
        TypeScriptConfig config;
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(30);
        }
        if (configFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(31);
        }
        if ((config = (service2 = TypeScriptConfigService.Provider.get(project)).parseConfigFile(configFile)) != null) {
            GlobalSearchScope globalSearchScope = service2.createConfigScope(config);
            if (globalSearchScope == null) {
                TypeScriptUtil.$$$reportNull$$$0(32);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            TypeScriptUtil.$$$reportNull$$$0(33);
        }
        return globalSearchScope;
    }

    private static GlobalSearchScope createPackageJsonScope(@NotNull VirtualFile packageJson2) {
        VirtualFile topDirectory;
        if (packageJson2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(34);
        }
        if ((topDirectory = packageJson2.getParent()) == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VfsUtilCore.isAncestor((VirtualFile)topDirectory, (VirtualFile)file, (boolean)true)) {
                    return true;
                }
                VirtualFile currentFilePackageJson = TypeScriptUtil.getPackageJsonOutsideNodeModules(file);
                if (currentFilePackageJson != null) {
                    VirtualFile currentRoot = currentFilePackageJson.getParent();
                    return VfsUtilCore.isAncestor((VirtualFile)currentRoot, (VirtualFile)topDirectory, (boolean)false);
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static Collection<JSClass> getNonStrictParents(@NotNull JSClass clazz, boolean includeInterfaces) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(35);
        }
        ArrayList<JSClass> result2 = new ArrayList<JSClass>();
        JSClassUtils.processClassesInHierarchy(clazz, includeInterfaces, (aClass, typeSubstitutor, fromImplements) -> {
            result2.add(aClass);
            return true;
        });
        ArrayList<JSClass> arrayList = result2;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Contract(value="null->null")
    public static String convertToExternalModuleText(@Nullable String unifiedModuleName) {
        if (unifiedModuleName == null) {
            return null;
        }
        if (unifiedModuleName.startsWith("module:")) {
            String sub = JSStringUtil.unescapeStringLiteralValue(unifiedModuleName.substring("module:".length()));
            return JSStringUtil.isDoubleQuotedString(sub) ? sub : StringUtil.wrapWithDoubleQuote((String)sub);
        }
        return null;
    }

    public static void resolveNameToClassesOverAliases(@Nullable String name, @NotNull PsiElement context2, @NotNull Collection<JSClass> resultCollection, Collection<JSClass> visitedAliases) {
        if (context2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(37);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(38);
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveTypeName(name, context2);
        for (PsiElement psiElement : result2.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)psiElement, resultCollection, visitedAliases);
                continue;
            }
            resultCollection.add((JSClass)psiElement);
        }
    }

    public static void resolveAliasToClass(@NotNull TypeScriptTypeAlias alias, @NotNull Collection<JSClass> resultCollection, @Nullable Collection<JSClass> visitedAliases) {
        TypeScriptSingleType singleType;
        TypeScriptType declaration;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(39);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(40);
        }
        if ((declaration = alias.getTypeDeclaration()) instanceof TypeScriptSingleType && !TypeScriptUtil.hasTypeArguments(singleType = (TypeScriptSingleType)declaration)) {
            if (visitedAliases == null) {
                visitedAliases = new HashSet<JSClass>();
            }
            if (!visitedAliases.add(alias)) {
                return;
            }
            TypeScriptUtil.resolveNameToClassesOverAliases(singleType.getQualifiedTypeName(), alias, resultCollection, visitedAliases);
        } else {
            resultCollection.add(alias);
        }
    }

    private static boolean hasTypeArguments(@NotNull TypeScriptSingleType singleType) {
        if (singleType == null) {
            TypeScriptUtil.$$$reportNull$$$0(41);
        }
        return singleType.getTypeArguments().length > 0;
    }

    @NotNull
    public static Iterable<JSNamedElement> getNamedMembers(@NotNull JSClass aClass) {
        if (aClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(42);
        }
        Iterable<? extends JSElement> members = aClass.getMembers();
        ArrayList<JSNamedElement> namedElements = new ArrayList<JSNamedElement>();
        for (JSElement jSElement : members) {
            if (!(jSElement instanceof JSNamedElement)) continue;
            namedElements.add((JSNamedElement)jSElement);
        }
        ArrayList<JSNamedElement> arrayList = namedElements;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyGenericsToType(@NotNull JSType typeInParentClass, @Nullable JSClass surroundClass, @Nullable JSClass parentClass) {
        if (typeInParentClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(44);
        }
        if (parentClass != null && surroundClass != null && DialectDetector.isTypeScript(surroundClass)) {
            JSType jSType = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(surroundClass, ContainerUtil.emptyList(), parentClass, typeInParentClass, null);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(45);
            }
            return jSType;
        }
        JSType jSType = typeInParentClass;
        if (jSType == null) {
            TypeScriptUtil.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    @NotNull
    public static String buildParameterTypeListStringWithApplyingGenerics(TypeScriptFunction function2, @Nullable PsiElement surroundClass) {
        TypeScriptTypeParameterList list2;
        JSClass classOfContext = JSResolveUtil.getClassOfContext(function2);
        if (classOfContext != null && (list2 = function2.getTypeParameterList()) != null) {
            String join = StringUtil.join((Object[])list2.getTypeParameters(), parameter -> {
                JSType jsType = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
                if (surroundClass instanceof JSClass) {
                    jsType = TypeScriptUtil.applyGenericsToType(jsType, (JSClass)surroundClass, classOfContext);
                }
                return jsType.getTypeText(JSType.TypeTextFormat.CODE);
            }, (String)", ");
            Object object = StringUtil.isEmpty((String)join) ? "" : "<" + join + ">";
            if (object == null) {
                TypeScriptUtil.$$$reportNull$$$0(47);
            }
            return object;
        }
        return "";
    }

    @NotNull
    public static Map<TypeScriptMemberInfo, JSClass> getUnimplementedMembers(@NotNull JSClass jsClass, boolean includeOptional) {
        Map<TypeScriptMemberInfo, JSClass> infos;
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(48);
        }
        if ((infos = TypeScriptUtil.getMemberInfos(jsClass, includeOptional)).isEmpty()) {
            return new LinkedHashMap<TypeScriptMemberInfo, JSClass>();
        }
        LinkedHashMap<TypeScriptMemberInfo, JSClass> result2 = new LinkedHashMap<TypeScriptMemberInfo, JSClass>();
        infos.forEach((cur, curClass) -> {
            if (cur.getKind() == TypeScriptMemberInfo.Kind.UNIMPLEMENTED) {
                result2.put((TypeScriptMemberInfo)cur, (JSClass)curClass);
            }
        });
        LinkedHashMap<TypeScriptMemberInfo, JSClass> linkedHashMap = result2;
        if (linkedHashMap == null) {
            TypeScriptUtil.$$$reportNull$$$0(49);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Map<TypeScriptMemberInfo, JSClass> getMemberInfos(@NotNull JSClass jsClass, boolean includeOptional) {
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(50);
        }
        ArrayList implementedInterfaces = new ArrayList();
        HashMap typeSubstitutors = new HashMap();
        JSClassUtils.processClassesInHierarchy(jsClass, true, (aClass, typeSubstitutor, fromImplements) -> {
            if ((includeOptional || fromImplements || TypeScriptPsiUtil.isAbstractElement(aClass)) && aClass != jsClass) {
                implementedInterfaces.add(aClass);
            }
            typeSubstitutors.put(aClass, typeSubstitutor);
            return true;
        });
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(jsClass, DialectDetector.isTypeScript(jsClass));
        LinkedHashMap<TypeScriptMemberInfo, JSClass> membersToImplement = new LinkedHashMap<TypeScriptMemberInfo, JSClass>();
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)jsClass, () -> {
            for (JSClass implementedInterface : implementedInterfaces) {
                TypeScriptUtil.fillUnimplementedInterfaceMembers(jsClass, implementedInterface, membersToImplement, typeSubstitutors, source, includeOptional);
            }
        });
        LinkedHashMap<TypeScriptMemberInfo, JSClass> linkedHashMap = membersToImplement;
        if (linkedHashMap == null) {
            TypeScriptUtil.$$$reportNull$$$0(51);
        }
        return linkedHashMap;
    }

    private static void fillUnimplementedInterfaceMembers(@NotNull JSClass jsClass, @NotNull JSClass implementedInterface, @NotNull Map<TypeScriptMemberInfo, JSClass> membersToImplement, @NotNull Map<JSClass, JSTypeSubstitutor> typeSubstitutors, @NotNull JSTypeSource source, boolean includeOptional) {
        List<TypeScriptMemberInfo> implementedMembers;
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(52);
        }
        if (implementedInterface == null) {
            TypeScriptUtil.$$$reportNull$$$0(53);
        }
        if (membersToImplement == null) {
            TypeScriptUtil.$$$reportNull$$$0(54);
        }
        if (typeSubstitutors == null) {
            TypeScriptUtil.$$$reportNull$$$0(55);
        }
        if (source == null) {
            TypeScriptUtil.$$$reportNull$$$0(56);
        }
        if ((implementedMembers = TypeScriptUtil.getImplementedMembers(jsClass, implementedInterface, typeSubstitutors)).isEmpty()) {
            return;
        }
        JSRecordType classType = TypeScriptTypeParser.buildTypeFromClass(jsClass, false, true, TypeScriptPsiUtil.isAbstractElement(jsClass), false);
        classType = (JSRecordType)classType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)type2 -> TypeScriptUtil.replaceThisType(type2, jsClass, source)));
        JSRecordType objectType = null;
        for (TypeScriptMemberInfo implementedMember : implementedMembers) {
            TypeScriptMemberInfo.Kind errorForObjectMember;
            ProcessingContext context2;
            boolean memberIsAlreadyAdded = false;
            for (TypeScriptMemberInfo member : membersToImplement.keySet()) {
                if (member.getMember() == null || !member.getMember().isEquivalentTo(implementedMember.getMember(), null, true)) continue;
                memberIsAlreadyAdded = true;
                break;
            }
            if (memberIsAlreadyAdded) continue;
            JSRecordType.TypeMember typeMember = includeOptional ? TypeScriptUtil.overrideOptionalFlagForTypeMember(implementedMember.getMember()) : implementedMember.getMember();
            TypeScriptMemberInfo.Kind implementationError = TypeScriptUtil.getImplementationError(typeMember = typeMember == null ? null : typeMember.copyTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)type1 -> TypeScriptUtil.replaceThisType(type1, jsClass, source))), classType, context2 = JSTypeComparingContextService.createProcessingContextWithCallEnvironment(jsClass));
            if (implementationError == null) continue;
            if (objectType == null) {
                List<JSClass> objectClasses = TypeScriptClassResolver.getInstance().findObjectClasses(jsClass);
                for (JSClass objectClass : objectClasses) {
                    JSRecordType currentObjectType = TypeScriptTypeParser.buildTypeFromClass(objectClass, false, false, false, false);
                    if (objectType == null) {
                        objectType = currentObjectType;
                        continue;
                    }
                    List objectTypeMembers = ContainerUtil.concat(objectType.getTypeMembers(), currentObjectType.getTypeMembers());
                    objectType = new JSRecordTypeImpl(objectType.getSource(), objectTypeMembers);
                }
                if (objectType == null) {
                    objectType = new JSRecordTypeImpl(source, Collections.emptyList());
                }
            }
            if ((errorForObjectMember = TypeScriptUtil.getImplementationError(typeMember, objectType, context2)) == null) continue;
            if (implementationError == TypeScriptMemberInfo.Kind.INCOMPATIBLE || errorForObjectMember == TypeScriptMemberInfo.Kind.INCOMPATIBLE) {
                implementedMember = TypeScriptMemberInfo.create(implementedMember.getMember(), implementedMember.getElement(), TypeScriptMemberInfo.Kind.INCOMPATIBLE);
            }
            membersToImplement.put(implementedMember, implementedInterface);
        }
    }

    @Nullable
    private static TypeScriptMemberInfo.Kind getImplementationError(@Nullable JSRecordType.TypeMember baseMember, @NotNull JSRecordType inheritedClassType, @NotNull ProcessingContext context2) {
        if (inheritedClassType == null) {
            TypeScriptUtil.$$$reportNull$$$0(57);
        }
        if (context2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(58);
        }
        if (baseMember instanceof JSRecordType.PropertySignature) {
            JSRecordType.PropertySignature inheritedSignature = inheritedClassType.findPropertySignature(((JSRecordType.PropertySignature)baseMember).getMemberName());
            boolean isBaseOptional = ((JSRecordType.PropertySignature)baseMember).isOptional();
            if (inheritedSignature == null) {
                return isBaseOptional ? null : TypeScriptMemberInfo.Kind.UNIMPLEMENTED;
            }
            if (inheritedSignature.isOptional() && !TypeScriptUtil.isInitializedParameterProperty(inheritedSignature) && !isBaseOptional) {
                return TypeScriptMemberInfo.Kind.INCOMPATIBLE;
            }
            JSType type2 = ((JSRecordType.PropertySignature)baseMember).getJSType();
            if (type2 == null) {
                return null;
            }
            return type2.isDirectlyAssignableType(inheritedSignature.getJSType(), context2) ? null : TypeScriptMemberInfo.Kind.INCOMPATIBLE;
        }
        if (baseMember instanceof JSRecordType.IndexSignature) {
            JSType type3 = ((JSRecordType.IndexSignature)baseMember).getMemberParameterType();
            JSRecordType.IndexSignature inheritedIndexer = inheritedClassType.findIndexer(type3.getClass());
            if (inheritedIndexer == null) {
                return TypeScriptMemberInfo.Kind.UNIMPLEMENTED;
            }
            return ((JSRecordType.IndexSignature)baseMember).getMemberType().isDirectlyAssignableType(inheritedIndexer.getMemberType(), context2) ? null : TypeScriptMemberInfo.Kind.INCOMPATIBLE;
        }
        return TypeScriptMemberInfo.Kind.UNIMPLEMENTED;
    }

    private static boolean isInitializedParameterProperty(@NotNull JSRecordType.PropertySignature signature) {
        PsiElement element;
        if (signature == null) {
            TypeScriptUtil.$$$reportNull$$$0(59);
        }
        if ((element = signature.getMemberSource().getSingleElement()) instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            return ((JSParameter)element).getInitializerOrStub() != null;
        }
        return false;
    }

    @NotNull
    private static List<TypeScriptMemberInfo> getImplementedMembers(@NotNull JSClass jsClass, @NotNull JSClass implementedInterface, @NotNull Map<JSClass, JSTypeSubstitutor> typeSubstitutors) {
        JSType typeDeclaration;
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(60);
        }
        if (implementedInterface == null) {
            TypeScriptUtil.$$$reportNull$$$0(61);
        }
        if (typeSubstitutors == null) {
            TypeScriptUtil.$$$reportNull$$$0(62);
        }
        ArrayList<TypeScriptMemberInfo> implementedMembers = new ArrayList<TypeScriptMemberInfo>();
        if (implementedInterface instanceof TypeScriptInterface) {
            TypeScriptObjectType body2 = ((TypeScriptInterface)implementedInterface).getBody();
            if (body2 == null) {
                ArrayList<TypeScriptMemberInfo> arrayList = implementedMembers;
                if (arrayList == null) {
                    TypeScriptUtil.$$$reportNull$$$0(63);
                }
                return arrayList;
            }
            for (TypeScriptTypeMember typeMember : body2.getTypeMembers()) {
                JSRecordType.TypeMember interfaceTypeMember = TypeScriptTypeMemberParser.buildTypeMember(typeMember);
                if (interfaceTypeMember == null) continue;
                implementedMembers.add(TypeScriptMemberInfo.create(interfaceTypeMember, typeMember));
            }
        } else if (implementedInterface instanceof TypeScriptClass) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(implementedInterface, true);
            for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(implementedInterface)) {
                JSRecordType.TypeMember member = TypeScriptTypeMemberParser.buildTypeMemberFromElement(implementedInterface, (PsiElement)classMember, false, typeSource, typeSubstitutors.get(implementedInterface));
                if (member == null) continue;
                implementedMembers.add(TypeScriptMemberInfo.create(member, classMember));
            }
        } else if (implementedInterface instanceof TypeScriptTypeAlias && (typeDeclaration = ((TypeScriptTypeAlias)implementedInterface).getParsedTypeDeclaration()) != null) {
            if (JSTypeUtils.hasForeignGenericParameter(typeDeclaration)) {
                JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExtendClass(jsClass, implementedInterface);
                typeDeclaration = JSTypeUtils.applyGenericArguments(typeDeclaration, substitutor);
            }
            JSRecordType recordType = typeDeclaration.asRecordType();
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                if (!(member instanceof JSRecordType.PropertySignature)) continue;
                String name = ((JSRecordType.PropertySignature)member).getMemberName();
                JSType type2 = ((JSRecordType.PropertySignature)member).getJSType();
                implementedMembers.add(TypeScriptMemberInfo.create(member, new JSLocalImplicitElementImpl(name, type2, implementedInterface, JSImplicitElement.Type.Property)));
            }
        }
        ArrayList<TypeScriptMemberInfo> arrayList = implementedMembers;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    private static JSType replaceThisType(JSType type2, JSClass jsClass, JSTypeSource source) {
        if (type2 instanceof TypeScriptGenericThisTypeImpl) {
            String name = jsClass.getQualifiedName();
            if (name != null) {
                return new TypeScriptGenericThisTypeImpl(type2.getSource(), JSNamedTypeFactory.createType(name, source, JSTypeContext.INSTANCE));
            }
            if (jsClass instanceof JSClassExpression) {
                return new TypeScriptGenericThisTypeImpl(type2.getSource(), TypeScriptTypeParser.buildTypeFromClass(jsClass, false));
            }
        }
        return type2;
    }

    @NotNull
    private static JSRecordType.TypeMember overrideOptionalFlagForTypeMember(JSRecordType.TypeMember member) {
        JSRecordType.PropertySignature propertySignature;
        if (member instanceof JSRecordType.PropertySignature && (propertySignature = (JSRecordType.PropertySignature)member).isOptional()) {
            return new PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.getJSType(), false, propertySignature.isConst(), propertySignature.getMemberSource());
        }
        JSRecordType.TypeMember typeMember = member;
        if (typeMember == null) {
            TypeScriptUtil.$$$reportNull$$$0(65);
        }
        return typeMember;
    }

    public static boolean isTypeScriptMethod(PsiElement element) {
        return element instanceof JSFunction && !(element instanceof TypeScriptCallSignature);
    }

    public static boolean isTypeScriptProperty(PsiElement element) {
        return element instanceof TypeScriptPropertySignature || element instanceof JSVariable;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull String name, @NotNull PsiElement context2) {
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(66);
        }
        if (context2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(67);
        }
        JSType type2 = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(context2, false), JSContext.INSTANCE);
        return TypeScriptUtil.getShortestTypeNameInContext(type2, context2);
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull JSType type2, @Nullable PsiElement context2) {
        if (type2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(68);
        }
        type2 = JSCompositeTypeFactory.optimizeTypeIfComposite(JSTypeUtils.getValuableType(type2, context2));
        if (context2 == null || (!(type2 instanceof JSNamedType) || type2 instanceof JSPrimitiveType) && !(type2 instanceof TypeScriptEnumLiteralType)) {
            String string = type2.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(69);
            }
            return string;
        }
        String text2 = type2.getResolvedTypeText();
        return TypeScriptUtil.getShortestTypeNameInContextForQualifiedName(context2, text2);
    }

    @NotNull
    public static String getShortestTypeNameInContextForQualifiedName(@NotNull PsiElement context2, @NotNull String startQName) {
        String currentName;
        JSQualifiedNameImpl name;
        if (context2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(70);
        }
        if (startQName == null) {
            TypeScriptUtil.$$$reportNull$$$0(71);
        }
        if ((name = JSQualifiedNameImpl.fromQualifiedName(startQName)).getParent() == null) {
            String string = startQName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(72);
            }
            return string;
        }
        String result2 = null;
        Object qName = null;
        boolean hasNonIdentifiers = false;
        for (JSQualifiedName current = name; !(current == null || !StringUtil.isEmpty(result2) && StringUtil.equals((CharSequence)startQName, result2) || TypeScriptUtil.hasAmbientExternalModuleInQName(currentName = current.getName())); current = current.getParent()) {
            if (qName == null) {
                qName = currentName;
            } else if (StringUtil.isJavaIdentifier((String)qName)) {
                qName = currentName + "." + (String)qName;
            } else {
                hasNonIdentifiers = true;
                qName = currentName + "[\"" + (String)qName + "\"]";
            }
            result2 = TypeScriptImportHandler.getInstance().getQualifiedNameResolvedType((String)qName, context2);
        }
        if (result2 != null && (StringUtil.equals((CharSequence)startQName, result2) || hasNonIdentifiers)) {
            String string = qName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(73);
            }
            return string;
        }
        String string = startQName;
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(74);
        }
        return string;
    }

    public static boolean hasAmbientExternalModuleInQName(@Nullable String value) {
        return value != null && value.startsWith("module:");
    }

    @NotNull
    public static JSType getBaseTypeOfEnumLiteralType(@NotNull JSResolvableType type2) {
        String text2;
        JSQualifiedNameImpl name;
        JSQualifiedName parent;
        if (type2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(75);
        }
        if ((parent = (name = JSQualifiedNameImpl.fromQualifiedName(text2 = type2.getResolvedTypeText())).getParent()) != null) {
            String qualifiedName = parent.getQualifiedName();
            JSType jSType = JSNamedType.createType(qualifiedName, type2.getSource(), JSTypeContext.INSTANCE);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(76);
            }
            return jSType;
        }
        JSResolvableType jSResolvableType = type2;
        if (jSResolvableType == null) {
            TypeScriptUtil.$$$reportNull$$$0(77);
        }
        return jSResolvableType;
    }

    @NotNull
    public static File getTypeScriptExternalFolderFile() {
        return new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), EXTERNAL);
    }

    @NotNull
    public static File getTypeScriptCompilerFolderFile() {
        File file;
        try {
            file = JSPluginPathManager.getPluginResourceOrSource(TypeScriptUtil.class, COMPILER_DIRECTORY_NAME, AppMode.isDevServer() ? "javascript-plugin" : "JavaScriptLanguage/src");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file == null) {
            TypeScriptUtil.$$$reportNull$$$0(78);
        }
        return file;
    }

    public static boolean resolveIsStrict(@NotNull JSReferenceExpression node) {
        if (node == null) {
            TypeScriptUtil.$$$reportNull$$$0(79);
        }
        return JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> TypeScriptUtil.isStrictResolveQualifier(node.getQualifier()));
    }

    public static boolean isStrictResolveQualifier(@Nullable JSExpression qualifier) {
        JSType jsType;
        if (TypeScriptUtil.isValidThisQualifier(qualifier) || TypeScriptUtil.isValidSuperQualifier(qualifier) || qualifier == null) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((JSReferenceExpression)qualifier).multiResolve(false)) {
                PsiElement resolve2 = result2.getElement();
                if (!(resolve2 instanceof TypeScriptModule) && !(resolve2 instanceof TypeScriptImportStatement) && !(resolve2 instanceof ES6ImportedBinding) && !(resolve2 instanceof ES6ImportSpecifierAlias) && !(resolve2 instanceof JSFile)) continue;
                return true;
            }
        }
        if (TypeScriptUtil.isStrictType(jsType = JSResolveUtil.getExpressionJSType(qualifier))) {
            return !TypeScriptUtil.isImportType(jsType) || TypeScriptUtil.isStrictType(jsType.substitute((PsiElement)qualifier));
        }
        return false;
    }

    public static boolean isImportType(@Nullable JSType jsType) {
        return jsType instanceof JSImportType;
    }

    public static boolean isValidSuperQualifier(JSExpression qualifier) {
        return qualifier instanceof JSSuperExpression && JSResolveUtil.getClassOfContext((PsiElement)qualifier) != null;
    }

    public static boolean isValidThisQualifier(JSExpression qualifier) {
        return qualifier instanceof JSThisExpression && JSContextResolver.findContextElement((PsiElement)qualifier) instanceof JSClass;
    }

    public static ProblemHighlightType getProblemHighlightTypeForType(@Nullable JSType type2) {
        if (TypeScriptUtil.isStrictType(type2)) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    public static boolean isStrictType(@Nullable JSType jsType) {
        return jsType != null && !JSTypeUtils.hasAnyTypeOrNotStrictType(jsType) && !(jsType instanceof JSNullType);
    }

    public static boolean isUnderNodeModules(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TypeScriptUtil.$$$reportNull$$$0(80);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(81);
        }
        return JSLibraryUtil.hasDirectoryInPath(file, JSLibraryUtil.LIBRARY_DIR_NAMES, project.getBaseDir());
    }

    public static boolean isDefinitionFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptUtil.$$$reportNull$$$0(82);
        }
        return TypeScriptUtil.isDefinitionFile(file.getNameSequence());
    }

    public static boolean isDefinitionFile(@NotNull CharSequence fileName) {
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(83);
        }
        for (String extension : TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS) {
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTypeScriptFile(@NotNull CharSequence fileName) {
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(84);
        }
        for (String extension : TYPESCRIPT_EXTENSIONS) {
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaScriptFile(@NotNull CharSequence fileName) {
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(85);
        }
        for (String extension : JAVASCRIPT_EXTENSIONS) {
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)extension)) continue;
            return true;
        }
        return false;
    }

    public static JSRecordType getFunctionTypeMembers(@Nullable PsiElement source) {
        if (source == null || !DialectDetector.isTypeScript(source)) {
            return null;
        }
        return TypeScriptUtil.getTypeMembers(source, JSTypeUtils.getFunctionTypeName(source.getContainingFile(), false));
    }

    private static JSRecordType getTypeMembers(@NotNull PsiElement source, @NotNull String className) {
        JSElement context2;
        if (source == null) {
            TypeScriptUtil.$$$reportNull$$$0(86);
        }
        if (className == null) {
            TypeScriptUtil.$$$reportNull$$$0(87);
        }
        if ((context2 = ES6PsiUtil.getNonStrictExportScope(source)) == null) {
            context2 = source;
        }
        return JSNamedTypeFactory.createType(className, JSTypeSourceFactory.createTypeSource((PsiElement)context2, true), JSTypeContext.INSTANCE, false).asRecordType();
    }

    @NotNull
    public static GlobalSearchScope createFilterByNodeModuleScope(@NotNull GlobalSearchScope scope2, @NotNull PsiElement context2) {
        if (scope2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(88);
        }
        if (context2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(89);
        }
        if (context2 instanceof PsiFile) {
            context2 = ((PsiFile)context2).getOriginalFile();
        }
        final VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)context2);
        final ProjectFileIndex index = ProjectFileIndex.getInstance((Project)context2.getProject());
        Object resultScope = contextFile == null ? scope2 : new DelegatingGlobalSearchScope(scope2){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                VirtualFile currentNodeModules = JSLibraryUtil.findAncestorLibraryDir(file, "node_modules");
                if (currentNodeModules == null) {
                    return true;
                }
                VirtualFile parentDir = currentNodeModules.getParent();
                boolean isPartOfProject = index.isInContent(parentDir) || index.isInLibrary(parentDir);
                return !isPartOfProject || VfsUtilCore.isAncestor((VirtualFile)parentDir, (VirtualFile)contextFile, (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$2", "contains"));
            }
        };
        return DialectDetector.isTypeScript(context2) ? resultScope : TypeScriptUtil.excludeTsGlobalDeclarationsFromNodeModules((GlobalSearchScope)resultScope, context2.getProject());
    }

    @Nullable
    public static JSRecordType getTypeAliasRecordTypeForSubstitutor(@NotNull TypeScriptTypeAlias alias, @Nullable JSTypeSubstitutor substitutor) {
        JSType typeToProcess;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(90);
        }
        return (typeToProcess = JSTypeUtils.applyGenericArguments(alias.getParsedTypeDeclaration(), substitutor)) == null ? null : typeToProcess.asRecordType();
    }

    public static boolean isDefinitionFile(@Nullable PsiFile file) {
        return file != null && TypeScriptUtil.isDefinitionFile(file.getName());
    }

    public static int getTypePrecedence(@NotNull JSTypeDeclaration declaration) {
        if (declaration == null) {
            TypeScriptUtil.$$$reportNull$$$0(91);
        }
        if (declaration instanceof TypeScriptParenthesizedType) {
            return 0;
        }
        if (declaration instanceof TypeScriptSingleType) {
            return 1;
        }
        if (declaration instanceof TypeScriptArrayType) {
            return 2;
        }
        if (declaration instanceof TypeScriptTypeOperator) {
            return 3;
        }
        if (declaration instanceof TypeScriptUnionOrIntersectionType) {
            TypeScriptUnionOrIntersectionType unionOrIntersection = (TypeScriptUnionOrIntersectionType)declaration;
            return unionOrIntersection.isIntersectionType() ? 4 : 5;
        }
        if (declaration instanceof TypeScriptFunctionType) {
            return 6;
        }
        return -1;
    }

    @Nullable
    public static PsiElement evaluateThisFromFunction(@NotNull TypeScriptFunction function2) {
        PsiElement element;
        JSType contextualType;
        JSParameter parameter;
        if (function2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(92);
        }
        if ((parameter = TypeScriptPsiUtil.getThisParameter(function2)) != null) {
            return parameter;
        }
        if (function2 instanceof JSExpression && (contextualType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((Object)function2), JSExpectedTypeKind.CONTEXTUAL)) instanceof JSFunctionTypeImpl && (element = contextualType.getSourceElement()) instanceof TypeScriptFunction && (parameter = TypeScriptPsiUtil.getThisParameter((TypeScriptFunction)element)) != null) {
            return parameter;
        }
        return null;
    }

    @Nullable
    public static JSType evaluateThisTypeFromFunction(TypeScriptFunction function2) {
        TypeScriptTypeEvaluator evaluator = new TypeScriptTypeEvaluator(new JSEvaluateContext(function2.getContainingFile()));
        JSType thisType = evaluator.computeThisType(function2);
        if (thisType == null) {
            return null;
        }
        return thisType;
    }

    @NotNull
    public static String extractQualifierForJsxFactory(@NotNull String factory) {
        int qualifierSeparator;
        if (factory == null) {
            TypeScriptUtil.$$$reportNull$$$0(93);
        }
        String string = (qualifierSeparator = factory.indexOf(".")) > 0 ? factory.substring(0, qualifierSeparator) : factory;
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(94);
        }
        return string;
    }

    public static boolean isLocalClassPossible(@Nullable PsiElement element) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null || TypeScriptUtil.isDefinitionFile(file)) {
            return false;
        }
        JSElement exportScope = ES6PsiUtil.getNonStrictExportScope(element);
        if (exportScope instanceof TypeScriptModule) {
            return !((TypeScriptModule)exportScope).isExternal();
        }
        return true;
    }

    public static boolean hasOuterGenerics(@Nullable PsiElement element) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null || TypeScriptUtil.isDefinitionFile(file)) {
            return false;
        }
        PsiElement context2 = element;
        PsiElement candidate;
        while ((candidate = PsiTreeUtil.findFirstContext((PsiElement)context2, (boolean)true, el -> el instanceof TypeScriptTypeParameterListOwner || ES6PsiUtil.isExportScope(el))) instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameterList list2;
            if (!(candidate instanceof TypeScriptTypeMember) && !(candidate instanceof TypeScriptInterface) && (list2 = ((TypeScriptTypeParameterListOwner)candidate).getTypeParameterList()) != null) {
                return true;
            }
            context2 = candidate;
        }
        return false;
    }

    public static boolean isES6LibName(@NotNull String libraryName) {
        if (libraryName == null) {
            TypeScriptUtil.$$$reportNull$$$0(95);
        }
        if ((libraryName = StringUtil.toLowerCase((String)libraryName)).startsWith("esnext")) {
            return true;
        }
        if (!libraryName.startsWith("es")) {
            return false;
        }
        int indexOfEnd = libraryName.indexOf(".");
        if (indexOfEnd == -1) {
            indexOfEnd = libraryName.length();
        }
        try {
            String index = libraryName.substring(2, indexOfEnd);
            int parsedValue = Integer.parseInt(index);
            if (index.length() == 1 && parsedValue >= 6) {
                return true;
            }
            if (index.length() == 4 && parsedValue >= 2015) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptUtil.class).debug((Throwable)e);
        }
        return false;
    }

    @NotNull
    public static GlobalSearchScope excludeTsGlobalDeclarationsFromNodeModules(@NotNull GlobalSearchScope scope2, final @NotNull Project project) {
        if (scope2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(96);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(97);
        }
        final TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(project);
        return new DelegatingGlobalSearchScope(scope2){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                CharSequence name = file.getNameSequence();
                if (!TypeScriptUtil.isTypeScriptFile(name)) {
                    return true;
                }
                VirtualFile topDirectory = JSLibraryUtil.getLibraryFolder(file, "node_modules");
                if (topDirectory == null) {
                    return true;
                }
                return configService.isImplicitIncludedNodeModulesFile(project, file, topDirectory);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$3", "contains"));
            }
        };
    }

    @NotNull
    public static Collection<String> getSourceNamesForDeclaration(@NotNull String dtsFile) {
        String extension;
        if (dtsFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(98);
        }
        if ((extension = JSFileReferencesUtil.findExtension(dtsFile, TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptUtil.$$$reportNull$$$0(99);
            }
            return list2;
        }
        String trimmedName = JSFileReferencesUtil.trimExistingExtension(dtsFile, extension);
        SmartList fileNames2 = new SmartList();
        for (Map.Entry<String, String> entry : TS_SOURCE_TO_DECLARATION_EXTENSION.entrySet()) {
            String tsLike = entry.getKey();
            String dtsLike = entry.getValue();
            if (!dtsLike.equals(extension)) continue;
            fileNames2.add((Object)(trimmedName + tsLike));
        }
        SmartList smartList = fileNames2;
        if (smartList == null) {
            TypeScriptUtil.$$$reportNull$$$0(100);
        }
        return smartList;
    }

    public static boolean isTypeScriptFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptUtil.$$$reportNull$$$0(101);
        }
        FileType fileType = file.getFileType();
        return ArrayUtil.contains((Object)fileType, (Object[])TYPESCRIPT_FILE_TYPES_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 11, 12, 26, 27, 32, 33, 36, 43, 45, 46, 47, 49, 51, 63, 64, 65, 69, 72, 73, 74, 76, 77, 78, 94, 99, 100 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 94: 
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedModuleText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedModuleName";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 23: 
            case 30: 
            case 81: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 19: 
            case 88: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: 
            case 37: 
            case 58: 
            case 67: 
            case 70: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeNodeModules";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 29: 
            case 80: 
            case 82: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultCollection";
                break;
            }
            case 39: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInParentClass";
                break;
            }
            case 48: 
            case 50: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedInterface";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToImplement";
                break;
            }
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutors";
                break;
            }
            case 56: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritedClassType";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 68: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startQName";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorFunctions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalModule";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildScopeByElement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigScope";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonStrictParents";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedMembers";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "applyGenericsToType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterTypeListStringWithApplyingGenerics";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnimplementedMembers";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberInfos";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedMembers";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideOptionalFlagForTypeMember";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContext";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptCompilerFolderFile";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "extractQualifierForJsxFactory";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNamesForDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorFunctions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 94: 
            case 99: 
            case 100: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileByRelativePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPatternBasedExternalModule";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAllRegularExternalModules";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createScopeWithFilterByNodeModules";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAllPatternExternalModules";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllAugmentationModules";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildScopeByElement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createPsiElementScope";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createConfigScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createPackageJsonScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParents";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameToClassesOverAliases";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveAliasToClass";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeArguments";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getNamedMembers";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "applyGenericsToType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getUnimplementedMembers";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMemberInfos";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fillUnimplementedInterfaceMembers";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationError";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isInitializedParameterProperty";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedMembers";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContext";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsStrict";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isUnderNodeModules";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isDefinitionFile";
                break;
            }
            case 84: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptFile";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScriptFile";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMembers";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createFilterByNodeModuleScope";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAliasRecordTypeForSubstitutor";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getTypePrecedence";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "evaluateThisFromFunction";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "extractQualifierForJsxFactory";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isES6LibName";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "excludeTsGlobalDeclarationsFromNodeModules";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getSourceNamesForDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 11, 12, 26, 27, 32, 33, 36, 43, 45, 46, 47, 49, 51, 63, 64, 65, 69, 72, 73, 74, 76, 77, 78, 94, 99, 100 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface JSClassHierarchyProcessor
    extends JSClassUtils.JSClassHierarchyProcessor {
        public boolean process(@NotNull JSClass var1, @NotNull JSTypeSubstitutor var2, boolean var3);

        @Override
        default public boolean process(@NotNull JSClass aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean fromStaticContext, int depth) {
            if (aClass == null) {
                JSClassHierarchyProcessor.$$$reportNull$$$0(0);
            }
            if (typeSubstitutor == null) {
                JSClassHierarchyProcessor.$$$reportNull$$$0(1);
            }
            if (fromStaticContext) {
                return true;
            }
            return this.process(aClass, typeSubstitutor, fromImplements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeSubstitutor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$JSClassHierarchyProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

