/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.lang.javascript.scratch.JSScratchFileInfoProvider;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveScopeProvider
extends JSResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(1);
        }
        FileType type2 = file.getFileType();
        if (!this.isApplicable(file) && !TypeScriptResolveScopeProvider.isTypeScriptScratchFile(file, project, type2)) {
            return null;
        }
        TypeScriptLibraryProvider libraryService = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> allLibraries = TypeScriptLibraryProvider.getAllLibraries(project);
        if (allLibraries.contains(file)) {
            return GlobalSearchScope.filesScope((Project)project, libraryService.getPredefinedLibraries(file));
        }
        GlobalSearchScope moduleAndLibraryScope = this.getModuleAndDefaultLibraryScope(file, project);
        return this.restrictByFileType(file, libraryService, moduleAndLibraryScope);
    }

    protected GlobalSearchScope restrictByFileType(@NotNull VirtualFile file, @NotNull TypeScriptLibraryProvider libraryService, @NotNull GlobalSearchScope moduleAndLibraryScope) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (libraryService == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if (moduleAndLibraryScope == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return libraryService.getFileTypeRestrictedScope(moduleAndLibraryScope, file);
    }

    @NotNull
    private GlobalSearchScope getModuleAndDefaultLibraryScope(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(6);
        }
        JSLanguageLevel level = DialectDetector.getConfiguredJSLevel(file, project);
        Set<VirtualFile> includedFiles = JSPredefinedLibraryManager.getPredefinedLibraryManager(project).getRequiredLibraryFilesForResolve(level);
        Set<VirtualFile> excludedFiles = JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles();
        GlobalSearchScope globalSearchScope = this.getProjectAndLibrariesScope(file, project, includedFiles, excludedFiles);
        if (globalSearchScope == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static boolean isTypeScriptScratchFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull FileType type2) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(10);
        }
        return type2 instanceof LanguageFileType && JSScratchFileInfoProvider.Provider.isScratchForLanguage(project, file, type2, JavaScriptSupportLoader.TYPESCRIPT);
    }

    protected boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(11);
        }
        return TypeScriptUtil.isTypeScriptFile(file);
    }

    @Override
    protected boolean isApplicablePredefinedLibraryFile(@NotNull VirtualFile predefinedLibraryFile) {
        if (predefinedLibraryFile == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(12);
        }
        return this.isApplicable(predefinedLibraryFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleAndLibraryScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLibraryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAndDefaultLibraryScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restrictByFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAndDefaultLibraryScope";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptScratchFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicablePredefinedLibraryFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

