/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptFileCachedDataEvaluator
extends JSFileCachedDataEvaluator {
    public TypeScriptFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(0);
        }
        super(outCachedData);
    }

    @Override
    public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression node) {
        if (node == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void visitTypeScriptExportAssignment(@NotNull TypeScriptExportAssignment exportAssignment) {
        if (exportAssignment == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(2);
        }
        this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
    }

    @Override
    public void visitJSVariable(@NotNull JSVariable node) {
        if (node == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(3);
        }
        this.checkIfExportStatement(node);
        this.setSkipChildren();
    }

    @Override
    public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
        TypeScriptExternalModuleReference externalModuleReference;
        if (importStatement == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(4);
        }
        if ((externalModuleReference = importStatement.getExternalModuleReference()) != null) {
            this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
        }
        this.checkIfExportStatement(importStatement);
        this.setSkipChildren();
    }

    @Override
    public void visitTypeScriptImplicitModule(@NotNull TypeScriptImplicitModule module) {
        if (module == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(5);
        }
        this.checkIfExportStatement(module);
        this.visitElement(module);
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(6);
        }
        this.setSkipChildren();
    }

    private void checkIfExportStatement(@NotNull JSAttributeListOwner node) {
        JSAttributeList attributeList;
        if (node == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(7);
        }
        if ((attributeList = node.getAttributeList()) != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
            this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
        }
    }

    @Override
    public void visitJSFile(@NotNull JSFile file) {
        if (file == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(8);
        }
        if (TypeScriptUtil.isDefinitionFile(file)) {
            this.visitFile(file);
        } else {
            super.visitJSFile(file);
        }
    }

    @Override
    public void visitES6ExportDefaultAssignment(@NotNull ES6ExportDefaultAssignment node) {
        if (node == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(9);
        }
        this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outCachedData";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportAssignment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptFileCachedDataEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSAssignmentExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeScriptExportAssignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSVariable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeScriptImportStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeScriptImplicitModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfExportStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitES6ExportDefaultAssignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class TypeScriptReferencePathsVisitor
    extends JSFileCachedDataEvaluator.JSReferencedPathsVisitor {
        public void visitComment(@NotNull PsiComment comment) {
            PsiElement prev;
            String text2;
            Matcher matcher;
            if (comment == null) {
                TypeScriptReferencePathsVisitor.$$$reportNull$$$0(0);
            }
            if (comment.getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT && comment.getParent() instanceof JSFile && (matcher = TypeScriptPsiUtil.TYPESCRIPT_REFERENCE_PATH.matcher(text2 = comment.getText())).matches() && ((prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)comment, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) instanceof PsiComment || prev == null)) {
                boolean isLib = "lib".equals(matcher.group(1));
                String fileOrLib = TypeScriptPsiUtil.getPathText(matcher);
                this.addReferencedPath(!isLib ? fileOrLib : TypeScriptLibraries.wrapAsLibraryFile(fileOrLib));
            }
        }

        @Override
        public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
            TypeScriptExternalModuleReference externalModuleReference;
            if (importStatement == null) {
                TypeScriptReferencePathsVisitor.$$$reportNull$$$0(1);
            }
            if ((externalModuleReference = importStatement.getExternalModuleReference()) != null) {
                ASTNode referenceNode = externalModuleReference.findReferenceNode();
                String qName = importStatement.getQualifiedName();
                if (referenceNode != null && qName != null) {
                    this.addReferencedPath(StringUtil.unquoteString((String)referenceNode.getText()));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptFileCachedDataEvaluator$TypeScriptReferencePathsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeScriptImportStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

