/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocCommentFixer;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDocCommentFixer
implements DocCommentFixer {
    public void fixComment(@NotNull Project project, @NotNull Editor editor, @NotNull PsiComment comment) {
        if (project == null) {
            JSDocCommentFixer.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSDocCommentFixer.$$$reportNull$$$0(1);
        }
        if (comment == null) {
            JSDocCommentFixer.$$$reportNull$$$0(2);
        }
        if (!(comment instanceof JSDocComment)) {
            return;
        }
        JSDocComment docComment = (JSDocComment)comment;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document document2 = editor.getDocument();
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
        JSFunction commentElement = null;
        ArrayList<String> tagsToAdd = new ArrayList<String>();
        HashSet<Integer> tagsToRemove = new HashSet<Integer>();
        HashMap<Integer, String> tagsToUpdate = new HashMap<Integer, String>();
        JSFunction function2 = JSDocumentationUtils.findFunctionAppliedTo(docComment);
        if (function2 != null) {
            JSType type2;
            commentElement = function2;
            JSDocumentationUtils.JSDocParametersMappingToFunctionInfo info2 = JSDocumentationUtils.checkDocCommentMatchesFunctionSignature(docComment, function2);
            if (info2 != null) {
                List<Pair<Integer, String>> paramsToAdd = info2.getParamsToAdd();
                for (Pair<Integer, String> s : paramsToAdd) {
                    tagsToAdd.add("param " + (String)s.getSecond());
                }
                tagsToRemove.addAll(info2.getParamsToRemove().keySet());
            }
            if ((type2 = TypeFromUsageDetector.detectTypeFromUsage(function2)) != null && !(type2 instanceof JSVoidType)) {
                JSDocTag[] tags = docComment.getTags();
                boolean returnTagFound = false;
                for (int i = 0; i < tags.length; ++i) {
                    JSDocTag tag = tags[i];
                    if (!tag.is(JSDocBlockTags.RETURNS)) continue;
                    tagsToUpdate.put(i, "{" + type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}");
                    returnTagFound = true;
                    break;
                }
                if (!returnTagFound) {
                    tagsToAdd.add("return {" + type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}");
                }
            }
        } else {
            JSType type3;
            PsiElement element = JSDocumentationUtils.findAttachedElementFromComment(docComment);
            commentElement = element;
            JSExpression exprForTypeEval = null;
            if (element instanceof JSVariable) {
                exprForTypeEval = ((JSVariable)element).getInitializer();
            } else if (element instanceof JSProperty) {
                exprForTypeEval = ((JSProperty)element).getValue();
            } else if (element instanceof JSExpression) {
                exprForTypeEval = (JSExpression)element;
            }
            if (exprForTypeEval != null && (type3 = JSResolveUtil.getExpressionJSType(exprForTypeEval)) != null && (!(type3 instanceof JSAnyType) || type3.isSourceStrict())) {
                boolean typeTagFound = false;
                JSDocTag[] tags = docComment.getTags();
                for (int i = 0; i < tags.length; ++i) {
                    JSDocTag tag = tags[i];
                    if (!tag.is(JSDocBlockTags.TYPE)) continue;
                    tagsToUpdate.put(i, "{" + type3.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}");
                    typeTagFound = true;
                    break;
                }
                if (!typeTagFound) {
                    tagsToAdd.add("type {" + type3.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}");
                }
            }
        }
        if (commentElement != null) {
            JSDocumentationUtils.createOrUpdateTagsInDocComment(commentElement, tagsToAdd, tagsToUpdate, tagsToRemove);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "comment";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/documentation/JSDocCommentFixer";
        objectArray[2] = "fixComment";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

