/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static boolean isIncompleteArrowFunctionParameter(@NotNull JSReferenceExpression element) {
        PsiElement parent;
        if (element == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(0);
        }
        if ((parent = element.getParent()) instanceof JSParenthesizedExpression || parent instanceof JSCommaExpression && PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{JSCommaExpression.class}) instanceof JSParenthesizedExpression) {
            PsiElement prevSibling = PsiTreeUtil.prevCodeLeaf((PsiElement)element);
            PsiElement nextSibling = PsiTreeUtil.nextCodeLeaf((PsiElement)element);
            if (prevSibling != null && nextSibling != null) {
                IElementType prevElementType = prevSibling.getNode().getElementType();
                IElementType nextElementType = nextSibling.getNode().getElementType();
                return !(prevElementType != JSTokenTypes.LPAR && prevElementType != JSTokenTypes.COMMA || nextElementType != JSTokenTypes.RPAR && nextElementType != JSTokenTypes.COMMA);
            }
        }
        return false;
    }

    protected void addCompletions(@NotNull CompletionParameters completionParameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        JSFunction functionLike;
        PsiElement parent;
        if (completionParameters == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(3);
        }
        if ((parent = completionParameters.getPosition().getParent()) == null) {
            return;
        }
        JSFunction jSFunction = parent instanceof JSParameter ? ((JSParameter)parent).getDeclaringFunction() : (functionLike = parent instanceof JSReferenceExpression ? (PsiElement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{JSCommaExpression.class}), JSParenthesizedExpression.class) : null);
        if (functionLike == null) {
            return;
        }
        JSParameterCompletionProvider.completeContextualFunction(result2, parent, functionLike);
        JSParameterCompletionProvider.completeJSDocFunction(result2, functionLike);
    }

    private static void completeJSDocFunction(@NotNull CompletionResultSet result2, @NotNull PsiElement functionLike) {
        if (result2 == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(4);
        }
        if (functionLike == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(5);
        }
        if (!(functionLike instanceof JSFunction)) {
            return;
        }
        JSFunction jsFunction = (JSFunction)functionLike;
        PsiComment docComment = JSDocumentationUtils.findDocComment(functionLike);
        if (!(docComment instanceof JSDocComment)) {
            return;
        }
        JSDocComment jsDocComment = (JSDocComment)docComment;
        HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
        result2.addAllElements((Iterable)ContainerUtil.map((Collection)JSDocumentationUtils.getTagToParameterMap(jsDocComment, jsFunction, tagNames).getNonMatchedTags().values(), tag -> {
            String paramName = Objects.requireNonNull(tag.getNamepath()).getText();
            return JSParameterCompletionProvider.getLookupElement((PsiElement)tag, paramName);
        }));
    }

    @NotNull
    private static LookupElement getLookupElement(PsiElement element, String name) {
        LookupElement lookupElement = JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((Object)element, (String)name).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter)), JSLookupPriority.PARAMETER_NAME_FROM_EXPECTED_TYPE);
        if (lookupElement == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(6);
        }
        return lookupElement;
    }

    private static void completeContextualFunction(@NotNull CompletionResultSet result2, @NotNull PsiElement parent, @NotNull PsiElement functionLike) {
        if (result2 == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(8);
        }
        if (functionLike == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(9);
        }
        if (!(functionLike instanceof JSExpression)) {
            return;
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)functionLike);
        JSTypeUtils.getFunctionType(expectedType, false, functionLike).forEach(type2 -> {
            PsiElement sourceElement;
            if (type2 instanceof JSFunctionTypeImpl && (sourceElement = type2.getSource().getSourceElement()) instanceof JSFunctionItem) {
                String name;
                JSParameterItem[] expectedParameters = ((JSFunctionItem)sourceElement).getParameters();
                JSParameterListElement[] functionParameters = functionLike instanceof JSFunction ? ((JSFunction)functionLike).getParameters() : (PsiElement[])JSParameterCompletionProvider.expandCommaExpressions((PsiElement)((JSParenthesizedExpression)functionLike).getInnerExpression()).toArray(PsiElement[]::new);
                int paramIndex = -1;
                for (int i = 0; i < functionParameters.length; ++i) {
                    if (parent != functionParameters[i]) continue;
                    paramIndex = i;
                    break;
                }
                if (paramIndex == 0 && functionParameters.length == 1 && expectedParameters.length > 1) {
                    StringBuilder parameters = new StringBuilder();
                    for (JSParameterItem expectedParameter : expectedParameters) {
                        if (parameters.length() > 0) {
                            parameters.append(", ");
                        }
                        parameters.append(expectedParameter.getName());
                    }
                    result2.addElement(JSCompletionUtil.withJSLookupPriority(JSLookupUtilImpl.createMultiparamCompletionItem(sourceElement, parameters.toString()), JSLookupPriority.PARAMETER_LIST_FROM_EXPECTED_TYPE));
                }
                if (paramIndex >= 0 && paramIndex < expectedParameters.length && (name = expectedParameters[paramIndex].getName()) != null) {
                    result2.addElement(JSParameterCompletionProvider.getLookupElement(sourceElement, name));
                }
            }
        });
    }

    @NotNull
    private static Stream<PsiElement> expandCommaExpressions(@Nullable PsiElement e) {
        Stream<Object> stream = e instanceof JSCommaExpression ? Stream.concat(JSParameterCompletionProvider.expandCommaExpressions((PsiElement)((JSCommaExpression)e).getLOperand()), JSParameterCompletionProvider.expandCommaExpressions((PsiElement)((JSCommaExpression)e).getROperand())) : (e != null ? Stream.of(e) : Stream.empty());
        if (stream == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(10);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionLike";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSParameterCompletionProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSParameterCompletionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "expandCommaExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteArrowFunctionParameter";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "completeJSDocFunction";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "completeContextualFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10 -> new IllegalStateException(string);
        };
    }
}

