/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.HtmlTextCompletionConfidence;
import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.TypeScriptDirectivesCompletionProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAutoCompletionPopupPolicy
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile2, int offset) {
        boolean isIdentifier;
        IElementType nodeType;
        PsiElement prevContextElement;
        ASTNode node;
        PsiElement commentOrLiteral;
        if (contextElement == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(0);
        }
        if (psiFile2 == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(1);
        }
        if ((commentOrLiteral = PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{PsiComment.class, JSExpression.class})) instanceof JSLiteralExpression) {
            if (JSAutoCompletionPopupPolicy.shouldSkipAutopopupInLiteral((JSLiteralExpression)commentOrLiteral)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(2);
                }
                return threeState;
            }
        } else if (commentOrLiteral instanceof PsiComment) {
            PsiElement parent;
            if (TypeScriptDirectivesCompletionProvider.shouldSuggestDirectives(commentOrLiteral, offset)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(3);
                }
                return threeState;
            }
            if (!(contextElement.getNode().getElementType() == JSDocTokenTypes.DOC_TAG_NAME || (parent = contextElement.getParent()) instanceof JSDocTagNamepath && parent.getReference() instanceof JSDocParamReference || parent instanceof JSDocTagType)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(4);
                }
                return threeState;
            }
        }
        if ((node = (prevContextElement = contextElement).getNode()) != null && ((nodeType = node.getElementType()) == JSTokenTypes.DOT || nodeType == JSTokenTypes.DOT_DOT || nodeType == JSTokenTypes.DOT_DOT_DOT)) {
            prevContextElement = PsiTreeUtil.prevLeaf((PsiElement)prevContextElement);
        }
        if (prevContextElement != null && prevContextElement.getParent() instanceof JSParameterList || prevContextElement instanceof PsiErrorElement) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(5);
            }
            return threeState;
        }
        PsiElement parent = contextElement.getParent();
        boolean bl = isIdentifier = node != null && JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType());
        if (parent instanceof JSProperty && !isIdentifier || (parent instanceof JSProperty || JSAutoCompletionPopupPolicy.isShorthandedProperty(parent)) && !JSAutoCompletionPopupPolicy.isES6OrTypeScript(contextElement) || parent instanceof TypeScriptPropertySignature) {
            JSClass classOfContext = JSResolveUtil.getClassOfContext(parent);
            if (classOfContext != null && classOfContext.isInterface()) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (parent.getParent() instanceof TypeScriptObjectType) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(7);
                }
                return threeState;
            }
            if (JSAutoCompletionPopupPolicy.isCssAcceptableProperty(parent)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(8);
                }
                return threeState;
            }
            if (!JSCompletionUtil.isUnparsedGenericTail(parent)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(9);
                }
                return threeState;
            }
        }
        if (HtmlTextCompletionConfidence.shouldSkipAutopopupInHtml((PsiElement)contextElement, (int)offset)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(10);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(11);
        }
        return threeState;
    }

    private static boolean isCssAcceptableProperty(@NotNull PsiElement element) {
        if (element == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(12);
        }
        if (ContainerUtil.or((Object[])element.getReferences(), reference -> reference instanceof CssClassOrIdReference)) {
            return true;
        }
        return JavaScriptReferenceContributor.isAcceptableCssLiteralPlace(element, true);
    }

    private static boolean isES6OrTypeScript(@NotNull PsiElement psiFile2) {
        DialectOptionHolder holder;
        if (psiFile2 == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(13);
        }
        return (holder = DialectDetector.dialectOfElement(psiFile2)) != null && (holder.isTypeScript || holder.isECMA6);
    }

    private static boolean isShorthandedProperty(@Nullable PsiElement parent) {
        return parent instanceof JSReferenceExpression && parent.getParent() instanceof ES6Property && ((ES6Property)parent.getParent()).isShorthanded();
    }

    private static boolean shouldSkipAutopopupInLiteral(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(14);
        }
        if (literal instanceof XmlTag) {
            return false;
        }
        if (!literal.isQuotedLiteral()) {
            return true;
        }
        PsiElement parent = literal.getParent();
        if (parent instanceof JSVariable) {
            return ((JSVariable)parent).getInitializer() == literal && ((JSVariable)parent).getTypeElement() == null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldSkipAutopopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutopopup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCssAcceptableProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isES6OrTypeScript";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutopopupInLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

